/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cache;

import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandlerEvent;
import org.netbeans.modules.vcscore.cache.CacheHandlerListener;

public abstract class FileSystemCache {
    protected boolean isSaved = false;
    protected String identifier;
    private ArrayList listeners = new ArrayList();
    private Object listenersLock = new Object();
    public static final int EVENT_ADD = 0;
    public static final int EVENT_REMOVE = 1;
    public static final int EVENT_CHANGED = 2;
    public static final int EVENT_CHANGED_RECURSIVELY = 3;
    public static final int EVENT_CHANGED_IGNORE_LIST = 4;
    private HashMap lockedFileObjects;
    private HashMap locks;

    public FileSystemCache(String id) {
        this.identifier = id;
        this.lockedFileObjects = new HashMap();
        this.locks = new HashMap();
    }

    public String getId() {
        return this.identifier;
    }

    public boolean isWrittenToDisk() {
        return this.isSaved;
    }

    public abstract void writeAllToDisk();

    public abstract CacheFile getCacheFile(File var1, int var2, Object var3);

    public abstract void registerDir(CacheDir var1);

    public abstract void unregisterDir(CacheDir var1);

    public abstract CacheDir getDir(String var1);

    protected boolean doesStrategyApply(CacheDir dir, int goalLevel, int toPass) {
        if (dir.getAppliedLevel() >= toPass) {
            return false;
        }
        if (goalLevel < toPass) {
            return false;
        }
        if (goalLevel <= dir.getAppliedLevel()) {
            return false;
        }
        return goalLevel < 10 || toPass <= 0 || goalLevel == toPass;
    }

    protected void loadDir(CacheDir dir, int strategy, Object locker) {
        if (dir == null) {
            return;
        }
        if (strategy == 11 || strategy == 12) {
            boolean recursiv;
            dir.setAppliedLevel(-1);
            boolean bl = recursiv = strategy == 12;
            if (recursiv) {
                dir.removeAll(recursiv);
            } else {
                dir.removeFiles();
            }
        }
        if (this.doesStrategyApply(dir, strategy, 0)) {
            dir.populateWithLocal(locker);
        }
        if (dir.isLocal()) {
            return;
        }
        if (strategy == 6) {
            this.loadFromDiskOrRefreshRecursively(dir, locker);
            return;
        }
        if (this.doesStrategyApply(dir, strategy, 3) && !dir.readFromDisk(locker) && strategy == 5) {
            dir.checkServer(locker);
        }
        if (this.doesStrategyApply(dir, strategy, 11)) {
            dir.checkServer(locker);
        }
        if (this.doesStrategyApply(dir, strategy, 10)) {
            dir.setAppliedLevel(10);
        }
        if (this.doesStrategyApply(dir, strategy, 12)) {
            dir.checkServerRecursive(locker);
        }
    }

    protected void loadFromDiskOrRefreshRecursively(CacheDir dir, Object locker) {
        if (!dir.readFromDisk(locker)) {
            dir.checkServerRecursive(locker);
        } else {
            CacheDir[] subDirs = dir.getSubDirs();
            int i = 0;
            while (i < subDirs.length) {
                if (!subDirs[i].isLocal()) {
                    this.loadFromDiskOrRefreshRecursively(subDirs[i], locker);
                }
                ++i;
            }
        }
    }

    public void addCacheHandlerListener(CacheHandlerListener toAdd) {
        Object object = this.listenersLock;
        synchronized (object) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(toAdd);
        }
    }

    public void removeCacheHandlerListener(CacheHandlerListener toRemove) {
        Object object = this.listenersLock;
        synchronized (object) {
            if (this.listeners != null) {
                ((AbstractCollection)this.listeners).remove(toRemove);
            }
        }
    }

    void removeAllListeners() {
        Object object = this.listenersLock;
        synchronized (object) {
            if (this.listeners != null) {
                this.listeners.clear();
                this.listeners = null;
            }
        }
    }

    public void fireCacheHandlerEvent(int type, CacheFile firedFile) {
        CacheHandlerEvent event = new CacheHandlerEvent(firedFile, type == 3);
        this.fireCacheHandlerEvent(type, event);
    }

    public void fireCacheHandlerEvent(int type, CacheHandlerEvent event) {
        ArrayList list;
        Object object = this.listenersLock;
        synchronized (object) {
            if (this.listeners == null) {
                return;
            }
            list = (ArrayList)this.listeners.clone();
        }
        int i = 0;
        while (i < list.size()) {
            if (type == 2 || type == 4 || type == 3) {
                ((CacheHandlerListener)list.get(i)).statusChanged(event);
            }
            if (type == 0) {
                ((CacheHandlerListener)list.get(i)).cacheAdded(event);
            }
            if (type == 1) {
                ((CacheHandlerListener)list.get(i)).cacheRemoved(event);
            }
            ++i;
        }
    }
}

