/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.caching;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import org.netbeans.api.vcs.FileStatusInfo;
import org.netbeans.modules.vcscore.Variables;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.caching.FileStatusProvider;
import org.netbeans.modules.vcscore.caching.VcsCacheDir;
import org.netbeans.modules.vcscore.caching.VcsCacheFile;

public class RefreshCommandSupport {
    public static final int ELEMENT_INDEX_FILE_NAME = 0;
    public static final int ELEMENT_INDEX_STATUS = 1;
    public static final int ELEMENT_INDEX_LOCKER = 2;
    public static final int ELEMENT_INDEX_REVISION = 3;
    public static final int ELEMENT_INDEX_STICKY = 4;
    public static final int ELEMENT_INDEX_ATTR = 5;
    public static final int ELEMENT_INDEX_SIZE = 6;
    public static final int ELEMENT_INDEX_DATE = 7;
    public static final int ELEMENT_INDEX_TIME = 8;
    public static final int NUM_ELEMENTS = 9;
    public static final String ANNOTATION_PATTERN_FILE_NAME = "fileName";
    public static final String ANNOTATION_PATTERN_STATUS = "status";
    public static final String ANNOTATION_PATTERN_LOCKER = "locker";
    public static final String ANNOTATION_PATTERN_REVISION = "revision";
    public static final String ANNOTATION_PATTERN_STICKY = "sticky";
    public static final String ANNOTATION_PATTERN_ATTR = "attribute";
    public static final String ANNOTATION_PATTERN_SIZE = "size";
    public static final String ANNOTATION_PATTERN_DATE = "date";
    public static final String ANNOTATION_PATTERN_TIME = "time";
    public static final int MULTI_FILES_ANNOTATION_EMPTY = 0;
    public static final int MULTI_FILES_ANNOTATION_LIST = 1;
    public static final int MULTI_FILES_ANNOTATION_NOT_SYNCH_ATTR = 2;
    public static final String DEFAULT_ANNOTATION_PATTERN = "${fileName}$[? status] [ [${status}$[? revision] [; ${revision}] []]] [$[? revision] [ ${revision}] []]$[? locker][ (${locker})] []$[? sticky][ (${sticky})] []";
    public static final int[] DEFAULT_MULTI_FILES_ANNOTATION_TYPES = new int[]{2, 1, 0, 0, 0, 0, 0, 0, 0};
    public static final String DEFAULT_MULTI_FILES_ANNOTATION_DELIMETER = ", ";
    private static final String DIRECTORY_CACHE_ID = "D";
    private static String local = null;

    private RefreshCommandSupport() {
    }

    public static String getFileName(String[] elements) {
        if (elements.length < 9) {
            return null;
        }
        return elements[0];
    }

    public static CacheFile matchToFile(String[] elements, String cacheName, File parent) {
        if (elements.length < 9) {
            throw new IllegalArgumentException("The number of elements (" + elements.length + ") < " + 9);
        }
        CacheFile file = new VcsCacheFile(cacheName);
        String name = elements[0];
        if (name == null) {
            throw new IllegalArgumentException("File name element is missing.");
        }
        file.setName(name);
        if (name.endsWith("/") && (file = CacheHandler.getInstance().getCacheFile(new File(parent, name.substring(0, name.length() - 1)), 10, cacheName)) == null) {
            file = new VcsCacheDir(cacheName, new File(parent, name.substring(0, name.length() - 1)));
        }
        RefreshCommandSupport.matchToFile(elements, file);
        return file;
    }

    public static CacheFile matchToExistingFile(String[] elements, String cacheName, File parent) {
        CacheFile file;
        if (elements.length < 9) {
            throw new IllegalArgumentException("The number of elements (" + elements.length + ") < " + 9);
        }
        String name = elements[0];
        if (name == null) {
            throw new IllegalArgumentException("File name element is missing.");
        }
        boolean fileIsDir = name.endsWith("/");
        if (fileIsDir) {
            name = name.substring(0, name.length() - 1);
        }
        if ((file = CacheHandler.getInstance().getCacheFile(new File(parent, name), 10, cacheName)) == null) {
            file = fileIsDir ? new VcsCacheDir(cacheName, new File(parent, name)) : new VcsCacheFile(cacheName);
            file.setName(name);
        }
        RefreshCommandSupport.matchToFile(elements, file);
        if (file instanceof VcsCacheFile) {
            ((VcsCacheFile)file).setLocal(false);
        }
        if (file instanceof VcsCacheDir) {
            ((VcsCacheDir)file).setLocal(false);
        }
        return file;
    }

    public static CacheFile matchToFile(String[] elements, CacheFile file) {
        RefreshCommandSupport.matchToFile(elements, (VcsCacheFile.VcsPersistentData)file.getPersistentData());
        return file;
    }

    public static VcsCacheFile.VcsPersistentData matchToFile(String[] elements, VcsCacheFile.VcsPersistentData data) {
        String size;
        String time;
        String date;
        String attr;
        String sticky;
        String revision;
        String locker;
        if (elements.length < 9) {
            throw new IllegalArgumentException("The number of elements (" + elements.length + ") < " + 9);
        }
        String status = elements[1];
        if (status != null) {
            data.setStatus(status.trim());
        }
        if ((locker = elements[2]) != null) {
            data.setLocker(locker.trim());
        }
        if ((revision = elements[3]) != null) {
            data.setRevision(revision.trim());
        }
        if ((sticky = elements[4]) != null) {
            data.setSticky(sticky.trim());
        }
        if ((attr = elements[5]) != null) {
            data.setAttr(attr.trim());
        }
        if ((date = elements[7]) != null) {
            data.setDate(date.trim());
        }
        if ((time = elements[8]) != null) {
            data.setTime(time.trim());
        }
        if ((size = elements[6]) != null) {
            try {
                data.setSize(Integer.parseInt(size.trim()));
            }
            catch (NumberFormatException e) {
                data.setSize(0);
            }
        }
        return data;
    }

    public static String[] makeElements(CacheFile file) {
        return RefreshCommandSupport.makeElements((VcsCacheFile.VcsPersistentData)file.getPersistentData());
    }

    public static String[] makeElements(VcsCacheFile.VcsPersistentData data) {
        String[] elements = new String[9];
        elements[0] = data.getName();
        elements[1] = data.getStatus();
        elements[2] = data.getLocker();
        elements[3] = data.getRevision();
        elements[4] = data.getSticky();
        elements[5] = data.getAttr();
        elements[7] = data.getDate();
        elements[8] = data.getTime();
        elements[6] = Integer.toString(data.getSize());
        return elements;
    }

    public static String[] getElementsFromLine(String line) {
        boolean dir = false;
        int index = 0;
        if (line.charAt(index) == '/') {
            ++index;
        }
        String[] elements = new String[9];
        int i = 0;
        while (index < line.length() && i < 9) {
            String element;
            int next = line.indexOf(47, index);
            if (next < 0) break;
            if (next > 0 && line.substring(next - 1).startsWith(" // ")) {
                int nextSl;
                StringBuffer adjusted = new StringBuffer();
                int begin = index;
                int end = next - 1;
                while (true) {
                    if (begin < end) {
                        adjusted.append(line.substring(begin, end));
                    }
                    adjusted.append('/');
                    nextSl = line.indexOf(47, end + " // ".length());
                    int nextMySep = line.indexOf(" // ", end + " // ".length());
                    begin = end + " // ".length();
                    if (nextMySep < 0 || nextMySep >= nextSl) break;
                    end = nextMySep;
                }
                end = nextSl > 0 ? nextSl : line.length();
                adjusted.append(line.substring(begin, end));
                element = adjusted.toString();
                next = end;
            } else {
                element = new String(line.substring(index, next));
            }
            index = next + 1;
            if (i == 0 && DIRECTORY_CACHE_ID.equals(element)) {
                dir = true;
                --i;
            } else {
                elements[i] = element;
            }
            ++i;
        }
        if (dir) {
            elements[0] = elements[0] + "/";
        }
        return elements;
    }

    public static String getLineFromElements(String[] elements) {
        if (elements.length < 9) {
            return null;
        }
        boolean dir = elements[0].endsWith("/");
        String firstElement = dir ? elements[0].substring(0, elements[0].length() - 1) : elements[0];
        StringBuffer line = new StringBuffer();
        if (dir) {
            line.append(DIRECTORY_CACHE_ID);
        }
        line.append('/');
        line.append(RefreshCommandSupport.adjustElement(firstElement));
        line.append('/');
        int i = 1;
        while (i < 9) {
            line.append(RefreshCommandSupport.adjustElement(elements[i]));
            line.append('/');
            ++i;
        }
        return line.toString();
    }

    private static String adjustElement(String element) {
        int index = element.indexOf(47);
        if (index < 0) {
            return element;
        }
        StringBuffer adjusted = new StringBuffer();
        int begin = 0;
        while (index >= 0 && index < element.length()) {
            adjusted.append(element.substring(begin, index));
            adjusted.append(" // ");
            begin = index + 1;
            index = element.indexOf(47, begin);
        }
        if (begin < element.length()) {
            adjusted.append(element.substring(begin));
        }
        return adjusted.toString();
    }

    public static String getStatusAnnotation(String name, String fullName, String annotationPattern, FileStatusProvider statusProvider) {
        return RefreshCommandSupport.getStatusAnnotation(name, fullName, annotationPattern, statusProvider, null);
    }

    public static String getStatusAnnotation(String name, String fullName, String annotationPattern, FileStatusProvider statusProvider, Hashtable additionalVars) {
        Hashtable<String, String> vars = new Hashtable<String, String>();
        if (additionalVars != null) {
            vars.putAll(additionalVars);
        }
        vars.put(ANNOTATION_PATTERN_FILE_NAME, name);
        FileStatusInfo statusInfo = statusProvider.getFileStatusInfo(fullName);
        String status = statusInfo != null ? statusInfo.getDisplayName() : statusProvider.getFileStatus(fullName);
        if (status != null) {
            vars.put(ANNOTATION_PATTERN_STATUS, status);
        }
        if ((status = statusProvider.getFileLocker(fullName)) != null) {
            vars.put(ANNOTATION_PATTERN_LOCKER, status);
        }
        if ((status = statusProvider.getFileRevision(fullName)) != null) {
            vars.put(ANNOTATION_PATTERN_REVISION, status);
        }
        if ((status = statusProvider.getFileSticky(fullName)) != null) {
            vars.put(ANNOTATION_PATTERN_STICKY, status);
        }
        if ((status = statusProvider.getFileSize(fullName)) != null) {
            vars.put(ANNOTATION_PATTERN_SIZE, status);
        }
        if ((status = statusProvider.getFileAttribute(fullName)) != null) {
            vars.put(ANNOTATION_PATTERN_ATTR, status);
        }
        if ((status = statusProvider.getFileDate(fullName)) != null) {
            vars.put(ANNOTATION_PATTERN_DATE, status);
        }
        if ((status = statusProvider.getFileTime(fullName)) != null) {
            vars.put(ANNOTATION_PATTERN_TIME, status);
        }
        return Variables.expand(vars, annotationPattern, false);
    }

    public static String getStatusAnnotation(String name, ArrayList files, String annotationPattern, FileStatusProvider statusProvider, int[] multiFilesAnnotationTypes) {
        Hashtable<String, String> vars = new Hashtable<String, String>();
        ArrayList<String> attributes = new ArrayList<String>();
        int n = files.size();
        if (n == 0) {
            return name;
        }
        vars.put(ANNOTATION_PATTERN_FILE_NAME, name);
        Object trans = null;
        int i = 0;
        while (i < n) {
            FileStatusInfo statusInfo = statusProvider.getFileStatusInfo((String)files.get(i));
            String status = statusInfo != null ? statusInfo.getDisplayName() : statusProvider.getFileStatus((String)files.get(i));
            attributes.add(status);
            ++i;
        }
        String attr = RefreshCommandSupport.getAttribute(attributes, multiFilesAnnotationTypes[1], statusProvider.getNotInSynchStatus());
        if (attr != null) {
            vars.put(ANNOTATION_PATTERN_STATUS, attr);
        }
        attributes.clear();
        int i2 = 0;
        while (i2 < n) {
            attributes.add(statusProvider.getFileLocker((String)files.get(i2)));
            ++i2;
        }
        attr = RefreshCommandSupport.getAttribute(attributes, multiFilesAnnotationTypes[2], statusProvider.getNotInSynchStatus());
        if (attr != null) {
            vars.put(ANNOTATION_PATTERN_LOCKER, attr);
        }
        attributes.clear();
        int i3 = 0;
        while (i3 < n) {
            attributes.add(statusProvider.getFileRevision((String)files.get(i3)));
            ++i3;
        }
        attr = RefreshCommandSupport.getAttribute(attributes, multiFilesAnnotationTypes[3], statusProvider.getNotInSynchStatus());
        if (attr != null) {
            vars.put(ANNOTATION_PATTERN_REVISION, attr);
        }
        attributes.clear();
        int i4 = 0;
        while (i4 < n) {
            attributes.add(statusProvider.getFileSticky((String)files.get(i4)));
            ++i4;
        }
        attr = RefreshCommandSupport.getAttribute(attributes, multiFilesAnnotationTypes[4], statusProvider.getNotInSynchStatus());
        if (attr != null) {
            vars.put(ANNOTATION_PATTERN_STICKY, attr);
        }
        attributes.clear();
        int i5 = 0;
        while (i5 < n) {
            attributes.add(statusProvider.getFileAttribute((String)files.get(i5)));
            ++i5;
        }
        attr = RefreshCommandSupport.getAttribute(attributes, multiFilesAnnotationTypes[5], statusProvider.getNotInSynchStatus());
        if (attr != null) {
            vars.put(ANNOTATION_PATTERN_ATTR, attr);
        }
        attributes.clear();
        int i6 = 0;
        while (i6 < n) {
            attributes.add(statusProvider.getFileSize((String)files.get(i6)));
            ++i6;
        }
        attr = RefreshCommandSupport.getAttribute(attributes, multiFilesAnnotationTypes[6], statusProvider.getNotInSynchStatus());
        if (attr != null) {
            vars.put(ANNOTATION_PATTERN_SIZE, attr);
        }
        attributes.clear();
        int i7 = 0;
        while (i7 < n) {
            attributes.add(statusProvider.getFileDate((String)files.get(i7)));
            ++i7;
        }
        attr = RefreshCommandSupport.getAttribute(attributes, multiFilesAnnotationTypes[7], statusProvider.getNotInSynchStatus());
        if (attr != null) {
            vars.put(ANNOTATION_PATTERN_DATE, attr);
        }
        attributes.clear();
        int i8 = 0;
        while (i8 < n) {
            attributes.add(statusProvider.getFileTime((String)files.get(i8)));
            ++i8;
        }
        attr = RefreshCommandSupport.getAttribute(attributes, multiFilesAnnotationTypes[8], statusProvider.getNotInSynchStatus());
        if (attr != null) {
            vars.put(ANNOTATION_PATTERN_TIME, attr);
        }
        return Variables.expand(vars, annotationPattern, false);
    }

    private static String getAttribute(ArrayList attributes, int annotationType, String nSynch) {
        Object firstObj = attributes.get(0);
        if (firstObj == null) {
            return null;
        }
        String first = (String)firstObj;
        int n = attributes.size();
        int i = 1;
        i = 1;
        while (i < n) {
            if (!firstObj.equals(attributes.get(i))) break;
            ++i;
        }
        boolean differ = i < n;
        switch (annotationType) {
            case 0: {
                if (differ) {
                    return "";
                }
                return first;
            }
            case 2: {
                if (differ) {
                    return nSynch;
                }
                return first;
            }
            case 1: {
                if (!differ) {
                    return first;
                }
                StringBuffer buf = new StringBuffer(first);
                int j = 1;
                while (j < n) {
                    buf.append(DEFAULT_MULTI_FILES_ANNOTATION_DELIMETER + (String)attributes.get(j));
                    ++j;
                }
                return buf.toString();
            }
        }
        return "";
    }
}

