/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.caching;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.api.vcs.VcsManager;
import org.netbeans.api.vcs.commands.Command;
import org.netbeans.modules.vcscore.DirReaderListener;
import org.netbeans.modules.vcscore.FileReaderListener;
import org.netbeans.modules.vcscore.VcsDirContainer;
import org.netbeans.modules.vcscore.VcsFactory;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.cache.FileSystemCache;
import org.netbeans.modules.vcscore.caching.FileStatusProvider;
import org.netbeans.modules.vcscore.caching.RefreshCommandSupport;
import org.netbeans.modules.vcscore.caching.VcsCacheDir;
import org.netbeans.modules.vcscore.caching.VcsCacheFile;
import org.netbeans.modules.vcscore.commands.VcsDescribedCommand;
import org.netbeans.modules.vcscore.util.Debug;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.netbeans.spi.vcs.commands.CommandSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;

public class VcsCache
extends FileSystemCache
implements FileReaderListener {
    private Debug E;
    private Debug D;
    private Reference fileSystem;
    private String fsRoot;
    private int rootNameLength;
    private Map cacheDirs;
    private HashMap refreshStrategyWhenNonLocal;
    private Map directoriesScheduledForRefresh;
    private static RequestProcessor ignoreListRequestProcessor;
    private static WeakSet vcsCacheInstanceSet;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$caching$VcsCache;

    public VcsCache(Reference fileSystem, String cacheName) {
        super(cacheName);
        this.D = this.E = new Debug("VcsCache", true);
        this.fileSystem = fileSystem;
        VcsFileSystem fsystem = (VcsFileSystem)fileSystem.get();
        this.fsRoot = fsystem.getRootDirectory().getAbsolutePath();
        fsystem.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                VcsCache.this.updateFSRoot();
            }
        });
        this.rootNameLength = this.fsRoot.length();
        this.cacheDirs = new Hashtable();
        this.refreshStrategyWhenNonLocal = new HashMap();
        this.directoriesScheduledForRefresh = new HashMap();
    }

    public void updateFSRoot() {
        this.fsRoot = ((VcsFileSystem)this.fileSystem.get()).getRootDirectory().getAbsolutePath();
        this.rootNameLength = this.fsRoot.length();
    }

    String getPath(File file) {
        String filePath = file.getAbsolutePath();
        if (filePath.length() <= this.rootNameLength) {
            return "";
        }
        String path = filePath.charAt(this.rootNameLength) == '/' || filePath.charAt(this.rootNameLength) == File.separatorChar ? filePath.substring(this.rootNameLength + 1) : filePath.substring(this.rootNameLength);
        path = path.replace(File.separatorChar, '/');
        return path;
    }

    String getAbsolutePath(File file) {
        return file.getAbsolutePath();
    }

    private VcsFactory getFactory() {
        VcsFileSystem fsystem = (VcsFileSystem)this.fileSystem.get();
        if (fsystem == null) {
            return null;
        }
        return fsystem.getVcsFactory();
    }

    void runVcsDirReader(VcsCacheDir cacheDir, Object locker) {
        VcsFileSystem fsystem;
        VcsCache vcsCache = this;
        synchronized (vcsCache) {
            fsystem = (VcsFileSystem)this.fileSystem.get();
            if (fsystem == null) {
                return;
            }
            if (cacheDir.isBeingLoaded()) {
                return;
            }
            cacheDir.setBeingLoaded(true);
        }
        CommandSupport list = fsystem.isOffLine() ? fsystem.getCommandSupport("LIST_OFFLINE") : fsystem.getCommandSupport("LIST");
        if (list != null) {
            RequestProcessor.getDefault().post((Runnable)new RefreshProcessStarter(list, cacheDir.getFile(), locker));
        } else {
            VcsCache vcsCache2 = this;
            synchronized (vcsCache2) {
                cacheDir.setBeingLoaded(false);
            }
        }
    }

    synchronized void runVcsDirReaderRecursive(VcsCacheDir cacheDir, Object locker) {
        VcsFileSystem fsystem = (VcsFileSystem)this.fileSystem.get();
        if (fsystem == null) {
            return;
        }
        CommandSupport list = fsystem.isOffLine() ? fsystem.getCommandSupport("LIST_SUB_OFFLINE") : fsystem.getCommandSupport("LIST_SUB");
        if (list != null) {
            RequestProcessor.getDefault().post((Runnable)new RefreshProcessStarter(list, cacheDir.getFile(), locker));
        }
    }

    String getCacheFileName(File dir) {
        VcsFileSystem fsystem = (VcsFileSystem)this.fileSystem.get();
        if (fsystem == null) {
            return null;
        }
        return fsystem.getCacheFileName(this.getPath(dir));
    }

    FilenameFilter getLocalFileFilter() {
        VcsFileSystem fsystem = (VcsFileSystem)this.fileSystem.get();
        if (fsystem == null) {
            return null;
        }
        return fsystem.getLocalFileFilter();
    }

    String getLocalFileStatus() {
        VcsFileSystem fsystem = (VcsFileSystem)this.fileSystem.get();
        if (fsystem == null) {
            return "";
        }
        FileStatusProvider statusProvider = fsystem.getStatusProvider();
        if (statusProvider == null) {
            return "";
        }
        return statusProvider.getLocalFileStatus();
    }

    public void writeAllToDisk() {
    }

    protected void loadDir(CacheDir dir, int strategy, Object locker) {
        if (strategy == 11 || strategy == 12) {
            ((VcsCacheDir)dir).refreshLocal(strategy == 12);
            if (dir.isLocal()) {
                return;
            }
            if (this.doesStrategyApply(dir, strategy, 11)) {
                dir.checkServer(locker);
            }
            if (this.doesStrategyApply(dir, strategy, 10)) {
                dir.setAppliedLevel(10);
            }
            if (this.doesStrategyApply(dir, strategy, 12)) {
                dir.checkServerRecursive(locker);
            }
        } else {
            super.loadDir(dir, strategy, locker);
        }
        if (dir.isLocal() && (this.doesStrategyApply(dir, strategy, 11) || this.doesStrategyApply(dir, strategy, 3))) {
            this.refreshStrategyWhenNonLocal.put(dir.getAbsolutePath(), new Integer(strategy));
        }
    }

    public CacheFile getCacheFile(File toFind, int strategy, Object locker) {
        String parentDir;
        VcsFileSystem fsystem = (VcsFileSystem)this.fileSystem.get();
        if (fsystem == null) {
            return null;
        }
        boolean findThis = false;
        if (fsystem.getRootDirectory().equals(toFind) || toFind.getParentFile() == null) {
            parentDir = toFind.getAbsolutePath();
            toFind = fsystem.getRootDirectory();
            findThis = true;
        } else {
            parentDir = toFind.getParentFile().getAbsolutePath();
        }
        CacheDir cacheDir = this.getDir(parentDir);
        if (cacheDir == null) {
            boolean[] grandParentExists = new boolean[]{false};
            cacheDir = this.lookupCacheDir(new File(parentDir), grandParentExists);
            if (!grandParentExists[0]) {
                cacheDir = this.initCacheDir(new File(parentDir));
            }
            if (cacheDir == null) {
                return null;
            }
        }
        if (strategy == 4) {
            int level = cacheDir.getAppliedLevel();
            if (level >= 3) {
                cacheDir.populateWithLocal(locker);
                cacheDir.setAppliedLevel(level);
            }
            strategy = 3;
        }
        if (strategy != 5 && strategy != 3 && strategy != -1 || cacheDir.getAppliedLevel() < 3) {
            this.loadDir(cacheDir, strategy, locker);
        }
        if (findThis) {
            return cacheDir;
        }
        String name = toFind.getName();
        CacheFile file = cacheDir.getFile(name);
        if (file != null) {
            return file;
        }
        CacheDir dir = cacheDir.getSubDir(name);
        return dir;
    }

    public void doRefreshDir(CacheDir dir, boolean recursively) {
        this.doRefreshDir(dir, recursively, null);
    }

    public void doRefreshDir(CacheDir dir, boolean recursively, Object locker) {
        int strategy;
        int n = strategy = recursively ? 12 : 11;
        if (dir instanceof VcsCacheDir) {
            VcsCacheDir vdir = (VcsCacheDir)dir;
            if (vdir.isBeingLoaded()) {
                Map map = this.directoriesScheduledForRefresh;
                synchronized (map) {
                    Object[] params = (Object[])this.directoriesScheduledForRefresh.get(vdir);
                    if (params != null) {
                        if (recursively && !((Boolean)params[0]).booleanValue()) {
                            params[0] = Boolean.TRUE;
                        }
                    } else {
                        params = new Object[]{recursively ? Boolean.TRUE : Boolean.FALSE, locker};
                        this.directoriesScheduledForRefresh.put(vdir, params);
                    }
                }
            } else {
                vdir.setLoaded(false);
                this.loadDir(dir, strategy, locker);
            }
        } else {
            this.loadDir(dir, strategy, locker);
        }
    }

    private void runScheduledRefresh(CacheDir dir) {
        Object[] params;
        Map map = this.directoriesScheduledForRefresh;
        synchronized (map) {
            params = (Object[])this.directoriesScheduledForRefresh.remove(dir);
        }
        if (params != null) {
            this.doRefreshDir(dir, (Boolean)params[0], params[1]);
        }
    }

    private CacheDir lookupCacheDir(File file, boolean[] grandParentExists) {
        File parent = file.getParentFile();
        if (parent == null) {
            return null;
        }
        CacheDir parentDir = this.getDir(parent.getAbsolutePath());
        if (parentDir == null) {
            parentDir = this.lookupCacheDir(parent, grandParentExists);
        }
        CacheDir dir = null;
        if (parentDir != null) {
            grandParentExists[0] = true;
            dir = parentDir.getSubDir(file.getName());
        }
        return dir;
    }

    CacheDir lookupCacheDir(File file, boolean local) {
        File parent = file.getParentFile();
        if (parent == null) {
            return null;
        }
        CacheDir parentDir = this.getDir(parent.getAbsolutePath());
        if (parentDir == null) {
            parentDir = this.lookupCacheDir(parent, local);
        }
        if (parentDir != null) {
            CacheDir dir = parentDir.getSubDir(file.getName());
            if (dir == null) {
                dir = new VcsCacheDir(this.getId(), file);
                parentDir.addChildDir(dir, false);
                dir.setLocal(local);
                if (local) {
                    dir.setStatus(this.getLocalFileStatus());
                } else {
                    ((VcsCacheDir)dir).readChildNamesFromDisk();
                }
            }
            this.registerDir(dir);
            return dir;
        }
        return null;
    }

    private CacheDir initCacheDir(File toInit) {
        File parentFile = toInit.getParentFile();
        CacheDir parentDir = null;
        if (parentFile != null) {
            parentDir = this.getDir(parentFile.getAbsolutePath());
        }
        CacheDir initDir = null;
        if (parentDir == null && parentFile != null) {
            parentDir = this.lookupCacheDir(parentFile, false);
        }
        if (parentDir == null) {
            VcsFileSystem fsystem = (VcsFileSystem)this.fileSystem.get();
            if (fsystem == null) {
                return null;
            }
            VcsFactory factory = fsystem.getVcsFactory();
            initDir = new VcsCacheDir(this.getId(), toInit);
            initDir.setLocal(false);
            ((VcsCacheFile.VcsPersistentData)initDir.getPersistentData()).setModified(true);
        } else {
            initDir = parentDir.getSubDir(toInit.getName());
            if (initDir == null) {
                initDir = new VcsCacheDir(this.getId(), toInit);
                parentDir.addChildDir(initDir, false);
                initDir.setLocal(false);
            }
        }
        this.registerDir(initDir);
        return initDir;
    }

    /*
     * WARNING - void declaration
     */
    public void registerDir(CacheDir dir) {
        if (dir != null) {
            int index;
            String fullName = dir.getAbsolutePath();
            while (fullName.endsWith(File.separator)) {
                fullName = fullName.substring(0, fullName.length() - 1);
            }
            while ((index = fullName.indexOf(File.separator + File.separator)) > 0) {
                void var3_3;
                fullName = fullName.substring(0, (int)var3_3) + fullName.substring((int)(var3_3 + true), fullName.length());
            }
            this.cacheDirs.put(fullName, new WeakReference<CacheDir>(dir));
        }
    }

    public void registerDirRecursive(CacheDir dir) {
        this.registerDir(dir);
        CacheDir[] dirs = dir.getSubDirs();
        int i = 0;
        while (i < dirs.length) {
            this.registerDirRecursive(dirs[i]);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void unregisterDir(CacheDir dir) {
        if (dir != null) {
            int index;
            String fullName = dir.getAbsolutePath();
            while (fullName.endsWith(File.separator)) {
                fullName = fullName.substring(0, fullName.length() - 1);
            }
            while ((index = fullName.indexOf(File.separator + File.separator)) > 0) {
                void var3_3;
                fullName = fullName.substring(0, (int)var3_3) + fullName.substring((int)(var3_3 + true), fullName.length());
            }
            this.cacheDirs.remove(fullName);
            CacheDir[] subDirs = dir.getSubDirs();
            int i = 0;
            while (i < subDirs.length) {
                this.unregisterDir(subDirs[i]);
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public CacheDir getDir(String fullName) {
        int index;
        while (fullName.endsWith(File.separator)) {
            fullName = fullName.substring(0, fullName.length() - 1);
        }
        while ((index = fullName.indexOf(File.separator + File.separator)) > 0) {
            void var2_2;
            fullName = fullName.substring(0, (int)var2_2) + fullName.substring((int)(var2_2 + true), fullName.length());
        }
        Reference cacheDirRef = (Reference)this.cacheDirs.get(fullName);
        return cacheDirRef != null ? cacheDirRef.get() : null;
    }

    private void heyDoRefreshDir(String path) {
        FileObject fo;
        VcsFileSystem fsystem = (VcsFileSystem)this.fileSystem.get();
        if (fsystem != null && (fo = fsystem.findExistingResource(path)) != null) {
            fo.refresh();
            fsystem.checkForModifications(fo.getPath(), false, true, false);
        }
    }

    private void heyDoRefreshDirRecursive(VcsCacheDir dir) {
        this.heyDoRefreshDir(this.getPath(dir.getFile()));
        CacheDir[] subdirs = dir.getSubDirs();
        int i = 0;
        while (i < subdirs.length) {
            this.heyDoRefreshDirRecursive((VcsCacheDir)subdirs[i]);
            ++i;
        }
    }

    private ArrayList getNonLocalSubfiles(VcsCacheDir dir) {
        String[] mySubFiles = dir.getFilesAndSubdirs();
        ArrayList<String> lastNonLocal = new ArrayList<String>(Arrays.asList(mySubFiles));
        int i = 0;
        while (i < lastNonLocal.size()) {
            CacheDir subDir;
            String fileName = lastNonLocal.get(i);
            CacheFile file = dir.getFile(fileName);
            if (file instanceof VcsCacheFile) {
                if (((VcsCacheFile)file).isLocal()) {
                    lastNonLocal.remove(i--);
                }
            } else if (file instanceof VcsCacheDir && ((VcsCacheDir)file).isLocal()) {
                lastNonLocal.remove(i--);
            }
            if ((subDir = dir.getSubDir(fileName)) instanceof VcsCacheDir && ((VcsCacheDir)subDir).isLocal()) {
                lastNonLocal.remove(i--);
            }
            ++i;
        }
        return lastNonLocal;
    }

    private VcsCacheDir createSubFiles(VcsFileSystem fs, String path, Collection rawData, Object locker) {
        VcsCacheDir dir = (VcsCacheDir)fs.getCacheProvider().getDir(path);
        if (dir == null && (dir = this.createAndRefreshReadFolders(fs.getFile(path))) == null) {
            dir = (VcsCacheDir)this.initCacheDir(fs.getFile(path));
        }
        CacheHandler handler = CacheHandler.getInstance();
        ArrayList lastNonLocal = this.getNonLocalSubfiles(dir);
        Iterator it = rawData.iterator();
        while (it.hasNext()) {
            Integer refresh;
            String[] elements = (String[])it.next();
            CacheFile file = RefreshCommandSupport.matchToFile(elements, fs.getCacheIdStr(), dir.getFile());
            handler.addCacheLocker(locker, file);
            String fileName = file.getName();
            if (file instanceof VcsCacheFile) {
                ((VcsCacheFile)file).setLocal(false);
                if (lastNonLocal.contains(fileName)) {
                    dir.removeFile(fileName, false);
                    dir.addFile(file, false);
                    ((AbstractCollection)lastNonLocal).remove(fileName);
                    continue;
                }
                dir.addFile(file, true);
                continue;
            }
            if (!(file instanceof VcsCacheDir)) continue;
            VcsCacheDir sDir = (VcsCacheDir)file;
            sDir.setLocal(false);
            if (lastNonLocal.contains(fileName)) {
                ((AbstractCollection)lastNonLocal).remove(fileName);
            } else {
                dir.addChildDir(sDir, true);
            }
            if (sDir != dir.getSubDir(fileName)) {
                VcsCacheDir origDir = (VcsCacheDir)dir.getSubDir(fileName);
                origDir.setStatus(sDir.getStatus());
                origDir.setSticky(sDir.getSticky());
                origDir.setLocker(sDir.getLocker());
                origDir.setRevision(sDir.getRevision());
                origDir.setSize(sDir.getSize());
                origDir.setDate(sDir.getDate());
                origDir.setTime(sDir.getTime());
                origDir.setAttr(sDir.getAttr());
                origDir.setLocal(false);
                handler.removeCacheLocker(locker, sDir);
                sDir = origDir;
                handler.addCacheLocker(locker, sDir);
            }
            if ((refresh = (Integer)this.refreshStrategyWhenNonLocal.get(sDir.getAbsolutePath())) == null) continue;
            this.loadDir(sDir, refresh, null);
        }
        if (lastNonLocal.size() > 0) {
            int i = lastNonLocal.size() - 1;
            while (i >= 0) {
                String fileName = (String)lastNonLocal.get(i);
                CacheFile file = dir.getFile(fileName);
                if (file != null) {
                    dir.removeFile(fileName, true);
                } else {
                    CacheDir subDir = dir.getSubDir(fileName);
                    if (subDir != null) {
                        dir.removeChildDir(fileName, true);
                    }
                }
                --i;
            }
            dir.refreshLocal(false);
        }
        dir.setLoaded(true);
        return dir;
    }

    private VcsCacheDir createSubFiles(VcsFileSystem fs, VcsDirContainer filesByName, Object locker) {
        Hashtable fileElements = (Hashtable)filesByName.getElement();
        Collection<Object> rawData = fileElements == null ? Collections.EMPTY_LIST : fileElements.values();
        CacheHandler handler = CacheHandler.getInstance();
        VcsCacheDir dir = this.createSubFiles(fs, filesByName.getPath(), rawData, locker);
        handler.addCacheLocker(locker, dir);
        VcsDirContainer[] subfilesByName = filesByName.getSubdirContainers();
        int i = 0;
        while (i < subfilesByName.length) {
            VcsCacheDir subDir = this.createSubFiles(fs, subfilesByName[i], locker);
            dir.addChildDir(subDir, true);
            handler.addCacheLocker(locker, subDir);
            ++i;
        }
        return dir;
    }

    private VcsCacheDir createAndRefreshReadFolders(File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            return null;
        }
        VcsCacheDir parentDir = (VcsCacheDir)this.getDir(parent.getAbsolutePath());
        if (parentDir == null) {
            parentDir = this.createAndRefreshReadFolders(parent);
        }
        if (parentDir != null) {
            CacheDir dir;
            if (!(parentDir.isLocal() || parentDir.isLoaded() || parentDir.isBeingLoaded())) {
                this.getCacheFile(new File(parentDir.getFile(), "testing"), 5, null);
            }
            if ((dir = parentDir.getSubDir(file.getName())) == null) {
                dir = new VcsCacheDir(this.getId(), file);
                parentDir.addChildDir(dir, false);
                dir.setLocal(false);
                ((VcsCacheDir)dir).readChildNamesFromDisk();
            }
            parentDir.writeToDisk();
            this.registerDir(dir);
            this.heyDoRefreshDir(this.getPath(parentDir.getFile()));
            return (VcsCacheDir)dir;
        }
        return null;
    }

    public void readFileFinished(String path, Collection rawData) {
        VcsFileSystem fs = (VcsFileSystem)this.fileSystem.get();
        if (fs == null) {
            return;
        }
        VcsCacheDir dir = (VcsCacheDir)fs.getCacheProvider().getDir(path);
        if (dir == null && (dir = this.createAndRefreshReadFolders(fs.getFile(path))) == null) {
            dir = (VcsCacheDir)this.initCacheDir(fs.getFile(path));
            this.registerDir(dir);
        }
        HashSet<CacheFile> readFilesLocked = new HashSet<CacheFile>();
        Iterator it = rawData.iterator();
        while (it.hasNext()) {
            CacheFile file;
            String[] elements = (String[])it.next();
            if (elements.length == 1) {
                file = dir.getFile(elements[0]);
                if (file != null) {
                    dir.removeFile(elements[0], true);
                    continue;
                }
                file = dir.getSubDir(elements[0]);
                if (file == null) continue;
                dir.removeChildDir(elements[0], true);
                continue;
            }
            file = RefreshCommandSupport.matchToExistingFile(elements, fs.getCacheIdStr(), dir.getFile());
            readFilesLocked.add(file);
            String fileName = file.getName();
            boolean isAdded = false;
            if (file instanceof VcsCacheFile && dir.getFile(fileName) == null) {
                dir.addFile(file, true);
                isAdded = true;
            } else if (file instanceof VcsCacheDir && dir.getSubDir(fileName) == null) {
                dir.addChildDir((CacheDir)file, true);
                isAdded = true;
            }
            if (isAdded) {
                this.fireCacheHandlerEvent(0, file);
                continue;
            }
            try {
                this.fireCacheHandlerEvent(2, file);
            }
            catch (UndeclaredThrowableException utex) {
                throw (UndeclaredThrowableException)ErrorManager.getDefault().annotate((Throwable)utex, "BAD cache file fired: " + file + ", it's parent = " + file.getParent() + ", dir = " + dir + ", registered dir for file '" + dir.getFile().getAbsolutePath() + "' = " + this.getDir(dir.getFile().getAbsolutePath()) + "\nPlease attach this text to issue #24340");
            }
        }
        dir.writeToDisk();
        this.heyDoRefreshDir(this.getPath(dir.getFile()));
    }

    public void readDirFinished(String path, Collection rawData, boolean success, Object locker) {
        VcsFileSystem fs = (VcsFileSystem)this.fileSystem.get();
        if (fs == null) {
            return;
        }
        String absolutePath = this.fsRoot + File.separatorChar + path.replace('/', File.separatorChar);
        if (!success && rawData.size() == 0) {
            CacheDir dir = this.getDir(absolutePath);
            if (dir instanceof VcsCacheDir) {
                ((VcsCacheDir)dir).setBeingLoaded(false);
                ((VcsCacheDir)dir).setLoaded(true);
            }
            return;
        }
        VcsCacheDir dir = this.createSubFiles(fs, path, rawData, locker);
        this.registerDir(dir);
        dir.writeToDisk();
        dir.setBeingLoaded(false);
        this.fireCacheHandlerEvent(2, dir);
        this.heyDoRefreshDir(this.getPath(dir.getFile()));
        this.runScheduledRefresh(dir);
    }

    public void readDirFinishedRecursive(String path, VcsDirContainer rawData, boolean success, Object locker) {
        VcsFileSystem fs = (VcsFileSystem)this.fileSystem.get();
        if (fs == null) {
            return;
        }
        String absolutePath = this.fsRoot + File.separatorChar + path.replace('/', File.separatorChar);
        VcsCacheDir dir = this.createSubFiles(fs, rawData, locker);
        this.registerDirRecursive(dir);
        dir.writeToDiskRecursively();
        this.fireCacheHandlerEvent(3, dir);
        this.heyDoRefreshDirRecursive(dir);
    }

    void createIgnoreList(final VcsCacheDir dir, ArrayList parentIgnoreList) {
        VcsFileSystem fs = (VcsFileSystem)this.fileSystem.get();
        if (fs == null) {
            return;
        }
        final VcsFileSystem.IgnoreListSupport ignSupport = fs.getIgnoreListSupport();
        Class clazz = class$org$netbeans$modules$vcscore$caching$VcsCache == null ? (class$org$netbeans$modules$vcscore$caching$VcsCache = VcsCache.class$("org.netbeans.modules.vcscore.caching.VcsCache")) : class$org$netbeans$modules$vcscore$caching$VcsCache;
        synchronized (clazz) {
            if (vcsCacheInstanceSet == null) {
                vcsCacheInstanceSet = new WeakSet();
            }
            vcsCacheInstanceSet.add((Object)this);
            if (ignoreListRequestProcessor == null) {
                ignoreListRequestProcessor = new RequestProcessor("Ignore List Creation Request Processor");
            }
            ignoreListRequestProcessor.post(new Runnable(){

                public void run() {
                    if (dir.isIgnoreListSet()) {
                        return;
                    }
                    ArrayList ignoreList = VcsUtilities.createIgnoreList(dir, VcsCache.this.getPath(dir.getFile()), ignSupport);
                    dir.setIgnoreList(ignoreList);
                }
            });
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        Class clazz = class$org$netbeans$modules$vcscore$caching$VcsCache == null ? (class$org$netbeans$modules$vcscore$caching$VcsCache = VcsCache.class$("org.netbeans.modules.vcscore.caching.VcsCache")) : class$org$netbeans$modules$vcscore$caching$VcsCache;
        synchronized (clazz) {
            if (vcsCacheInstanceSet != null && vcsCacheInstanceSet.isEmpty()) {
                vcsCacheInstanceSet = null;
                ignoreListRequestProcessor = null;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DirReaderListenerWithLock
    implements DirReaderListener {
        private Object locker;

        public DirReaderListenerWithLock(Object locker) {
            this.locker = locker;
        }

        public void readDirFinished(String path, Collection rawData, boolean success) {
            VcsCache.this.readDirFinished(path, rawData, success, this.locker);
            this.locker = null;
        }

        public void readDirFinishedRecursive(String path, VcsDirContainer rawData, boolean success) {
            VcsCache.this.readDirFinishedRecursive(path, rawData, success, this.locker);
            this.locker = null;
        }
    }

    private class RefreshProcessStarter
    implements Runnable {
        private CommandSupport list;
        private File dir;
        private Object locker;

        public RefreshProcessStarter(CommandSupport list, File dir, Object locker) {
            this.list = list;
            this.dir = dir;
            this.locker = locker;
        }

        public void run() {
            Command cmd = this.list.createCommand();
            if (cmd instanceof VcsDescribedCommand) {
                ((VcsDescribedCommand)cmd).setDiskFiles(new File[]{this.dir});
                ((VcsDescribedCommand)cmd).addDirReaderListener(new DirReaderListenerWithLock(this.locker));
                VcsManager.getDefault().showCustomizer(cmd);
                cmd.execute();
            }
        }
    }
}

