/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.caching;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.caching.RefreshCommandSupport;
import org.netbeans.modules.vcscore.caching.VcsCache;
import org.netbeans.modules.vcscore.caching.VcsCacheFile;
import org.netbeans.modules.vcscore.util.Debug;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.openide.ErrorManager;

public class VcsCacheDir
extends CacheDir {
    private Debug E;
    private Debug D;
    private volatile boolean beingLoaded;
    private boolean errorLineReported;
    private boolean errorWriteReported;
    private Object errorLock;
    private final Object loadedLock;

    public VcsCacheDir(String cacheName, File dirFile) {
        super(cacheName, dirFile, (CacheFile.PersistentData)new VcsCacheFile.VcsPersistentData(true));
        this.D = this.E = new Debug("VcsCacheDir", true);
        this.beingLoaded = false;
        this.errorLineReported = false;
        this.errorWriteReported = false;
        this.errorLock = new Object();
        this.loadedLock = new Object();
        this.setLocal(true);
        this.setLoaded(false);
    }

    VcsCacheDir(String cacheName, File dirFile, CacheFile.PersistentData data) {
        super(cacheName, dirFile, data);
        this.D = this.E = new Debug("VcsCacheDir", true);
        this.beingLoaded = false;
        this.errorLineReported = false;
        this.errorWriteReported = false;
        this.errorLock = new Object();
        this.loadedLock = new Object();
        this.setLoaded(false);
    }

    public String getPath() {
        return this.dirFile.getAbsolutePath();
    }

    public File getFile() {
        return this.dirFile;
    }

    public String getFSPath() {
        return ((VcsCache)this.getCacheObject()).getPath(this.getFile());
    }

    public final boolean isLoaded() {
        return ((VcsCacheFile.VcsPersistentData)this.getPersistentData()).isLoaded();
    }

    protected final void setLoaded(boolean loaded) {
        Object object = this.loadedLock;
        synchronized (object) {
            ((VcsCacheFile.VcsPersistentData)this.getPersistentData()).setLoaded(loaded);
            this.loadedLock.notifyAll();
        }
    }

    public final boolean isBeingLoaded() {
        return this.beingLoaded;
    }

    protected final void setBeingLoaded(boolean beingLoaded) {
        this.beingLoaded = beingLoaded;
    }

    protected final void setLoadedRecursive(boolean loaded) {
        this.setLoaded(loaded);
        CacheDir[] subdirs = this.getSubDirs();
        int i = 0;
        while (i < subdirs.length) {
            ((VcsCacheDir)subdirs[i]).setLoadedRecursive(loaded);
            ++i;
        }
    }

    public final void waitToLoad() throws InterruptedException {
        Object object = this.loadedLock;
        synchronized (object) {
            while (!this.isLoaded()) {
                this.loadedLock.wait();
            }
        }
    }

    public void add(CacheFile child) {
        if (child instanceof VcsCacheDir || child instanceof CacheDir) {
            this.addChildDir((CacheDir)child, true);
        } else {
            this.addFile(child, true);
        }
    }

    private boolean checkSiblings(CacheFile file) {
        boolean bad;
        boolean bl = bad = !((VcsCacheFile.VcsPersistentData)file.getPersistentData()).dumpSiblings(false);
        if (bad) {
            ((VcsCacheFile.VcsPersistentData)file.getPersistentData()).dumpSiblings(true);
        }
        if (!bad) {
            String[] children = this.getSubDirNames();
            int i = 0;
            while (i < children.length) {
                VcsCacheDir cDir = (VcsCacheDir)this.getSubDirIfExists(children[i]);
                if (cDir != null) {
                    VcsCacheFile.VcsPersistentData sdata = (VcsCacheFile.VcsPersistentData)cDir.getPersistentData();
                    boolean bl2 = bad = bad || !sdata.dumpSiblings(false);
                    if (bad) {
                        sdata.dumpSiblings(true);
                    }
                }
                ++i;
            }
            children = this.getFileNames();
            int i2 = 0;
            while (i2 < children.length) {
                VcsCacheFile cFile = (VcsCacheFile)this.getFileIfExists(children[i2]);
                if (cFile != null) {
                    VcsCacheFile.VcsPersistentData sdata = (VcsCacheFile.VcsPersistentData)cFile.getPersistentData();
                    boolean bl3 = bad = bad || !sdata.dumpSiblings(false);
                    if (bad) {
                        sdata.dumpSiblings(true);
                    }
                }
                ++i2;
            }
        }
        return !bad;
    }

    public CacheDir addChildDir(CacheDir subDir, boolean fireEvent) {
        CacheDir dir = super.addChildDir(subDir, fireEvent);
        this.adjustSiblingDataToChildrenData(true, subDir.getPersistentData());
        if (Boolean.getBoolean("vcs.cache.debug") && !this.checkSiblings(subDir)) {
            System.out.println("BAD SIBLINGS after addChildDir(" + subDir + ") into " + this);
            Thread.currentThread();
            Thread.dumpStack();
        }
        return dir;
    }

    public void addFile(CacheFile file, boolean fireEvent) {
        super.addFile(file, fireEvent);
        this.adjustSiblingDataToChildrenData(true, file.getPersistentData());
        if (Boolean.getBoolean("vcs.cache.debug") && !this.checkSiblings(file)) {
            System.out.println("BAD SIBLINGS after addFile(" + file + ") into " + this);
            Thread.currentThread();
            Thread.dumpStack();
        }
    }

    public void removeFile(String flName, boolean fireEvent) {
        CacheFile file = this.getFile(flName);
        if (file != null) {
            super.removeFile(flName, fireEvent);
            this.adjustSiblingDataToChildrenData(false, file.getPersistentData());
        }
    }

    protected void setParent(CacheDir par) {
        super.setParent(par);
        VcsCacheFile.VcsPersistentData vdata = (VcsCacheFile.VcsPersistentData)this.getPersistentData();
        if (par != null) {
            vdata.setCacheFileName(((VcsCacheDir)par).getCacheFileName());
            ((VcsCacheDir)par).adjustChildrenData(true, vdata);
        } else {
            vdata.setRemoved(true);
        }
        vdata.setModified(true);
    }

    public void removeFiles() {
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            CacheFile[] childFiles = this.getFiles();
            super.removeFiles();
            int i = 0;
            while (i < childFiles.length) {
                this.adjustSiblingDataToChildrenData(false, childFiles[i].getPersistentData());
                ++i;
            }
        }
    }

    void adjustSiblingDataToChildrenData(boolean add, CacheFile.PersistentData data) {
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            int numOfSiblings = this.getFileNames().length + this.getSubDirNames().length;
            String[] children = this.getSubDirNames();
            int i = 0;
            while (i < children.length) {
                VcsCacheDir cDir = (VcsCacheDir)this.getSubDirIfExists(children[i]);
                if (cDir != null) {
                    VcsCacheFile.VcsPersistentData sdata = (VcsCacheFile.VcsPersistentData)cDir.getPersistentData();
                    if (add) {
                        sdata.addSiblingData(data);
                    } else {
                        sdata.removeSiblingData(data);
                    }
                    sdata.setNumOfSiblings(numOfSiblings);
                }
                ++i;
            }
            children = this.getFileNames();
            int i2 = 0;
            while (i2 < children.length) {
                VcsCacheFile cFile = (VcsCacheFile)this.getFileIfExists(children[i2]);
                if (cFile != null) {
                    VcsCacheFile.VcsPersistentData sdata = (VcsCacheFile.VcsPersistentData)cFile.getPersistentData();
                    if (add) {
                        sdata.addSiblingData(data);
                    } else {
                        sdata.removeSiblingData(data);
                    }
                    sdata.setNumOfSiblings(numOfSiblings);
                }
                ++i2;
            }
        }
    }

    void adjustChildrenData(boolean add, VcsCacheFile.VcsPersistentData data) {
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            String[] dirs = this.getSubDirNames();
            int i = 0;
            while (i < dirs.length) {
                VcsCacheDir cDir = (VcsCacheDir)this.getSubDirIfExists(dirs[i]);
                if (cDir != null) {
                    VcsCacheFile.VcsPersistentData sdata = (VcsCacheFile.VcsPersistentData)cDir.getPersistentData();
                    if (add) {
                        data.addSiblingData(sdata);
                    } else {
                        data.removeSiblingData(sdata);
                    }
                }
                ++i;
            }
            String[] files = this.getFileNames();
            int i2 = 0;
            while (i2 < files.length) {
                VcsCacheFile cFile = (VcsCacheFile)this.getFileIfExists(files[i2]);
                if (cFile != null) {
                    VcsCacheFile.VcsPersistentData sdata = (VcsCacheFile.VcsPersistentData)cFile.getPersistentData();
                    if (add) {
                        data.addSiblingData(sdata);
                    } else {
                        data.removeSiblingData(sdata);
                    }
                }
                ++i2;
            }
            data.setNumOfSiblings(dirs.length + files.length);
        }
    }

    public String[] getFilesAndSubdirs() {
        String[] files = this.getFileNames();
        String[] dirs = this.getSubDirNames();
        String[] filesAndDirs = new String[files.length + dirs.length];
        System.arraycopy(files, 0, filesAndDirs, 0, files.length);
        System.arraycopy(dirs, 0, filesAndDirs, files.length, dirs.length);
        return filesAndDirs;
    }

    CacheFile getChildIfExists(String name) {
        CacheFile file = this.getFileIfExists(name);
        if (file == null) {
            file = this.getSubDirIfExists(name);
        }
        return file;
    }

    protected CacheFile createChildFromData(CacheFile.PersistentData data) {
        CacheFile file;
        if (data.isDirectory()) {
            file = new VcsCacheDir(this.getCacheName(), new File(this.getFile(), data.getName()), data);
            ((VcsCacheDir)file).readChildNamesFromDisk();
        } else {
            file = new VcsCacheFile(this.getCacheName(), data);
        }
        return file;
    }

    protected String getCacheFileName() {
        return ((VcsCache)this.getCacheObject()).getCacheFileName(this.dirFile);
    }

    public void removeChildDir(String subdirName, boolean fireEvent) {
        CacheDir subDir = this.getSubDir(subdirName);
        if (subDir != null) {
            ((VcsCacheDir)subDir).deleteDiskCache(true);
            super.removeChildDir(subdirName, fireEvent);
            this.adjustSiblingDataToChildrenData(false, subDir.getPersistentData());
        }
    }

    public void populateWithLocal(Object locker) {
        FilenameFilter filter = ((VcsCache)this.getCacheObject()).getLocalFileFilter();
        File[] subFiles = filter == null ? this.dirFile.listFiles() : this.dirFile.listFiles(filter);
        HashSet<String> localDirNames = new HashSet<String>();
        if (subFiles != null) {
            CacheHandler handler = CacheHandler.getInstance();
            int index = 0;
            while (index < subFiles.length) {
                File oneFile = subFiles[index];
                if (oneFile != null && oneFile.isDirectory()) {
                    localDirNames.add(oneFile.getName());
                    VcsCacheDir dir = (VcsCacheDir)this.getCacheObject().getDir(oneFile.getAbsolutePath());
                    if (dir == null) {
                        dir = (VcsCacheDir)((VcsCache)this.getCacheObject()).lookupCacheDir(oneFile, true);
                    }
                    if (dir == null) {
                        dir = new VcsCacheDir(this.getCacheObject().getId(), oneFile);
                        dir.setStatus(((VcsCache)this.getCacheObject()).getLocalFileStatus());
                        dir.setLocker("");
                        dir.setRevision("");
                        dir.setSticky("");
                        dir.setAttr("");
                        dir.setDate("");
                        dir.setTime("");
                        dir.setSize(0);
                        dir.setLocal(true);
                        this.addChildDir(dir, false);
                        dir.getPersistentData().setModified(false);
                    }
                    handler.addCacheLocker(locker, dir);
                }
                ++index;
            }
        }
        CacheDir[] subDirs = this.getSubDirs();
        int i = 0;
        while (i < subDirs.length) {
            if (subDirs[i].isLocal() && !localDirNames.contains(subDirs[i].getName())) {
                this.removeChildDir(subDirs[i].getName(), false);
            }
            ++i;
        }
        this.setAppliedLevel(0);
    }

    public void refreshLocal(boolean recursively) {
        int i;
        File[] subFiles;
        String[] mySubFiles = this.getFilesAndSubdirs();
        ArrayList<String> lastLocal = new ArrayList<String>(Arrays.asList(mySubFiles));
        int i2 = 0;
        while (i2 < lastLocal.size()) {
            String fileName = lastLocal.get(i2);
            CacheFile file = this.getFile(fileName);
            if (file instanceof VcsCacheFile) {
                if (!((VcsCacheFile)file).isLocal()) {
                    lastLocal.remove(i2--);
                }
            } else if (file instanceof VcsCacheDir && !((VcsCacheDir)file).isLocal()) {
                lastLocal.remove(i2--);
            }
            ++i2;
        }
        FilenameFilter filter = ((VcsCache)this.getCacheObject()).getLocalFileFilter();
        File[] fileArray = subFiles = filter == null ? this.dirFile.listFiles() : this.dirFile.listFiles(filter);
        if (subFiles != null) {
            i = 0;
            while (i < subFiles.length) {
                String name = subFiles[i].getName();
                if (lastLocal.contains(name)) {
                    ((AbstractCollection)lastLocal).remove(name);
                } else if (subFiles[i].isDirectory() && this.getSubDir(name) != null) {
                    VcsCacheDir dir = (VcsCacheDir)this.getCacheObject().getDir(subFiles[i].getAbsolutePath());
                    if (dir == null) {
                        dir = (VcsCacheDir)((VcsCache)this.getCacheObject()).lookupCacheDir(subFiles[i], true);
                    }
                    if (dir == null) {
                        dir = new VcsCacheDir(this.getCacheObject().getId(), subFiles[i]);
                        dir.setStatus(((VcsCache)this.getCacheObject()).getLocalFileStatus());
                        dir.setLocker("");
                        dir.setRevision("");
                        dir.setSticky("");
                        dir.setAttr("");
                        dir.setDate("");
                        dir.setTime("");
                        dir.setSize(0);
                        dir.setLocal(true);
                        this.addChildDir(dir, false);
                    }
                    dir.getPersistentData().setModified(false);
                }
                ++i;
            }
        }
        i = 0;
        while (i < lastLocal.size()) {
            String fileName = lastLocal.get(i);
            CacheFile file = this.getFile(fileName);
            if (file != null) {
                this.removeFile(fileName, true);
            } else {
                CacheDir subDir = this.getSubDir(fileName);
                if (subDir != null) {
                    this.removeChildDir(fileName, true);
                }
            }
            ++i;
        }
        if (recursively) {
            CacheDir[] subDirs = this.getSubDirs();
            int i3 = 0;
            while (i3 < subDirs.length) {
                ((VcsCacheDir)subDirs[i3]).refreshLocal(recursively);
                ++i3;
            }
        }
    }

    /*
     * Loose catch block
     */
    void readChildNamesFromDisk() {
        String cacheFilePath = this.getCacheFileName();
        if (cacheFilePath == null) {
            return;
        }
        ArrayList<String> files = new ArrayList<String>();
        ArrayList<String> dirs = new ArrayList<String>();
        File cacheFile = new File(cacheFilePath);
        ArrayList<String> cacheLines = new ArrayList<String>();
        if (cacheFile.exists() && cacheFile.canRead()) {
            Object cacheFileLock = VcsCacheFile.VcsPersistentData.getFileAccessLock(cacheFile);
            try {
                Object object = cacheFileLock;
                synchronized (object) {
                    block28: {
                        BufferedReader in = null;
                        in = new BufferedReader(new FileReader(cacheFile));
                        String line = null;
                        while ((line = in.readLine()) != null) {
                            cacheLines.add(line);
                        }
                        Object var11_15 = null;
                        if (in == null) break block28;
                        try {
                            in.close();
                        }
                        catch (IOException exc) {
                            // empty catch block
                        }
                        in = null;
                        {
                            break block28;
                            catch (IOException e) {
                                var11_15 = null;
                                if (in == null) break block28;
                                try {
                                    in.close();
                                }
                                catch (IOException exc) {
                                    // empty catch block
                                }
                                in = null;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var11_16 = null;
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException exc) {
                                    // empty catch block
                                }
                                in = null;
                            }
                            throw throwable;
                        }
                    }
                }
                Object var15_22 = null;
            }
            catch (Throwable throwable) {
                Object var15_23 = null;
                VcsCacheFile.VcsPersistentData.releaseFileAccessLock(cacheFile, cacheFileLock);
                throw throwable;
            }
            VcsCacheFile.VcsPersistentData.releaseFileAccessLock(cacheFile, cacheFileLock);
            {
            }
        }
        if (cacheLines.size() > 0) {
            int ds;
            int i = 0;
            while (i < cacheLines.size()) {
                String line = (String)cacheLines.get(i);
                boolean[] isDir = new boolean[1];
                try {
                    String name = VcsCacheFile.readFileCacheName(line, this.getCacheName(), isDir);
                    if (isDir[0]) {
                        dirs.add(name);
                    } else {
                        files.add(name);
                    }
                }
                catch (IllegalArgumentException iaex) {
                    Object object = this.errorLock;
                    synchronized (object) {
                        if (!this.errorLineReported) {
                            ErrorManager.getDefault().notify(16, ErrorManager.getDefault().annotate((Throwable)iaex, "Line read: '" + line + "'"));
                            this.errorLineReported = true;
                        }
                    }
                }
                ++i;
            }
            int fs = files.size();
            if (fs + (ds = dirs.size()) > 0) {
                this.addChildNames(files.toArray(new String[fs]), dirs.toArray(new String[ds]));
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean readFromDisk(Object locker) {
        CacheFile file;
        boolean isOk = false;
        String cacheFilePath = this.getCacheFileName();
        if (cacheFilePath == null) {
            return false;
        }
        ArrayList<CacheFile> files = new ArrayList<CacheFile>();
        File cacheFile = new File(cacheFilePath);
        ArrayList<String> cacheLines = new ArrayList<String>();
        if (cacheFile.exists() && cacheFile.canRead()) {
            Object cacheFileLock = VcsCacheFile.VcsPersistentData.getFileAccessLock(cacheFile);
            try {
                Object object = cacheFileLock;
                synchronized (object) {
                    block27: {
                        BufferedReader in = null;
                        in = new BufferedReader(new FileReader(cacheFile));
                        String line = null;
                        while ((line = in.readLine()) != null) {
                            cacheLines.add(line);
                        }
                        in.close();
                        isOk = true;
                        Object var12_15 = null;
                        if (in == null) break block27;
                        try {
                            in.close();
                        }
                        catch (IOException exc) {
                            // empty catch block
                        }
                        in = null;
                        {
                            break block27;
                            catch (IOException e) {
                                this.E.err(e, "readDirFromDiskCache() failed");
                                var12_15 = null;
                                if (in == null) break block27;
                                try {
                                    in.close();
                                }
                                catch (IOException exc) {
                                    // empty catch block
                                }
                                in = null;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var12_16 = null;
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException exc) {
                                    // empty catch block
                                }
                                in = null;
                            }
                            throw throwable;
                        }
                    }
                }
                Object var16_21 = null;
            }
            catch (Throwable throwable) {
                Object var16_22 = null;
                VcsCacheFile.VcsPersistentData.releaseFileAccessLock(cacheFile, cacheFileLock);
                throw throwable;
            }
            VcsCacheFile.VcsPersistentData.releaseFileAccessLock(cacheFile, cacheFileLock);
            {
            }
        }
        if (cacheLines.size() > 0) {
            int i = 0;
            while (i < cacheLines.size()) {
                String line = (String)cacheLines.get(i);
                try {
                    file = VcsCacheFile.readFileCache(line, this.getCacheName(), this.getFile());
                    files.add(file);
                }
                catch (IllegalArgumentException iaex) {
                    Object object = this.errorLock;
                    synchronized (object) {
                        if (!this.errorLineReported) {
                            ErrorManager.getDefault().notify(16, ErrorManager.getDefault().annotate((Throwable)iaex, "Line read: '" + line + "'"));
                            this.errorLineReported = true;
                        }
                    }
                }
                ++i;
            }
        }
        CacheHandler handler = CacheHandler.getInstance();
        Iterator filesIt = ((AbstractList)files).iterator();
        while (filesIt.hasNext()) {
            file = (CacheFile)filesIt.next();
            this.add(file);
            file.getPersistentData().setModified(false);
            handler.addCacheLocker(locker, file);
            if (!(file instanceof CacheDir)) continue;
            this.getCacheObject().registerDir((CacheDir)file);
        }
        if (isOk) {
            this.setLoaded(true);
            this.setAppliedLevel(3);
            this.setModifiedContent(false);
        }
        this.setLocal(false);
        return isOk;
    }

    /*
     * Unable to fully structure code
     */
    protected CacheFile readFileFromDisk(String name) {
        cacheFilePath = this.getCacheFileName();
        file = null;
        if (cacheFilePath != null && (cacheFile = new File(cacheFilePath)).exists() && cacheFile.canRead()) {
            cacheFileLock = VcsCacheFile.VcsPersistentData.getFileAccessLock(cacheFile);
            try {
                var6_6 = cacheFileLock;
                synchronized (var6_6) {
                    block25: {
                        in = null;
                        try {
                            in = new BufferedReader(new FileReader(cacheFile));
                            line = null;
                            while ((line = in.readLine()) != null) {
                                try {
                                    elements = RefreshCommandSupport.getElementsFromLine(line);
                                    fileName = elements[0];
                                    if (!name.equals(fileName)) continue;
                                    file = new VcsCacheFile(this.getCacheName(), name);
                                    RefreshCommandSupport.matchToFile(elements, file);
                                    file.setLocal(false);
                                    file.setParent(this);
                                    file.getPersistentData().setModified(false);
                                    break;
                                }
                                catch (IllegalArgumentException iaex) {
                                    var10_12 = this.errorLock;
                                    synchronized (var10_12) {
                                        if (!this.errorLineReported) {
                                            ErrorManager.getDefault().notify(16, ErrorManager.getDefault().annotate((Throwable)iaex, "Line read: '" + line + "'"));
                                            this.errorLineReported = true;
                                        }
                                    }
                                }
                            }
                            in.close();
                            var13_14 = null;
                            ** if (in == null) goto lbl-1000
                        }
                        catch (Throwable var12_20) {
                            var13_16 = null;
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException exc) {
                                    // empty catch block
                                }
                            }
                            throw var12_20;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                in.close();
                            }
                            catch (IOException exc) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block25;
                            catch (IOException e) {
                                this.E.err(e, "readFileFromDiskCache() failed");
                                var13_15 = null;
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (IOException exc) {}
                                }
                            }
                        }
                    }
                }
                var17_22 = null;
            }
            catch (Throwable var16_24) {
                var17_23 = null;
                VcsCacheFile.VcsPersistentData.releaseFileAccessLock(cacheFile, cacheFileLock);
                throw var16_24;
            }
            VcsCacheFile.VcsPersistentData.releaseFileAccessLock(cacheFile, cacheFileLock);
            {
            }
        }
        if (file == null) {
            file = new VcsCacheFile(this.getCacheName(), name);
            file.setStatus(((VcsCache)this.getCacheObject()).getLocalFileStatus());
            file.setLocal(true);
        }
        return file;
    }

    /*
     * Unable to fully structure code
     */
    protected CacheDir readDirFromDisk(String name) {
        cacheFilePath = this.getCacheFileName();
        dir = null;
        if (cacheFilePath != null && (cacheFile = new File(cacheFilePath)).exists() && cacheFile.canRead()) {
            cacheFileLock = VcsCacheFile.VcsPersistentData.getFileAccessLock(cacheFile);
            try {
                var6_6 = cacheFileLock;
                synchronized (var6_6) {
                    block26: {
                        dirName = name + "/";
                        in = null;
                        try {
                            in = new BufferedReader(new FileReader(cacheFile));
                            line = null;
                            while ((line = in.readLine()) != null) {
                                try {
                                    elements = RefreshCommandSupport.getElementsFromLine(line);
                                    fileName = elements[0];
                                    if (!dirName.equals(fileName)) continue;
                                    dir = new VcsCacheDir(this.getCacheName(), new File(this.getFile(), name));
                                    dir.setName(name);
                                    RefreshCommandSupport.matchToFile(elements, dir);
                                    dir.setLocal(false);
                                    dir.setParent(this);
                                    dir.getPersistentData().setModified(false);
                                    break;
                                }
                                catch (IllegalArgumentException iaex) {
                                    var11_13 = this.errorLock;
                                    synchronized (var11_13) {
                                        if (!this.errorLineReported) {
                                            ErrorManager.getDefault().notify(16, ErrorManager.getDefault().annotate((Throwable)iaex, "Line read: '" + line + "'"));
                                            this.errorLineReported = true;
                                        }
                                    }
                                }
                            }
                            in.close();
                            var14_15 = null;
                            ** if (in == null) goto lbl-1000
                        }
                        catch (Throwable var13_21) {
                            var14_17 = null;
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException exc) {
                                    // empty catch block
                                }
                            }
                            throw var13_21;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                in.close();
                            }
                            catch (IOException exc) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block26;
                            catch (IOException e) {
                                this.E.err(e, "readDirFromDiskCache() failed");
                                var14_16 = null;
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (IOException exc) {}
                                }
                            }
                        }
                    }
                }
                var18_23 = null;
            }
            catch (Throwable var17_25) {
                var18_24 = null;
                VcsCacheFile.VcsPersistentData.releaseFileAccessLock(cacheFile, cacheFileLock);
                throw var17_25;
            }
            VcsCacheFile.VcsPersistentData.releaseFileAccessLock(cacheFile, cacheFileLock);
            {
            }
        }
        if (dir == null) {
            dir = new VcsCacheDir(this.getCacheName(), new File(this.getFile(), name));
            dir.setStatus(((VcsCache)this.getCacheObject()).getLocalFileStatus());
            dir.setLocal(true);
            dir.setParent(this);
            dir.getPersistentData().setModified(false);
        } else {
            dir.readChildNamesFromDisk();
        }
        return dir;
    }

    /*
     * Unable to fully structure code
     */
    public void writeToDisk() {
        cacheFilePath = this.getCacheFileName();
        if (cacheFilePath == null) {
            return;
        }
        files = this.getFiles();
        dirs = this.getSubDirs();
        ok = false;
        cacheFile = new File(cacheFilePath);
        cacheFileLock = VcsCacheFile.VcsPersistentData.getFileAccessLock(cacheFile);
        try {
            var7_7 = cacheFileLock;
            synchronized (var7_7) {
                block47: {
                    out = null;
                    cacheDir = cacheFile.getParentFile();
                    if (!cacheDir.exists()) {
                        cacheDir.mkdirs();
                    }
                    try {
                        cacheFile.createNewFile();
                    }
                    catch (IOException ioexc) {
                        var11_15 = this.errorLock;
                        synchronized (var11_15) {
                            if (!this.errorWriteReported) {
                                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)ioexc, "Exception when trying to create a new file '" + cacheFile.getAbsolutePath()));
                                this.errorWriteReported = true;
                            }
                        }
                    }
                    out = new BufferedWriter(new FileWriter(cacheFile));
                    i = 0;
                    while (i < files.length) {
                        if (!((VcsCacheFile)files[i]).isLocal() && (line = ((VcsCacheFile.VcsPersistentData)files[i].getPersistentData()).writeLineToDisk()).length() > 0) {
                            out.write(line);
                            out.newLine();
                        }
                        files[i].getPersistentData().setModified(false);
                        ++i;
                    }
                    i = 0;
                    while (i < dirs.length) {
                        if (!((VcsCacheDir)dirs[i]).isLocal() && (line = ((VcsCacheFile.VcsPersistentData)dirs[i].getPersistentData()).writeLineToDisk()).length() > 0) {
                            out.write(line);
                            out.newLine();
                        }
                        dirs[i].getPersistentData().setModified(false);
                        ++i;
                    }
                    out.flush();
                    ok = true;
                    var15_19 = null;
                    try {
                        if (out == null) ** GOTO lbl112
                        out.close();
                    }
                    catch (IOException e) {
                        var17_25 = this.errorLock;
                        synchronized (var17_25) {
                            if (!this.errorWriteReported) {
                                ErrorManager.getDefault().notify((Throwable)e);
                                this.errorWriteReported = true;
                            }
                        }
                    }
                    {
                        catch (IOException exc) {
                            var10_14 = this.errorLock;
                            synchronized (var10_14) {
                                if (!this.errorWriteReported) {
                                    ErrorManager.getDefault().notify((Throwable)exc);
                                    this.errorWriteReported = true;
                                }
                            }
                            var15_20 = null;
                            try {
                                if (out == null) ** GOTO lbl112
                                out.close();
                            }
                            catch (IOException e) {
                                var17_26 = this.errorLock;
                                synchronized (var17_26) {
                                    if (!this.errorWriteReported) {
                                        ErrorManager.getDefault().notify((Throwable)e);
                                        this.errorWriteReported = true;
                                    }
                                    break block47;
                                }
                            }
                        }
                    }
                    catch (Throwable var14_32) {
                        var15_21 = null;
                        try {
                            if (out != null) {
                                out.close();
                            }
                        }
                        catch (IOException e) {
                            var17_27 = this.errorLock;
                            synchronized (var17_27) {
                                if (!this.errorWriteReported) {
                                    ErrorManager.getDefault().notify((Throwable)e);
                                    this.errorWriteReported = true;
                                }
                            }
                        }
                        throw var14_32;
                    }
                }
            }
            var21_34 = null;
        }
        catch (Throwable var20_36) {
            var21_35 = null;
            VcsCacheFile.VcsPersistentData.releaseFileAccessLock(cacheFile, cacheFileLock);
            throw var20_36;
        }
        VcsCacheFile.VcsPersistentData.releaseFileAccessLock(cacheFile, cacheFileLock);
        if (ok) {
            this.setModifiedContent(false);
            try {
                this.getPersistentData().writeToDisk();
            }
            catch (IOException ioex) {
                var8_9 = this.errorLock;
                synchronized (var8_9) {
                    if (!this.errorWriteReported) {
                        ErrorManager.getDefault().notify((Throwable)ioex);
                        this.errorWriteReported = true;
                    }
                }
            }
        }
    }

    public String writeLineToDisk() {
        String[] elements = RefreshCommandSupport.makeElements(this);
        elements[0] = elements[0] + "/";
        return RefreshCommandSupport.getLineFromElements(elements);
    }

    private void deleteDiskCache(boolean recursive) {
        String cacheFilePath = this.getCacheFileName();
        if (cacheFilePath == null) {
            return;
        }
        File cacheFile = new File(cacheFilePath);
        cacheFile.delete();
        if (recursive) {
            CacheDir[] subDirs = this.getSubDirs();
            int i = 0;
            while (i < subDirs.length) {
                ((VcsCacheDir)subDirs[i]).deleteDiskCache(recursive);
                ++i;
            }
        }
    }

    public void checkServer(Object locker) {
        boolean runReader;
        VcsCacheDir vcsCacheDir = this;
        synchronized (vcsCacheDir) {
            if (this.isBeingLoaded()) {
                return;
            }
            if (!this.isLoaded() || !this.isLocal()) {
                this.setAppliedLevel(3);
                runReader = true;
            } else {
                runReader = false;
            }
        }
        if (runReader) {
            VcsCache cache = (VcsCache)this.getCacheObject();
            cache.runVcsDirReader(this, locker);
        }
    }

    public void checkServerRecursive(Object locker) {
        boolean runReader;
        VcsCacheDir vcsCacheDir = this;
        synchronized (vcsCacheDir) {
            if (this.isBeingLoaded()) {
                return;
            }
            if (!this.isLoaded() || !this.isLocal()) {
                this.setAppliedLevel(3);
                runReader = true;
            } else {
                runReader = false;
            }
        }
        if (runReader) {
            VcsCache cache = (VcsCache)this.getCacheObject();
            cache.runVcsDirReaderRecursive(this, locker);
        }
    }

    protected void createIgnoreList() {
        CacheDir parent = this.getParent();
        VcsCache cache = (VcsCache)this.getCacheObject();
        cache.createIgnoreList(this, parent == null ? null : parent.getIgnoreList());
    }

    public String toString() {
        String[] fileNames = this.getFileNames();
        String[] dirNames = this.getDirNames();
        String strOut = "VcsDir[name='" + this.getName() + "',status=" + this.getStatus() + ", file = " + this.getFile() + "\n files=" + VcsUtilities.arrayToString(fileNames) + ",\n subdir=" + VcsUtilities.arrayToString(dirNames) + "\n isLocal = " + this.isLocal() + " isLoaded = " + this.isLoaded() + " isBeingLoaded = " + this.isBeingLoaded() + "]";
        return strOut;
    }
}

