/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.caching;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.caching.RefreshCommandSupport;
import org.netbeans.modules.vcscore.caching.VcsCache;
import org.netbeans.modules.vcscore.caching.VcsCacheDir;
import org.netbeans.modules.vcscore.util.Debug;
import org.openide.ErrorManager;
import org.openide.util.WeakSet;

public class VcsCacheFile
extends CacheFile {
    private Debug E;
    private Debug D;
    public static final String STATUS_IGNORED = "Ignored";
    public static final String STATUS_DEAD = "Dead";

    public VcsCacheFile(String memberOfCache) {
        super(memberOfCache, new VcsPersistentData(false));
        this.D = this.E = new Debug("VcsFile", false);
    }

    public VcsCacheFile(String memberOfCache, String name) {
        super(memberOfCache, name, new VcsPersistentData(false));
        this.D = this.E = new Debug("VcsFile", false);
    }

    public VcsCacheFile(String memberOfCache, String name, boolean local) {
        this(memberOfCache, name);
        this.setLocal(local);
    }

    VcsCacheFile(String memberOfCache, CacheFile.PersistentData data) {
        super(memberOfCache, data.getName(), data);
        this.D = this.E = new Debug("VcsFile", false);
    }

    public void setLocal(boolean local) {
        ((VcsPersistentData)this.getPersistentData()).setLocal(local);
    }

    public boolean isLocal() {
        return ((VcsPersistentData)this.getPersistentData()).isLocal();
    }

    public String getStatus() {
        CacheDir parent = this.getParent();
        if (this.isLocal() && parent != null && parent.isIgnoreListSet() && parent.isIgnored(this.getName())) {
            return STATUS_IGNORED;
        }
        return super.getStatus();
    }

    protected void setParent(CacheDir par) {
        super.setParent(par);
        VcsPersistentData vdata = (VcsPersistentData)this.getPersistentData();
        if (par != null) {
            vdata.setCacheFileName(((VcsCacheDir)par).getCacheFileName());
            ((VcsCacheDir)par).adjustChildrenData(true, vdata);
        } else {
            vdata.setRemoved(true);
        }
        vdata.setModified(true);
    }

    public static String readFileCacheName(String line, String cacheName, boolean[] isDir) {
        String[] elements = RefreshCommandSupport.getElementsFromLine(line);
        String name = elements[0];
        if (name == null) {
            throw new IllegalArgumentException("File name element is missing.");
        }
        isDir[0] = name.endsWith("/");
        return isDir[0] ? name.substring(0, name.length() - 1) : name;
    }

    public static CacheFile readFileCache(String line, String cacheName, File parent) {
        VcsCacheDir parentDir;
        String[] elements = RefreshCommandSupport.getElementsFromLine(line);
        String name = elements[0];
        if (name == null) {
            throw new IllegalArgumentException("File name element is missing.");
        }
        boolean fileIsDir = name.endsWith("/");
        String fileName = fileIsDir ? name.substring(0, name.length() - 1) : name;
        VcsCache cache = (VcsCache)CacheHandler.getInstance().getCache(cacheName);
        CacheFile file = null;
        if (cache != null && (parentDir = (VcsCacheDir)cache.getDir(parent.getAbsolutePath())) != null) {
            file = parentDir.getChildIfExists(fileName);
        }
        if (file == null) {
            file = fileIsDir ? new VcsCacheDir(cacheName, new File(parent, fileName)) : new VcsCacheFile(cacheName);
            file.setName(fileName);
        }
        RefreshCommandSupport.matchToFile(elements, file);
        if (file instanceof VcsCacheFile) {
            file.setLocal(false);
        }
        if (file instanceof VcsCacheDir) {
            ((VcsCacheDir)file).setLocal(false);
        }
        file.getPersistentData().setModified(false);
        return file;
    }

    public String toString() {
        return "VcsFile[name='" + this.getName() + "'" + ",status=" + this.getStatus() + ",locker=" + this.getLocker() + ",revision=" + this.getRevision() + ",sticky=" + this.getSticky() + ",attr=" + this.getAttr() + ",size=" + this.getSize() + ",date=" + this.getDate() + ",time=" + this.getTime() + ",local=" + this.isLocal() + "]";
    }

    protected static class VcsPersistentData
    extends CacheFile.PersistentData {
        private File cacheFile = null;
        private WeakSet siblings = new WeakSet();
        private int numOfSiblings = 0;
        private boolean removed = false;
        private volatile boolean loaded = false;
        private boolean errorLineReported = false;
        private Object errorLock = new Object();
        private static Map OPEN_FILES_LOCKS = new HashMap();
        static /* synthetic */ Class class$org$netbeans$modules$vcscore$caching$VcsCacheFile$VcsPersistentData;

        public VcsPersistentData(boolean directory) {
            super(directory);
        }

        protected void setRemoved(boolean removed) {
            this.removed = removed;
        }

        protected final void setLoaded(boolean loaded) {
            this.loaded = loaded;
        }

        protected final boolean isLoaded() {
            return this.loaded;
        }

        void setCacheFileName(String cacheFileName) {
            this.cacheFile = cacheFileName == null ? null : new File(cacheFileName);
        }

        void addSiblingData(CacheFile.PersistentData data) {
            WeakSet weakSet = this.siblings;
            synchronized (weakSet) {
                this.siblings.add((Object)data);
            }
        }

        void removeSiblingData(CacheFile.PersistentData data) {
            WeakSet weakSet = this.siblings;
            synchronized (weakSet) {
                this.siblings.remove((Object)data);
            }
        }

        void setNumOfSiblings(int numOfSiblings) {
            WeakSet weakSet = this.siblings;
            synchronized (weakSet) {
                this.numOfSiblings = numOfSiblings;
            }
        }

        public boolean dumpSiblings(boolean print) {
            return this.dumpSiblings(print, (Set)this.siblings);
        }

        public boolean dumpSiblings(boolean print, Set siblings) {
            if (print) {
                Class clazz = class$org$netbeans$modules$vcscore$caching$VcsCacheFile$VcsPersistentData == null ? (class$org$netbeans$modules$vcscore$caching$VcsCacheFile$VcsPersistentData = VcsPersistentData.class$("org.netbeans.modules.vcscore.caching.VcsCacheFile$VcsPersistentData")) : class$org$netbeans$modules$vcscore$caching$VcsCacheFile$VcsPersistentData;
                synchronized (clazz) {
                    System.err.println("PersistentData " + this + " have " + this.numOfSiblings + " siblings:");
                    HashSet siblingsSet = new HashSet(siblings);
                    Iterator it = siblingsSet.iterator();
                    while (it.hasNext()) {
                        System.err.println("  " + it.next());
                    }
                    System.err.println("  Siblings contains me = " + siblings.contains(this) + "\n");
                }
            }
            return siblings.contains(this);
        }

        public String writeLineToDisk() {
            if (this.removed) {
                return "";
            }
            String[] elements = RefreshCommandSupport.makeElements(this);
            if (this.isDirectory()) {
                elements[0] = elements[0] + "/";
            }
            return RefreshCommandSupport.getLineFromElements(elements);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void doWriteToDisk() throws IOException {
            Object lock;
            block11: {
                block10: {
                    if (this.cacheFile == null) return;
                    if (this.isDirectory() && !this.isLoaded()) {
                        return;
                    }
                    lock = VcsPersistentData.getFileAccessLock(this.cacheFile);
                    try {
                        Object object = lock;
                        synchronized (object) {
                            if (!this.isModified()) {
                                // MONITOREXIT @DISABLED, blocks:[0, 3, 9] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                                Object var9_3 = null;
                                break block10;
                            }
                            WeakSet weakSet = this.siblings;
                            synchronized (weakSet) {
                                HashSet strongSiblings = new HashSet(this.siblings);
                                if (strongSiblings.size() == this.numOfSiblings) {
                                    this.doWriteToDisk(strongSiblings, true);
                                } else {
                                    this.doWriteToDisk(strongSiblings, false);
                                }
                                this.setUnmodified(strongSiblings);
                            }
                        }
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var9_5 = null;
                        VcsPersistentData.releaseFileAccessLock(this.cacheFile, lock);
                        throw throwable;
                    }
                }
                VcsPersistentData.releaseFileAccessLock(this.cacheFile, lock);
                return;
            }
            Object var9_4 = null;
            VcsPersistentData.releaseFileAccessLock(this.cacheFile, lock);
        }

        private void setUnmodified(Set siblings) {
            Iterator it = siblings.iterator();
            while (it.hasNext()) {
                VcsPersistentData data = (VcsPersistentData)it.next();
                data.setModified(false);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void doWriteToDisk(Set siblings, boolean canOverwrite) throws IOException {
            if (!canOverwrite) {
                this.addSiblingsFromDisk(siblings);
            }
            BufferedWriter out = null;
            try {
                File cacheDir = this.cacheFile.getParentFile();
                if (!cacheDir.exists()) {
                    cacheDir.mkdirs();
                }
                this.cacheFile.createNewFile();
                out = new BufferedWriter(new FileWriter(this.cacheFile));
                Iterator it = siblings.iterator();
                while (it.hasNext()) {
                    String line;
                    VcsPersistentData data = (VcsPersistentData)it.next();
                    if (!data.isLocal() && (line = data.writeLineToDisk()).length() > 0) {
                        out.write(line);
                        out.newLine();
                    }
                    data.setModified(false);
                }
                out.flush();
                Object var9_8 = null;
                if (out == null) return;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
            out.close();
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void addSiblingsFromDisk(Set siblings) throws IOException {
            HashSet<String> siblingsNames = new HashSet<String>();
            Iterator it = siblings.iterator();
            while (it.hasNext()) {
                CacheFile.PersistentData data = (CacheFile.PersistentData)it.next();
                siblingsNames.add(data.getName());
            }
            if (!this.cacheFile.exists() || !this.cacheFile.canRead()) return;
            BufferedReader in = null;
            in = new BufferedReader(new FileReader(this.cacheFile));
            String line = null;
            while ((line = in.readLine()) != null) {
                try {
                    String[] elements = RefreshCommandSupport.getElementsFromLine(line);
                    String fileName = elements[0];
                    if (fileName == null) {
                        Object object = this.errorLock;
                        synchronized (object) {
                            if (!this.errorLineReported) {
                                ErrorManager.getDefault().notify(16, ErrorManager.getDefault().annotate((Throwable)new IllegalArgumentException("File name element is missing."), "Line read: '" + line + "' in file " + this.cacheFile));
                                this.errorLineReported = true;
                            }
                            continue;
                        }
                    }
                    boolean isDir = fileName.endsWith("/");
                    if (isDir) {
                        fileName = fileName.substring(0, fileName.length() - 1);
                    }
                    if (siblingsNames.contains(fileName)) continue;
                    VcsPersistentData data = new VcsPersistentData(isDir);
                    data.setName(fileName);
                    RefreshCommandSupport.matchToFile(elements, data);
                    data.setModified(false);
                    siblings.add(data);
                    siblingsNames.add(data.getName());
                }
                catch (IllegalArgumentException iaex) {
                    Object object = this.errorLock;
                    synchronized (object) {
                        if (!this.errorLineReported) {
                            ErrorManager.getDefault().notify(16, ErrorManager.getDefault().annotate((Throwable)iaex, "Line read: '" + line + "'"));
                        }
                    }
                }
            }
            in.close();
            Object var12_15 = null;
            if (in == null) return;
            try {
                in.close();
                return;
            }
            catch (IOException exc) {}
            return;
            {
                catch (IOException e) {
                    Object var12_16 = null;
                    if (in == null) return;
                    try {
                        in.close();
                        return;
                    }
                    catch (IOException exc) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException exc) {
                    // empty catch block
                }
                throw throwable;
            }
        }

        static Object getFileAccessLock(File file) {
            MutableInt lock;
            Map map = OPEN_FILES_LOCKS;
            synchronized (map) {
                lock = (MutableInt)OPEN_FILES_LOCKS.get(file);
                if (lock == null) {
                    lock = new MutableInt();
                    OPEN_FILES_LOCKS.put(file, lock);
                }
                lock.inc();
            }
            return lock;
        }

        static void releaseFileAccessLock(File file, Object lock) {
            if (!(lock instanceof MutableInt)) {
                throw new IllegalArgumentException("Bad lock instance");
            }
            MutableInt miLock = (MutableInt)lock;
            Map map = OPEN_FILES_LOCKS;
            synchronized (map) {
                miLock.dec();
                if (miLock.get() <= 0) {
                    OPEN_FILES_LOCKS.remove(file);
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        private static final class MutableInt {
            private int i = 0;

            public void set(int i) {
                this.i = i;
            }

            public int get() {
                return this.i;
            }

            public void inc() {
                ++this.i;
            }

            public void dec() {
                --this.i;
            }

            public String toString() {
                return Integer.toString(this.i);
            }
        }
    }
}

