/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.caching;

import java.awt.Image;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.vcs.FileStatusInfo;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.cache.CacheHandlerEvent;
import org.netbeans.modules.vcscore.cache.CacheHandlerListener;
import org.netbeans.modules.vcscore.cache.FileSystemCache;
import org.netbeans.modules.vcscore.caching.FileCacheProvider;
import org.netbeans.modules.vcscore.caching.FileStatusProvider;
import org.netbeans.modules.vcscore.caching.VcsCache;
import org.netbeans.modules.vcscore.caching.VcsCacheDir;
import org.netbeans.modules.vcscore.caching.VcsCacheFile;
import org.netbeans.modules.vcscore.util.Debug;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.netbeans.modules.vcscore.versioning.VersioningFileSystem;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;

public class VcsFSCache
implements FileStatusProvider,
FileCacheProvider {
    private Debug E;
    private Debug D;
    public final String localStatusStr;
    public final String ignoredStatusStr;
    private WeakReference fileSystem;
    private CacheHandler handler;
    private String cacheId;
    private String fsRoot;
    private String relativeMountPoint;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$cache$CacheHandlerListener;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$caching$VcsFSCache;

    public VcsFSCache(VcsFileSystem fileSystem) {
        this.D = this.E = new Debug("CvsFsCache", true);
        this.localStatusStr = this.g("CTL_StatusLocal");
        this.ignoredStatusStr = this.g("CTL_StatusIgnored");
        this.fileSystem = new WeakReference<VcsFileSystem>(fileSystem);
        this.cacheId = fileSystem.getCacheIdStr();
        this.fsRoot = fileSystem.getFSRoot();
        this.relativeMountPoint = fileSystem.getRelativeMountPoint();
        this.handler = CacheHandler.getInstance();
        VcsCache cacheObj = new VcsCache(this.fileSystem, this.getCacheId());
        this.handler.registerCacheType(this.getCacheId(), cacheObj);
        cacheObj.addCacheHandlerListener((CacheHandlerListener)WeakListener.create((Class)(class$org$netbeans$modules$vcscore$cache$CacheHandlerListener == null ? (class$org$netbeans$modules$vcscore$cache$CacheHandlerListener = VcsFSCache.class$("org.netbeans.modules.vcscore.cache.CacheHandlerListener")) : class$org$netbeans$modules$vcscore$cache$CacheHandlerListener), (EventListener)fileSystem, (Object)cacheObj));
        VersioningFileSystem vsystem = fileSystem.getVersioningFileSystem();
        if (vsystem instanceof CacheHandlerListener) {
            cacheObj.addCacheHandlerListener((CacheHandlerListener)WeakListener.create((Class)(class$org$netbeans$modules$vcscore$cache$CacheHandlerListener == null ? (class$org$netbeans$modules$vcscore$cache$CacheHandlerListener = VcsFSCache.class$("org.netbeans.modules.vcscore.cache.CacheHandlerListener")) : class$org$netbeans$modules$vcscore$cache$CacheHandlerListener), (EventListener)((CacheHandlerListener)((Object)vsystem)), (Object)cacheObj));
        }
    }

    private static Set createDefaultPossibleFileStatusInfos() {
        HashSet<FileStatusInfo> statusInfos = new HashSet<FileStatusInfo>();
        statusInfos.add(FileStatusInfo.LOCAL);
        statusInfos.add(FileStatusInfo.MODIFIED);
        statusInfos.add(new CacheProvidedFileStatusInfo("Dead", NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$caching$VcsFSCache == null ? (class$org$netbeans$modules$vcscore$caching$VcsFSCache = VcsFSCache.class$("org.netbeans.modules.vcscore.caching.VcsFSCache")) : class$org$netbeans$modules$vcscore$caching$VcsFSCache), (String)"CTL_StatusDead"), null));
        statusInfos.add(new CacheProvidedFileStatusInfo("Ignored", NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$caching$VcsFSCache == null ? (class$org$netbeans$modules$vcscore$caching$VcsFSCache = VcsFSCache.class$("org.netbeans.modules.vcscore.caching.VcsFSCache")) : class$org$netbeans$modules$vcscore$caching$VcsFSCache), (String)"CTL_StatusIgnored"), null));
        statusInfos.add(new CacheProvidedFileStatusInfo(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$caching$VcsFSCache == null ? (class$org$netbeans$modules$vcscore$caching$VcsFSCache = VcsFSCache.class$("org.netbeans.modules.vcscore.caching.VcsFSCache")) : class$org$netbeans$modules$vcscore$caching$VcsFSCache), (String)"CTL_StatusNotInSync"), NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$caching$VcsFSCache == null ? (class$org$netbeans$modules$vcscore$caching$VcsFSCache = VcsFSCache.class$("org.netbeans.modules.vcscore.caching.VcsFSCache")) : class$org$netbeans$modules$vcscore$caching$VcsFSCache), (String)"CTL_StatusNotInSync"), null));
        return statusInfos;
    }

    public Set getPossibleFileStatusInfos() {
        VcsFileSystem fs = (VcsFileSystem)this.fileSystem.get();
        if (fs != null) {
            Set fss = fs.getPossibleFileStatusInfos();
            if (fss == null || fss.size() == 0) {
                return VcsFSCache.createDefaultPossibleFileStatusInfos();
            }
            return fss;
        }
        return VcsFSCache.createDefaultPossibleFileStatusInfos();
    }

    public String getNotInSynchStatus() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$caching$VcsFSCache == null ? (class$org$netbeans$modules$vcscore$caching$VcsFSCache = VcsFSCache.class$("org.netbeans.modules.vcscore.caching.VcsFSCache")) : class$org$netbeans$modules$vcscore$caching$VcsFSCache), (String)"CTL_StatusNotInSync");
    }

    public void setFileModified(String path) {
        this.setFileStatus(path, FileStatusInfo.MODIFIED.getName());
    }

    public String getLocalFileStatus() {
        return this.localStatusStr;
    }

    public void setFileStatus(String path, String status) {
        CacheFile file = this.getFileOrDir(path, null);
        if (file != null && !status.equals(file.getStatus())) {
            file.setStatus(status);
            file.getParent().writeToDisk();
            FileSystemCache cache = this.handler.getCache(this.getCacheId());
            cache.fireCacheHandlerEvent(2, file);
        }
    }

    /*
     * Unable to fully structure code
     */
    public Set setExistingFileStatus(String folderPath, String[] fileNames, String status, Collection notModifiableStates, boolean fireChange) {
        dir = this.getDir(folderPath);
        if (dir != null) {
            block10: {
                changedFiles = new HashSet<CacheFile>();
                i = 0;
                while (i < fileNames.length) {
                    file = dir.getFile(fileNames[i]);
                    if (file == null) {
                        file = dir.getSubDir(fileNames[i]);
                    }
                    if (file != null) {
                        oldStatus = file.getStatus();
                        if (!(notModifiableStates != null && notModifiableStates.contains(oldStatus) || status.equals(oldStatus))) {
                            file.setStatus(status);
                            changedFiles.add(file);
                        }
                    }
                    ++i;
                }
                if (changedFiles.size() > 0) {
                    dir.writeToDisk();
                    if (fireChange) {
                        cache = this.handler.getCache(this.getCacheId());
                        try {
                            cache.fireCacheHandlerEvent(2, new CacheHandlerEvent(changedFiles));
                            break block10;
                        }
                        catch (UndeclaredThrowableException utex) {
                            files = "";
                            it = changedFiles.iterator();
                            ** while (it.hasNext())
                        }
lbl-1000:
                        // 1 sources

                        {
                            file = (CacheFile)it.next();
                            files = files + file.toString() + ", parent = " + file.getParent() + "\n";
                            continue;
                        }
lbl31:
                        // 1 sources

                        ErrorManager.getDefault().notify((Throwable)((UndeclaredThrowableException)ErrorManager.getDefault().annotate((Throwable)utex, "BAD cache files fired: " + files + ", " + "dir = " + dir + ", registered dir for file '" + ((VcsCacheDir)dir).getFile().getAbsolutePath() + "' = " + this.getDir(((VcsCacheDir)dir).getFile().getAbsolutePath()) + "\nPlease attach this text to issue #24340")));
                    }
                }
            }
            return changedFiles;
        }
        return Collections.EMPTY_SET;
    }

    public String getFileStatus(String path) {
        String dirPath;
        CacheDir dir;
        CacheFile file = this.getFileOrDir(path, null);
        String stat = file != null ? file.getStatus() : ((dir = this.getDir(dirPath = VcsUtilities.getDirNamePart(path))) != null && dir.isIgnored(VcsUtilities.getFileNamePart(path)) ? "Ignored" : this.localStatusStr);
        return stat;
    }

    public FileStatusInfo getFileStatusInfo(String path) {
        String status = this.getFileStatus(path);
        if (status == null) {
            return null;
        }
        VcsFileSystem fs = (VcsFileSystem)this.fileSystem.get();
        if (fs != null) {
            Map statusInfoMap = fs.getPossibleFileStatusInfoMap();
            return (FileStatusInfo)statusInfoMap.get(status);
        }
        return null;
    }

    public String getFileLocker(String path) {
        String locker = null;
        CacheFile file = this.getFileOrDir(path, null);
        if (file != null) {
            locker = file.getLocker();
        }
        return locker;
    }

    public String getFileRevision(String path) {
        CacheFile file = this.getFileOrDir(path, null);
        if (file != null) {
            return file.getRevision();
        }
        return null;
    }

    public String getFileSticky(String path) {
        CacheFile file = this.getFileOrDir(path, null);
        if (file != null) {
            return file.getSticky();
        }
        return null;
    }

    public String getFileAttribute(String path) {
        CacheFile file = this.getFileOrDir(path, null);
        if (file != null) {
            return file.getAttr();
        }
        return null;
    }

    public String getFileSize(String path) {
        CacheFile file = this.getFileOrDir(path, null);
        if (file != null) {
            return "" + file.getSize();
        }
        return null;
    }

    public String getFileDate(String path) {
        CacheFile file = this.getFileOrDir(path, null);
        if (file != null) {
            return file.getDate();
        }
        return null;
    }

    public String getFileTime(String path) {
        CacheFile file = this.getFileOrDir(path, null);
        if (file != null) {
            return file.getTime();
        }
        return null;
    }

    public void refreshDir(String path) {
        FileCacheProvider cache;
        VcsFileSystem fs = (VcsFileSystem)this.fileSystem.get();
        if (fs != null && (cache = fs.getCacheProvider()) != null) {
            cache.refreshCacheDir(path);
        }
    }

    public void refreshDirRecursive(String path) {
        FileCacheProvider cache;
        VcsFileSystem fs = (VcsFileSystem)this.fileSystem.get();
        if (fs != null && (cache = fs.getCacheProvider()) != null) {
            cache.refreshCacheDirRecursive(path);
        }
    }

    public Reference createReference(FileObject fo) {
        String path = fo.getPackageNameExt(File.separatorChar, '.');
        String absolutePath = this.getAbsolutePath(path);
        File file = new File(absolutePath);
        return CacheHandler.getInstance().createReference(fo, file, this.getCacheId());
    }

    public String getCacheId() {
        return this.cacheId;
    }

    public void setFSRoot(String fsRoot) {
        this.fsRoot = fsRoot;
    }

    public void setRelativeMountPoint(String relativeMountPoint) {
        this.relativeMountPoint = relativeMountPoint;
    }

    private String getAbsolutePath(String path) {
        path = this.fsRoot + File.separator + this.relativeMountPoint + File.separator + path.replace('/', File.separatorChar);
        while (path.endsWith(File.separator) && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private CacheFile getFileOrDir(String path, int strategy, Object locker) {
        FileCacheProvider cache;
        VcsFileSystem fs = (VcsFileSystem)this.fileSystem.get();
        CacheFile file = null;
        if (fs != null && (cache = fs.getCacheProvider()) != null) {
            path = this.getAbsolutePath(path);
            file = this.handler.getCacheFile(new File(path), strategy, cache.getCacheId(), locker);
        }
        return file;
    }

    private CacheFile getFileOrDir(String path, Object locker) {
        VcsFileSystem fs = (VcsFileSystem)this.fileSystem.get();
        int strategy = fs != null && fs.getAutoRefresh() == 0 ? 3 : 5;
        return this.getFileOrDir(path, strategy, locker);
    }

    public CacheFile getFile(String path) {
        int sep;
        String pDirName;
        FileSystemCache cache = this.handler.getCache(this.getCacheId());
        CacheDir dir = cache.getDir(pDirName = (sep = (path = this.getAbsolutePath(path)).lastIndexOf(File.separatorChar)) < 0 ? "" : path.substring(0, sep));
        if (dir == null) {
            return null;
        }
        String name = sep < 0 ? path : path.substring(sep + 1);
        return dir.getFile(name);
    }

    public CacheDir getDir(String path) {
        FileSystemCache cache = this.handler.getCache(this.getCacheId());
        CacheDir dir = cache.getDir(path = this.getAbsolutePath(path));
        if (dir == null) {
            int sep = path.lastIndexOf(File.separatorChar);
            String pDirName = sep < 0 ? "" : path.substring(0, sep);
            CacheDir parent = cache.getDir(pDirName);
            if (parent == null) {
                return null;
            }
            String name = sep < 0 ? path : path.substring(sep + 1);
            dir = parent.getSubDir(name);
        }
        return dir;
    }

    public boolean isFile(String path) {
        return this.getFile(path) != null;
    }

    public boolean isDir(String path) {
        return this.getDir(path) != null;
    }

    public void readDir(String path) {
        this.readDir(path, null);
    }

    public void readDir(String path, Object locker) {
        this.getFileOrDir(path + "/test", locker);
    }

    public void readDirFromDiskCache(String path) {
        this.readDirFromDiskCache(path, null);
    }

    public void readDirFromDiskCache(String path, Object locker) {
        this.getFileOrDir(path + "/test", 4, locker);
    }

    public String[] getFilesAndSubdirs(String path) {
        VcsCacheDir dir = (VcsCacheDir)this.getDir(path);
        if (dir == null) {
            return null;
        }
        return dir.getFilesAndSubdirs();
    }

    public void refreshCacheDir(String path) {
        String apath;
        FileSystemCache cache;
        CacheDir dir;
        VcsFileSystem fsystem = (VcsFileSystem)this.fileSystem.get();
        if (fsystem.isOffLine() && fsystem.getCommand("LIST_OFFLINE") == null) {
            if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)this.g("DLG_RefreshCommandDisabled"), 0)))) {
                fsystem.setOffLine(false);
            } else {
                return;
            }
        }
        if ((dir = (cache = this.handler.getCache(this.getCacheId())).getDir(apath = this.getAbsolutePath(path))) == null && (dir = cache.getDir(apath = VcsUtilities.getDirNamePart(apath))) == null) {
            this.getFileOrDir(VcsUtilities.getDirNamePart(path), null);
            return;
        }
        ((VcsCache)cache).doRefreshDir(dir, false);
    }

    public void refreshCacheDirRecursive(String path) {
        VcsFileSystem fsystem = (VcsFileSystem)this.fileSystem.get();
        if (fsystem.isOffLine() && fsystem.getCommand("LIST_OFFLINE") == null && fsystem.getCommand("LIST_SUB_OFFLINE") == null) {
            if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)this.g("DLG_RefreshCommandDisabled"), 0)))) {
                fsystem.setOffLine(false);
            } else {
                return;
            }
        }
        FileSystemCache cache = this.handler.getCache(this.getCacheId());
        String fullPath = this.getAbsolutePath(path);
        CacheDir dir = cache.getDir(fullPath);
        Object refreshDirsLocker = new Object();
        if (dir == null) {
            dir = cache.getDir(fullPath = VcsUtilities.getDirNamePart(fullPath));
            if (dir == null && "".equals(path)) {
                dir = (CacheDir)cache.getCacheFile(fsystem.getFile(path), 3, refreshDirsLocker);
            }
            if (dir == null) {
                return;
            }
        }
        ((VcsCache)cache).doRefreshDir(dir, true, refreshDirsLocker);
    }

    public void refreshDirFromDiskCache(File fpath) {
        this.refreshDirFromDiskCache(fpath, null);
    }

    public void refreshDirFromDiskCache(File fpath, Object locker) {
        String path;
        FileSystemCache cache = this.handler.getCache(this.getCacheId());
        CacheDir dir = cache.getDir(path = fpath.getAbsolutePath());
        if (dir == null && (dir = cache.getDir(path = VcsUtilities.getDirNamePart(path))) == null) {
            return;
        }
        dir.readFromDisk(locker);
    }

    public void addFolder(String path) {
        FileSystemCache cache = this.handler.getCache(this.getCacheId());
        File file = new File(this.getAbsolutePath(path));
        CacheDir dir = cache.getDir(file.getParent());
        VcsCacheDir localDir = new VcsCacheDir(cache.getId(), file);
        localDir.setLocal(true);
        localDir.setStatus(this.getLocalFileStatus());
        dir.addChildDir(localDir, true);
        cache.registerDir(localDir);
    }

    public void addFile(String path) {
        FileSystemCache cache = this.handler.getCache(this.getCacheId());
        cache.getCacheFile(new File(this.getAbsolutePath(path)), 0, null);
    }

    public void rename(String oldPath, String newPath) {
        FileSystemCache cache = this.handler.getCache(this.getCacheId());
        CacheFile file = cache.getCacheFile(new File(this.getAbsolutePath(oldPath)), 0, null);
        if (file == null) {
            return;
        }
        String newParentPath = VcsUtilities.getDirNamePart(newPath);
        CacheDir newParent = (CacheDir)cache.getCacheFile(new File(this.getAbsolutePath(newParentPath)), 0, null);
        String newFileName = VcsUtilities.getFileNamePart(newPath);
        if (newParent != null && newParent.equals(file.getParent())) {
            newParent.renameChild(file.getName(), newFileName, true);
        } else if (file instanceof VcsCacheFile) {
            if (((VcsCacheFile)file).isLocal()) {
                file.getParent().removeFile(file.getName(), true);
                if (newParent != null) {
                    file.setName(newFileName);
                    newParent.addFile(file, true);
                }
            }
        } else if (file instanceof VcsCacheDir && ((VcsCacheDir)file).isLocal()) {
            file.getParent().removeChildDir(file.getName(), true);
            if (newParent != null) {
                file.setName(newFileName);
                newParent.addChildDir((CacheDir)file, true);
            }
        }
    }

    public void remove(String path, boolean wasDirectory) {
        CacheDir parent = null;
        if (wasDirectory) {
            CacheDir dir = this.getDir(path);
            if (dir != null && (parent = dir.getParent()) != null) {
                parent.removeChildDir(dir.getName(), true);
            }
        } else {
            CacheFile file = this.getFile(path);
            if (file != null) {
                parent = file.getParent();
                parent.removeFile(file.getName(), true);
            }
        }
    }

    private String g(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$caching$VcsFSCache == null ? (class$org$netbeans$modules$vcscore$caching$VcsFSCache = VcsFSCache.class$("org.netbeans.modules.vcscore.caching.VcsFSCache")) : class$org$netbeans$modules$vcscore$caching$VcsFSCache), (String)s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class CacheProvidedFileStatusInfo
    extends FileStatusInfo {
        private String status;
        private String displayedStatus;
        private String iconResource;

        public CacheProvidedFileStatusInfo(String status, String displayedStatus, String iconResource) {
            super(status);
            this.displayedStatus = displayedStatus;
            this.iconResource = iconResource;
        }

        public String getDisplayName() {
            return this.displayedStatus;
        }

        public Image getIcon() {
            return this.iconResource != null ? Utilities.loadImage((String)this.iconResource) : null;
        }
    }
}

