/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cmdline;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JFrame;
import org.netbeans.modules.vcscore.DirReaderListener;
import org.netbeans.modules.vcscore.FileReaderListener;
import org.netbeans.modules.vcscore.RetrievingDialog;
import org.netbeans.modules.vcscore.Variables;
import org.netbeans.modules.vcscore.VcsDirContainer;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cmdline.CommandLineVcsDirReader;
import org.netbeans.modules.vcscore.cmdline.ExecuteCommand;
import org.netbeans.modules.vcscore.cmdline.UserCommand;
import org.netbeans.modules.vcscore.cmdline.VcsListRecursiveCommand;
import org.netbeans.modules.vcscore.commands.CommandDataOutputListener;
import org.netbeans.modules.vcscore.commands.CommandOutputListener;
import org.netbeans.modules.vcscore.commands.VcsCommandVisualizer;
import org.netbeans.modules.vcscore.util.Debug;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class CommandLineVcsDirReaderRecursive
extends ExecuteCommand {
    private Debug E;
    private Debug D;
    private String path;
    private VcsDirContainer rawData;
    private DirReaderListener listener;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$cmdline$CommandLineVcsDirReaderRecursive;

    public CommandLineVcsDirReaderRecursive(DirReaderListener listener, VcsFileSystem fileSystem, UserCommand listSub, Hashtable vars) {
        super(fileSystem, listSub, vars);
        this.D = this.E = new Debug("CommandLineVcsDirReaderRecursive", true);
        this.path = null;
        this.rawData = null;
        this.listener = null;
        this.listener = listener;
        String commonParent = (String)vars.get("COMMON_PARENT");
        String dir = (String)vars.get("DIR");
        if (commonParent != null && commonParent.length() > 0) {
            dir = commonParent + Variables.expand(vars, "${PS}", false) + dir;
        }
        this.path = dir.replace(File.separatorChar, '/');
    }

    public VcsCommandVisualizer getVisualizer() {
        return null;
    }

    protected void runCommand(String[] execs) {
        this.printErrorOutput("Recursive Command can not execute the command. Please supply a class of instance of VcsListRecursiveCommand.");
        this.printErrorOutput("LIST_SUB: " + NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$CommandLineVcsDirReaderRecursive == null ? (class$org$netbeans$modules$vcscore$cmdline$CommandLineVcsDirReaderRecursive = CommandLineVcsDirReaderRecursive.class$("org.netbeans.modules.vcscore.cmdline.CommandLineVcsDirReaderRecursive")) : class$org$netbeans$modules$vcscore$cmdline$CommandLineVcsDirReaderRecursive), (String)"MSG_List_command_failed") + "\n");
        this.exitStatus = 1;
    }

    protected void runClass(String exec, String className, String[] args) {
        this.E.deb("runClass: " + className);
        this.E.deb("Creating new CvsListCommand");
        boolean success = true;
        Class<?> listClass = null;
        try {
            listClass = Class.forName(className, true, VcsUtilities.getSFSClassLoader());
        }
        catch (ClassNotFoundException e) {
            this.printErrorOutput("LIST_SUB: " + NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$CommandLineVcsDirReaderRecursive == null ? (class$org$netbeans$modules$vcscore$cmdline$CommandLineVcsDirReaderRecursive = CommandLineVcsDirReaderRecursive.class$("org.netbeans.modules.vcscore.cmdline.CommandLineVcsDirReaderRecursive")) : class$org$netbeans$modules$vcscore$cmdline$CommandLineVcsDirReaderRecursive), (String)"ERR_ClassNotFound", (Object)className));
            success = false;
        }
        this.E.deb(listClass + " loaded");
        VcsListRecursiveCommand listCommand = null;
        try {
            listCommand = (VcsListRecursiveCommand)listClass.newInstance();
        }
        catch (InstantiationException e) {
            this.printErrorOutput("LIST_SUB: " + NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$CommandLineVcsDirReaderRecursive == null ? (class$org$netbeans$modules$vcscore$cmdline$CommandLineVcsDirReaderRecursive = CommandLineVcsDirReaderRecursive.class$("org.netbeans.modules.vcscore.cmdline.CommandLineVcsDirReaderRecursive")) : class$org$netbeans$modules$vcscore$cmdline$CommandLineVcsDirReaderRecursive), (String)"ERR_CanNotInstantiate", listClass));
            success = false;
        }
        catch (IllegalAccessException e) {
            this.printErrorOutput(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$CommandLineVcsDirReaderRecursive == null ? (class$org$netbeans$modules$vcscore$cmdline$CommandLineVcsDirReaderRecursive = CommandLineVcsDirReaderRecursive.class$("org.netbeans.modules.vcscore.cmdline.CommandLineVcsDirReaderRecursive")) : class$org$netbeans$modules$vcscore$cmdline$CommandLineVcsDirReaderRecursive), (String)"LIST_SUB: ERR_IllegalAccessOnClass", listClass));
            success = false;
        }
        this.E.deb("VcsListCommand created.");
        VcsDirContainer filesByName = new VcsDirContainer(this.path);
        UserCommand listSub = (UserCommand)this.getCommand();
        if (success) {
            Hashtable vars = this.getVariables();
            ExecuteCommand.setAdditionalParams(listCommand, this.getFileSystem());
            String dataRegex = (String)listSub.getProperty("data.regex");
            if (dataRegex == null) {
                dataRegex = "^(.*$)";
            }
            vars.put("DATAREGEX", dataRegex);
            String errorRegex = (String)listSub.getProperty("error.regex");
            if (errorRegex == null) {
                errorRegex = "^(.*$)";
            }
            vars.put("ERRORREGEX", errorRegex);
            String input = (String)listSub.getProperty("input");
            if (input != null) {
                vars.put("INPUT", input);
            }
            try {
                success = listCommand.listRecursively(vars, args, filesByName, new CommandOutputListener(){

                    public void outputLine(String line) {
                        CommandLineVcsDirReaderRecursive.this.printOutput(line);
                    }
                }, new CommandOutputListener(){

                    public void outputLine(String line) {
                        CommandLineVcsDirReaderRecursive.this.printErrorOutput(line);
                    }
                }, new CommandDataOutputListener(){

                    public void outputData(String[] data) {
                        CommandLineVcsDirReaderRecursive.this.printDataOutput(data);
                    }
                }, (String)listSub.getProperty("data.regex"), new CommandDataOutputListener(){

                    public void outputData(String[] data) {
                        CommandLineVcsDirReaderRecursive.this.printDataErrorOutput(data);
                    }
                }, (String)listSub.getProperty("error.regex"));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable thr) {
                success = false;
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate(thr, NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$CommandLineVcsDirReaderRecursive == null ? (class$org$netbeans$modules$vcscore$cmdline$CommandLineVcsDirReaderRecursive = CommandLineVcsDirReaderRecursive.class$("org.netbeans.modules.vcscore.cmdline.CommandLineVcsDirReaderRecursive")) : class$org$netbeans$modules$vcscore$cmdline$CommandLineVcsDirReaderRecursive), (String)"ERR_EXC_IN_CLASS", (Object)className)));
            }
        }
        this.rawData = filesByName;
        this.translateElementsRecursively(this.rawData, listSub);
        this.exitStatus = success ? 0 : 1;
    }

    private void translateElementsRecursively(VcsDirContainer rawData, UserCommand listSub) {
        Hashtable filesByName = (Hashtable)rawData.getElement();
        if (filesByName != null) {
            Hashtable<String, String[]> filesByNameTranslated = new Hashtable<String, String[]>();
            Enumeration enumeration = filesByName.keys();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                String[] elements = (String[])filesByName.get(name);
                elements = CommandLineVcsDirReader.translateElements(elements, listSub);
                filesByNameTranslated.put(name, elements);
            }
            rawData.setElement(filesByNameTranslated);
        }
        VcsDirContainer[] subdirs = rawData.getSubdirContainers();
        int i = 0;
        while (i < subdirs.length) {
            this.translateElementsRecursively(subdirs[i], listSub);
            ++i;
        }
    }

    public void run() {
        String exec;
        Hashtable vars = this.getVariables();
        String commonParent = (String)vars.get("COMMON_PARENT");
        String dir = (String)vars.get("DIR");
        if (commonParent != null && commonParent.length() > 0) {
            dir = commonParent + Variables.expand(vars, "${PS}", false) + dir;
        }
        if ((exec = this.getExec()) == null || exec.trim().length() == 0) {
            RetrievingDialog rd = new RetrievingDialog(this.getFileSystem(), this.path, new JFrame(), false);
            VcsUtilities.centerWindow(rd);
            rd.run();
            this.exitStatus = 0;
            return;
        }
        try {
            super.run();
            Object var7_6 = null;
            int lastSlash = this.path.lastIndexOf(47);
            if (lastSlash > 0) {
                this.path = this.path.substring(0, lastSlash);
            }
            this.listener.readDirFinishedRecursive(this.path, this.rawData, this.getExitStatus() == 0);
            this.getFileSystem().removeNumDoAutoRefresh(dir);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            int lastSlash = this.path.lastIndexOf(47);
            if (lastSlash > 0) {
                this.path = this.path.substring(0, lastSlash);
            }
            this.listener.readDirFinishedRecursive(this.path, this.rawData, this.getExitStatus() == 0);
            this.getFileSystem().removeNumDoAutoRefresh(dir);
            throw throwable;
        }
    }

    public void addFileReaderListener(FileReaderListener l) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

