/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cmdline;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Set;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.netbeans.api.vcs.VcsManager;
import org.netbeans.api.vcs.commands.Command;
import org.netbeans.api.vcs.commands.CommandTask;
import org.netbeans.modules.vcscore.FileReaderListener;
import org.netbeans.modules.vcscore.Variables;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cmdline.CommandLineVcsDirReader;
import org.netbeans.modules.vcscore.cmdline.UserCommand;
import org.netbeans.modules.vcscore.cmdline.VcsAdditionalCommand;
import org.netbeans.modules.vcscore.cmdline.exec.BadRegexException;
import org.netbeans.modules.vcscore.cmdline.exec.ExternalCommand;
import org.netbeans.modules.vcscore.commands.CommandDataOutputListener;
import org.netbeans.modules.vcscore.commands.CommandOutputListener;
import org.netbeans.modules.vcscore.commands.RegexOutputListener;
import org.netbeans.modules.vcscore.commands.TextOutputListener;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.commands.VcsCommandIO;
import org.netbeans.modules.vcscore.commands.VcsCommandVisualizer;
import org.netbeans.modules.vcscore.commands.VcsDescribedCommand;
import org.netbeans.modules.vcscore.util.Debug;
import org.netbeans.modules.vcscore.util.VariableValueAdjustment;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.netbeans.spi.vcs.commands.CommandSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ExecuteCommand
implements VcsCommandExecutor {
    private Debug E;
    private Debug D;
    public static final String DEFAULT_REGEX = "^(.*$)";
    public static final String STATUS_USE_REG_EXP_PARSE_OUTPUT = "REG_EXP_PARSE_OUTPUT";
    private VcsFileSystem fileSystem;
    private UserCommand cmd;
    private Hashtable vars;
    private String preferredExec;
    private VcsDescribedCommand command;
    private CommandTask task;
    private ArrayList textOutputListeners;
    private ArrayList textErrorListeners;
    private ArrayList regexOutputListeners;
    private ArrayList regexErrorListeners;
    private ArrayList dataOutputListeners;
    private ArrayList dataErrorListeners;
    private ArrayList fileReaderListeners;
    private boolean doFileRefresh;
    private boolean doPostExecutionRefresh;
    private boolean getFileRefreshFromErrOut;
    private ArrayList filesToRefresh;
    private ArrayList refreshInfoElements;
    private String refreshFilesBase;
    private String refreshFilesMustStartWith;
    private boolean substituteStatuses;
    private RE[] substituitionRegExps;
    private String[] substituitionStatuses;
    private Collection processingFilesCollection;
    protected int exitStatus;
    private String lastCollectedFolder;
    private Set lastCollectedElements;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$VcsFileSystem;

    public ExecuteCommand(VcsFileSystem fileSystem, UserCommand cmd, Hashtable vars) {
        this(fileSystem, cmd, vars, null);
    }

    public ExecuteCommand(VcsFileSystem fileSystem, UserCommand cmd, Hashtable vars, String preferredExec) {
        this.D = this.E = new Debug("ExecuteCommand", true);
        this.fileSystem = null;
        this.cmd = null;
        this.vars = null;
        this.preferredExec = null;
        this.command = null;
        this.task = null;
        this.textOutputListeners = new ArrayList();
        this.textErrorListeners = new ArrayList();
        this.regexOutputListeners = new ArrayList();
        this.regexErrorListeners = new ArrayList();
        this.dataOutputListeners = new ArrayList();
        this.dataErrorListeners = new ArrayList();
        this.fileReaderListeners = new ArrayList();
        this.getFileRefreshFromErrOut = false;
        this.refreshFilesBase = null;
        this.refreshFilesMustStartWith = null;
        this.substituteStatuses = false;
        this.processingFilesCollection = null;
        this.exitStatus = 0;
        this.lastCollectedFolder = null;
        this.lastCollectedElements = null;
        this.fileSystem = fileSystem;
        this.cmd = cmd;
        this.vars = vars;
        if (preferredExec == null) {
            preferredExec = (String)cmd.getProperty("exec");
        }
        this.preferredExec = preferredExec;
        this.doFileRefresh = VcsCommandIO.getIntegerPropertyAssumeNegative(cmd, "data.fileName.index") >= 0;
        this.doPostExecutionRefresh = VcsCommandIO.getBooleanProperty(cmd, "refreshProcessedFiles");
        if (this.doFileRefresh) {
            this.refreshInfoElements = new ArrayList();
            String statusSubstitutions = (String)cmd.getProperty("refreshFileStatusSubstitutions");
            boolean bl = this.substituteStatuses = statusSubstitutions != null && statusSubstitutions.length() > 0;
            if (this.substituteStatuses) {
                this.parseStatusSubstitutions(statusSubstitutions);
            }
            this.getFileRefreshFromErrOut = VcsCommandIO.getBooleanProperty(cmd, "refreshInfoFromBothDataOuts");
        }
    }

    private void parseStatusSubstitutions(String statusSubstitutions) {
        String[] substitutions = VcsUtilities.getQuotedStrings(statusSubstitutions);
        int n = substitutions.length / 2;
        RE[] regExps = new RE[n];
        String[] statuses = new String[n];
        int nn = n;
        int i = 0;
        while (i < n) {
            block8: {
                try {
                    regExps[i] = new RE(substitutions[2 * i]);
                }
                catch (RESyntaxException e) {
                    ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)e, NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand == null ? ExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.ExecuteCommand") : class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand), (String)"MSG_BadRegExpInStatusSubstitution", (Object)substitutions[2 * i])));
                    --nn;
                    break block8;
                }
                statuses[i] = substitutions[2 * i + 1];
            }
            ++i;
        }
        if (n == nn) {
            this.substituitionRegExps = regExps;
            this.substituitionStatuses = statuses;
        } else {
            n = nn;
            this.substituitionRegExps = new RE[n];
            this.substituitionStatuses = new String[n];
            int j = 0;
            int i2 = 0;
            while (i2 < n) {
                if (regExps[j] == null) {
                    --i2;
                } else {
                    this.substituitionRegExps[i2] = regExps[j];
                    this.substituitionStatuses[i2] = statuses[j];
                }
                ++j;
                ++i2;
            }
        }
    }

    public VcsDescribedCommand getDescribedCommand() {
        return this.command;
    }

    public void setDescribedCommand(VcsDescribedCommand command) {
        this.command = command;
    }

    public CommandTask getTask() {
        return this.task;
    }

    public void setTask(CommandTask task) {
        this.task = task;
    }

    public final synchronized void addTextOutputListener(TextOutputListener l) {
        if (this.textOutputListeners != null) {
            this.textOutputListeners.add(l);
        }
    }

    public final synchronized void addTextErrorListener(TextOutputListener l) {
        if (this.textErrorListeners != null) {
            this.textErrorListeners.add(l);
        }
    }

    public final synchronized void addRegexOutputListener(RegexOutputListener l) {
        if (this.regexOutputListeners != null) {
            this.regexOutputListeners.add(l);
        }
    }

    public final synchronized void addRegexErrorListener(RegexOutputListener l) {
        if (this.regexErrorListeners != null) {
            this.regexErrorListeners.add(l);
        }
    }

    public void addOutputListener(CommandOutputListener l) {
        if (this.textOutputListeners != null) {
            this.textOutputListeners.add(l);
        }
    }

    public void addErrorOutputListener(CommandOutputListener l) {
        if (this.textErrorListeners != null) {
            this.textErrorListeners.add(l);
        }
    }

    public void addDataOutputListener(CommandDataOutputListener l) {
        if (this.dataOutputListeners != null) {
            this.dataOutputListeners.add(l);
        }
    }

    public void addDataErrorOutputListener(CommandDataOutputListener l) {
        if (this.dataErrorListeners != null) {
            this.dataErrorListeners.add(l);
        }
    }

    public final VcsCommand getCommand() {
        return this.cmd;
    }

    public final Hashtable getVariables() {
        return this.vars;
    }

    public final int getExitStatus() {
        return this.exitStatus;
    }

    public VcsCommandVisualizer getVisualizer() {
        return null;
    }

    private void commandFinished(String exec, boolean success) {
        this.textOutputListeners.clear();
        this.textErrorListeners.clear();
        this.regexOutputListeners.clear();
        this.regexErrorListeners.clear();
        this.dataOutputListeners.clear();
        this.dataErrorListeners.clear();
        if (this.doFileRefresh) {
            this.flushRefreshInfo();
            this.cleanupSendRefreshInfo();
        }
        this.textOutputListeners = null;
        this.textErrorListeners = null;
        this.regexOutputListeners = null;
        this.regexErrorListeners = null;
        this.dataOutputListeners = null;
        this.dataErrorListeners = null;
        if (success || VcsCommandIO.getIntegerPropertyAssumeNegative(this.cmd, "refreshOnFail") == 1) {
            this.refreshRemainingFiles();
            boolean whatChanged = false;
            Object changedInfo = null;
        }
        this.fileReaderListeners.clear();
        this.fileReaderListeners = null;
    }

    public String preprocessCommand(VcsCommand vc, Hashtable vars, String exec) {
        this.preferredExec = exec;
        this.fileSystem.getVarValueAdjustment().adjustVarValues(vars);
        if (exec != null && exec.indexOf("TEMPORARY_FILE") >= 0) {
            try {
                File tempFile = File.createTempFile("VCS", "tmp");
                tempFile.deleteOnExit();
                vars.put("TEMPORARY_FILE", tempFile.getAbsolutePath());
            }
            catch (IOException ioex) {
                // empty catch block
            }
        }
        this.vars = vars;
        if (exec != null) {
            this.preferredExec = Variables.expand(vars, exec, false);
        }
        return exec;
    }

    public String getExec() {
        return this.preferredExec;
    }

    protected final VcsFileSystem getFileSystem() {
        return this.fileSystem;
    }

    private StringBuffer[] addRegexListeners(ExternalCommand ec, RE[] globalRegexs) {
        StringBuffer errorOutput;
        StringBuffer dataOutput;
        String errorRegex;
        String dataRegex = (String)this.cmd.getProperty("data.regex");
        if (dataRegex == null) {
            dataRegex = DEFAULT_REGEX;
        }
        if ((errorRegex = (String)this.cmd.getProperty("error.regex")) == null) {
            errorRegex = DEFAULT_REGEX;
        }
        String dataRegexGlobal = (String)this.cmd.getProperty("data.regex.global");
        String errorRegexGlobal = (String)this.cmd.getProperty("error.regex.global");
        RE dataRegexGlobalRE = null;
        RE errorRegexGlobalRE = null;
        if (dataRegexGlobal != null) {
            try {
                dataRegexGlobalRE = new RE(dataRegexGlobal);
            }
            catch (RESyntaxException exc) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)exc, NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand == null ? (class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand = ExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.exec.ExternalCommand")) : class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand), (String)"MSG_BadRegexMessageInfo", (Object)dataRegexGlobal)));
            }
            if (dataRegexGlobalRE != null) {
                globalRegexs[0] = dataRegexGlobalRE;
                dataOutput = new StringBuffer();
            } else {
                dataOutput = null;
            }
        } else {
            dataOutput = null;
        }
        if (errorRegexGlobal != null) {
            try {
                errorRegexGlobalRE = new RE(errorRegexGlobal);
            }
            catch (RESyntaxException exc) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)exc, NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand == null ? (class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand = ExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.exec.ExternalCommand")) : class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand), (String)"MSG_BadRegexMessageInfo", (Object)errorRegexGlobal)));
            }
            if (errorRegexGlobalRE != null) {
                globalRegexs[1] = errorRegexGlobalRE;
                errorOutput = new StringBuffer();
            } else {
                errorOutput = null;
            }
        } else {
            errorOutput = null;
        }
        try {
            if (dataRegexGlobalRE == null) {
                ec.addRegexOutputListener(new RegexOutputListener(){

                    public void outputMatchedGroups(String[] data) {
                        ExecuteCommand.this.printDataOutput(data);
                    }
                }, dataRegex);
            } else {
                ec.addRegexOutputListener(new RegexOutputListener(){

                    public void outputMatchedGroups(String[] data) {
                        if (data != null) {
                            int i = 0;
                            while (i < data.length) {
                                dataOutput.append(data[i]);
                                ++i;
                            }
                            dataOutput.append(" ");
                        }
                    }
                }, dataRegex);
            }
        }
        catch (BadRegexException e) {
            ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)e, NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand == null ? (class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand = ExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.exec.ExternalCommand")) : class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand), (String)"MSG_BadRegexMessageInfo", (Object)dataRegex)));
        }
        try {
            if (errorRegexGlobalRE == null) {
                ec.addRegexErrorListener(new RegexOutputListener(){

                    public void outputMatchedGroups(String[] data) {
                        ExecuteCommand.this.printDataErrorOutput(data);
                    }
                }, errorRegex);
            } else {
                ec.addRegexErrorListener(new RegexOutputListener(){

                    public void outputMatchedGroups(String[] data) {
                        if (data != null) {
                            int i = 0;
                            while (i < data.length) {
                                errorOutput.append(data[i]);
                                ++i;
                            }
                            errorOutput.append(" ");
                        }
                    }
                }, errorRegex);
            }
        }
        catch (BadRegexException e) {
            ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)e, NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand == null ? (class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand = ExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.exec.ExternalCommand")) : class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand), (String)"MSG_BadRegexMessageInfo", (Object)errorRegex)));
        }
        if (dataOutput != null || errorOutput != null) {
            return new StringBuffer[]{dataOutput, errorOutput};
        }
        return null;
    }

    private void printGlobalDataOutput(String globalDataOutput, RE globalDataRegex) {
        if (globalDataOutput.endsWith(" ")) {
            globalDataOutput = globalDataOutput.substring(0, globalDataOutput.length() - 1);
        }
        String[] parsed = ExternalCommand.matchToStringArray(globalDataRegex, globalDataOutput);
        this.printDataOutput(parsed);
    }

    private void printGlobalErrorDataOutput(String globalDataOutput, RE globalDataRegex) {
        if (globalDataOutput.endsWith(" ")) {
            globalDataOutput = globalDataOutput.substring(0, globalDataOutput.length() - 1);
        }
        String[] parsed = ExternalCommand.matchToStringArray(globalDataRegex, globalDataOutput);
        this.printDataErrorOutput(parsed);
    }

    protected void runCommand(String[] execs) {
        this.preferredExec = VcsUtilities.array2stringNl(execs);
        StringBuffer[] globalDataOutputWhole = null;
        RE[] globalRegexs = new RE[2];
        int i = 0;
        while (i < execs.length) {
            String exec = execs[i];
            ExternalCommand ec = new ExternalCommand(exec);
            ec.setInput((String)this.cmd.getProperty("input"));
            ec.setEnv(this.fileSystem.getEnvironmentVars());
            StringBuffer[] globalDataOutput = this.addRegexListeners(ec, globalRegexs);
            Iterator it = ((AbstractList)this.textOutputListeners).iterator();
            while (it.hasNext()) {
                ec.addTextOutputListener((TextOutputListener)it.next());
            }
            Iterator it2 = ((AbstractList)this.textErrorListeners).iterator();
            while (it2.hasNext()) {
                ec.addTextErrorListener((TextOutputListener)it2.next());
            }
            int status = ec.exec();
            if (status != this.exitStatus && (this.exitStatus == 0 || this.exitStatus == 1 && status == 2)) {
                this.exitStatus = status;
            }
            if (globalDataOutput != null) {
                if (globalDataOutputWhole == null) {
                    globalDataOutputWhole = globalDataOutput;
                } else {
                    globalDataOutputWhole[0].append((Object)globalDataOutput[0]);
                    globalDataOutputWhole[1].append((Object)globalDataOutput[1]);
                }
            }
            ++i;
        }
        if (globalDataOutputWhole != null) {
            if (globalDataOutputWhole[0] != null) {
                this.printGlobalDataOutput(globalDataOutputWhole[0].toString(), globalRegexs[0]);
            }
            if (globalDataOutputWhole[1] != null) {
                this.printGlobalErrorDataOutput(globalDataOutputWhole[1].toString(), globalRegexs[1]);
            }
        }
        this.E.deb("Command exited with exit status = " + this.exitStatus);
        switch (this.exitStatus) {
            case 0: {
                this.commandFinished(this.preferredExec, true);
                break;
            }
            case 1: 
            case 2: {
                this.commandFinished(this.preferredExec, false);
                this.fileSystem.removeNumDoAutoRefresh((String)this.vars.get("DIR"));
            }
        }
        this.D.deb("run(" + this.cmd.getName() + ") finished");
    }

    protected void printOutput(String line) {
        Iterator it = ((AbstractList)this.textOutputListeners).iterator();
        while (it.hasNext()) {
            ((TextOutputListener)it.next()).outputLine(line);
        }
    }

    protected void printErrorOutput(String line) {
        Iterator it = ((AbstractList)this.textErrorListeners).iterator();
        while (it.hasNext()) {
            ((TextOutputListener)it.next()).outputLine(line);
        }
    }

    protected void printDataOutput(String[] data) {
        Iterator it = ((AbstractList)this.regexOutputListeners).iterator();
        while (it.hasNext()) {
            ((RegexOutputListener)it.next()).outputMatchedGroups(data);
        }
        Iterator it2 = ((AbstractList)this.dataOutputListeners).iterator();
        while (it2.hasNext()) {
            ((CommandDataOutputListener)it2.next()).outputData(data);
        }
        if (this.doFileRefresh) {
            this.collectRefreshInfo(data);
        }
    }

    protected void printDataErrorOutput(String[] data) {
        Iterator it = ((AbstractList)this.regexErrorListeners).iterator();
        while (it.hasNext()) {
            ((RegexOutputListener)it.next()).outputMatchedGroups(data);
        }
        Iterator it2 = ((AbstractList)this.dataErrorListeners).iterator();
        while (it2.hasNext()) {
            ((CommandDataOutputListener)it2.next()).outputData(data);
        }
        if (this.getFileRefreshFromErrOut) {
            this.collectRefreshInfo(data);
        }
    }

    protected void runClass(String exec, String className, String[] args) {
        this.E.deb("runClass: " + className);
        boolean success = true;
        Class<?> execClass = null;
        this.preferredExec = exec;
        try {
            execClass = Class.forName(className, true, VcsUtilities.getSFSClassLoader());
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (execClass == null) {
            try {
                this.printErrorOutput("CLASS EXEC: " + ExecuteCommand.g("ERR_ClassNotFound", className));
            }
            catch (MissingResourceException mrexc) {
                this.printErrorOutput("CLASS EXEC: Class " + className + " not found");
            }
            success = false;
        }
        VcsAdditionalCommand execCommand = null;
        if (success) {
            this.D.deb(execClass + " loaded");
            try {
                execCommand = (VcsAdditionalCommand)execClass.newInstance();
            }
            catch (InstantiationException e) {
                this.printErrorOutput("CLASS EXEC: " + ExecuteCommand.g("ERR_CanNotInstantiate", execClass));
                success = false;
            }
            catch (IllegalAccessException e) {
                this.printErrorOutput("CLASS EXEC: " + ExecuteCommand.g("ERR_IllegalAccessOnClass", execClass));
                success = false;
            }
        }
        if (success) {
            this.E.deb("VcsAdditionalCommand created.");
            ExecuteCommand.setAdditionalParams(execCommand, this.fileSystem);
            String dataRegex = (String)this.cmd.getProperty("data.regex");
            String errorRegex = (String)this.cmd.getProperty("error.regex");
            String input = (String)this.cmd.getProperty("input");
            if (dataRegex != null) {
                this.vars.put("DATAREGEX", dataRegex);
            }
            if (errorRegex != null) {
                this.vars.put("ERRORREGEX", errorRegex);
            }
            if (input != null) {
                this.vars.put("INPUT", input);
            }
            try {
                success = execCommand.exec(this.vars, args, new CommandOutputListener(){

                    public void outputLine(String line) {
                        ExecuteCommand.this.printOutput(line);
                    }
                }, new CommandOutputListener(){

                    public void outputLine(String line) {
                        ExecuteCommand.this.printErrorOutput(line);
                    }
                }, new CommandDataOutputListener(){

                    public void outputData(String[] data) {
                        ExecuteCommand.this.printDataOutput(data);
                    }
                }, dataRegex, new CommandDataOutputListener(){

                    public void outputData(String[] data) {
                        ExecuteCommand.this.printDataErrorOutput(data);
                    }
                }, errorRegex);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable thr) {
                success = false;
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate(thr, NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand == null ? (class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand = ExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.ExecuteCommand")) : class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand), (String)"ERR_EXC_IN_CLASS", (Object)className)));
            }
        }
        Thread.currentThread();
        if (Thread.interrupted()) {
            this.exitStatus = 2;
            this.commandFinished(exec, false);
            this.fileSystem.removeNumDoAutoRefresh((String)this.vars.get("DIR"));
        } else if (success) {
            this.exitStatus = 0;
            this.commandFinished(exec, true);
        } else {
            this.exitStatus = 1;
            this.commandFinished(exec, false);
            this.fileSystem.removeNumDoAutoRefresh((String)this.vars.get("DIR"));
        }
    }

    public void run() {
        String tempFilePath2;
        block16: {
            String exec;
            int maxCmdLength = 0;
            String maxCmdLengthStr = (String)this.vars.get("MAX_CMD_LENGTH");
            if (maxCmdLengthStr != null) {
                try {
                    maxCmdLength = Integer.parseInt(maxCmdLengthStr);
                }
                catch (NumberFormatException nfex) {
                    // empty catch block
                }
            }
            if ((exec = this.preferredExec != null ? this.preferredExec : (String)this.cmd.getProperty("exec")) == null) {
                return;
            }
            String execOrig = exec;
            exec = Variables.expand(this.vars, exec, false);
            if ((exec = exec.trim()).trim().length() == 0) {
                this.preferredExec = "";
                return;
            }
            String[] execs = maxCmdLength > 0 && exec.length() > maxCmdLength ? this.splitExec(execOrig, maxCmdLength) : new String[]{exec};
            if (this.doPostExecutionRefresh) {
                this.filesToRefresh = new ArrayList(this.getFiles());
            } else if (this.doFileRefresh) {
                this.filesToRefresh = new ArrayList();
            }
            this.createRefreshFilesBase();
            String[] allArgs = VcsUtilities.getQuotedArguments(exec);
            String first = allArgs[0];
            this.E.deb("first = " + first);
            boolean disableRefresh = VcsCommandIO.getBooleanProperty(this.cmd, "checkForModifications");
            if (disableRefresh) {
                this.fileSystem.disableRefresh();
            }
            try {
                if (first != null && first.toLowerCase().endsWith(".class")) {
                    String[] args = new String[allArgs.length - 1];
                    System.arraycopy(allArgs, 1, args, 0, args.length);
                    this.runClass(exec, first.substring(0, first.length() - ".class".length()), args);
                } else {
                    this.runCommand(execs);
                }
                Object var11_11 = null;
                if (!disableRefresh) break block16;
                this.fileSystem.enableRefresh();
            }
            catch (Throwable throwable) {
                String tempFilePath2;
                Object var11_12 = null;
                if (disableRefresh) {
                    this.fileSystem.enableRefresh();
                }
                if ((tempFilePath2 = (String)this.vars.get("TEMPORARY_FILE")) != null) {
                    new File(tempFilePath2).delete();
                }
                throw throwable;
            }
        }
        if ((tempFilePath2 = (String)this.vars.get("TEMPORARY_FILE")) != null) {
            new File(tempFilePath2).delete();
        }
    }

    private String[] splitExec(String exec, int maxCmdLength) {
        String[] varNames = new String[]{"FILES", "QFILES", "PATHS", "QPATHS", "MPATHS", "QMPATHS"};
        int nVARS = varNames.length;
        int[][] fileIndexes = new int[nVARS][];
        int nFiles = 0;
        int i = 0;
        while (i < nVARS) {
            String indexesEncoded = (String)this.vars.get(varNames[i] + "_FILE_POS_INDEXES");
            if (indexesEncoded != null) {
                try {
                    fileIndexes[i] = (int[])VcsUtilities.decodeValue(indexesEncoded);
                    nFiles = fileIndexes[i].length;
                }
                catch (IOException ioex) {
                    // empty catch block
                }
            }
            ++i;
        }
        String[] varValues = new String[nVARS];
        int i2 = 0;
        while (i2 < nVARS) {
            varValues[i2] = (String)this.vars.get(varNames[i2]);
            ++i2;
        }
        ArrayList<String> execs = new ArrayList<String>();
        int startFileIndex = 0;
        do {
            int i3 = startFileIndex;
            int j = nFiles;
            String execTemp = null;
            while (i3 < j) {
                int k = (i3 + j) / 2;
                execTemp = this.getTempExec(startFileIndex, k, fileIndexes, exec, nVARS, varNames, varValues);
                if (execTemp.length() < maxCmdLength) {
                    i3 = k;
                    j = k;
                    continue;
                }
                j = k;
            }
            if (i3 == startFileIndex || execTemp == null) {
                return new String[]{Variables.expand(this.vars, exec, false)};
            }
            execs.add(execTemp);
            startFileIndex = i3;
            execTemp = this.getTempExec(startFileIndex, nFiles, fileIndexes, exec, nVARS, varNames, varValues);
            if (execTemp.length() >= maxCmdLength && startFileIndex != nFiles - 1) continue;
            execs.add(execTemp);
            break;
        } while (startFileIndex < nFiles);
        return execs.toArray(new String[0]);
    }

    private String getTempExec(int j, int k, int[][] fileIndexes, String exec, int nVARS, String[] varNames, String[] varValues) {
        int i = 0;
        while (i < nVARS) {
            String varTempValue = k < fileIndexes[i].length ? varValues[i].substring(fileIndexes[i][j], fileIndexes[i][k]) : varValues[i].substring(fileIndexes[i][j]);
            this.vars.put(varNames[i], varTempValue);
            ++i;
        }
        String execTemp = Variables.expand(this.vars, exec, false);
        execTemp = execTemp.trim();
        return execTemp;
    }

    protected static void setAdditionalParams(Object execCommand, VcsFileSystem fileSystem) {
        Class<?> clazz = execCommand.getClass();
        Class[] paramClasses = new Class[]{class$org$netbeans$modules$vcscore$VcsFileSystem == null ? (class$org$netbeans$modules$vcscore$VcsFileSystem = ExecuteCommand.class$("org.netbeans.modules.vcscore.VcsFileSystem")) : class$org$netbeans$modules$vcscore$VcsFileSystem};
        Method setFileSystemMethod = null;
        try {
            setFileSystemMethod = clazz.getDeclaredMethod("setFileSystem", paramClasses);
        }
        catch (NoSuchMethodException exc) {
            setFileSystemMethod = null;
        }
        catch (SecurityException excsec) {
            setFileSystemMethod = null;
        }
        if (setFileSystemMethod != null) {
            Object[] args = new Object[]{fileSystem};
            try {
                setFileSystemMethod.invoke(execCommand, args);
            }
            catch (IllegalAccessException iae) {
            }
            catch (IllegalArgumentException iare) {
            }
            catch (InvocationTargetException ite) {
            }
            catch (ExceptionInInitializerError eie) {
                // empty catch block
            }
        }
    }

    public Collection getFiles() {
        if (this.processingFilesCollection == null) {
            this.processingFilesCollection = ExecuteCommand.createProcessingFiles(this.fileSystem, this.vars);
        }
        return this.processingFilesCollection;
    }

    public static Collection createProcessingFiles(VcsFileSystem fileSystem, Hashtable vars) {
        VariableValueAdjustment valueAdjustment = fileSystem.getVarValueAdjustment();
        String separator = (String)vars.get("PS");
        char separatorChar = separator != null && separator.length() == 1 ? separator.charAt(0) : File.separatorChar;
        String paths = (String)vars.get("PATHS");
        String commonParent = (String)vars.get("COMMON_PARENT");
        if (commonParent != null) {
            commonParent = valueAdjustment.revertAdjustedVarValue(commonParent);
        }
        if ((paths = valueAdjustment.revertAdjustedVarValue(paths)) != null && paths.length() > 0) {
            int index;
            ArrayList<String> files = new ArrayList<String>();
            int len = paths.length();
            int begin = 0;
            do {
                if ((index = paths.indexOf("" + separatorChar + separatorChar, begin)) < 0) {
                    index = len;
                }
                String file = paths.substring(begin, index);
                if (commonParent != null) {
                    file = commonParent + "/" + file;
                }
                files.add(file.replace(separatorChar, '/'));
            } while ((begin = index + 2) < len);
            return Collections.unmodifiableList(files);
        }
        String path = (String)vars.get("DIR");
        String file = (String)vars.get("FILE");
        file = valueAdjustment.revertAdjustedVarValue(file);
        if ((path = valueAdjustment.revertAdjustedVarValue(path)) != null) {
            if (commonParent != null) {
                path = commonParent + "/" + path;
            }
            String fullPath = (path.length() > 0 ? path.replace(separatorChar, '/') : "") + (file == null ? "" : "/" + file);
            return Collections.singleton(fullPath);
        }
        return Collections.EMPTY_SET;
    }

    private void createRefreshFilesBase() {
        this.refreshFilesBase = (String)this.cmd.getProperty("refreshFileRelativePath");
        if (this.refreshFilesBase == null) {
            this.refreshFilesBase = (String)this.vars.get("COMMON_PARENT");
            this.refreshFilesMustStartWith = null;
        } else {
            this.refreshFilesBase = Variables.expand(this.vars, this.refreshFilesBase, false);
            String relMountPoint = this.fileSystem.getRelativeMountPoint();
            if (this.refreshFilesBase.length() <= relMountPoint.length()) {
                if (!relMountPoint.startsWith(this.refreshFilesBase)) {
                    this.doFileRefresh = false;
                    return;
                }
                this.refreshFilesMustStartWith = relMountPoint.substring(this.refreshFilesBase.length());
                while (this.refreshFilesMustStartWith.startsWith("/")) {
                    this.refreshFilesMustStartWith = this.refreshFilesMustStartWith.substring(1);
                }
                if (this.refreshFilesMustStartWith.length() == 0) {
                    this.refreshFilesMustStartWith = null;
                }
                this.refreshFilesBase = null;
            } else {
                if (!this.refreshFilesBase.startsWith(relMountPoint)) {
                    this.doFileRefresh = false;
                    return;
                }
                this.refreshFilesBase = this.refreshFilesBase.substring(relMountPoint.length());
                while (this.refreshFilesBase.startsWith("/")) {
                    this.refreshFilesBase = this.refreshFilesBase.substring(1);
                }
                if (this.refreshFilesBase.length() == 0) {
                    this.refreshFilesBase = null;
                }
                this.refreshFilesMustStartWith = null;
            }
        }
    }

    private void collectRefreshInfo(String[] elements) {
        if ((elements = CommandLineVcsDirReader.translateElements(elements, this.cmd)).length == 1) {
            this.flushRemoveFile(elements[0]);
            return;
        }
        if (elements[0] != null && elements[0].trim().length() > 0) {
            this.flushRefreshInfo();
        }
        this.refreshInfoElements.add(elements);
    }

    private void flushRemoveFile(String fileName) {
        String filePath;
        String fileDir = "";
        fileName.replace(File.separatorChar, '/');
        if (this.refreshFilesMustStartWith != null) {
            if (!fileName.startsWith(this.refreshFilesMustStartWith)) {
                return;
            }
            fileName = fileName.substring(this.refreshFilesMustStartWith.length() + 1);
        }
        if (this.refreshFilesBase != null) {
            filePath = this.refreshFilesBase + "/" + fileName;
            fileDir = VcsUtilities.getDirNamePart(filePath);
            fileName = VcsUtilities.getFileNamePart(filePath);
        } else {
            int sepIndex = fileName.indexOf(47);
            if (sepIndex < 0 || sepIndex == fileName.length() - 1) {
                fileDir = this.findFileDir(fileName);
                if (fileName.startsWith(fileDir + "/")) {
                    fileName = fileName.substring(fileDir.length() + 1);
                }
                filePath = fileDir.length() == 0 ? fileName : fileDir + "/" + fileName;
            } else {
                fileDir = this.findFileDir(fileName);
                filePath = fileDir.length() == 0 ? fileName : fileDir + "/" + fileName;
                fileDir = VcsUtilities.getDirNamePart(filePath);
                fileName = VcsUtilities.getFileNamePart(filePath);
            }
        }
        this.sendRefreshInfo(fileDir, new String[]{fileName});
        ((AbstractCollection)this.filesToRefresh).remove(filePath);
    }

    private void flushRefreshInfo() {
        Object name = null;
        String[] elements = this.mergeInfoElements();
        while (elements != null) {
            if (elements[0] != null && elements[0].trim().length() > 0) {
                String filePath;
                elements[0].replace(File.separatorChar, '/');
                String fileName = elements[0];
                String fileDir = "";
                if (this.refreshFilesMustStartWith != null) {
                    if (!fileName.startsWith(this.refreshFilesMustStartWith)) {
                        return;
                    }
                    fileName = fileName.substring(this.refreshFilesMustStartWith.length() + 1);
                }
                if (this.refreshFilesBase != null) {
                    filePath = this.refreshFilesBase + "/" + fileName;
                    fileDir = VcsUtilities.getDirNamePart(filePath);
                    elements[0] = fileName = VcsUtilities.getFileNamePart(filePath);
                } else {
                    int sepIndex = fileName.indexOf(47);
                    if (sepIndex < 0 || sepIndex == fileName.length() - 1) {
                        fileDir = this.findFileDir(fileName);
                        if (fileName.startsWith(fileDir + "/")) {
                            elements[0] = fileName = fileName.substring(fileDir.length() + 1);
                        }
                        filePath = fileDir.length() == 0 ? fileName : fileDir + "/" + fileName;
                    } else {
                        fileDir = this.findFileDir(fileName);
                        filePath = fileDir.length() == 0 ? fileName : fileDir + "/" + fileName;
                        fileDir = VcsUtilities.getDirNamePart(filePath);
                        elements[0] = fileName = VcsUtilities.getFileNamePart(filePath);
                    }
                }
                if (this.substituteStatuses && (elements = this.performStatusSubstitution(elements)) == null) {
                    if (!this.doPostExecutionRefresh) {
                        this.filesToRefresh.add(filePath);
                    }
                } else {
                    fileName = elements[0];
                    if (!fileName.endsWith("/") && this.fileSystem.folder(fileDir + "/" + fileName)) {
                        elements[0] = fileName = fileName + "/";
                    }
                    this.sendRefreshInfo(fileDir, elements);
                    ((AbstractCollection)this.filesToRefresh).remove(filePath);
                }
            }
            elements = this.mergeInfoElements();
        }
    }

    private String[] mergeInfoElements() {
        String[] elements = null;
        while (this.refreshInfoElements.size() > 0) {
            String[] elements1 = (String[])this.refreshInfoElements.get(0);
            if (elements == null) {
                elements = elements1;
                this.refreshInfoElements.remove(0);
                continue;
            }
            if (elements1[0] != null && elements1[0].trim().length() != 0) break;
            elements = this.mergeElements(elements, elements1);
            this.refreshInfoElements.remove(0);
        }
        return elements;
    }

    private String[] mergeElements(String[] e1, String[] e2) {
        int i = 0;
        while (i < e1.length && i < e2.length) {
            if (i != 0 && (e1[i] == null || e1[i].trim().length() == 0 && e2[i] != null && e2[i].trim().length() > 0)) {
                e1[i] = e2[i];
            }
            ++i;
        }
        return e1;
    }

    private String[] performStatusSubstitution(String[] elements) {
        String status = elements[1];
        if (status == null) {
            return elements;
        }
        int i = 0;
        while (i < this.substituitionRegExps.length) {
            if (this.substituitionRegExps[i].match(status)) {
                status = STATUS_USE_REG_EXP_PARSE_OUTPUT.equals(this.substituitionStatuses[i]) ? this.substituitionRegExps[i].getParen(0) : this.substituitionStatuses[i];
                elements[1] = status;
                return elements;
            }
            ++i;
        }
        return null;
    }

    private String findFileDir(String name) {
        String dir = "";
        Collection files = this.doPostExecutionRefresh ? this.filesToRefresh : this.getFiles();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            String filePath = (String)it.next();
            if (!filePath.endsWith(name)) continue;
            if (filePath.length() <= name.length()) break;
            dir = filePath.substring(0, filePath.length() - name.length() - 1);
            break;
        }
        return dir;
    }

    private void refreshRemainingFiles() {
        if (!"LIST_FILE".equals(this.cmd.getName())) {
            if (this.filesToRefresh != null && this.filesToRefresh.size() > 0) {
                this.doRefreshFiles(this.fileSystem, this.filesToRefresh);
            } else if (VcsCommandIO.getBooleanProperty(this.cmd, "refreshProcessedFiles")) {
                this.doRefreshFiles(this.fileSystem, this.getFiles());
            }
        }
    }

    private void doRefreshFiles(VcsFileSystem fileSystem, Collection filesPaths) {
        CommandSupport cmdSupp = fileSystem.getCommandSupport("LIST_FILE");
        if (cmdSupp != null) {
            Command cmd = cmdSupp.createCommand();
            ArrayList<FileObject> foFiles = new ArrayList<FileObject>();
            ArrayList<File> diskFiles = new ArrayList<File>();
            Iterator it = filesPaths.iterator();
            while (it.hasNext()) {
                String file = (String)it.next();
                FileObject fo = fileSystem.findFileObject(file);
                if (fo != null) {
                    foFiles.add(fo);
                    continue;
                }
                diskFiles.add(fileSystem.getFile(file));
            }
            if (foFiles.size() > 0) {
                cmd.setFiles(foFiles.toArray(new FileObject[foFiles.size()]));
            }
            if (cmd instanceof VcsDescribedCommand) {
                if (diskFiles.size() > 0) {
                    ((VcsDescribedCommand)cmd).setDiskFiles(diskFiles.toArray(new File[diskFiles.size()]));
                }
                Iterator it2 = ((AbstractList)this.fileReaderListeners).iterator();
                while (it2.hasNext()) {
                    ((VcsDescribedCommand)cmd).addFileReaderListener((FileReaderListener)it2.next());
                }
            }
            VcsManager.getDefault().showCustomizer(cmd);
            cmd.execute();
        }
    }

    private void sendRefreshInfo(String folder, String[] elements) {
        if (!folder.equals(this.lastCollectedFolder)) {
            if (this.lastCollectedFolder != null) {
                Iterator it = ((AbstractList)new ArrayList(this.fileReaderListeners)).iterator();
                while (it.hasNext()) {
                    ((FileReaderListener)it.next()).readFileFinished(this.lastCollectedFolder, this.lastCollectedElements);
                }
                this.lastCollectedElements.clear();
            }
            this.lastCollectedFolder = folder;
        }
        if (this.lastCollectedElements == null) {
            this.lastCollectedElements = new HashSet();
        }
        this.lastCollectedElements.add(elements);
    }

    private void cleanupSendRefreshInfo() {
        if (this.lastCollectedFolder != null) {
            Iterator it = ((AbstractList)new ArrayList(this.fileReaderListeners)).iterator();
            while (it.hasNext()) {
                ((FileReaderListener)it.next()).readFileFinished(this.lastCollectedFolder, this.lastCollectedElements);
            }
        }
        this.lastCollectedFolder = null;
        this.lastCollectedElements = null;
    }

    public void addFileReaderListener(FileReaderListener l) {
        if (this.fileReaderListeners != null) {
            this.fileReaderListeners.add(l);
        }
    }

    private static final String g(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand == null ? (class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand = ExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.ExecuteCommand")) : class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand), (String)s);
    }

    private static final String g(String s, Object obj) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand == null ? (class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand = ExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.ExecuteCommand")) : class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand), (String)s, (Object)obj);
    }

    private static final String g(String s, Object obj1, Object obj2) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand == null ? (class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand = ExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.ExecuteCommand")) : class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand), (String)s, (Object)obj1, (Object)obj2);
    }

    private static final String g(String s, Object obj1, Object obj2, Object obj3) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand == null ? (class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand = ExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.ExecuteCommand")) : class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand), (String)s, (Object)obj1, (Object)obj2, (Object)obj3);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

