/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cmdline;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.util.Debug;
import org.openide.util.NbBundle;

public class UserCommand
implements VcsCommand,
Serializable,
Cloneable,
Comparable {
    private static Debug E;
    private static Debug D;
    public static final String NAME_REFRESH_FILE = "LIST_FILE";
    public static final String PROPERTY_REFRESH_PROCESSED_FILES = "refreshProcessedFiles";
    public static final String PROPERTY_INPUT = "input";
    public static final String PROPERTY_DATA_REGEX = "data.regex";
    public static final String PROPERTY_ERROR_REGEX = "error.regex";
    public static final String PROPERTY_DATA_REGEX_GLOBAL = "data.regex.global";
    public static final String PROPERTY_ERROR_REGEX_GLOBAL = "error.regex.global";
    public static final String PROPERTY_LIST_INDEX_FILE_NAME = "data.fileName.index";
    public static final String PROPERTY_LIST_INDEX_REMOVED_FILE_NAME = "data.removedFileName.index";
    public static final String PROPERTY_LIST_INDEX_STATUS = "data.status.index";
    public static final String PROPERTY_LIST_INDEX_LOCKER = "data.locker.index";
    public static final String PROPERTY_LIST_INDEX_REVISION = "data.revision.index";
    public static final String PROPERTY_LIST_INDEX_STICKY = "data.sticky.index";
    public static final String PROPERTY_LIST_INDEX_ATTR = "data.attr.index";
    public static final String PROPERTY_LIST_INDEX_DATE = "data.date.index";
    public static final String PROPERTY_LIST_INDEX_TIME = "data.time.index";
    public static final String PROPERTY_LIST_INDEX_SIZE = "data.size.index";
    public static final String PROPERTY_REFRESH_FILE_STATUS_SUBSTITUTIONS = "refreshFileStatusSubstitutions";
    public static final String PROPERTY_REFRESH_INFO_FROM_BOTH_DATA_OUTS = "refreshInfoFromBothDataOuts";
    public static final String PROPERTY_REFRESH_FILE_RELATIVE_PATH = "refreshFileRelativePath";
    private String name = "";
    private String advancedName = null;
    private String label = "";
    private String exec = "";
    private String input = "";
    private long timeout = 0L;
    private String dataRegex = "(.*$)";
    private String errorRegex = "";
    private boolean displayOutput = false;
    private boolean doRefresh = false;
    private String refreshRecursivelyPattern = "";
    private boolean refreshParent = true;
    private boolean checkForModifications = false;
    private boolean onDir = true;
    private boolean onFile = true;
    private boolean onRoot = false;
    private boolean notOnRoot = false;
    private String confirmationMsg = "";
    private boolean processAllFiles = false;
    private int numRevisions = 0;
    private boolean changingNumRevisions = false;
    private boolean changingRevision = false;
    private String changedRevisionVariableName = "";
    private int[] orderArr = new int[]{-1};
    private int statusIndex = -1;
    private int lockerIndex = -1;
    private int attrIndex = -1;
    private int dateIndex = -1;
    private int timeIndex = -1;
    private int sizeIndex = -1;
    private int fileNameIndex = -1;
    public volatile String[] userParams = null;
    private HashMap properties = new HashMap();
    private ArrayList children = null;
    static final long serialVersionUID = 6658759487911693730L;

    public UserCommand() {
        this.setPropertiesFromFields();
    }

    public UserCommand(String name) {
        this.name = name;
        this.properties = null;
        this.setPropertiesFromFields();
    }

    public Object clone() {
        UserCommand uc = new UserCommand();
        uc.copyFrom(this);
        return uc;
    }

    public void copyFrom(VcsCommand vc) {
        UserCommand uc = (UserCommand)vc;
        this.name = uc.name;
        this.label = uc.label;
        this.orderArr = (int[])uc.orderArr.clone();
        String[] properties = uc.getPropertyNames();
        int i = 0;
        while (i < properties.length) {
            this.setProperty(properties[i], uc.getProperty(properties[i]));
            ++i;
        }
    }

    public int compareTo(Object o) {
        if (!(o instanceof UserCommand)) {
            throw new IllegalArgumentException("Bad object type");
        }
        UserCommand cmd = (UserCommand)o;
        int[] o1 = this.orderArr;
        int[] o2 = cmd.getOrder();
        int l1 = o1.length;
        int l2 = o2.length;
        int i = 0;
        while (i < l1 && i < l2) {
            if (o1[i] != o2[i]) {
                return o1[i] - o2[i];
            }
            ++i;
        }
        return l1 - l2;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDisplayName(String displayName) {
        this.label = displayName;
    }

    public String getDisplayName() {
        return this.label;
    }

    public void setOrder(int[] orderArr) {
        this.orderArr = (int[])orderArr.clone();
    }

    public int[] getOrder() {
        return (int[])this.orderArr.clone();
    }

    public String toString() {
        if (this.exec != null) {
            return this.name + "[" + this.getOrderString() + "]" + "(" + this.label + ")(" + this.timeout + ")='" + this.exec + "'" + (this.name.equals("LIST") ? "[[" + this.statusIndex + "," + this.lockerIndex + "," + this.attrIndex + "," + this.dateIndex + "," + this.timeIndex + ", " + this.sizeIndex + "," + this.fileNameIndex + "]]" : "");
        }
        return this.label + "[" + this.getOrderString() + "]";
    }

    public String getOrderString() {
        return UserCommand.getOrderString(this.orderArr);
    }

    public static String getOrderString(int[] orderArr) {
        String str = "";
        int i = 0;
        while (i < orderArr.length) {
            str = str + orderArr[i];
            if (i < orderArr.length - 1) {
                str = str + ".";
            }
            ++i;
        }
        return str;
    }

    public String[] getPropertyNames() {
        Set props = this.properties.keySet();
        return props.toArray(new String[0]);
    }

    public synchronized Object getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public synchronized void setProperty(String propertyName, Object value) {
        if (value == null) {
            this.properties.remove(propertyName);
        } else {
            this.properties.put(propertyName, value);
        }
    }

    public static void readFinished(List cmds) {
    }

    private void setPropertiesFromFields() {
        if (this.properties == null) {
            this.properties = new HashMap();
            if (this.exec == null) {
                return;
            }
            this.setProperty("advancedName", this.advancedName);
            this.setProperty("exec", this.exec);
            this.setProperty(PROPERTY_INPUT, this.input);
            this.setProperty(PROPERTY_DATA_REGEX, this.dataRegex);
            this.setProperty(PROPERTY_ERROR_REGEX, this.errorRegex);
            this.setProperty("display", this.displayOutput ? Boolean.TRUE : Boolean.FALSE);
            this.setProperty("refreshRecursivelyPatternMatched", this.refreshRecursivelyPattern);
            this.setProperty("refreshParentFolder", this.doRefresh && this.refreshParent ? Boolean.TRUE : Boolean.FALSE);
            this.setProperty("refreshCurrentFolder", this.doRefresh && !this.refreshParent ? Boolean.TRUE : Boolean.FALSE);
            this.setProperty("checkForModifications", this.checkForModifications ? Boolean.TRUE : Boolean.FALSE);
            if (this.onRoot) {
                this.onDir = false;
                this.onFile = false;
            } else {
                this.onRoot = true;
            }
            this.setProperty("onFile", this.onFile ? Boolean.TRUE : Boolean.FALSE);
            this.setProperty("onDir", this.onDir ? Boolean.TRUE : Boolean.FALSE);
            this.setProperty("onRoot", this.onRoot ? Boolean.TRUE : Boolean.FALSE);
            this.setProperty("confirmationMsg", this.confirmationMsg);
            this.setProperty("processAllFiles", this.processAllFiles ? Boolean.TRUE : Boolean.FALSE);
            this.setProperty("numRevisions", new Integer(this.numRevisions));
            this.setProperty("changingNumRevisions", this.changingNumRevisions ? Boolean.TRUE : Boolean.FALSE);
            this.setProperty("changingRevision", this.changingRevision ? Boolean.TRUE : Boolean.FALSE);
            this.setProperty("changedRevisionVarName", this.changedRevisionVariableName);
            if ("LIST".equals(this.name) || "LIST_SUB".equals(this.name)) {
                this.setProperty(PROPERTY_LIST_INDEX_FILE_NAME, new Integer(this.fileNameIndex));
                this.setProperty(PROPERTY_LIST_INDEX_STATUS, new Integer(this.statusIndex));
                this.setProperty(PROPERTY_LIST_INDEX_LOCKER, new Integer(this.lockerIndex));
                this.setProperty(PROPERTY_LIST_INDEX_ATTR, new Integer(this.attrIndex));
                this.setProperty(PROPERTY_LIST_INDEX_DATE, new Integer(this.dateIndex));
                this.setProperty(PROPERTY_LIST_INDEX_TIME, new Integer(this.timeIndex));
                this.setProperty(PROPERTY_LIST_INDEX_SIZE, new Integer(this.sizeIndex));
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setPropertiesFromFields();
    }

    static String g(String s) {
        return NbBundle.getBundle((String)"org.netbeans.modules.vcscore.cmdline.Bundle").getString(s);
    }

    static String g(String s, Object obj) {
        return MessageFormat.format(UserCommand.g(s), obj);
    }

    static String g(String s, Object obj1, Object obj2) {
        return MessageFormat.format(UserCommand.g(s), obj1, obj2);
    }

    static String g(String s, Object obj1, Object obj2, Object obj3) {
        return MessageFormat.format(UserCommand.g(s), obj1, obj2, obj3);
    }

    static {
        D = E = new Debug("UserCommand", true);
    }
}

