/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cmdline;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.api.vcs.commands.Command;
import org.netbeans.api.vcs.commands.CommandTask;
import org.netbeans.modules.vcscore.DirReaderListener;
import org.netbeans.modules.vcscore.FileReaderListener;
import org.netbeans.modules.vcscore.Variables;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.cache.FileSystemCache;
import org.netbeans.modules.vcscore.caching.FileCacheProvider;
import org.netbeans.modules.vcscore.cmdline.UserCommand;
import org.netbeans.modules.vcscore.cmdline.UserCommandCustomizer;
import org.netbeans.modules.vcscore.cmdline.UserCommandTask;
import org.netbeans.modules.vcscore.cmdline.WrappingCommandTask;
import org.netbeans.modules.vcscore.commands.ActionCommandSupport;
import org.netbeans.modules.vcscore.commands.CommandCustomizationSupport;
import org.netbeans.modules.vcscore.commands.RegexErrorListener;
import org.netbeans.modules.vcscore.commands.RegexOutputListener;
import org.netbeans.modules.vcscore.commands.TextErrorListener;
import org.netbeans.modules.vcscore.commands.TextOutputListener;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.commands.VcsCommandIO;
import org.netbeans.modules.vcscore.commands.VcsCommandVisualizer;
import org.netbeans.modules.vcscore.commands.VcsDescribedCommand;
import org.netbeans.modules.vcscore.util.Table;
import org.netbeans.modules.vcscore.util.VariableInputDialog;
import org.netbeans.modules.vcscore.util.VariableValueAdjustment;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.netbeans.spi.vcs.commands.CommandSupport;
import org.netbeans.spi.vcs.commands.CommandTaskSupport;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;

public class UserCommandSupport
extends CommandSupport
implements PrivilegedAction,
ActionCommandSupport {
    private static final String PROPERTY_PARSED_ATTR_NAMES = "_For_Internal_Use_Only_FOAttributesNamesParsed";
    private static final String PROPERTY_PARSED_ATTR_NEMPTY_VARS = "_For_Internal_Use_Only_FOAttributesNotEmptyVars";
    private static final String PROPERTY_PARSED_ATTR_VALUES_VARS = "_For_Internal_Use_Only_FOAttributesValuesVars";
    private UserCommand cmd;
    private VcsFileSystem fileSystem;
    private String displayName;
    private Class implementedCommandClass = null;
    private static final String QUOTING = "${QUOTE}";
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$commands$VcsDescribedCommand;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$cmdline$UserCommandSupport$CustomizationStatus;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$DirReaderListener;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$commands$TextOutputListener;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$commands$TextErrorListener;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$commands$RegexOutputListener;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$commands$RegexErrorListener;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$FileReaderListener;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$caching$VcsFSCache;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$cmdline$UserCommandSupport;
    static /* synthetic */ Class class$org$netbeans$api$vcs$commands$Command;

    public UserCommandSupport(UserCommand cmd, VcsFileSystem fileSystem) {
        super(UserCommandSupport.getClassesForCommand(cmd));
        this.cmd = cmd;
        this.fileSystem = fileSystem;
        this.displayName = UserCommandSupport.getDisplayName(cmd, fileSystem);
        this.implementedCommandClass = UserCommandSupport.findImplementedCommandClass(cmd);
    }

    private static Class[] getClassesForCommand(UserCommand cmd) {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(class$org$netbeans$modules$vcscore$commands$VcsDescribedCommand == null ? (class$org$netbeans$modules$vcscore$commands$VcsDescribedCommand = UserCommandSupport.class$("org.netbeans.modules.vcscore.commands.VcsDescribedCommand")) : class$org$netbeans$modules$vcscore$commands$VcsDescribedCommand);
        classes.add(class$org$netbeans$modules$vcscore$cmdline$UserCommandSupport$CustomizationStatus == null ? (class$org$netbeans$modules$vcscore$cmdline$UserCommandSupport$CustomizationStatus = UserCommandSupport.class$("org.netbeans.modules.vcscore.cmdline.UserCommandSupport$CustomizationStatus")) : class$org$netbeans$modules$vcscore$cmdline$UserCommandSupport$CustomizationStatus);
        Class cmdClass = UserCommandSupport.findImplementedCommandClass(cmd);
        if (cmdClass != null) {
            classes.add(cmdClass);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static Class findImplementedCommandClass(UserCommand cmd) {
        String cmdClassName = (String)cmd.getProperty("associatedCommandInterfaceName");
        Class<?> cmdClass = null;
        if (cmdClassName != null) {
            try {
                ClassLoader systemClassLoader = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = UserCommandSupport.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
                cmdClass = Class.forName(cmdClassName, false, systemClassLoader);
            }
            catch (ClassNotFoundException cnfex) {
                ErrorManager.getDefault().notify((Throwable)cnfex);
            }
        }
        return cmdClass;
    }

    private static String getDisplayName(UserCommand cmd, VcsFileSystem fileSystem) {
        String label = cmd.getDisplayName();
        if (label != null) {
            char mnemonicChar;
            int mnemonicIndex;
            label = Variables.expand(fileSystem.getVariablesAsHashtable(), label, false);
            String mnemonic = (String)cmd.getProperty("labelMnemonic");
            if (mnemonic != null && mnemonic.length() > 0 && (mnemonicIndex = label.indexOf(mnemonicChar = mnemonic.charAt(0))) >= 0) {
                label = label.substring(0, mnemonicIndex) + "&" + label.substring(mnemonicIndex);
            }
        }
        return label;
    }

    public UserCommand getVcsCommand() {
        return this.cmd;
    }

    public VcsFileSystem getVcsFileSystem() {
        return this.fileSystem;
    }

    public String getName() {
        return this.cmd.getName();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Class getImplementedCommandClass() {
        return this.implementedCommandClass;
    }

    public boolean hasExpertMode() {
        return VcsCommandIO.getBooleanProperty(this.cmd, "supportsAdvancedMode");
    }

    VcsFileSystem getFileSystem() {
        return this.fileSystem;
    }

    protected CommandTaskSupport createTask(Command command) {
        VcsDescribedCommand dCommand;
        if (!(command instanceof VcsDescribedCommand)) {
            return null;
        }
        if (!((CustomizationStatus)command).isAlreadyCustomizedUserCommand()) {
            this.doCustomization(false, (VcsDescribedCommand)command);
        }
        if ((dCommand = (VcsDescribedCommand)command).getNextCommand() != null) {
            WrappingCommandTask wt = new WrappingCommandTask(this, dCommand);
            wt.runTasks();
            return wt;
        }
        return new UserCommandTask(this, dCommand);
    }

    DirReaderListener getAttachedDirReaderListener(Command command) {
        EventListener[] listeners = this.getListeners(class$org$netbeans$modules$vcscore$DirReaderListener == null ? (class$org$netbeans$modules$vcscore$DirReaderListener = UserCommandSupport.class$("org.netbeans.modules.vcscore.DirReaderListener")) : class$org$netbeans$modules$vcscore$DirReaderListener, command);
        return listeners != null && listeners.length > 0 ? (DirReaderListener)listeners[0] : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int execute(CommandTask task) {
        int i;
        if (task instanceof WrappingCommandTask) {
            return ((WrappingCommandTask)task).waitForTasks();
        }
        Command command = this.getCommand(task);
        if (!(command instanceof VcsDescribedCommand)) {
            return 1;
        }
        if (!(task instanceof UserCommandTask)) {
            return 1;
        }
        UserCommandTask userTask = (UserCommandTask)task;
        if (userTask.willSpawnRefresh()) {
            userTask.spawnRefresh();
            return 0;
        }
        VcsDescribedCommand dCommand = (VcsDescribedCommand)command;
        VcsCommandExecutor ec = userTask.getExecutor();
        EventListener[] listeners = this.getListeners(class$org$netbeans$modules$vcscore$commands$TextOutputListener == null ? (class$org$netbeans$modules$vcscore$commands$TextOutputListener = UserCommandSupport.class$("org.netbeans.modules.vcscore.commands.TextOutputListener")) : class$org$netbeans$modules$vcscore$commands$TextOutputListener, command);
        if (listeners != null) {
            i = 0;
            while (i < listeners.length) {
                ec.addTextOutputListener((TextOutputListener)listeners[i]);
                ++i;
            }
        }
        if ((listeners = this.getListeners(class$org$netbeans$modules$vcscore$commands$TextErrorListener == null ? (class$org$netbeans$modules$vcscore$commands$TextErrorListener = UserCommandSupport.class$("org.netbeans.modules.vcscore.commands.TextErrorListener")) : class$org$netbeans$modules$vcscore$commands$TextErrorListener, command)) != null) {
            i = 0;
            while (i < listeners.length) {
                ec.addTextErrorListener((TextErrorListener)listeners[i]);
                ++i;
            }
        }
        if ((listeners = this.getListeners(class$org$netbeans$modules$vcscore$commands$RegexOutputListener == null ? (class$org$netbeans$modules$vcscore$commands$RegexOutputListener = UserCommandSupport.class$("org.netbeans.modules.vcscore.commands.RegexOutputListener")) : class$org$netbeans$modules$vcscore$commands$RegexOutputListener, command)) != null) {
            i = 0;
            while (i < listeners.length) {
                ec.addRegexOutputListener((RegexOutputListener)listeners[i]);
                ++i;
            }
        }
        if ((listeners = this.getListeners(class$org$netbeans$modules$vcscore$commands$RegexErrorListener == null ? (class$org$netbeans$modules$vcscore$commands$RegexErrorListener = UserCommandSupport.class$("org.netbeans.modules.vcscore.commands.RegexErrorListener")) : class$org$netbeans$modules$vcscore$commands$RegexErrorListener, command)) != null) {
            i = 0;
            while (i < listeners.length) {
                ec.addRegexErrorListener((RegexErrorListener)listeners[i]);
                ++i;
            }
        }
        if ((listeners = this.getListeners(class$org$netbeans$modules$vcscore$FileReaderListener == null ? (class$org$netbeans$modules$vcscore$FileReaderListener = UserCommandSupport.class$("org.netbeans.modules.vcscore.FileReaderListener")) : class$org$netbeans$modules$vcscore$FileReaderListener, command)) != null) {
            i = 0;
            while (i < listeners.length) {
                ec.addFileReaderListener((FileReaderListener)listeners[i]);
                ++i;
            }
        }
        Map additionalVariables = dCommand.getAdditionalVariables();
        Hashtable vars = ec.getVariables();
        if (additionalVariables != null) {
            vars.putAll(additionalVariables);
        }
        ec.preprocessCommand(this.cmd, vars, dCommand.getPreferredExec());
        VcsCommandVisualizer visualizer = ec.getVisualizer();
        if (visualizer != null && !visualizer.openAfterCommandFinish()) {
            visualizer.open();
        }
        if (VcsCommandIO.getBooleanProperty(ec.getCommand(), "display") && (visualizer = userTask.getVisualizer(true)) != null) {
            visualizer.open();
        }
        try {
            ec.run();
            Object var11_11 = null;
            visualizer = ec.getVisualizer();
            if (visualizer == null) return ec.getExitStatus();
            visualizer.setExitStatus(ec.getExitStatus());
            if (!visualizer.openAfterCommandFinish()) return ec.getExitStatus();
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            visualizer = ec.getVisualizer();
            if (visualizer == null) throw throwable;
            visualizer.setExitStatus(ec.getExitStatus());
            if (!visualizer.openAfterCommandFinish()) throw throwable;
            visualizer.open();
            throw throwable;
        }
        visualizer.open();
        return ec.getExitStatus();
    }

    public FileObject[] getApplicableFiles(FileObject[] files) {
        boolean offLine = this.fileSystem.isOffLine();
        if (offLine != this.getName().endsWith("_OFFLINE")) {
            if (offLine && this.fileSystem.getCommand(this.getName() + "_OFFLINE") != null) {
                return null;
            }
            if (!offLine) {
                return null;
            }
        }
        if (VcsCommandIO.getIntegerPropertyAssumeZero(this.cmd, "numRevisions") != 0) {
            Command cmd = this.getCommand();
            if (cmd != null) {
                Map vars = ((VcsDescribedCommand)cmd).getAdditionalVariables();
                if (vars == null || vars.get("REVISION") == null) {
                    return null;
                }
            } else {
                return null;
            }
        }
        files = VcsUtilities.convertFileObjects(files);
        FileObject[] appFiles = CommandCustomizationSupport.getApplicableFiles(this.fileSystem, this.cmd, files);
        return appFiles;
    }

    protected Object clone() throws CloneNotSupportedException {
        UserCommandSupport clone = new UserCommandSupport(this.cmd, this.fileSystem);
        return clone;
    }

    protected void initializeCommand(Command cmd) {
        super.initializeCommand(cmd);
        VcsDescribedCommand vcmd = (VcsDescribedCommand)cmd;
        vcmd.setVcsCommand(this.cmd);
        FileSystemCache cache = CacheHandler.getInstance().getCache(this.fileSystem.getCacheIdStr());
        if (cache instanceof FileReaderListener) {
            vcmd.addFileReaderListener((FileReaderListener)((Object)cache));
        }
        cmd.setExpertMode(this.fileSystem.isExpertMode());
    }

    public Object run() {
        Command cmd = this.getCommand();
        if (!(cmd instanceof VcsDescribedCommand)) {
            throw new IllegalArgumentException("Command " + cmd + " is not an instance of VcsDescribedCommand!");
        }
        return this.doCustomization(true, (VcsDescribedCommand)cmd);
    }

    private Object doCustomization(boolean doCreateCustomizer, VcsDescribedCommand cmd) {
        Table files = this.getFilesToActOn(cmd);
        if (files.size() == 0) {
            files = null;
        }
        if ("LIST".equals(cmd.getName()) && this.fileSystem.isOffLine() && this.fileSystem.getCommand("LIST_OFFLINE") == null) {
            if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$caching$VcsFSCache == null ? (class$org$netbeans$modules$vcscore$caching$VcsFSCache = UserCommandSupport.class$("org.netbeans.modules.vcscore.caching.VcsFSCache")) : class$org$netbeans$modules$vcscore$caching$VcsFSCache), (String)"DLG_RefreshCommandDisabled"), 0)))) {
                this.fileSystem.setOffLine(false);
            } else {
                return new UserCancelException();
            }
        }
        if (files != null && VcsCommandIO.getBooleanPropertyAssumeDefault(this.cmd, "needsHierarchicalOrder")) {
            files = UserCommandSupport.createHierarchicalOrder(files);
        }
        boolean cmdCanRunOnMultipleFiles = VcsCommandIO.getBooleanPropertyAssumeDefault(this.cmd, "runOnMultipleFiles");
        boolean cmdCanRunOnMultipleFilesInFolder = VcsCommandIO.getBooleanPropertyAssumeDefault(this.cmd, "runOnMultipleFilesInFolder");
        VariableValueAdjustment valueAdjustment = this.fileSystem.getVarValueAdjustment();
        FileCacheProvider cacheProvider = this.fileSystem.getCacheProvider();
        Object obj = this.doCustomization(doCreateCustomizer, null, cmd, files, cacheProvider, valueAdjustment, cmdCanRunOnMultipleFiles, cmdCanRunOnMultipleFilesInFolder);
        return obj;
    }

    private Object doCustomization(boolean doCreateCustomizer, UserCommandCustomizer customizer, VcsDescribedCommand cmd, Table files, FileCacheProvider cacheProvider, VariableValueAdjustment valueAdjustment, boolean cmdCanRunOnMultipleFiles, boolean cmdCanRunOnMultipleFilesInFolder) {
        boolean[] forEachFile = null;
        Hashtable vars = this.fileSystem.getVariablesAsHashtable();
        Map additionalVars = cmd.getAdditionalVariables();
        if (additionalVars != null) {
            vars.putAll(additionalVars);
        }
        UserCommandSupport.setVariablesFromCommandInterfaces(cmd, vars);
        if (cmd.isExpertMode()) {
            vars.put("CTRL_DOWN_IN_ACTION", Boolean.TRUE);
        }
        if (files != null && files.size() > 1) {
            forEachFile = new boolean[]{true};
        }
        return this.doCustomization(doCreateCustomizer, customizer, cmd, files, cacheProvider, valueAdjustment, vars, forEachFile, cmdCanRunOnMultipleFiles, cmdCanRunOnMultipleFilesInFolder);
    }

    private Object doCustomization(boolean doCreateCustomizer, UserCommandCustomizer customizer, VcsDescribedCommand cmd, Table files, FileCacheProvider cacheProvider, VariableValueAdjustment valueAdjustment, Hashtable vars, boolean[] forEachFile, boolean cmdCanRunOnMultipleFiles, boolean cmdCanRunOnMultipleFilesInFolder) {
        Table subFiles;
        VcsCommand vcsCmd = cmd.getVcsCommand();
        if (files != null) {
            subFiles = UserCommandSupport.setupRestrictedFileMap(files, vars, vcsCmd);
            UserCommandSupport.setVariables(subFiles, vars, QUOTING, valueAdjustment, cacheProvider, this.fileSystem.getRelativeMountPoint(), true);
        } else {
            subFiles = null;
        }
        String commandExec = (String)vcsCmd.getProperty("exec");
        String newExec = CommandCustomizationSupport.preCustomize(this.fileSystem, vcsCmd, vars);
        if (commandExec != null && newExec == null) {
            return new UserCancelException();
        }
        Object finalCustomizer = null;
        if ((commandExec == null || newExec != null) && doCreateCustomizer) {
            finalCustomizer = this.createCustomizer(customizer, newExec, vars, forEachFile, cmd, files, cacheProvider, valueAdjustment, cmdCanRunOnMultipleFiles, cmdCanRunOnMultipleFilesInFolder);
            customizer = finalCustomizer instanceof UserCommandCustomizer ? (UserCommandCustomizer)finalCustomizer : null;
        }
        if (newExec != null) {
            cmd.setPreferredExec(newExec);
        }
        cmd.setAdditionalVariables(vars);
        if (finalCustomizer == null && files != null) {
            VcsDescribedCommand lastCmd = cmd;
            if (!cmdCanRunOnMultipleFiles || cmdCanRunOnMultipleFilesInFolder) {
                lastCmd = this.createNextCustomizedCommand(cmd, subFiles, cacheProvider, valueAdjustment, vars, cmdCanRunOnMultipleFiles, cmdCanRunOnMultipleFilesInFolder);
            }
            Iterator it = subFiles.keySet().iterator();
            while (it.hasNext()) {
                files.remove(it.next());
            }
            if (files.size() > 0 && lastCmd != null) {
                VcsDescribedCommand nextCmd = this.createNextCommand(files, lastCmd);
                this.doCustomization(false, null, nextCmd, files, cacheProvider, valueAdjustment, new Hashtable(vars), forEachFile, cmdCanRunOnMultipleFiles, cmdCanRunOnMultipleFilesInFolder);
            }
        }
        ((CustomizationStatus)((Object)cmd)).setAlreadyCustomizedUserCommand(true);
        return finalCustomizer;
    }

    private VcsDescribedCommand createNextCustomizedCommand(VcsDescribedCommand cmd, Table files, FileCacheProvider cacheProvider, VariableValueAdjustment valueAdjustment, Hashtable vars, boolean cmdCanRunOnMultipleFiles, boolean cmdCanRunOnMultipleFilesInFolder) {
        Table subFiles = UserCommandSupport.setupRestrictedFileMap(files, cmdCanRunOnMultipleFiles, cmdCanRunOnMultipleFilesInFolder);
        UserCommandSupport.setVariables(subFiles, vars, QUOTING, valueAdjustment, cacheProvider, this.fileSystem.getRelativeMountPoint(), true);
        cmd.setAdditionalVariables(vars);
        if (files.size() != subFiles.size()) {
            Table remaining = new Table();
            Enumeration en = files.keys();
            while (en.hasMoreElements()) {
                Object singleFile = en.nextElement();
                if (subFiles.containsKey(singleFile)) continue;
                remaining.put(singleFile, files.get(singleFile));
            }
            VcsDescribedCommand nextCmd = this.createNextCommand(remaining, cmd);
            Hashtable newVars = new Hashtable(vars);
            VcsDescribedCommand nextCustomizedCommand = this.createNextCustomizedCommand(nextCmd, remaining, cacheProvider, valueAdjustment, newVars, cmdCanRunOnMultipleFiles, cmdCanRunOnMultipleFilesInFolder);
            String newExec = CommandCustomizationSupport.preCustomize(this.fileSystem, nextCmd.getVcsCommand(), newVars);
            if (newExec == null) {
                return null;
            }
            nextCmd.setPreferredExec(newExec);
            nextCmd.setAdditionalVariables(newVars);
            return nextCustomizedCommand;
        }
        return cmd;
    }

    private VcsDescribedCommand createNextCommand(Table files, VcsDescribedCommand oldCommand) {
        Command command = this.createCommand();
        if (!(command instanceof VcsDescribedCommand)) {
            throw new IllegalArgumentException("Command " + command + " is not an instance of VcsDescribedCommand!");
        }
        UserCommandSupport.setCommandFilesFromTable(command, files, this.fileSystem);
        command.setExpertMode(oldCommand.isExpertMode());
        command.setGUIMode(oldCommand.isGUIMode());
        oldCommand.setNextCommand(command);
        return (VcsDescribedCommand)command;
    }

    private Table getFilesToActOn(Command cmd) {
        File[] diskFiles;
        Table files = new Table();
        FileObject[] fos = cmd.getFiles();
        if (fos != null) {
            int i = 0;
            while (i < fos.length) {
                files.put(fos[i].getPath(), fos[i]);
                ++i;
            }
        }
        if (cmd instanceof VcsDescribedCommand && (diskFiles = ((VcsDescribedCommand)cmd).getDiskFiles()) != null) {
            String root = this.fileSystem.getFile("").getAbsolutePath();
            int i = 0;
            while (i < diskFiles.length) {
                String path = diskFiles[0].getAbsolutePath();
                if (path.indexOf(root) == 0) {
                    path = path.substring(root.length());
                    while (path.startsWith(File.separator)) {
                        path = path.substring(1);
                    }
                }
                files.put(path.replace(File.separatorChar, '/'), (Object)null);
                ++i;
            }
        }
        return files;
    }

    private Object createCustomizer(UserCommandCustomizer customizer, String newExec, final Hashtable vars, final boolean[] forEachFile, final VcsDescribedCommand command, final Table files, final FileCacheProvider cacheProvider, final VariableValueAdjustment valueAdjustment, final boolean cmdCanRunOnMultipleFiles, final boolean cmdCanRunOnMultipleFilesInFolder) {
        VariableInputDialog dlg;
        StringBuffer title = new StringBuffer();
        try {
            dlg = CommandCustomizationSupport.createInputDialog(this.fileSystem, newExec, vars, this.cmd, forEachFile, title);
        }
        catch (UserCancelException ucex) {
            return ucex;
        }
        if (dlg == null) {
            return null;
        }
        if (customizer == null) {
            customizer = new UserCommandCustomizer();
        }
        final UserCommandCustomizer finalCustomizer = customizer;
        customizer.setCommand(command, dlg, this.fileSystem, title.toString());
        dlg.addCloseListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                boolean isPromptForEachFile = dlg.getPromptForEachFile();
                if (dlg.isValidInput() && forEachFile != null) {
                    forEachFile[0] = isPromptForEachFile;
                    UserCommandSupport.this.fileSystem.setPromptForVarsForEachFile(forEachFile[0]);
                }
                if (files == null) {
                    return;
                }
                if (isPromptForEachFile) {
                    Object singleFile = files.keys().nextElement();
                    Table subFiles = new Table();
                    subFiles.put(singleFile, files.get(singleFile));
                    UserCommandSupport.setVariables(subFiles, vars, UserCommandSupport.QUOTING, valueAdjustment, cacheProvider, UserCommandSupport.this.fileSystem.getRelativeMountPoint(), true);
                    command.setAdditionalVariables(vars);
                    VcsDescribedCommand nextCmd = UserCommandSupport.this.createNextCommand(files, command);
                    files.remove(singleFile);
                    UserCommandSupport.this.doCustomization(true, finalCustomizer, nextCmd, files, cacheProvider, valueAdjustment, cmdCanRunOnMultipleFiles, cmdCanRunOnMultipleFilesInFolder);
                } else {
                    VcsCommand vcsCmd = command.getVcsCommand();
                    Table subFiles = UserCommandSupport.setupRestrictedFileMap(files, vars, vcsCmd);
                    VcsDescribedCommand lastCmd = command;
                    if (!cmdCanRunOnMultipleFiles || cmdCanRunOnMultipleFilesInFolder) {
                        lastCmd = UserCommandSupport.this.createNextCustomizedCommand(command, subFiles, cacheProvider, valueAdjustment, vars, cmdCanRunOnMultipleFiles, cmdCanRunOnMultipleFilesInFolder);
                    }
                    Iterator it = subFiles.keySet().iterator();
                    while (it.hasNext()) {
                        files.remove(it.next());
                    }
                    if (files.size() > 0 && lastCmd != null) {
                        VcsDescribedCommand nextCmd = UserCommandSupport.this.createNextCommand(files, lastCmd);
                        UserCommandSupport.this.doCustomization(false, null, nextCmd, files, cacheProvider, valueAdjustment, new Hashtable(vars), forEachFile, cmdCanRunOnMultipleFiles, cmdCanRunOnMultipleFilesInFolder);
                    }
                }
            }
        });
        return customizer;
    }

    public Class getActionClass() {
        Class<?> actionClass = (Class<?>)this.cmd.getProperty("_For_Internal_Use_Only_generalCommandActionClass");
        if (actionClass == null) {
            Object actionClassNameObj = this.cmd.getProperty("generalCommandActionClassName");
            if (actionClassNameObj instanceof String) {
                String actionClassName = (String)actionClassNameObj;
                try {
                    actionClass = Class.forName(actionClassName, false, VcsUtilities.getSFSClassLoader());
                }
                catch (ClassNotFoundException e) {
                    ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)e, NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$UserCommandSupport == null ? (class$org$netbeans$modules$vcscore$cmdline$UserCommandSupport = UserCommandSupport.class$("org.netbeans.modules.vcscore.cmdline.UserCommandSupport")) : class$org$netbeans$modules$vcscore$cmdline$UserCommandSupport), (String)"EXC_CouldNotFindAction", (Object)actionClassName)));
                }
            }
            if (actionClass != null) {
                this.cmd.setProperty("_For_Internal_Use_Only_generalCommandActionClass", actionClass);
            }
        }
        return actionClass;
    }

    public String getActionDisplayName() {
        return (String)this.cmd.getProperty("generalCommandActionDisplayName");
    }

    public static void setCommandFilesFromTable(Command command, Table files, VcsFileSystem fileSystem) {
        ArrayList<File> diskFiles = new ArrayList<File>();
        ArrayList<FileObject> foFiles = new ArrayList<FileObject>();
        Iterator it = files.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            FileObject fo = (FileObject)files.get(name);
            if (fo != null) {
                foFiles.add(fo);
                continue;
            }
            diskFiles.add(fileSystem.getFile(name));
        }
        FileObject[] fos = foFiles.toArray(new FileObject[foFiles.size()]);
        command.setFiles(fos);
        if (command instanceof VcsDescribedCommand) {
            VcsDescribedCommand dcmd = (VcsDescribedCommand)command;
            if (diskFiles.size() > 0) {
                dcmd.setDiskFiles(diskFiles.toArray(new File[diskFiles.size()]));
            }
        }
    }

    private static Table createHierarchicalOrder(Table files) {
        TreeMap sorted = new TreeMap(files);
        Table sortedFiles = new Table();
        Iterator it = sorted.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            sortedFiles.put(key, files.get(key));
        }
        return sortedFiles;
    }

    private static Table setupRestrictedFileMap(Table files, boolean cmdCanRunOnMultipleFiles, boolean cmdCanRunOnMultipleFilesInFolder) {
        Table subFiles = new Table();
        if (!cmdCanRunOnMultipleFiles && !cmdCanRunOnMultipleFilesInFolder) {
            Object singleFile = files.keys().nextElement();
            subFiles.put(singleFile, files.get(singleFile));
        } else if (cmdCanRunOnMultipleFilesInFolder) {
            Enumeration keys = files.keys();
            String file = (String)keys.nextElement();
            subFiles.put(file, files.get(file));
            String folder = "";
            int index = file.lastIndexOf(47);
            if (index >= 0) {
                folder = file.substring(0, index);
            }
            while (keys.hasMoreElements()) {
                file = (String)keys.nextElement();
                String testFolder = "";
                index = file.lastIndexOf(47);
                if (index >= 0) {
                    testFolder = file.substring(0, index);
                }
                if (!folder.equals(testFolder)) continue;
                subFiles.put(file, files.get(file));
            }
        }
        return subFiles;
    }

    private static Table setupRestrictedFileMap(Table files, Hashtable vars, VcsCommand cmd) {
        String[] attrsToVars = (String[])cmd.getProperty("loadAttributesToVars");
        if (attrsToVars != null) {
            files = UserCommandSupport.getAttributeRestrictedFileMap(files, vars, cmd, attrsToVars);
        }
        if (Boolean.TRUE.equals(cmd.getProperty("distinguishBinaryFiles"))) {
            files = UserCommandSupport.getBinaryRestrictedFileMap(files, vars, cmd);
        }
        return files;
    }

    private static Table getAttributeRestrictedFileMap(Table files, Hashtable vars, VcsCommand cmd, String[] attrsToVars) {
        Map attrNonNullVars = null;
        Map attrValueVars = null;
        String[] attrNames = (String[])cmd.getProperty(PROPERTY_PARSED_ATTR_NAMES);
        if (attrNames != null) {
            attrNonNullVars = (Map)cmd.getProperty(PROPERTY_PARSED_ATTR_NEMPTY_VARS);
            attrValueVars = (Map)cmd.getProperty(PROPERTY_PARSED_ATTR_VALUES_VARS);
        } else {
            attrNonNullVars = new HashMap();
            attrValueVars = new HashMap();
            attrNames = UserCommandSupport.getAttrNamesAndVars(attrNonNullVars, attrValueVars, attrsToVars);
            cmd.setProperty(PROPERTY_PARSED_ATTR_NAMES, attrNames);
            cmd.setProperty(PROPERTY_PARSED_ATTR_NEMPTY_VARS, attrNonNullVars);
            cmd.setProperty(PROPERTY_PARSED_ATTR_VALUES_VARS, attrValueVars);
        }
        Table subFiles = attrNames != null ? UserCommandSupport.setVarsFromAttrs(files, vars, attrNames, attrNonNullVars, attrValueVars) : files;
        return subFiles;
    }

    private static String[] getAttrNamesAndVars(Map attrNonNullVars, Map attrValueVars, String[] attrsToVars) {
        String[] attrNames = new String[attrsToVars.length / 3];
        int i = 0;
        while (i < attrsToVars.length - 2) {
            String attrName;
            attrNames[i / 3] = attrName = attrsToVars[i];
            attrNonNullVars.put(attrName, attrsToVars[i + 1]);
            attrValueVars.put(attrName, attrsToVars[i + 2]);
            i += 3;
        }
        return attrNames;
    }

    private static Table getBinaryRestrictedFileMap(Table files, Hashtable vars, VcsCommand cmd) {
        Table restrictedFiles = new Table();
        Iterator it = files.keySet().iterator();
        if (!it.hasNext()) {
            return files;
        }
        String name = (String)it.next();
        FileObject fo = (FileObject)files.get(name);
        boolean isBinary = fo == null ? false : UserCommandSupport.isFOBinary(fo);
        restrictedFiles.put(name, fo);
        while (it.hasNext()) {
            name = (String)it.next();
            fo = (FileObject)files.get(name);
            if (fo == null ? isBinary : isBinary != UserCommandSupport.isFOBinary(fo)) continue;
            restrictedFiles.put(name, fo);
        }
        vars.put("PROCESSING_BINARY_FILES", isBinary ? Boolean.TRUE.toString() : "");
        return restrictedFiles;
    }

    private static boolean isFOBinary(FileObject fo) {
        String mimeType = fo.getMIMEType();
        return !mimeType.startsWith("text") && !"content/unknown".equals(mimeType);
    }

    private static Table setVarsFromAttrs(Table files, Hashtable vars, String[] attrNames, Map attrNonNullVars, Map attrValueVars) {
        if (attrNames.length == 0) {
            return files;
        }
        Table result = new Table();
        Object[] attrs = UserCommandSupport.getAttributes(result, files, attrNames);
        int i = 0;
        while (i < attrs.length) {
            vars.put(attrNonNullVars.get(attrNames[i]), attrs[i] != null ? Boolean.TRUE.toString() : "");
            if (attrs[i] != null) {
                vars.put(attrValueVars.get(attrNames[i]), attrs[i].toString());
            } else {
                vars.remove(attrValueVars.get(attrNames[i]));
            }
            ++i;
        }
        return result;
    }

    private static Object[] getAttributes(Table result, Table files, String[] attrNames) {
        int i;
        ArrayList<Object> values = new ArrayList<Object>();
        Iterator it = files.keySet().iterator();
        if (!it.hasNext()) {
            return values.toArray();
        }
        String name = (String)it.next();
        FileObject fo = (FileObject)files.get(name);
        if (fo == null) {
            values.addAll(Collections.nCopies(attrNames.length, null));
        } else {
            i = 0;
            while (i < attrNames.length) {
                values.add(fo.getAttribute(attrNames[i]));
                ++i;
            }
        }
        result.put(name, fo);
        while (it.hasNext()) {
            name = (String)it.next();
            fo = (FileObject)files.get(name);
            if (fo == null) {
                if (!Arrays.equals(values.toArray(), Collections.nCopies(attrNames.length, null).toArray())) {
                    continue;
                }
            } else {
                i = 0;
                while (i < attrNames.length) {
                    Object value = values.get(i);
                    Object attr = fo.getAttribute(attrNames[i]);
                    if (!(value == null && attr == null || value != null && value.equals(attr))) break;
                    ++i;
                }
                if (i < attrNames.length) continue;
            }
            result.put(name, fo);
        }
        return values.toArray();
    }

    private static void setVariables(Table files, Hashtable vars, String quoting, VariableValueAdjustment valueAdjustment, FileCacheProvider cacheProvider, String relativeMountPoint, boolean useGreatestParentPaths) {
        String module;
        String fullName;
        FileObject fo;
        String greatestParent;
        if (useGreatestParentPaths) {
            greatestParent = UserCommandSupport.findGreatestParent(files);
            if (greatestParent != null && greatestParent.length() == 0) {
                greatestParent = null;
            }
        } else {
            greatestParent = null;
        }
        boolean isFileFolder = (fo = (FileObject)files.get(fullName = (String)files.keys().nextElement())) != null && fo.isFolder();
        String origFullName = fullName;
        if (greatestParent != null) {
            fullName = fullName.substring(greatestParent.length());
            while (fullName.startsWith("/")) {
                fullName = fullName.substring(1);
            }
        }
        String path = VcsUtilities.getDirNamePart(fullName);
        String file = VcsUtilities.getFileNamePart(fullName);
        String separator = (String)vars.get("PS");
        char separatorChar = separator != null && separator.length() == 1 ? separator.charAt(0) : File.separatorChar;
        path = path.replace('/', separatorChar);
        fullName = fullName.replace('/', separatorChar);
        file = valueAdjustment.adjustVarValue(file);
        path = valueAdjustment.adjustVarValue(path);
        if ((fullName = valueAdjustment.adjustVarValue(fullName)).length() == 0) {
            fullName = ".";
        }
        if ((module = relativeMountPoint) == null) {
            module = "";
        }
        if (greatestParent != null) {
            if (module.length() > 0) {
                module = module + separatorChar;
            }
            module = module + greatestParent;
        }
        if (module.length() > 0) {
            module = module.replace('/', separatorChar);
            module = valueAdjustment.adjustVarValue(module);
        }
        vars.put("MODULE", module);
        if (module.length() > 0) {
            module = module + separatorChar;
        }
        vars.put("PATH", fullName);
        vars.put("QPATH", fullName.length() > 0 ? quoting + fullName + quoting : fullName);
        vars.put("DIR", path);
        if (path.length() == 0 && file.length() > 0 && file.charAt(0) == '/') {
            file = file.substring(1, file.length());
        }
        vars.put("FILE", file);
        vars.put("QFILE", quoting + file + quoting);
        if (fo != null) {
            vars.put("MIMETYPE", fo.getMIMEType());
        } else {
            int extIndex = file.lastIndexOf(46);
            String ext = extIndex >= 0 && extIndex < file.length() - 1 ? file.substring(extIndex + 1) : "";
            String mime = FileUtil.getMIMEType((String)ext);
            if (mime != null) {
                vars.put("MIMETYPE", mime);
            }
        }
        if (isFileFolder) {
            CacheDir cDir = cacheProvider.getDir(origFullName);
            if (cDir != null) {
                vars.put("CACHED_ATTR", cDir.getAttr());
            } else {
                vars.remove("CACHED_ATTR");
            }
        } else {
            CacheFile cFile = cacheProvider.getFile(origFullName);
            if (cFile != null) {
                vars.put("CACHED_ATTR", cFile.getAttr());
            } else {
                vars.remove("CACHED_ATTR");
            }
        }
        vars.put("FILE_IS_FOLDER", isFileFolder ? Boolean.TRUE.toString() : "");
        StringBuffer qpaths = new StringBuffer();
        StringBuffer paths = new StringBuffer();
        StringBuffer mpaths = new StringBuffer();
        StringBuffer qmpaths = new StringBuffer();
        StringBuffer vfiles = new StringBuffer();
        StringBuffer qfiles = new StringBuffer();
        int nVARS = 6;
        int nFILES = files.size();
        int[][] fileIndexes = new int[6][nFILES];
        int iFile = 0;
        Enumeration enumeration = files.keys();
        while (enumeration.hasMoreElements()) {
            fullName = (String)enumeration.nextElement();
            fo = (FileObject)files.get(fullName);
            origFullName = fullName;
            if (greatestParent != null) {
                fullName = fullName.substring(greatestParent.length());
                while (fullName.startsWith("/")) {
                    fullName = fullName.substring(1);
                }
            }
            if (fullName.length() == 0) {
                fullName = ".";
            }
            isFileFolder |= fo != null && fo.isFolder();
            file = VcsUtilities.getFileNamePart(fullName);
            fullName = fullName.replace('/', separatorChar);
            file = valueAdjustment.adjustVarValue(file);
            fullName = valueAdjustment.adjustVarValue(fullName);
            fileIndexes[0][iFile] = vfiles.length();
            fileIndexes[1][iFile] = qfiles.length();
            fileIndexes[2][iFile] = paths.length();
            fileIndexes[3][iFile] = qpaths.length();
            fileIndexes[4][iFile] = mpaths.length();
            fileIndexes[5][iFile] = qmpaths.length();
            vfiles.append(file);
            vfiles.append(separatorChar);
            qfiles.append(quoting);
            qfiles.append(file);
            qfiles.append(quoting);
            qfiles.append(" ");
            paths.append(fullName);
            paths.append("" + separatorChar + separatorChar);
            qpaths.append(quoting);
            qpaths.append(fullName);
            qpaths.append(quoting);
            qpaths.append(" ");
            mpaths.append(module + fullName);
            mpaths.append(" ");
            qmpaths.append(quoting);
            qmpaths.append(module + fullName);
            qmpaths.append(quoting);
            qmpaths.append(" ");
            ++iFile;
        }
        vars.put("FILES", vfiles.delete(vfiles.length() - 1, vfiles.length()).toString());
        vars.put("QFILES", qfiles.toString().trim());
        vars.put("PATHS", paths.delete(paths.length() - 2, paths.length()).toString());
        vars.put("QPATHS", qpaths.toString().trim());
        vars.put("MPATHS", mpaths.toString().trim());
        vars.put("QMPATHS", qmpaths.toString().trim());
        try {
            vars.put("FILES_FILE_POS_INDEXES", VcsUtilities.encodeValue(fileIndexes[0]));
            vars.put("QFILES_FILE_POS_INDEXES", VcsUtilities.encodeValue(fileIndexes[1]));
            vars.put("PATHS_FILE_POS_INDEXES", VcsUtilities.encodeValue(fileIndexes[2]));
            vars.put("QPATHS_FILE_POS_INDEXES", VcsUtilities.encodeValue(fileIndexes[3]));
            vars.put("MPATHS_FILE_POS_INDEXES", VcsUtilities.encodeValue(fileIndexes[4]));
            vars.put("QMPATHS_FILE_POS_INDEXES", VcsUtilities.encodeValue(fileIndexes[5]));
        }
        catch (IOException ioex) {
            // empty catch block
        }
        vars.put("NUM_FILES", "" + files.size());
        vars.put("MULTIPLE_FILES", files.size() > 1 ? Boolean.TRUE.toString() : "");
        vars.put("FILES_IS_FOLDER", isFileFolder ? Boolean.TRUE.toString() : "");
        if (greatestParent != null) {
            greatestParent = greatestParent.replace('/', separatorChar);
            greatestParent = valueAdjustment.adjustVarValue(greatestParent);
            vars.put("COMMON_PARENT", greatestParent);
        } else {
            vars.remove("COMMON_PARENT");
        }
    }

    private static String findGreatestParent(Table files) {
        String greatestParent = null;
        Enumeration enumeration = files.keys();
        while (enumeration.hasMoreElements()) {
            String fullName = (String)enumeration.nextElement();
            String parent = VcsUtilities.getDirNamePart(fullName);
            if (greatestParent == null) {
                greatestParent = parent;
                continue;
            }
            if (parent.startsWith(greatestParent) && (parent.length() <= greatestParent.length() || parent.charAt(greatestParent.length()) == '/')) continue;
            StringBuffer commonParent = new StringBuffer();
            int i = 0;
            while (i < parent.length() && i < greatestParent.length()) {
                char c = parent.charAt(i);
                if (greatestParent.charAt(i) != c) break;
                commonParent.append(c);
                ++i;
            }
            int end = commonParent.length();
            if (parent.length() != end && parent.charAt(end) != '/' || greatestParent.length() != end && greatestParent.charAt(end) != '/') {
                int i2 = end - 1;
                while (i2 >= 0) {
                    char c = commonParent.charAt(i2);
                    commonParent.deleteCharAt(i2);
                    if (c == '/') break;
                    --i2;
                }
            }
            greatestParent = commonParent.toString();
        }
        if (greatestParent != null) {
            while (greatestParent.endsWith("/")) {
                greatestParent = greatestParent.substring(0, greatestParent.length() - 1);
            }
        }
        return greatestParent;
    }

    private static void setVariablesFromCommandInterfaces(Command cmd, Hashtable vars) {
        Class[] interfaces = cmd.getClass().getInterfaces();
        UserCommandSupport.setVariablesFromCommandInterfaces(cmd, interfaces, vars);
    }

    private static void setVariablesFromCommandInterfaces(Command cmd, Class[] interfaces, Hashtable vars) {
        int i = 0;
        while (i < interfaces.length) {
            if (!((class$org$netbeans$api$vcs$commands$Command == null ? UserCommandSupport.class$("org.netbeans.api.vcs.commands.Command") : class$org$netbeans$api$vcs$commands$Command).equals(interfaces[i]) || (class$org$netbeans$modules$vcscore$commands$VcsDescribedCommand == null ? UserCommandSupport.class$("org.netbeans.modules.vcscore.commands.VcsDescribedCommand") : class$org$netbeans$modules$vcscore$commands$VcsDescribedCommand).equals(interfaces[i]) || (class$org$netbeans$modules$vcscore$cmdline$UserCommandSupport$CustomizationStatus == null ? UserCommandSupport.class$("org.netbeans.modules.vcscore.cmdline.UserCommandSupport$CustomizationStatus") : class$org$netbeans$modules$vcscore$cmdline$UserCommandSupport$CustomizationStatus).equals(interfaces[i]))) {
                try {
                    BeanInfo beanInfo = Introspector.getBeanInfo(interfaces[i]);
                    PropertyDescriptor[] propDescrs = beanInfo.getPropertyDescriptors();
                    int j = 0;
                    while (j < propDescrs.length) {
                        String name = propDescrs[j].getName();
                        Object value = propDescrs[j].getReadMethod().invoke((Object)cmd, new Object[0]);
                        if (value != null) {
                            vars.put(name, value.toString());
                        }
                        ++j;
                    }
                }
                catch (IntrospectionException iex) {
                }
                catch (IllegalAccessException iaex) {
                }
                catch (IllegalArgumentException iarex) {
                }
                catch (InvocationTargetException itex) {
                    // empty catch block
                }
                Class[] subinterfaces = interfaces[i].getInterfaces();
                UserCommandSupport.setVariablesFromCommandInterfaces(cmd, subinterfaces, vars);
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static interface CustomizationStatus
    extends Command {
        public boolean isAlreadyCustomizedUserCommand();

        public void setAlreadyCustomizedUserCommand(boolean var1);
    }
}

