/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cmdline;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.vcscore.DirReaderListener;
import org.netbeans.modules.vcscore.Variables;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.cache.FileSystemCache;
import org.netbeans.modules.vcscore.cmdline.CommandLineVcsDirReader;
import org.netbeans.modules.vcscore.cmdline.CommandLineVcsDirReaderRecursive;
import org.netbeans.modules.vcscore.cmdline.ExecuteCommand;
import org.netbeans.modules.vcscore.cmdline.UserCommand;
import org.netbeans.modules.vcscore.cmdline.UserCommandSupport;
import org.netbeans.modules.vcscore.commands.CommandExecutorSupport;
import org.netbeans.modules.vcscore.commands.CommandOutputCollector;
import org.netbeans.modules.vcscore.commands.CommandOutputVisualizer;
import org.netbeans.modules.vcscore.commands.CommandTaskInfo;
import org.netbeans.modules.vcscore.commands.ProvidedCommand;
import org.netbeans.modules.vcscore.commands.RegexOutputListener;
import org.netbeans.modules.vcscore.commands.TextOutputListener;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.commands.VcsCommandIO;
import org.netbeans.modules.vcscore.commands.VcsCommandVisualizer;
import org.netbeans.modules.vcscore.commands.VcsDescribedCommand;
import org.netbeans.modules.vcscore.commands.VcsDescribedTask;
import org.netbeans.modules.vcscore.runtime.RuntimeCommand;
import org.netbeans.modules.vcscore.runtime.RuntimeCommandTask;
import org.netbeans.modules.vcscore.runtime.VcsRuntimeCommand;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.netbeans.spi.vcs.VcsCommandsProvider;
import org.netbeans.spi.vcs.commands.CommandTaskSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class UserCommandTask
extends CommandTaskSupport
implements VcsDescribedTask,
RuntimeCommandTask,
ProvidedCommand {
    private UserCommandSupport cmdSupport;
    private VcsDescribedCommand cmd;
    private VcsCommandExecutor executor;
    private CommandOutputCollector outputCollector;
    private VcsRuntimeCommand runtimeCommand;
    private VcsCommandVisualizer visualizer;
    private File spawnRefreshFile;
    private boolean spawnRefreshRecursively;
    private static Set runningTasks = new HashSet();
    private static List pendingTasks = new LinkedList();
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$cmdline$UserCommandTask;

    public UserCommandTask(UserCommandSupport cmdSupport, VcsDescribedCommand cmd) {
        super(cmdSupport, cmd);
        this.cmdSupport = cmdSupport;
        this.cmd = cmd;
        this.executor = cmd.getExecutor();
        if (this.executor == null) {
            this.executor = this.createExecutor();
        }
        if (this.executor instanceof ExecuteCommand) {
            ((ExecuteCommand)this.executor).setTask(this);
        }
        this.outputCollector = new CommandOutputCollector(this, cmdSupport.getVcsFileSystem().getCommandsProvider());
    }

    private VcsCommandExecutor createExecutor() {
        VcsFileSystem fileSystem = this.cmdSupport.getFileSystem();
        Hashtable vars = fileSystem.getVariablesAsHashtable();
        Map additionalVariables = this.cmd.getAdditionalVariables();
        if (additionalVariables != null) {
            vars.putAll(additionalVariables);
        }
        UserCommand uCmd = (UserCommand)this.cmd.getVcsCommand();
        VcsCommandExecutor vce = "LIST".equals(this.cmd.getName()) || "LIST_OFFLINE".equals(this.cmd.getName()) ? this.createRefresh(fileSystem, vars, uCmd) : ("LIST_SUB".equals(this.cmd.getName()) || "LIST_SUB_OFFLINE".equals(this.cmd.getName()) ? this.createRecursiveRefresh(fileSystem, vars, uCmd) : new ExecuteCommand(fileSystem, uCmd, vars, this.cmd.getPreferredExec()));
        return vce;
    }

    private String getRefreshPath(VcsFileSystem fileSystem, Hashtable vars) {
        String path = null;
        FileObject[] fos = this.cmd.getFiles();
        if (fos != null && fos.length > 0) {
            path = fos[0].getPackageName('/');
        } else {
            String root;
            File[] diskFiles = this.cmd.getDiskFiles();
            if (diskFiles != null && diskFiles.length > 0 && (path = diskFiles[0].getAbsolutePath()).indexOf(root = fileSystem.getFile("").getAbsolutePath()) == 0) {
                path = path.substring(root.length());
                while (path.startsWith(File.separator)) {
                    path = path.substring(1);
                }
            }
        }
        return path;
    }

    private File getRefreshDir(VcsFileSystem fileSystem, Hashtable vars) {
        File dir = null;
        FileObject[] fos = this.cmd.getFiles();
        boolean isDir = true;
        if (fos != null && fos.length > 0) {
            dir = FileUtil.toFile((FileObject)fos[0]);
            isDir = fos[0].isFolder();
        } else {
            File[] diskFiles = this.cmd.getDiskFiles();
            if (diskFiles != null && diskFiles.length > 0) {
                dir = diskFiles[0];
                isDir = dir.isDirectory();
            }
        }
        if (dir != null && !isDir) {
            dir = dir.getParentFile();
        }
        return dir;
    }

    private VcsCommandExecutor createRefresh(VcsFileSystem fileSystem, Hashtable vars, UserCommand uCmd) {
        DirReaderListener dirListener = this.cmdSupport.getAttachedDirReaderListener(this.cmd);
        if (dirListener != null) {
            String file = (String)vars.get("FILE");
            String dir = (String)vars.get("DIR");
            dir = dir.length() > 0 ? dir + Variables.expand(vars, "${PS}", false) + file : file;
            vars.put("FILE", "");
            vars.put("DIR", dir);
            this.cmd.setAdditionalVariables(vars);
            return new CommandLineVcsDirReader(dirListener, fileSystem, uCmd, vars);
        }
        this.spawnRefreshFile = new File(this.getRefreshDir(fileSystem, vars), "test");
        this.spawnRefreshRecursively = false;
        return null;
    }

    private VcsCommandExecutor createRecursiveRefresh(VcsFileSystem fileSystem, Hashtable vars, UserCommand uCmd) {
        DirReaderListener dirListener = this.cmdSupport.getAttachedDirReaderListener(this.cmd);
        if (dirListener != null) {
            String file = (String)vars.get("FILE");
            String dir = (String)vars.get("DIR");
            dir = dir.length() > 0 ? dir + Variables.expand(vars, "${PS}", false) + file : file;
            vars.put("FILE", "");
            vars.put("DIR", dir);
            this.cmd.setAdditionalVariables(vars);
            return new CommandLineVcsDirReaderRecursive(dirListener, fileSystem, uCmd, vars);
        }
        this.spawnRefreshFile = new File(this.getRefreshDir(fileSystem, vars), "test");
        this.spawnRefreshRecursively = true;
        return null;
    }

    boolean willSpawnRefresh() {
        return this.spawnRefreshFile != null;
    }

    void spawnRefresh() {
        FileSystemCache cache = CacheHandler.getInstance().getCache(this.cmdSupport.getFileSystem().getCacheIdStr());
        Object locker = new Object();
        cache.getCacheFile(this.spawnRefreshFile, this.spawnRefreshRecursively ? 12 : 11, locker);
        Object var2_2 = null;
    }

    public String getDisplayName() {
        if (this.willSpawnRefresh()) {
            return null;
        }
        return super.getDisplayName();
    }

    public VcsCommandExecutor getExecutor() {
        return this.executor;
    }

    public Map getVariables() {
        return this.executor.getVariables();
    }

    public VcsCommand getVcsCommand() {
        return this.executor.getCommand();
    }

    public synchronized RuntimeCommand getRuntimeCommand(CommandTaskInfo info) {
        if (this.willSpawnRefresh()) {
            return null;
        }
        if (this.runtimeCommand == null) {
            this.runtimeCommand = new VcsRuntimeCommand(info);
        }
        return this.runtimeCommand;
    }

    private VcsCommandVisualizer createVisualizer() {
        final CommandOutputVisualizer outputVisualizer = new CommandOutputVisualizer(this);
        this.outputCollector.addTextOutputListener(new TextOutputListener(){

            public void outputLine(String line) {
                outputVisualizer.stdOutputLine(line);
            }
        });
        this.outputCollector.addTextErrorListener(new TextOutputListener(){

            public void outputLine(String line) {
                outputVisualizer.errOutputLine(line);
            }
        });
        this.outputCollector.addRegexOutputListener(new RegexOutputListener(){

            public void outputMatchedGroups(String[] data) {
                outputVisualizer.stdOutputData(data);
            }
        });
        this.outputCollector.addRegexErrorListener(new RegexOutputListener(){

            public void outputMatchedGroups(String[] data) {
                outputVisualizer.errOutputData(data);
            }
        });
        return outputVisualizer;
    }

    public VcsCommandVisualizer getVisualizer() {
        return this.getVisualizer(true);
    }

    synchronized VcsCommandVisualizer getVisualizer(boolean showPlainOutput) {
        if (this.visualizer == null) {
            this.visualizer = this.executor.getVisualizer();
            if (this.visualizer == null && showPlainOutput) {
                this.visualizer = this.createVisualizer();
            }
        }
        if (this.isFinished()) {
            this.visualizer.setExitStatus(this.executor.getExitStatus());
        }
        return this.visualizer;
    }

    protected boolean canExecute() {
        if (this.willSpawnRefresh()) {
            return true;
        }
        return this.canRun(this);
    }

    protected int execute() {
        Set set;
        int status = 0;
        try {
            status = super.execute();
            Object var3_2 = null;
            set = runningTasks;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Set set2 = runningTasks;
            synchronized (set2) {
                runningTasks.remove(this);
            }
            if (this.visualizer != null) {
                this.visualizer.setExitStatus(this.executor.getExitStatus());
            }
            throw throwable;
        }
        synchronized (set) {
            runningTasks.remove(this);
        }
        if (this.visualizer != null) {
            this.visualizer.setExitStatus(this.executor.getExitStatus());
        }
        if (this.executor != null) {
            this.doPostprocessing();
        }
        return status;
    }

    private void doPostprocessing() {
        VcsCommand cmd = this.executor.getCommand();
        VcsFileSystem fileSystem = this.cmdSupport.getFileSystem();
        String message = null;
        String name = cmd.getDisplayName();
        if (name != null) {
            int i = name.indexOf(38);
            if (i >= 0) {
                name = name.substring(0, i) + name.substring(i + 1);
            }
            switch (this.executor.getExitStatus()) {
                case 0: {
                    message = UserCommandTask.g("MSG_Command_name_finished", name);
                    break;
                }
                case 1: {
                    if (VcsCommandIO.getBooleanPropertyAssumeDefault(this.executor.getCommand(), "ignoreFail")) {
                        message = UserCommandTask.g("MSG_Command_name_finished", name);
                        break;
                    }
                    message = UserCommandTask.g("MSG_Command_name_failed", name);
                    break;
                }
                case 2: {
                    message = UserCommandTask.g("MSG_Command_name_interrupted", name);
                }
            }
        }
        String notification = null;
        if (this.executor.getExitStatus() != 0 && !VcsCommandIO.getBooleanPropertyAssumeDefault(cmd, "ignoreFail")) {
            if (message != null) {
                fileSystem.debugErr(message);
                this.printErrorOutput(fileSystem);
            }
            if (fileSystem.isCommandNotification()) {
                notification = (String)cmd.getProperty("notificationFailMsg");
            }
        } else {
            if (message != null && fileSystem != null) {
                fileSystem.debug(message);
            }
            if (fileSystem.isCommandNotification()) {
                notification = (String)cmd.getProperty("notificationSuccessMsg");
            }
        }
        if (notification != null) {
            CommandExecutorSupport.commandNotification(this.executor, notification, fileSystem);
        }
        CommandExecutorSupport.postprocessCommand(fileSystem, this.executor);
    }

    private void printErrorOutput(final VcsFileSystem fileSystem) {
        if (fileSystem == null) {
            return;
        }
        fileSystem.debugErr(UserCommandTask.g("MSG_Check_whole_output"));
        final boolean[] isErrorOutput = new boolean[]{false};
        this.outputCollector.addTextErrorListener(new TextOutputListener(){

            public void outputLine(String line) {
                isErrorOutput[0] = true;
                fileSystem.debugErr(line);
            }
        });
        if (!isErrorOutput[0]) {
            fileSystem.debugErr(UserCommandTask.g("MSG_No_error_output"));
        }
    }

    public VcsCommandsProvider getProvider() {
        return this.cmdSupport.getVcsFileSystem().getCommandsProvider();
    }

    public void setProvider(VcsCommandsProvider provider) {
        throw new IllegalStateException("setProvider() method should not be called.");
    }

    private static boolean areFilesInSamePackage(Collection files1, Collection files2) {
        Iterator it1 = files1.iterator();
        while (it1.hasNext()) {
            String file1 = (String)it1.next();
            String dir1 = VcsUtilities.getDirNamePart(file1);
            Iterator it2 = files2.iterator();
            while (it2.hasNext()) {
                String file2 = (String)it2.next();
                String dir2 = VcsUtilities.getDirNamePart(file2);
                if (!dir1.equals(dir2)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isParentFolder(Collection files1, Collection files2) {
        Iterator it1 = files1.iterator();
        while (it1.hasNext()) {
            String file1 = (String)it1.next();
            Iterator it2 = files2.iterator();
            while (it2.hasNext()) {
                String file2 = (String)it2.next();
                if (!file1.startsWith(file2)) continue;
                return true;
            }
        }
        return false;
    }

    private HashMap createConcurrencyMap(String concurrencyWith) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (concurrencyWith != null) {
            String[] items = VcsUtilities.getQuotedStrings(concurrencyWith);
            int i = 0;
            while (i < items.length) {
                block5: {
                    int index = items[i].lastIndexOf(32);
                    if (index >= 0) {
                        int conc;
                        String cmdName = items[i].substring(0, index);
                        String concStr = items[i].substring(index + 1);
                        try {
                            conc = Integer.parseInt(concStr);
                        }
                        catch (NumberFormatException nfexc) {
                            break block5;
                        }
                        map.put(cmdName, new Integer(conc));
                    }
                }
                ++i;
            }
        }
        return map;
    }

    private boolean canRun(UserCommandTask task) {
        if (!pendingTasks.contains(task)) {
            pendingTasks.add(task);
        }
        VcsCommandExecutor vce = task.getExecutor();
        VcsCommand cmd = vce.getCommand();
        Collection files = vce.getFiles();
        int concurrency = VcsCommandIO.getIntegerPropertyAssumeZero(cmd, "concurrentExec");
        String concurrencyWith = (String)cmd.getProperty("concurrentExecWith");
        boolean haveToWait = false;
        if (concurrency != -1) {
            HashSet<UserCommandTask> tasksToTest;
            HashMap concurrencyMap = this.createConcurrencyMap(concurrencyWith);
            String name = cmd.getName();
            boolean serialOnFile = (concurrency & 1) != 0;
            boolean serialOnPackage = (concurrency & 2) != 0;
            boolean serialWithParent = (concurrency & 4) != 0;
            boolean serialOfCommand = (concurrency & 8) != 0;
            boolean serialOfAll = (concurrency & 0x10) != 0;
            Set set = runningTasks;
            synchronized (set) {
                tasksToTest = new HashSet<UserCommandTask>(runningTasks);
            }
            if ((concurrency & 0x20) != 0) {
                Iterator pendingIt = pendingTasks.iterator();
                while (pendingIt.hasNext()) {
                    UserCommandTask pendingTask = (UserCommandTask)pendingIt.next();
                    if (pendingTask == task) break;
                    tasksToTest.add(pendingTask);
                }
            }
            Iterator iter = tasksToTest.iterator();
            while (iter.hasNext()) {
                UserCommandTask cwTest = (UserCommandTask)iter.next();
                VcsCommandExecutor ec = cwTest.getExecutor();
                Collection cmdFiles = ec.getFiles();
                VcsCommand uc = ec.getCommand();
                int cmdConcurrency = VcsCommandIO.getIntegerPropertyAssumeZero(uc, "concurrentExec");
                if (-1 == cmdConcurrency) continue;
                if (serialOfAll) {
                    haveToWait = true;
                    break;
                }
                String cmdName = uc.getName();
                haveToWait = UserCommandTask.matchSerial(name, cmdName, files, cmdFiles, serialOnFile, serialOnPackage, serialWithParent, serialOfCommand);
                if (!haveToWait) {
                    if ((cmdConcurrency & 0x10) != 0) {
                        haveToWait = true;
                        break;
                    }
                    haveToWait = UserCommandTask.matchSerial(cmdName, name, cmdFiles, files, (cmdConcurrency & 1) != 0, (cmdConcurrency & 2) != 0, (cmdConcurrency & 4) != 0, (cmdConcurrency & 8) != 0);
                }
                if (haveToWait) break;
                Integer concurrencyWithNum = (Integer)concurrencyMap.get(cmdName);
                if (concurrencyWithNum == null || !UserCommandTask.haveToWaitFor(files, cmdFiles, concurrencyWithNum)) continue;
                haveToWait = true;
                break;
            }
        }
        if (!haveToWait) {
            Set set = runningTasks;
            synchronized (set) {
                runningTasks.add(task);
            }
            pendingTasks.remove(task);
        }
        return !haveToWait;
    }

    private static boolean matchSerial(String name, String name2, Collection files, Collection files2, boolean serialOnFile, boolean serialOnPackage, boolean serialWithParent, boolean serialOfCommand) {
        boolean matchOnFile = false;
        boolean matchOnPackage = false;
        boolean matchWithParent = false;
        boolean matchOfCommand = false;
        if (serialOnFile) {
            Iterator it = files.iterator();
            while (it.hasNext()) {
                String file = (String)it.next();
                if (!files2.contains(file)) continue;
                matchOnFile = true;
                break;
            }
        }
        if (serialOnPackage && UserCommandTask.areFilesInSamePackage(files, files2)) {
            matchOnPackage = true;
        }
        if (serialWithParent && UserCommandTask.isParentFolder(files, files2)) {
            matchWithParent = true;
        }
        if (serialOfCommand) {
            matchOfCommand = name.equals(name2);
        }
        return !(serialOfCommand && !matchOfCommand || !matchOnFile && !matchOnPackage && !matchWithParent && !matchOfCommand);
    }

    private static boolean haveToWaitFor(Collection files, Collection cmdFiles, int concurrency) {
        boolean serialWithParent;
        boolean serialOnFile = (concurrency & 1) != 0;
        boolean serialOnPackage = (concurrency & 2) != 0;
        boolean bl = serialWithParent = (concurrency & 4) != 0;
        if (serialOnFile) {
            Iterator it = files.iterator();
            while (it.hasNext()) {
                String file = (String)it.next();
                if (!cmdFiles.contains(file)) continue;
                return true;
            }
        }
        if (serialOnPackage && UserCommandTask.areFilesInSamePackage(files, cmdFiles)) {
            return true;
        }
        return serialWithParent && UserCommandTask.isParentFolder(files, cmdFiles);
    }

    private static String g(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$UserCommandTask == null ? (class$org$netbeans$modules$vcscore$cmdline$UserCommandTask = UserCommandTask.class$("org.netbeans.modules.vcscore.cmdline.UserCommandTask")) : class$org$netbeans$modules$vcscore$cmdline$UserCommandTask), (String)s);
    }

    private static String g(String s, Object obj) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$UserCommandTask == null ? (class$org$netbeans$modules$vcscore$cmdline$UserCommandTask = UserCommandTask.class$("org.netbeans.modules.vcscore.cmdline.UserCommandTask")) : class$org$netbeans$modules$vcscore$cmdline$UserCommandTask), (String)s, (Object)obj);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

