/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cmdline.exec;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.netbeans.modules.vcscore.cmdline.exec.BadRegexException;
import org.netbeans.modules.vcscore.cmdline.exec.SafeRunnable;
import org.netbeans.modules.vcscore.cmdline.exec.WatchDog;
import org.netbeans.modules.vcscore.commands.RegexOutputListener;
import org.netbeans.modules.vcscore.commands.TextOutputListener;
import org.netbeans.modules.vcscore.util.Debug;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ExternalCommand {
    private Debug E = new Debug("ExternalCommand", true);
    private Debug D = new Debug("ExternalCommand", true);
    private String command = null;
    private int exitStatus = 0;
    private String inputData = null;
    private int osType = Utilities.getOperatingSystem();
    private Object stdOutDataLock = new Object();
    private ArrayList stdOutDataListeners = new ArrayList();
    private ArrayList stdOutRegexps = new ArrayList();
    private Object stdErrDataLock = new Object();
    private ArrayList stdErrDataListeners = new ArrayList();
    private ArrayList stdErrRegexps = new ArrayList();
    private Object stdOutLock = new Object();
    private Object stdErrLock = new Object();
    private ArrayList stdOutListeners = new ArrayList();
    private ArrayList stdErrListeners = new ArrayList();
    private String[] envp = null;
    private static ArrayList outputGrabbers = new ArrayList();
    private static RequestProcessor outputRequestProcessor;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand;

    public ExternalCommand() {
    }

    public ExternalCommand(String command) {
        this.setCommand(command);
    }

    public ExternalCommand(String command, String input) {
        this.setCommand(command);
        this.setInput(input);
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setInput(String inputData) {
        this.inputData = inputData;
    }

    public void setEnv(String[] envp) {
        this.envp = envp;
    }

    private void setExitStatus(int exitStatus) {
        this.exitStatus = exitStatus;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String[] parseParameters(String s) {
        int NULL = 0;
        int INPARAM = 1;
        int INPARAMPENDING = 2;
        int STICK = 4;
        int STICKPENDING = 8;
        Vector<String> params = new Vector<String>(5, 5);
        int state = NULL;
        StringBuffer buff = new StringBuffer(20);
        int slength = s.length();
        int i = 0;
        while (i < slength) {
            block24: {
                char c;
                block33: {
                    block35: {
                        block34: {
                            block28: {
                                block32: {
                                    block31: {
                                        block29: {
                                            block30: {
                                                block25: {
                                                    block27: {
                                                        block26: {
                                                            c = s.charAt(i);
                                                            if (!Character.isWhitespace(c)) break block25;
                                                            if (state != NULL) break block26;
                                                            params.addElement(buff.toString());
                                                            buff.setLength(0);
                                                            break block24;
                                                        }
                                                        if (state != STICK) break block27;
                                                        params.addElement(buff.toString());
                                                        buff.setLength(0);
                                                        state = NULL;
                                                        break block24;
                                                    }
                                                    if (state == STICKPENDING) {
                                                        buff.append('\\');
                                                        params.addElement(buff.toString());
                                                        buff.setLength(0);
                                                        state = NULL;
                                                        break block24;
                                                    } else if (state == INPARAMPENDING) {
                                                        state = INPARAM;
                                                        buff.append('\\');
                                                        buff.append(c);
                                                        break block24;
                                                    } else {
                                                        buff.append(c);
                                                    }
                                                    break block24;
                                                }
                                                if (c != '\\') break block28;
                                                if (state != NULL) break block29;
                                                if (++i >= slength) break block30;
                                                char cc = s.charAt(i);
                                                if (cc == '\"' || cc == '\\') {
                                                    buff.append(cc);
                                                    break block24;
                                                } else if (Character.isWhitespace(cc)) {
                                                    buff.append(c);
                                                    --i;
                                                    break block24;
                                                } else {
                                                    buff.append(c);
                                                    buff.append(cc);
                                                }
                                                break block24;
                                            }
                                            buff.append('\\');
                                            break;
                                        }
                                        if (state != INPARAM) break block31;
                                        state = INPARAMPENDING;
                                        break block24;
                                    }
                                    if (state != INPARAMPENDING) break block32;
                                    buff.append('\\');
                                    state = INPARAM;
                                    break block24;
                                }
                                if (state == STICK) {
                                    state = STICKPENDING;
                                    break block24;
                                } else if (state == STICKPENDING) {
                                    buff.append('\\');
                                    state = STICK;
                                }
                                break block24;
                            }
                            if (c != '\"') break block33;
                            if (state != NULL) break block34;
                            state = INPARAM;
                            break block24;
                        }
                        if (state != INPARAM) break block35;
                        state = STICK;
                        break block24;
                    }
                    if (state == STICK) {
                        state = INPARAM;
                        break block24;
                    } else if (state == STICKPENDING) {
                        buff.append('\"');
                        state = STICK;
                        break block24;
                    } else {
                        buff.append('\"');
                        state = INPARAM;
                    }
                    break block24;
                }
                if (state == INPARAMPENDING) {
                    buff.append('\\');
                    state = INPARAM;
                } else if (state == STICKPENDING) {
                    buff.append('\\');
                    state = STICK;
                }
                buff.append(c);
            }
            ++i;
        }
        if (state == INPARAM) {
            params.addElement(buff.toString());
        } else if ((state & (INPARAMPENDING | STICKPENDING)) != 0) {
            buff.append('\\');
            params.addElement(buff.toString());
        } else if (buff.length() != 0) {
            params.addElement(buff.toString());
        }
        Object[] ret = new String[params.size()];
        params.copyInto(ret);
        return ret;
    }

    /*
     * Loose catch block
     */
    public int exec() {
        block32: {
            boolean finished2222;
            Process proc = null;
            OutputGrabber output = null;
            WatchDog watchDog = null;
            ArrayList arrayList = outputGrabbers;
            synchronized (arrayList) {
                if (outputRequestProcessor == null) {
                    outputRequestProcessor = new RequestProcessor("External Command Output Grabber Processor");
                    outputRequestProcessor.post((Runnable)new OutputGrabbersProcessor());
                }
            }
            try {
                String[] commandArr = this.parseParameters(this.command);
                this.D.deb("commandArr=" + VcsUtilities.arrayToString(commandArr));
                try {
                    proc = this.envp == null ? Runtime.getRuntime().exec(commandArr) : Runtime.getRuntime().exec(commandArr, this.envp);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)e, this.g("EXT_CMD_RuntimeExc", VcsUtilities.array2string(commandArr))));
                    this.stderrNextLine(this.g("EXT_CMD_RuntimeFailed", this.command));
                    this.setExitStatus(1);
                    int n = this.getExitStatus();
                    Object var10_13 = null;
                    this.D.deb("Processing command output");
                    this.D.deb("watchDog.cancel()");
                    if (watchDog != null) {
                        watchDog.cancel();
                    }
                    if (output != null) {
                        output.doStop();
                        boolean finished2222 = false;
                        do {
                            try {
                                output.waitToFinish();
                                finished2222 = true;
                            }
                            catch (InterruptedException iexc) {
                                output.doReallyStop();
                            }
                        } while (!finished2222);
                    }
                    return n;
                }
                if (this.inputData != null) {
                    try {
                        OutputStreamWriter os = new OutputStreamWriter(proc.getOutputStream());
                        os.write(this.inputData);
                        os.flush();
                        os.close();
                    }
                    catch (IOException e) {
                        this.E.err(e, "writeBytes(" + this.inputData + ") failed");
                    }
                }
                output = new OutputGrabber(proc.getInputStream(), proc.getErrorStream());
                ArrayList e = outputGrabbers;
                synchronized (e) {
                    outputGrabbers.add(output);
                    outputGrabbers.notifyAll();
                }
                int exit = proc.waitFor();
                this.setExitStatus(exit == 0 ? 0 : 1);
                Object var10_14 = null;
                this.D.deb("Processing command output");
                this.D.deb("watchDog.cancel()");
                if (watchDog != null) {
                    watchDog.cancel();
                }
                if (output == null) break block32;
                output.doStop();
                finished2222 = false;
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                this.D.deb("Processing command output");
                this.D.deb("watchDog.cancel()");
                if (watchDog != null) {
                    watchDog.cancel();
                }
                if (output != null) {
                    output.doStop();
                    boolean finished2222 = false;
                    do {
                        try {
                            output.waitToFinish();
                            finished2222 = true;
                        }
                        catch (InterruptedException iexc) {
                            output.doReallyStop();
                        }
                    } while (!finished2222);
                }
                throw throwable;
            }
            do {
                try {
                    output.waitToFinish();
                    finished2222 = true;
                }
                catch (InterruptedException iexc) {
                    output.doReallyStop();
                }
            } while (!finished2222);
            {
                break block32;
                catch (InterruptedException e) {
                    this.D.deb("Ring from the WatchDog.");
                    String[] commandArr = this.parseParameters(this.command);
                    this.D.deb("commandArr=" + VcsUtilities.arrayToString(commandArr));
                    proc.destroy();
                    this.setExitStatus(2);
                    Object var10_15 = null;
                    this.D.deb("Processing command output");
                    this.D.deb("watchDog.cancel()");
                    if (watchDog != null) {
                        watchDog.cancel();
                    }
                    if (output != null) {
                        output.doStop();
                        finished2222 = false;
                        do {
                            try {
                                output.waitToFinish();
                                finished2222 = true;
                            }
                            catch (InterruptedException iexc) {
                                output.doReallyStop();
                            }
                        } while (!finished2222);
                    }
                }
            }
        }
        this.D.deb("exec() -> " + this.getExitStatus());
        return this.getExitStatus();
    }

    public String toString() {
        return this.command;
    }

    public void addRegexOutputListener(RegexOutputListener l, String regex) throws BadRegexException {
        Object object = this.stdOutDataLock;
        synchronized (object) {
            if (this.stdOutDataListeners.contains(l)) {
                return;
            }
            RE pattern = null;
            try {
                pattern = new RE(regex);
            }
            catch (RESyntaxException e) {
                throw new BadRegexException("Bad regexp.", e);
            }
            this.stdOutDataListeners.add(l);
            this.stdOutRegexps.add(pattern);
        }
    }

    public void addRegexErrorListener(RegexOutputListener l, String regex) throws BadRegexException {
        Object object = this.stdErrDataLock;
        synchronized (object) {
            if (this.stdErrDataListeners.contains(l)) {
                return;
            }
            RE pattern = null;
            try {
                pattern = new RE(regex);
            }
            catch (RESyntaxException e) {
                throw new BadRegexException("Bad regexp.", e);
            }
            this.stdErrDataListeners.add(l);
            this.stdErrRegexps.add(pattern);
        }
    }

    public void addTextOutputListener(TextOutputListener l) {
        Object object = this.stdOutLock;
        synchronized (object) {
            this.stdOutListeners.add(l);
        }
    }

    public void addTextErrorListener(TextOutputListener l) {
        Object object = this.stdErrLock;
        synchronized (object) {
            this.stdErrListeners.add(l);
        }
    }

    public void removeRegexOutputListener(RegexOutputListener l) {
        Object object = this.stdOutDataLock;
        synchronized (object) {
            int index = this.stdOutDataListeners.indexOf(l);
            if (index < 0) {
                return;
            }
            this.stdOutDataListeners.remove(index);
            this.stdOutRegexps.remove(index);
        }
    }

    public void removeRegexErrorListener(RegexOutputListener l) {
        Object object = this.stdErrDataLock;
        synchronized (object) {
            int index = this.stdErrDataListeners.indexOf(l);
            if (index < 0) {
                return;
            }
            this.stdErrDataListeners.remove(index);
            this.stdErrRegexps.remove(index);
        }
    }

    public static String[] matchToStringArray(RE pattern, String line) {
        Vector<String> v = new Vector<String>(5);
        if (!pattern.match(line)) {
            return new String[0];
        }
        int i = 1;
        while (i < pattern.getParenCount()) {
            int subStart = pattern.getParenStart(i);
            int subEnd = pattern.getParenEnd(i);
            if (subStart >= 0 && subEnd > subStart) {
                v.addElement(line.substring(subStart, subEnd));
            }
            ++i;
        }
        int count = v.size();
        if (count <= 0) {
            count = 1;
        }
        String[] sa = new String[count];
        v.toArray(sa);
        return sa;
    }

    private void stdoutNextLine(String line) {
        Object object = this.stdOutDataLock;
        synchronized (object) {
            int n = this.stdOutDataListeners.size();
            int i = 0;
            while (i < n) {
                RE pattern = (RE)this.stdOutRegexps.get(i);
                String[] sa = ExternalCommand.matchToStringArray(pattern, line);
                if (sa != null && sa.length > 0) {
                    ((RegexOutputListener)this.stdOutDataListeners.get(i)).outputMatchedGroups(sa);
                }
                ++i;
            }
        }
        Object object2 = this.stdOutLock;
        synchronized (object2) {
            Iterator it = ((AbstractList)this.stdOutListeners).iterator();
            while (it.hasNext()) {
                ((TextOutputListener)it.next()).outputLine(line);
            }
        }
    }

    private void stderrNextLine(String line) {
        Object object = this.stdErrDataLock;
        synchronized (object) {
            int n = this.stdErrDataListeners.size();
            int i = 0;
            while (i < n) {
                RE pattern = (RE)this.stdErrRegexps.get(i);
                String[] sa = ExternalCommand.matchToStringArray(pattern, line);
                if (sa != null && sa.length > 0) {
                    ((RegexOutputListener)this.stdErrDataListeners.get(i)).outputMatchedGroups(sa);
                }
                ++i;
            }
        }
        Object object2 = this.stdErrLock;
        synchronized (object2) {
            Iterator it = ((AbstractList)this.stdErrListeners).iterator();
            while (it.hasNext()) {
                ((TextOutputListener)it.next()).outputLine(line);
            }
        }
    }

    String g(String s) {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand == null ? (class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand = ExternalCommand.class$("org.netbeans.modules.vcscore.cmdline.exec.ExternalCommand")) : class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand)).getString(s);
    }

    String g(String s, Object obj) {
        return MessageFormat.format(this.g(s), obj);
    }

    String g(String s, Object obj1, Object obj2) {
        return MessageFormat.format(this.g(s), obj1, obj2);
    }

    String g(String s, Object obj1, Object obj2, Object obj3) {
        return MessageFormat.format(this.g(s), obj1, obj2, obj3);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class OutputGrabbersProcessor
    implements Runnable {
        private OutputGrabbersProcessor() {
        }

        public void run() {
            while (true) {
                try {
                    ArrayList arrayList = outputGrabbers;
                    synchronized (arrayList) {
                        while (outputGrabbers.size() == 0) {
                            outputGrabbers.wait();
                        }
                    }
                    boolean processed = false;
                    int n = outputGrabbers.size();
                    int i = 0;
                    while (i < n) {
                        OutputGrabber output = (OutputGrabber)outputGrabbers.get(i);
                        if (!output.isStopped()) {
                            if (output.hasOutput()) {
                                output.run();
                                processed = true;
                            }
                        } else {
                            output.flush();
                            outputGrabbers.remove(i);
                            --i;
                            --n;
                        }
                        ++i;
                    }
                    if (processed) continue;
                    Thread.currentThread();
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException iexc) {
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    ErrorManager.getDefault().notify(t);
                    continue;
                }
                break;
            }
        }
    }

    private class OutputGrabber
    implements SafeRunnable {
        private static final int LINE_LENGTH = 80;
        private static final int BUFF_LENGTH = 512;
        private InputStreamReader stdout;
        private InputStreamReader stderr;
        private boolean eof_stdout = false;
        private boolean eof_stderr = false;
        private boolean shouldStop = false;
        private boolean stopped = false;
        private boolean finished = false;
        private StringBuffer outBuffer = new StringBuffer(80);
        private StringBuffer errBuffer = new StringBuffer(80);
        private char[] buff = new char[512];

        public OutputGrabber(InputStream stdout, InputStream stderr) {
            this.stdout = new InputStreamReader(stdout);
            this.stderr = new InputStreamReader(stderr);
        }

        public void doStop() {
            this.shouldStop = true;
        }

        public void doReallyStop() {
            try {
                this.stdout.close();
                this.stderr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public boolean isStopped() {
            try {
                if (ExternalCommand.this.osType != 8192 && ExternalCommand.this.osType != 1024) {
                    if (this.shouldStop && !this.stdout.ready() && !this.stderr.ready()) {
                        this.stopped = true;
                    }
                } else {
                    this.stopped = this.shouldStop && this.eof_stdout && this.eof_stderr;
                }
            }
            catch (IOException ioexc) {
                this.stopped = true;
            }
            return this.stopped;
        }

        public void waitToFinish() throws InterruptedException {
            OutputGrabber outputGrabber = this;
            synchronized (outputGrabber) {
                while (!this.finished) {
                    this.wait();
                }
            }
        }

        public boolean hasOutput() {
            boolean has;
            try {
                has = ExternalCommand.this.osType != 8192 && ExternalCommand.this.osType != 1024 ? this.stdout.ready() || this.stderr.ready() : true;
            }
            catch (IOException ioexc) {
                has = false;
            }
            return has;
        }

        public void run() {
            int n = 0;
            try {
                int i;
                if ((ExternalCommand.this.osType == 8192 || ExternalCommand.this.osType == 1024) && !this.eof_stdout || this.stdout.ready()) {
                    n = this.stdout.read(this.buff, 0, 512);
                }
                if (n > -1) {
                    i = 0;
                    while (i < n) {
                        if (this.buff[i] == '\n') {
                            ExternalCommand.this.stdoutNextLine(this.outBuffer.toString());
                            this.outBuffer.delete(0, this.outBuffer.length());
                        } else if (this.buff[i] != '\r') {
                            this.outBuffer.append(this.buff[i]);
                        }
                        ++i;
                    }
                } else {
                    this.stopped = true;
                    this.eof_stdout = true;
                }
                n = 0;
                if ((ExternalCommand.this.osType == 8192 || ExternalCommand.this.osType == 1024) && !this.eof_stderr || this.stderr.ready()) {
                    n = this.stderr.read(this.buff, 0, 512);
                }
                if (n > -1) {
                    i = 0;
                    while (i < n) {
                        if (this.buff[i] == '\n') {
                            ExternalCommand.this.stderrNextLine(this.errBuffer.toString());
                            this.errBuffer.delete(0, this.errBuffer.length());
                        } else if (this.buff[i] != '\r') {
                            this.errBuffer.append(this.buff[i]);
                        }
                        ++i;
                    }
                } else {
                    this.stopped = true;
                    this.eof_stderr = true;
                }
            }
            catch (IOException ioexc) {
                this.stopped = true;
            }
        }

        public void flush() {
            if (this.outBuffer.length() > 0) {
                ExternalCommand.this.stdoutNextLine(this.outBuffer.toString());
            }
            if (this.errBuffer.length() > 0) {
                ExternalCommand.this.stderrNextLine(this.errBuffer.toString());
            }
            try {
                this.stdout.close();
            }
            catch (IOException ioexc) {
                // empty catch block
            }
            try {
                this.stderr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.finished = true;
            OutputGrabber outputGrabber = this;
            synchronized (outputGrabber) {
                this.notifyAll();
            }
        }
    }
}

