/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.commands;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.vcscore.Variables;
import org.netbeans.modules.vcscore.VcsConfigVariable;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.caching.FileStatusProvider;
import org.netbeans.modules.vcscore.commands.PreCommandPerformer;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.commands.VcsCommandIO;
import org.netbeans.modules.vcscore.util.NotifyDescriptorInputPassword;
import org.netbeans.modules.vcscore.util.Table;
import org.netbeans.modules.vcscore.util.VariableInputComponent;
import org.netbeans.modules.vcscore.util.VariableInputDescriptor;
import org.netbeans.modules.vcscore.util.VariableInputDialog;
import org.netbeans.modules.vcscore.util.VariableInputFormatException;
import org.netbeans.modules.vcscore.util.VariableValueAdjustment;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.netbeans.modules.vcscore.versioning.RevisionEvent;
import org.netbeans.modules.vcscore.versioning.VersioningFileSystem;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.UserCancelException;

public class CommandCustomizationSupport {
    public static final String GLOBAL_INPUT_DESCRIPTOR = "GLOBAL_INPUT_DESCRIPTOR";
    public static final String GLOBAL_INPUT_EXPRESSION = "GLOBAL_INPUT_EXPRESSION";
    private static final String USER_GLOBAL_PARAM = "USER_GLOBAL_PARAM";
    private static final String USER_PARAM = "USER_PARAM";
    public static final String INPUT_DESCRIPTOR_PARSED = "_For_Internal_Use_Only__INPUT_DESCRIPTOR_PARSED";
    private static final String VAR_INPUT_MULTIPLE_FILES_TITLE_APPEND = " ...";
    private static final String VAR_INPUT_FILE_SEPARATOR = " - ";
    private static Map globalInputStrs = Collections.synchronizedMap(new WeakHashMap());
    private static Map globalInputDescrs = Collections.synchronizedMap(new WeakHashMap());
    private static final Object promptLock = new Object();
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$commands$CommandCustomizationSupport;

    private CommandCustomizationSupport() {
    }

    private static int numImportant(VcsFileSystem fileSystem, String paths, String ps) {
        if (paths == null) {
            return 0;
        }
        int num = 0;
        String delim = ps != null ? ps + ps : File.separator + File.separator;
        VariableValueAdjustment varValueAdjust = fileSystem.getVarValueAdjustment();
        int begin = 0;
        int end = paths.indexOf(delim);
        if (end < 0) {
            end = paths.length();
        }
        while (true) {
            String path = paths.substring(begin, end);
            if (fileSystem.isImportant(path = varValueAdjust.revertAdjustedVarValue(path))) {
                ++num;
            }
            if ((begin = end + delim.length()) > paths.length()) break;
            end = paths.indexOf(delim, begin);
            if (end >= 0) continue;
            end = paths.length();
        }
        return num;
    }

    public static void addImportantFiles(Collection fos, Table res, boolean all, VcsFileSystem fileSystem, boolean doNotTestFS) {
        Iterator it = fos.iterator();
        while (it.hasNext()) {
            Set[] scheduled;
            FileObject ff = (FileObject)it.next();
            try {
                if (ff.getFileSystem() instanceof VersioningFileSystem) {
                    res.put(ff.getPackageNameExt('/', '.'), ff);
                    continue;
                }
                if (!doNotTestFS && ff.getFileSystem() != fileSystem) {
                }
            }
            catch (FileStateInvalidException exc) {}
            continue;
            String fileName = ff.getPackageNameExt('/', '.');
            if (all || fileSystem.isImportant(fileName)) {
                res.put(fileName, ff);
            }
            if ((scheduled = (Set[])ff.getAttribute("VCS_SCHEDULED_FILES")) == null || scheduled[0] == null) continue;
            Iterator sit = scheduled[0].iterator();
            while (sit.hasNext()) {
                String name = (String)sit.next();
                res.put(name, (Object)null);
            }
        }
    }

    private static Table removeDisabled(FileStatusProvider statusProvider, Table files, VcsCommand cmd) {
        if (statusProvider == null) {
            return files;
        }
        String disabledStatus = (String)cmd.getProperty("disabledOnStatus");
        if (disabledStatus == null) {
            return files;
        }
        Table remaining = new Table();
        Enumeration enumeration = files.keys();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String status = statusProvider.getFileStatus(name);
            boolean disabled = VcsUtilities.isSetContainedInQuotedStrings(disabledStatus, Collections.singleton(status));
            if (disabled) continue;
            remaining.put(name, files.get(name));
        }
        return remaining;
    }

    public static FileObject[] getApplicableFiles(VcsFileSystem fileSystem, VcsCommand cmd, FileObject[] files) {
        Hashtable variables;
        String hiddenTestExpression;
        int i;
        boolean processAll = VcsCommandIO.getBooleanPropertyAssumeDefault(cmd, "processAllFiles") || fileSystem.isProcessUnimportantFiles();
        ArrayList<FileObject> fileObjects = new ArrayList<FileObject>();
        boolean isOnFiles = false;
        boolean isOnDirs = false;
        boolean isOnRoot = false;
        int i2 = 0;
        while (i2 < files.length) {
            fileObjects.add(files[i2]);
            if (files[i2].isFolder()) {
                isOnDirs = true;
            } else {
                isOnFiles = true;
            }
            if (files[i2].getPath().length() == 0) {
                isOnRoot = true;
            }
            ++i2;
        }
        if (isOnRoot) {
            isOnDirs = false;
        }
        if (isOnDirs && !VcsCommandIO.getBooleanPropertyAssumeDefault(cmd, "onDir")) {
            i = 0;
            while (i < files.length) {
                if (files[i].isFolder()) {
                    fileObjects.remove(files[i]);
                }
                ++i;
            }
        }
        if (isOnFiles && !VcsCommandIO.getBooleanPropertyAssumeDefault(cmd, "onFile")) {
            i = 0;
            while (i < files.length) {
                if (!files[i].isFolder()) {
                    fileObjects.remove(files[i]);
                }
                ++i;
            }
        }
        if (isOnRoot && !VcsCommandIO.getBooleanPropertyAssumeDefault(cmd, "onRoot")) {
            i = 0;
            while (i < files.length) {
                if (files[i].getPath().length() == 0) {
                    fileObjects.remove(files[i]);
                }
                ++i;
            }
        }
        if (fileObjects.size() > 0 && (hiddenTestExpression = (String)cmd.getProperty("hiddenTestExpression")) != null && Variables.expand(variables = fileSystem.getVariablesAsHashtable(), hiddenTestExpression, false).trim().length() > 0) {
            fileObjects.clear();
        }
        if (fileObjects.size() == 0) {
            return null;
        }
        Table filesTable = new Table();
        CommandCustomizationSupport.addImportantFiles(fileObjects, filesTable, processAll, fileSystem, false);
        filesTable = CommandCustomizationSupport.removeDisabled(fileSystem.getStatusProvider(), filesTable, cmd);
        if (filesTable.size() == 0) {
            return null;
        }
        FileObject[] applFiles = new FileObject[filesTable.size()];
        int i3 = 0;
        Iterator it = filesTable.keySet().iterator();
        while (it.hasNext()) {
            applFiles[i3++] = (FileObject)filesTable.get(it.next());
        }
        return applFiles;
    }

    private static String processConfirmation(String confirmation, Hashtable vars, VcsFileSystem fileSystem) throws UserCancelException {
        confirmation = Variables.expand(vars, confirmation, true);
        PreCommandPerformer cmdPerf = new PreCommandPerformer(fileSystem, vars);
        ArrayList confCommandsOutput = new ArrayList();
        confirmation = cmdPerf.process(confirmation, confCommandsOutput);
        vars.put("CONFIRMATION_MSG", confirmation);
        boolean confCommandsSuccess = true;
        if (confCommandsOutput.size() > 0) {
            Iterator it = ((AbstractList)confCommandsOutput).iterator();
            while (it.hasNext()) {
                boolean bl = confCommandsSuccess = confCommandsSuccess && (Boolean)it.next() != false;
            }
        }
        if (confCommandsSuccess) {
            vars.put("CONFIRMATION_SUCCESS", Boolean.TRUE.toString());
        } else {
            vars.remove("CONFIRMATION_SUCCESS");
        }
        return confirmation;
    }

    public static String preCustomize(VcsFileSystem fileSystem, VcsCommand cmd, Hashtable vars) {
        String exec;
        Object confObj = cmd.getProperty("confirmationMsg");
        String confirmation = confObj == null ? "" : (String)confObj;
        String fullName = (String)vars.get("PATH");
        String paths = (String)vars.get("PATHS");
        boolean confirmed = false;
        String pathSeparator = (String)vars.get("PS");
        pathSeparator = Variables.expand(vars, pathSeparator, false);
        if (fileSystem != null && (fullName == null || fileSystem.isImportant(fullName))) {
            vars.put("NUM_IMPORTANT_FILES", "" + CommandCustomizationSupport.numImportant(fileSystem, paths, pathSeparator));
            try {
                confirmation = CommandCustomizationSupport.processConfirmation(confirmation, vars, fileSystem);
            }
            catch (UserCancelException cancelExc) {
                return null;
            }
            confirmed = true;
        }
        if (confirmed && confirmation.length() > 0 && !NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)confirmation, 0)))) {
            return null;
        }
        if (fileSystem != null) {
            PreCommandPerformer cmdPerf = new PreCommandPerformer(fileSystem, vars);
            try {
                exec = cmdPerf.process((String)cmd.getProperty("exec"));
            }
            catch (UserCancelException cancelExc) {
                return null;
            }
        } else {
            exec = (String)cmd.getProperty("exec");
        }
        exec = CommandCustomizationSupport.insertGlobalOptions(exec, vars);
        return exec;
    }

    /*
     * WARNING - void declaration
     */
    private static String insertGlobalOptions(String exec, Hashtable vars) {
        String glInput;
        if (vars.get(GLOBAL_INPUT_DESCRIPTOR) != null && (glInput = (String)vars.get(GLOBAL_INPUT_EXPRESSION)) != null) {
            int index;
            String search = "${USER_GLOBAL_PARAM}";
            int pos = 0;
            while ((index = exec.indexOf(search, pos)) > 0) {
                void var5_5;
                exec = exec.substring(0, (int)var5_5) + glInput + exec.substring((int)(var5_5 + search.length()));
                pos = var5_5 + search.length();
            }
            Hashtable hashtable = vars;
            synchronized (hashtable) {
                vars.put(USER_GLOBAL_PARAM, glInput);
            }
        }
        return exec;
    }

    private static Component createNotificationDesign(String text, JCheckBox checkBox) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JLabel textLabel = new JLabel(text);
        textLabel.setForeground(Color.black);
        panel.add((Component)textLabel, "Center");
        if (checkBox != null) {
            panel.add((Component)checkBox, "South");
        }
        return panel;
    }

    public static void commandNotification(VcsCommandExecutor vce, String notification, final VcsFileSystem fileSystem) {
        final String notification1 = Variables.expand(vce.getVariables(), notification, false);
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)notification1);
                JCheckBox checkBox = fileSystem != null ? new JCheckBox(CommandCustomizationSupport.g("DLG_DoNotNotify")) : null;
                msg.setMessage((Object)CommandCustomizationSupport.createNotificationDesign(notification1, checkBox));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                if (checkBox != null && checkBox.isSelected()) {
                    fileSystem.setCommandNotification(false);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)CommandCustomizationSupport.g("DLG_CanBeEnabled")));
                }
            }
        });
    }

    private static Collection getAllFilesAssociatedWith(VcsFileSystem fileSystem, Collection fileNames) {
        HashSet files = new HashSet();
        Iterator filesIt = fileNames.iterator();
        while (filesIt.hasNext()) {
            String name = (String)filesIt.next();
            FileObject fo = fileSystem.findResource(name);
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                files.addAll(dobj.files());
            }
            catch (DataObjectNotFoundException donfexc) {
                // empty catch block
            }
        }
        return files;
    }

    private static void deleteUnimportantFiles(VcsFileSystem fileSystem, Collection processedFiles) {
        FileStatusProvider statusProvider = fileSystem.getStatusProvider();
        String localFileStatus = statusProvider != null ? statusProvider.getLocalFileStatus() : null;
        String ignoredFileStatus = "Ignored";
        Iterator filesIt = CommandCustomizationSupport.getAllFilesAssociatedWith(fileSystem, processedFiles).iterator();
        while (filesIt.hasNext()) {
            String status;
            FileObject fo = (FileObject)filesIt.next();
            String name = fo.getPackageNameExt('/', '.');
            if (fileSystem.isImportant(name) || statusProvider != null && !localFileStatus.equals(status = statusProvider.getFileStatus(name)) && !ignoredFileStatus.equals(status)) continue;
            if (fo != null) {
                try {
                    fo.delete(fo.lock());
                }
                catch (IOException ioexc) {}
                continue;
            }
            try {
                fileSystem.delete(name);
            }
            catch (IOException ioexc) {
                // empty catch block
            }
        }
    }

    private static void checkForModifications(VcsFileSystem fileSystem, VcsCommandExecutor vce) {
        if (VcsCommandIO.getBooleanProperty(vce.getCommand(), "checkForModifications")) {
            Collection files = vce.getFiles();
            Iterator it = files.iterator();
            while (it.hasNext()) {
                String path = (String)it.next();
                fileSystem.checkForModifications(path);
            }
        }
    }

    public static void checkRevisionChanges(VcsFileSystem fileSystem, VcsCommandExecutor vce) {
        int whatChanged = 0;
        String changedRevision = null;
        VcsCommand cmd = vce.getCommand();
        if (VcsCommandIO.getBooleanPropertyAssumeDefault(cmd, "changingNumRevisions")) {
            whatChanged = 4;
        }
        if (VcsCommandIO.getBooleanPropertyAssumeDefault(cmd, "changingRevision")) {
            whatChanged = 1;
            Object varName = cmd.getProperty("changedRevisionVarName");
            if (varName != null) {
                changedRevision = (String)vce.getVariables().get(varName);
            }
        }
        if (whatChanged != 0) {
            String[] files = vce.getFiles().toArray(new String[0]);
            int i = 0;
            while (i < files.length) {
                FileObject fo = fileSystem.findResource(files[i]);
                if (fo == null) {
                    fo = fileSystem.getVersioningFileSystem().findResource(files[i]);
                }
                if (fo != null) {
                    RevisionEvent event = new RevisionEvent(fo);
                    event.setRevisionChangeID(whatChanged);
                    event.setChangedRevision(changedRevision);
                    fileSystem.fireRevisionsChanged(event);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Table needPromptForUserParams(VcsFileSystem fileSystem, String exec, Hashtable vars, Hashtable varNames, Hashtable userParamsIndexes, VcsCommand cmd, boolean acceptUserParams) {
        int index2;
        String defaultParam;
        String varName;
        int varEnd;
        int num;
        char cnum;
        int varBegin;
        int index;
        Table results = new Table();
        String search = "${USER_GLOBAL_PARAM";
        int pos = 0;
        String[] userParamsLabels = fileSystem.getUserParamsLabels();
        String[] userParams = fileSystem.getUserParams();
        String[] userLocalParamsLabels = fileSystem.getUserLocalParamsLabels();
        while ((index = exec.indexOf(search, pos)) >= 0) {
            void var10_13;
            varBegin = var10_13 + 2;
            index = var10_13 + search.length();
            cnum = exec.charAt(index);
            num = 1;
            if (Character.isDigit(cnum)) {
                num = Character.digit(cnum, 10);
                ++index;
            }
            --num;
            varEnd = VcsUtilities.getPairIndex(exec, index, '{', '}');
            if (varEnd < 0) {
                pos = index;
                continue;
            }
            varName = exec.substring(varBegin, varEnd);
            defaultParam = "";
            if (exec.charAt(index) == '(' && (index2 = VcsUtilities.getPairIndex(exec, ++index, '(', ')')) > 0) {
                defaultParam = exec.substring(index, index2);
            }
            if (acceptUserParams && userParamsLabels != null) {
                if (num >= userParamsLabels.length) {
                    num = userParamsLabels.length - 1;
                }
                if (userParams[num] != null) {
                    defaultParam = userParams[num];
                }
                results.put(userParamsLabels[num], defaultParam);
                varNames.put(varName, userParamsLabels[num]);
                userParamsIndexes.put(varName, new Integer(num));
            } else {
                vars.put(varName, defaultParam);
            }
            pos = varEnd;
        }
        search = "${USER_PARAM";
        pos = 0;
        while ((index = exec.indexOf(search, pos)) >= 0) {
            varBegin = index + 2;
            cnum = exec.charAt(index += search.length());
            num = 1;
            if (Character.isDigit(cnum)) {
                num = Character.digit(cnum, 10);
                ++index;
            }
            --num;
            varEnd = VcsUtilities.getPairIndex(exec, index, '{', '}');
            if (varEnd < 0) {
                pos = index;
                continue;
            }
            varName = exec.substring(varBegin, varEnd);
            defaultParam = "";
            if (exec.charAt(index) == '(' && (index2 = VcsUtilities.getPairIndex(exec, ++index, '(', ')')) > 0) {
                defaultParam = exec.substring(index, index2);
            }
            if (acceptUserParams && userLocalParamsLabels != null) {
                String[] cmdUserParams = (String[])cmd.getProperty("userParams");
                if (cmdUserParams == null) {
                    cmdUserParams = new String[userLocalParamsLabels.length];
                }
                cmd.setProperty("userParams", cmdUserParams);
                if (num >= userLocalParamsLabels.length) {
                    num = userLocalParamsLabels.length - 1;
                }
                if (cmdUserParams[num] != null) {
                    defaultParam = cmdUserParams[num];
                }
                results.put(userLocalParamsLabels[num], defaultParam);
                varNames.put(varName, userLocalParamsLabels[num]);
                userParamsIndexes.put(varName, new Integer(-num - 1));
            } else {
                vars.put(varName, defaultParam);
            }
            pos = varEnd;
        }
        return results;
    }

    private static boolean needPromptForPR(String name, String exec, Hashtable vars) {
        boolean result = false;
        String oldPassword = (String)vars.get("PASSWORD");
        vars.put("PASSWORD", "");
        String oldReason = (String)vars.get("REASON");
        vars.put("REASON", "");
        String test = "variable_must_be_prompt_for";
        vars.put(name, test);
        String s = Variables.expand(vars, exec, false);
        boolean bl = result = s.indexOf(test) >= 0;
        if (oldPassword != null) {
            vars.put("PASSWORD", oldPassword);
        } else {
            vars.remove("PASSWORD");
        }
        if (oldReason != null) {
            vars.put("REASON", oldReason);
        } else {
            vars.remove("REASON");
        }
        return result;
    }

    private static void addComponentsWithPrecommands(VariableInputComponent component, ArrayList componentsWithPrecommands) {
        VariableInputComponent[] components;
        if (component.needsPreCommandPerform()) {
            componentsWithPrecommands.add(component);
        }
        if ((components = component.subComponents()) != null) {
            int i = 0;
            while (i < components.length) {
                CommandCustomizationSupport.addComponentsWithPrecommands(components[i], componentsWithPrecommands);
                ++i;
            }
        }
    }

    private static void processPrecommands(VcsFileSystem fileSystem, Hashtable vars, VariableInputDescriptor inputDescriptor) throws UserCancelException {
        VariableInputComponent[] components = inputDescriptor.components();
        ArrayList componentsWithPrecommands = new ArrayList();
        int i = 0;
        while (i < components.length) {
            CommandCustomizationSupport.addComponentsWithPrecommands(components[i], componentsWithPrecommands);
            ++i;
        }
        if (componentsWithPrecommands.size() > 0) {
            String[] defVals = new String[componentsWithPrecommands.size()];
            int i2 = 0;
            while (i2 < defVals.length) {
                defVals[i2] = ((VariableInputComponent)componentsWithPrecommands.get(i2)).getDefaultValue();
                ++i2;
            }
            PreCommandPerformer cmdPerf = new PreCommandPerformer(fileSystem, vars);
            String[] values = cmdPerf.process(defVals);
            int i3 = 0;
            while (i3 < values.length) {
                ((VariableInputComponent)componentsWithPrecommands.get(i3)).setValue(values[i3]);
                ++i3;
            }
        }
    }

    public static VariableInputDialog createInputDialog(final VcsFileSystem fileSystem, String exec, final Hashtable vars, final VcsCommand cmd, boolean[] forEachFile, StringBuffer retTitle) throws UserCancelException {
        String inputDescriptorStr;
        VariableInputDescriptor inputDescriptor = (VariableInputDescriptor)cmd.getProperty(INPUT_DESCRIPTOR_PARSED);
        if (inputDescriptor == null && (inputDescriptorStr = (String)cmd.getProperty("inputDescriptor")) != null) {
            try {
                inputDescriptor = VariableInputDescriptor.parseItems(inputDescriptorStr);
            }
            catch (VariableInputFormatException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
                throw new UserCancelException();
            }
            inputDescriptor.setValuesAsDefault();
            cmd.setProperty(INPUT_DESCRIPTOR_PARSED, inputDescriptor);
        }
        if (inputDescriptor != null) {
            CommandCustomizationSupport.processPrecommands(fileSystem, vars, inputDescriptor);
        }
        Hashtable hashtable = vars;
        synchronized (hashtable) {
            if (exec != null && CommandCustomizationSupport.needPromptForPR("PASSWORD", exec, vars)) {
                String password;
                Object object = promptLock;
                synchronized (object) {
                    password = fileSystem.getPassword();
                    if (password == null) {
                        NotifyDescriptorInputPassword nd = new NotifyDescriptorInputPassword(CommandCustomizationSupport.g("MSG_Password"), CommandCustomizationSupport.g("MSG_Password"));
                        if (!NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
                            fileSystem.setPassword(null);
                            throw new UserCancelException();
                        }
                        password = nd.getInputText();
                        fileSystem.setPassword(password);
                    }
                }
                vars.put("PASSWORD", password);
            }
            if (forEachFile == null || forEachFile[0]) {
                final String[] userParams = fileSystem.getUserParams();
                final Hashtable userParamsVarNames = new Hashtable();
                final Hashtable userParamsIndexes = new Hashtable();
                Boolean ctrlDown = (Boolean)vars.get("CTRL_DOWN_IN_ACTION");
                boolean expertCondition = ctrlDown != null && ctrlDown == true;
                boolean acceptUserParams = fileSystem.isAcceptUserParams() || ctrlDown != null && ctrlDown == true;
                Table userParamsPromptLabels = exec == null ? new Table() : CommandCustomizationSupport.needPromptForUserParams(fileSystem, exec, vars, userParamsVarNames, userParamsIndexes, cmd, acceptUserParams);
                if (inputDescriptor != null && CommandCustomizationSupport.showInputDescriptor(inputDescriptor, expertCondition, vars) || userParamsPromptLabels.size() > 0) {
                    String title;
                    String file = (String)vars.get("FILE");
                    final Hashtable dlgVars = new Hashtable(vars);
                    final VariableInputDialog dlg = new VariableInputDialog(new String[]{file}, inputDescriptor, expertCondition, dlgVars);
                    dlg.setVCSFileSystem(fileSystem, dlgVars);
                    if (cmd.getDisplayName() != null) {
                        dlg.setCmdName(cmd.getDisplayName());
                    } else {
                        dlg.setCmdName(cmd.getName());
                    }
                    if (expertCondition && exec != null) {
                        dlg.setExec(exec);
                    }
                    final String globalInputStr = (String)vars.get(GLOBAL_INPUT_DESCRIPTOR);
                    String globalInputStrStored = (String)globalInputStrs.get(fileSystem);
                    VariableInputDescriptor globalInputDescriptor = null;
                    if (globalInputStr != null) {
                        if (!globalInputStr.equals(globalInputStrStored)) {
                            try {
                                globalInputDescriptor = VariableInputDescriptor.parseItems(globalInputStr);
                            }
                            catch (VariableInputFormatException exc) {
                                ErrorManager.getDefault().notify((Throwable)exc);
                                VariableInputDialog variableInputDialog = null;
                                return variableInputDialog;
                            }
                            globalInputStrs.put(fileSystem, globalInputStr);
                            globalInputDescrs.put(fileSystem, globalInputDescriptor);
                            globalInputDescriptor.setValuesAsDefault();
                        } else {
                            globalInputDescriptor = (VariableInputDescriptor)globalInputDescrs.get(fileSystem);
                        }
                    }
                    dlg.setGlobalInput(globalInputDescriptor);
                    dlg.setUserParamsPromptLabels(userParamsPromptLabels, (String)cmd.getProperty("advancedName"));
                    dlg.setFilePromptDocumentListener(fileSystem, cmd);
                    if (forEachFile == null) {
                        dlg.showPromptEach(false);
                    } else {
                        dlg.setPromptEach(fileSystem.isPromptForVarsForEachFile());
                    }
                    String string = title = inputDescriptor != null ? inputDescriptor.getLabel() : null;
                    if (title == null) {
                        title = cmd.getDisplayName();
                    }
                    title = title + VAR_INPUT_FILE_SEPARATOR + file;
                    String multipleFiles = (String)vars.get("MULTIPLE_FILES");
                    if (multipleFiles != null && multipleFiles.length() > 0) {
                        title = title + VAR_INPUT_MULTIPLE_FILES_TITLE_APPEND;
                    }
                    retTitle.replace(0, retTitle.length(), title);
                    final VariableInputDescriptor dlgInputDescriptor = inputDescriptor;
                    final VariableInputDescriptor dlgGlobalInputDescriptor = globalInputDescriptor;
                    dlg.addCloseListener(new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            if (dlg.isValidInput()) {
                                dlg.processActions();
                                vars.clear();
                                vars.putAll(dlgVars);
                                if (dlgInputDescriptor != null) {
                                    dlgInputDescriptor.addValuesToHistory();
                                }
                                if (dlgGlobalInputDescriptor != null) {
                                    dlgGlobalInputDescriptor.addValuesToHistory();
                                    dlgGlobalInputDescriptor.setDefaultValues();
                                    String globalVIDString = dlgGlobalInputDescriptor.getStringInputItems();
                                    if (!globalVIDString.equals(globalInputStr)) {
                                        Vector fsVars = fileSystem.getVariables();
                                        Iterator it = ((AbstractList)fsVars).iterator();
                                        while (it.hasNext()) {
                                            VcsConfigVariable var = (VcsConfigVariable)it.next();
                                            if (!CommandCustomizationSupport.GLOBAL_INPUT_DESCRIPTOR.equals(var.getName())) continue;
                                            var.setValue(globalVIDString);
                                            break;
                                        }
                                        fileSystem.setVariables(fsVars);
                                    }
                                }
                                Hashtable valuesTable = dlg.getUserParamsValuesTable();
                                Enumeration enumeration = userParamsVarNames.keys();
                                while (enumeration.hasMoreElements()) {
                                    String varName = (String)enumeration.nextElement();
                                    String value = (String)valuesTable.get(userParamsVarNames.get(varName));
                                    vars.put(varName, value);
                                    int index = (Integer)userParamsIndexes.get(varName);
                                    if (index >= 0) {
                                        userParams[index] = value;
                                        continue;
                                    }
                                    String[] cmdUserParams = (String[])cmd.getProperty("userParams");
                                    cmdUserParams[-index - 1] = value;
                                    cmd.setProperty("userParams", cmdUserParams);
                                }
                                fileSystem.setUserParams(userParams);
                            }
                        }
                    });
                    VariableInputDialog variableInputDialog = dlg;
                    return variableInputDialog;
                }
                if (inputDescriptor != null && CommandCustomizationSupport.showInputDescriptor(inputDescriptor, true, vars)) {
                    VariableInputComponent[] components = inputDescriptor.components();
                    int i = 0;
                    while (i < components.length) {
                        String var = components[i].getVariable();
                        String value = components[i].getDefaultValue();
                        if (value != null) {
                            vars.put(var, value);
                        }
                        ++i;
                    }
                    String globalInputStr = (String)vars.get(GLOBAL_INPUT_DESCRIPTOR);
                    String globalInputStrStored = (String)globalInputStrs.get(fileSystem);
                    if (globalInputStr != null) {
                        VariableInputDescriptor globalInputDescriptor;
                        if (!globalInputStr.equals(globalInputStrStored)) {
                            try {
                                globalInputDescriptor = VariableInputDescriptor.parseItems(globalInputStr);
                            }
                            catch (VariableInputFormatException exc) {
                                ErrorManager.getDefault().notify((Throwable)exc);
                                VariableInputDialog title = null;
                                return title;
                            }
                            globalInputStrs.put(fileSystem, globalInputStr);
                            globalInputDescrs.put(fileSystem, globalInputDescriptor);
                        } else {
                            globalInputDescriptor = (VariableInputDescriptor)globalInputDescrs.get(fileSystem);
                        }
                        components = globalInputDescriptor.components();
                        int i2 = 0;
                        while (i2 < components.length) {
                            String var = components[i2].getVariable();
                            String value = components[i2].getDefaultValue();
                            if (value != null) {
                                vars.put(var, value);
                            }
                            ++i2;
                        }
                    }
                }
                if (forEachFile != null) {
                    forEachFile[0] = false;
                }
            }
            VariableInputDialog variableInputDialog = null;
            return variableInputDialog;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean promptForVariables(VcsFileSystem fileSystem, String exec, Hashtable vars, VcsCommand cmd, boolean[] forEachFile) {
        String inputDescriptorStr;
        VariableInputDescriptor inputDescriptor = (VariableInputDescriptor)cmd.getProperty(INPUT_DESCRIPTOR_PARSED);
        if (inputDescriptor == null && (inputDescriptorStr = (String)cmd.getProperty("inputDescriptor")) != null) {
            try {
                inputDescriptor = VariableInputDescriptor.parseItems(inputDescriptorStr);
            }
            catch (VariableInputFormatException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
                return false;
            }
            inputDescriptor.setValuesAsDefault();
            cmd.setProperty(INPUT_DESCRIPTOR_PARSED, inputDescriptor);
        }
        if (inputDescriptor != null) {
            try {
                CommandCustomizationSupport.processPrecommands(fileSystem, vars, inputDescriptor);
            }
            catch (UserCancelException cancelExc) {
                return false;
            }
        }
        Hashtable hashtable = vars;
        synchronized (hashtable) {
            if (CommandCustomizationSupport.needPromptForPR("PASSWORD", exec, vars)) {
                String password;
                Object object = promptLock;
                synchronized (object) {
                    password = fileSystem.getPassword();
                    if (password == null) {
                        NotifyDescriptorInputPassword nd = new NotifyDescriptorInputPassword(CommandCustomizationSupport.g("MSG_Password"), CommandCustomizationSupport.g("MSG_Password"));
                        if (!NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
                            fileSystem.setPassword(null);
                            return false;
                        }
                        password = nd.getInputText();
                        fileSystem.setPassword(password);
                    }
                }
                vars.put("PASSWORD", password);
            }
            if (forEachFile != null) {
                if (!forEachFile[0]) return true;
            }
            String[] userParams = fileSystem.getUserParams();
            Hashtable userParamsVarNames = new Hashtable();
            Hashtable userParamsIndexes = new Hashtable();
            Boolean ctrlDown = (Boolean)vars.get("CTRL_DOWN_IN_ACTION");
            boolean expertCondition = ctrlDown != null && ctrlDown == true;
            boolean acceptUserParams = fileSystem.isAcceptUserParams() || ctrlDown != null && ctrlDown == true;
            Table userParamsPromptLabels = CommandCustomizationSupport.needPromptForUserParams(fileSystem, exec, vars, userParamsVarNames, userParamsIndexes, cmd, acceptUserParams);
            if (inputDescriptor != null && CommandCustomizationSupport.showInputDescriptor(inputDescriptor, expertCondition, vars) || userParamsPromptLabels.size() > 0) {
                String title;
                String file = (String)vars.get("FILE");
                Hashtable dlgVars = new Hashtable(vars);
                VariableInputDialog dlg = new VariableInputDialog(new String[]{file}, inputDescriptor, expertCondition, dlgVars);
                dlg.setVCSFileSystem(fileSystem, dlgVars);
                if (cmd.getDisplayName() != null) {
                    dlg.setCmdName(cmd.getDisplayName());
                } else {
                    dlg.setCmdName(cmd.getName());
                }
                if (expertCondition && exec != null) {
                    dlg.setExec(exec);
                }
                String globalInputStr = (String)vars.get(GLOBAL_INPUT_DESCRIPTOR);
                String globalInputStrStored = (String)globalInputStrs.get(fileSystem);
                VariableInputDescriptor globalInputDescriptor = null;
                if (globalInputStr != null) {
                    if (!globalInputStr.equals(globalInputStrStored)) {
                        try {
                            globalInputDescriptor = VariableInputDescriptor.parseItems(globalInputStr);
                        }
                        catch (VariableInputFormatException exc) {
                            ErrorManager.getDefault().notify((Throwable)exc);
                            return false;
                        }
                        globalInputStrs.put(fileSystem, globalInputStr);
                        globalInputDescrs.put(fileSystem, globalInputDescriptor);
                        globalInputDescriptor.setValuesAsDefault();
                    } else {
                        globalInputDescriptor = (VariableInputDescriptor)globalInputDescrs.get(fileSystem);
                    }
                }
                dlg.setGlobalInput(globalInputDescriptor);
                dlg.setUserParamsPromptLabels(userParamsPromptLabels, (String)cmd.getProperty("advancedName"));
                dlg.setFilePromptDocumentListener(fileSystem, cmd);
                if (forEachFile == null) {
                    dlg.showPromptEach(false);
                } else {
                    dlg.setPromptEach(fileSystem.isPromptForVarsForEachFile());
                }
                String string = title = inputDescriptor != null ? inputDescriptor.getLabel() : null;
                if (title == null) {
                    title = cmd.getDisplayName();
                }
                title = title + VAR_INPUT_FILE_SEPARATOR + file;
                String multipleFiles = (String)vars.get("MULTIPLE_FILES");
                if (multipleFiles != null && multipleFiles.length() > 0) {
                    title = title + VAR_INPUT_MULTIPLE_FILES_TITLE_APPEND;
                }
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)dlg, title, true, dlg.getActionListener());
                dialogDescriptor.setClosingOptions(new Object[]{NotifyDescriptor.CANCEL_OPTION});
                final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                dlg.addCloseListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ev) {
                        dialog.dispose();
                    }
                });
                Object object = promptLock;
                synchronized (object) {
                    ((Component)dialog).setVisible(true);
                }
                if (!dlg.isValidInput()) return false;
                dlg.processActions();
                vars.clear();
                vars.putAll(dlgVars);
                if (inputDescriptor != null) {
                    inputDescriptor.addValuesToHistory();
                }
                if (globalInputDescriptor != null) {
                    globalInputDescriptor.addValuesToHistory();
                }
                Hashtable valuesTable = dlg.getUserParamsValuesTable();
                Enumeration enumeration = userParamsVarNames.keys();
                while (enumeration.hasMoreElements()) {
                    String varName = (String)enumeration.nextElement();
                    String value = (String)valuesTable.get(userParamsVarNames.get(varName));
                    vars.put(varName, value);
                    int index = (Integer)userParamsIndexes.get(varName);
                    if (index >= 0) {
                        userParams[index] = value;
                        continue;
                    }
                    String[] cmdUserParams = (String[])cmd.getProperty("userParams");
                    cmdUserParams[-index - 1] = value;
                    cmd.setProperty("userParams", cmdUserParams);
                }
                fileSystem.setUserParams(userParams);
                if (forEachFile == null) return true;
                forEachFile[0] = dlg.getPromptForEachFile();
                fileSystem.setPromptForVarsForEachFile(forEachFile[0]);
                return true;
            }
            if (inputDescriptor != null && CommandCustomizationSupport.showInputDescriptor(inputDescriptor, true, vars)) {
                VariableInputComponent[] components = inputDescriptor.components();
                int i = 0;
                while (i < components.length) {
                    String var = components[i].getVariable();
                    String value = components[i].getDefaultValue();
                    if (value != null) {
                        vars.put(var, value);
                    }
                    ++i;
                }
                String globalInputStr = (String)vars.get(GLOBAL_INPUT_DESCRIPTOR);
                String globalInputStrStored = (String)globalInputStrs.get(fileSystem);
                if (globalInputStr != null) {
                    VariableInputDescriptor globalInputDescriptor;
                    if (!globalInputStr.equals(globalInputStrStored)) {
                        try {
                            globalInputDescriptor = VariableInputDescriptor.parseItems(globalInputStr);
                        }
                        catch (VariableInputFormatException exc) {
                            ErrorManager.getDefault().notify((Throwable)exc);
                            return false;
                        }
                        globalInputStrs.put(fileSystem, globalInputStr);
                        globalInputDescrs.put(fileSystem, globalInputDescriptor);
                    } else {
                        globalInputDescriptor = (VariableInputDescriptor)globalInputDescrs.get(fileSystem);
                    }
                    components = globalInputDescriptor.components();
                    int i2 = 0;
                    while (i2 < components.length) {
                        String var = components[i2].getVariable();
                        String value = components[i2].getDefaultValue();
                        if (value != null) {
                            vars.put(var, value);
                        }
                        ++i2;
                    }
                }
            }
            if (forEachFile == null) return true;
            forEachFile[0] = false;
            return true;
        }
    }

    private static boolean showInputDescriptor(VariableInputDescriptor inputDescriptor, boolean isExpertMode, Map vars) {
        VariableInputComponent[] inputComponents = inputDescriptor.components();
        if (inputComponents.length == 0) {
            return false;
        }
        int i = 0;
        while (i < inputComponents.length) {
            if (VariableInputComponent.isVarConditionMatch(inputComponents[i].getVarConditions(), vars) && (inputComponents[i].isExpert() && isExpertMode || !inputComponents[i].isExpert() && inputComponents[i].getComponent() != 8)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String g(String s) {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$commands$CommandCustomizationSupport == null ? (class$org$netbeans$modules$vcscore$commands$CommandCustomizationSupport = CommandCustomizationSupport.class$("org.netbeans.modules.vcscore.commands.CommandCustomizationSupport")) : class$org$netbeans$modules$vcscore$commands$CommandCustomizationSupport)).getString(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

