/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.commands;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.vcs.commands.CommandTask;
import org.netbeans.modules.vcscore.RetrievingDialog;
import org.netbeans.modules.vcscore.Variables;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.caching.FileCacheProvider;
import org.netbeans.modules.vcscore.caching.FileStatusProvider;
import org.netbeans.modules.vcscore.commands.CommandProcessor;
import org.netbeans.modules.vcscore.commands.PreCommandPerformer;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.commands.VcsCommandIO;
import org.netbeans.modules.vcscore.commands.VcsDescribedTask;
import org.netbeans.modules.vcscore.util.Table;
import org.netbeans.modules.vcscore.util.VariableInputComponent;
import org.netbeans.modules.vcscore.util.VariableInputDescriptor;
import org.netbeans.modules.vcscore.util.VariableValueAdjustment;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.netbeans.modules.vcscore.versioning.RevisionEvent;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.UserCancelException;

public class CommandExecutorSupport {
    public static final String GLOBAL_INPUT_DESCRIPTOR = "GLOBAL_INPUT_DESCRIPTOR";
    public static final String GLOBAL_INPUT_EXPRESSION = "GLOBAL_INPUT_EXPRESSION";
    private static final String USER_GLOBAL_PARAM = "USER_GLOBAL_PARAM";
    private static final String USER_PARAM = "USER_PARAM";
    public static final String INPUT_DESCRIPTOR_PARSED = "_For_Internal_Use_Only__INPUT_DESCRIPTOR_PARSED";
    private static final String VAR_INPUT_MULTIPLE_FILES_TITLE_APPEND = " ...";
    private static final String VAR_INPUT_FILE_SEPARATOR = " - ";
    private static final Map foldersToRefreshByFilesystems = new WeakHashMap();
    private static Hashtable globalInputStrs = new Hashtable();
    private static Hashtable globalInputDescrs = new Hashtable();
    private static final Object promptLock = new Object();
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$commands$CommandExecutorSupport;

    private CommandExecutorSupport() {
    }

    private static int numImportant(VcsFileSystem fileSystem, String paths, String ps) {
        if (paths == null) {
            return 0;
        }
        int num = 0;
        String delim = ps != null ? ps + ps : File.separator + File.separator;
        VariableValueAdjustment varValueAdjust = fileSystem.getVarValueAdjustment();
        int begin = 0;
        int end = paths.indexOf(delim);
        if (end < 0) {
            end = paths.length();
        }
        while (true) {
            String path = paths.substring(begin, end);
            if (fileSystem.isImportant(path = varValueAdjust.revertAdjustedVarValue(path))) {
                ++num;
            }
            if ((begin = end + delim.length()) > paths.length()) break;
            end = paths.indexOf(delim, begin);
            if (end >= 0) continue;
            end = paths.length();
        }
        return num;
    }

    private static String processConfirmation(String confirmation, Hashtable vars, VcsFileSystem fileSystem) throws UserCancelException {
        confirmation = Variables.expand(vars, confirmation, false);
        PreCommandPerformer cmdPerf = new PreCommandPerformer(fileSystem, vars);
        ArrayList confCommandsOutput = new ArrayList();
        confirmation = cmdPerf.process(confirmation, confCommandsOutput);
        vars.put("CONFIRMATION_MSG", confirmation);
        boolean confCommandsSuccess = true;
        if (confCommandsOutput.size() > 0) {
            Iterator it = ((AbstractList)confCommandsOutput).iterator();
            while (it.hasNext()) {
                boolean bl = confCommandsSuccess = confCommandsSuccess && (Boolean)it.next() != false;
            }
        }
        if (confCommandsSuccess) {
            vars.put("CONFIRMATION_SUCCESS", Boolean.TRUE.toString());
        } else {
            vars.remove("CONFIRMATION_SUCCESS");
        }
        return confirmation;
    }

    /*
     * WARNING - void declaration
     */
    private static String insertGlobalOptions(String exec, Hashtable vars) {
        String glInput;
        if (vars.get(GLOBAL_INPUT_DESCRIPTOR) != null && (glInput = (String)vars.get(GLOBAL_INPUT_EXPRESSION)) != null) {
            int index;
            String search = "${USER_GLOBAL_PARAM}";
            int pos = 0;
            while ((index = exec.indexOf(search, pos)) > 0) {
                void var5_5;
                exec = exec.substring(0, (int)var5_5) + glInput + exec.substring((int)(var5_5 + search.length()));
                pos = var5_5 + search.length();
            }
            Hashtable hashtable = vars;
            synchronized (hashtable) {
                vars.put(USER_GLOBAL_PARAM, glInput);
            }
        }
        return exec;
    }

    private static Component createNotificationDesign(String text, JCheckBox checkBox) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JLabel textLabel = new JLabel(text);
        textLabel.setForeground(Color.black);
        panel.add((Component)textLabel, "Center");
        if (checkBox != null) {
            panel.add((Component)checkBox, "South");
        }
        return panel;
    }

    public static void commandNotification(VcsCommandExecutor vce, String notification, final VcsFileSystem fileSystem) {
        final String notification1 = Variables.expand(vce.getVariables(), notification, false);
        if (notification1.trim().length() == 0) {
            return;
        }
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)notification1);
                JCheckBox checkBox = fileSystem != null ? new JCheckBox(CommandExecutorSupport.g("DLG_DoNotNotify")) : null;
                msg.setMessage((Object)CommandExecutorSupport.createNotificationDesign(notification1, checkBox));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                if (checkBox != null && checkBox.isSelected()) {
                    fileSystem.setCommandNotification(false);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)CommandExecutorSupport.g("DLG_CanBeEnabled")));
                }
            }
        });
    }

    public static void postprocessCommand(VcsFileSystem fileSystem, VcsCommandExecutor vce) {
        int exit = vce.getExitStatus();
        VcsCommand cmd = vce.getCommand();
        if (0 == exit) {
            CommandExecutorSupport.checkForModifications(fileSystem, vce);
            CommandExecutorSupport.doRefresh(fileSystem, vce);
            CommandExecutorSupport.checkRevisionChanges(fileSystem, vce);
            if (VcsCommandIO.getBooleanProperty(cmd, "cleanUnimportantFilesOnSuccess")) {
                CommandExecutorSupport.deleteUnimportantFiles(fileSystem, vce.getFiles());
            }
        } else {
            Object refresh = cmd.getProperty("refreshOnFail");
            if (VcsCommand.REFRESH_ON_FAIL_TRUE.equals(refresh)) {
                CommandExecutorSupport.doRefresh(fileSystem, vce);
            } else if (VcsCommand.REFRESH_ON_FAIL_TRUE_ON_FOLDERS.equals(refresh)) {
                CommandExecutorSupport.doRefresh(fileSystem, vce, true);
            }
        }
        CommandExecutorSupport.issuePostCommands(cmd, vce.getVariables(), 0 == exit, fileSystem);
    }

    private static Collection getAllFilesAssociatedWith(VcsFileSystem fileSystem, Collection fileNames) {
        HashSet files = new HashSet();
        Iterator filesIt = fileNames.iterator();
        while (filesIt.hasNext()) {
            String name = (String)filesIt.next();
            FileObject fo = fileSystem.findResource(name);
            if (fo == null) continue;
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                files.addAll(dobj.files());
            }
            catch (DataObjectNotFoundException donfexc) {
                // empty catch block
            }
        }
        return files;
    }

    private static void deleteUnimportantFiles(VcsFileSystem fileSystem, Collection processedFiles) {
        FileStatusProvider statusProvider = fileSystem.getStatusProvider();
        String localFileStatus = statusProvider != null ? statusProvider.getLocalFileStatus() : null;
        String ignoredFileStatus = "Ignored";
        Iterator filesIt = CommandExecutorSupport.getAllFilesAssociatedWith(fileSystem, processedFiles).iterator();
        while (filesIt.hasNext()) {
            String status;
            FileObject fo = (FileObject)filesIt.next();
            String name = fo.getPackageNameExt('/', '.');
            if (fileSystem.isImportant(name) || statusProvider != null && !localFileStatus.equals(status = statusProvider.getFileStatus(name)) && !ignoredFileStatus.equals(status)) continue;
            if (fo != null) {
                try {
                    fo.delete(fo.lock());
                }
                catch (IOException ioexc) {}
                continue;
            }
            try {
                fileSystem.delete(name);
            }
            catch (IOException ioexc) {
                // empty catch block
            }
        }
    }

    private static void issuePostCommands(VcsCommand cmd, Hashtable vars, boolean success, VcsFileSystem fileSystem) {
        String commands = success ? (String)cmd.getProperty("commandsAfterSuccess") : (String)cmd.getProperty("commandsAfterFail");
        if (commands == null) {
            return;
        }
        if ((commands = Variables.expand(vars, commands, false).trim()).length() == 0) {
            return;
        }
        String[] cmdNames = VcsUtilities.getQuotedStrings(commands);
        int i = 0;
        while (i < cmdNames.length) {
            VcsCommand c = fileSystem.getCommand(cmdNames[i]);
            if (c != null) {
                Hashtable cVars = new Hashtable(vars);
                VcsCommandExecutor vce = fileSystem.getVcsFactory().getCommandExecutor(c, cVars);
                fileSystem.getCommandsPool().preprocessCommand(vce, cVars, fileSystem);
                fileSystem.getCommandsPool().startExecutor(vce);
            }
            ++i;
        }
    }

    private static void checkForModifications(VcsFileSystem fileSystem, VcsCommandExecutor vce) {
        if (VcsCommandIO.getBooleanProperty(vce.getCommand(), "checkForModifications")) {
            Collection files = vce.getFiles();
            Iterator it = files.iterator();
            while (it.hasNext()) {
                String path = (String)it.next();
                fileSystem.checkForModifications(path);
            }
        }
    }

    private static void doRefresh(VcsFileSystem fileSystem, VcsCommandExecutor vce) {
        CommandExecutorSupport.doRefresh(fileSystem, vce, false);
    }

    private static void doRefresh(VcsFileSystem fileSystem, VcsCommandExecutor vce, boolean foldersOnly) {
        Map foldersToRefresh = CommandExecutorSupport.getFoldersToRefresh(fileSystem, vce, foldersOnly);
        Map map = foldersToRefreshByFilesystems;
        synchronized (map) {
            Map fsFoldresMap;
            boolean refreshLater = false;
            CommandTask[] tasks = CommandProcessor.getInstance().getRunningCommandTasks();
            int i = 0;
            while (i < tasks.length) {
                if (tasks[i] instanceof VcsDescribedTask && !vce.equals(((VcsDescribedTask)((Object)tasks[i])).getExecutor())) {
                    VcsCommand cmd = ((VcsDescribedTask)((Object)tasks[i])).getVcsCommand();
                    boolean doRefreshCurrent = VcsCommandIO.getBooleanProperty(cmd, "refreshCurrentFolder");
                    boolean doRefreshParent = VcsCommandIO.getBooleanProperty(cmd, "refreshParentFolder");
                    if (doRefreshCurrent || doRefreshParent) {
                        refreshLater = true;
                        break;
                    }
                }
                ++i;
            }
            if (refreshLater) {
                fsFoldresMap = (TreeMap)foldersToRefreshByFilesystems.get(fileSystem);
                if (fsFoldresMap == null) {
                    fsFoldresMap = new TreeMap();
                    foldersToRefreshByFilesystems.put(fileSystem, fsFoldresMap);
                }
                CommandExecutorSupport.copyFoldersToRefresh(foldersToRefresh, fsFoldresMap);
                foldersToRefresh = Collections.EMPTY_MAP;
            } else {
                fsFoldresMap = (Map)foldersToRefreshByFilesystems.remove(fileSystem);
                if (fsFoldresMap != null) {
                    CommandExecutorSupport.copyFoldersToRefresh(fsFoldresMap, foldersToRefresh);
                }
            }
        }
        CommandExecutorSupport.doRefresh(fileSystem, foldersToRefresh);
    }

    private static void copyFoldersToRefresh(Map src, Map dest) {
        Iterator it = src.keySet().iterator();
        while (it.hasNext()) {
            String folderName = (String)it.next();
            Boolean srcRec = (Boolean)src.get(folderName);
            Boolean destRec = (Boolean)dest.get(folderName);
            if (Boolean.TRUE.equals(destRec)) continue;
            dest.put(folderName, srcRec);
        }
    }

    private static void doRefresh(VcsFileSystem fileSystem, Map foldersToRefresh) {
        Iterator it = foldersToRefresh.keySet().iterator();
        while (it.hasNext()) {
            String folderName = (String)it.next();
            Boolean rec = (Boolean)foldersToRefresh.get(folderName);
            CommandExecutorSupport.doRefresh(fileSystem, folderName, (boolean)rec);
        }
    }

    public static void doRefresh(VcsFileSystem fileSystem, String refreshPath, boolean recursive) {
        FileStatusProvider statusProvider = fileSystem.getStatusProvider();
        if (statusProvider == null) {
            return;
        }
        FileCacheProvider cache = fileSystem.getCacheProvider();
        String dirName = "";
        dirName = cache == null || cache.isDir(refreshPath) ? refreshPath : VcsUtilities.getDirNamePart(refreshPath);
        if (recursive) {
            Object execList;
            VcsCommand listSub = fileSystem.getCommand("LIST_SUB");
            Object object = execList = listSub != null ? listSub.getProperty("exec") : null;
            if (execList != null && ((String)execList).trim().length() > 0) {
                statusProvider.refreshDirRecursive(dirName);
            } else {
                RetrievingDialog rd = new RetrievingDialog(fileSystem, dirName, new JFrame(), false);
                VcsUtilities.centerWindow(rd);
                RequestProcessor rp = RequestProcessor.getDefault();
                rp.post((Runnable)rd);
            }
        } else {
            statusProvider.refreshDir(dirName);
        }
    }

    private static Map getFoldersToRefresh(VcsFileSystem fileSystem, VcsCommandExecutor vce, boolean foldersOnly) {
        TreeMap<String, Boolean> foldersToRefresh = new TreeMap<String, Boolean>();
        VcsCommand cmd = vce.getCommand();
        boolean doRefreshCurrent = VcsCommandIO.getBooleanProperty(cmd, "refreshCurrentFolder");
        boolean doRefreshParent = VcsCommandIO.getBooleanProperty(cmd, "refreshParentFolder");
        if (doRefreshCurrent || doRefreshParent) {
            Collection files = vce.getFiles();
            Iterator it = files.iterator();
            while (it.hasNext()) {
                Boolean rec;
                String fullPath = (String)it.next();
                String dir = VcsUtilities.getDirNamePart(fullPath);
                String file = VcsUtilities.getFileNamePart(fullPath);
                Boolean[] recursively = new Boolean[]{Boolean.FALSE};
                String folderName = CommandExecutorSupport.getFolderToRefresh(fileSystem, vce.getExec(), cmd, dir, file, foldersOnly, doRefreshCurrent, doRefreshParent, recursively);
                if (folderName == null || Boolean.TRUE.equals(rec = (Boolean)foldersToRefresh.get(folderName))) continue;
                foldersToRefresh.put(folderName, recursively[0]);
            }
        }
        return foldersToRefresh;
    }

    private static String getFolderToRefresh(VcsFileSystem fileSystem, String exec, VcsCommand cmd, String dir, String file, boolean foldersOnly, boolean doRefreshCurrent, boolean doRefreshParent, Boolean[] recursively) {
        FileCacheProvider cache = fileSystem.getCacheProvider();
        FileStatusProvider statusProvider = fileSystem.getStatusProvider();
        if (statusProvider == null) {
            return null;
        }
        if (doRefreshCurrent || doRefreshParent) {
            String refreshPath = dir;
            refreshPath.replace(File.separatorChar, '/');
            String refreshPathFile = refreshPath + (refreshPath.length() > 0 ? "/" : "") + file;
            if (!doRefreshParent && cache != null && cache.isDir(refreshPathFile)) {
                refreshPath = refreshPathFile;
            }
            String patternMatch = (String)cmd.getProperty("refreshRecursivelyPatternMatched");
            String patternUnmatch = (String)cmd.getProperty("refreshRecursivelyPatternUnmatched");
            boolean rec = exec != null && (cache == null || !cache.isFile(refreshPathFile) && (cache.isDir(refreshPathFile) || fileSystem.folder(refreshPathFile))) && (patternMatch != null && patternMatch.length() > 0 && exec.indexOf(patternMatch) >= 0 || patternUnmatch != null && patternUnmatch.length() > 0 && exec.indexOf(patternUnmatch) < 0);
            Boolean bl = recursively[0] = rec ? Boolean.TRUE : Boolean.FALSE;
            if (!foldersOnly || cache.isDir(refreshPath)) {
                return refreshPath;
            }
            return null;
        }
        return null;
    }

    public static void checkRevisionChanges(VcsFileSystem fileSystem, VcsCommandExecutor vce) {
        int whatChanged = 0;
        String changedRevision = null;
        VcsCommand cmd = vce.getCommand();
        if (VcsCommandIO.getBooleanPropertyAssumeDefault(cmd, "changingNumRevisions")) {
            whatChanged = 4;
        }
        if (VcsCommandIO.getBooleanPropertyAssumeDefault(cmd, "changingRevision")) {
            whatChanged = 1;
            Object varName = cmd.getProperty("changedRevisionVarName");
            if (varName != null) {
                changedRevision = (String)vce.getVariables().get(varName);
            }
        }
        if (whatChanged != 0) {
            String[] files = vce.getFiles().toArray(new String[0]);
            int i = 0;
            while (i < files.length) {
                FileObject fo = fileSystem.findResource(files[i]);
                if (fo == null) {
                    fo = fileSystem.getVersioningFileSystem().findResource(files[i]);
                }
                if (fo != null) {
                    RevisionEvent event = new RevisionEvent(fo);
                    event.setRevisionChangeID(whatChanged);
                    event.setChangedRevision(changedRevision);
                    fileSystem.fireRevisionsChanged(event);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Table needPromptForUserParams(VcsFileSystem fileSystem, String exec, Hashtable vars, Hashtable varNames, Hashtable userParamsIndexes, VcsCommand cmd, boolean acceptUserParams) {
        int index2;
        String defaultParam;
        String varName;
        int varEnd;
        int num;
        char cnum;
        int varBegin;
        int index;
        Table results = new Table();
        String search = "${USER_GLOBAL_PARAM";
        int pos = 0;
        String[] userParamsLabels = fileSystem.getUserParamsLabels();
        String[] userParams = fileSystem.getUserParams();
        String[] userLocalParamsLabels = fileSystem.getUserLocalParamsLabels();
        while ((index = exec.indexOf(search, pos)) >= 0) {
            void var10_13;
            varBegin = var10_13 + 2;
            index = var10_13 + search.length();
            cnum = exec.charAt(index);
            num = 1;
            if (Character.isDigit(cnum)) {
                num = Character.digit(cnum, 10);
                ++index;
            }
            --num;
            varEnd = VcsUtilities.getPairIndex(exec, index, '{', '}');
            if (varEnd < 0) {
                pos = index;
                continue;
            }
            varName = exec.substring(varBegin, varEnd);
            defaultParam = "";
            if (exec.charAt(index) == '(' && (index2 = VcsUtilities.getPairIndex(exec, ++index, '(', ')')) > 0) {
                defaultParam = exec.substring(index, index2);
            }
            if (acceptUserParams && userParamsLabels != null) {
                if (num >= userParamsLabels.length) {
                    num = userParamsLabels.length - 1;
                }
                if (userParams[num] != null) {
                    defaultParam = userParams[num];
                }
                results.put(userParamsLabels[num], defaultParam);
                varNames.put(varName, userParamsLabels[num]);
                userParamsIndexes.put(varName, new Integer(num));
            } else {
                vars.put(varName, defaultParam);
            }
            pos = varEnd;
        }
        search = "${USER_PARAM";
        pos = 0;
        while ((index = exec.indexOf(search, pos)) >= 0) {
            varBegin = index + 2;
            cnum = exec.charAt(index += search.length());
            num = 1;
            if (Character.isDigit(cnum)) {
                num = Character.digit(cnum, 10);
                ++index;
            }
            --num;
            varEnd = VcsUtilities.getPairIndex(exec, index, '{', '}');
            if (varEnd < 0) {
                pos = index;
                continue;
            }
            varName = exec.substring(varBegin, varEnd);
            defaultParam = "";
            if (exec.charAt(index) == '(' && (index2 = VcsUtilities.getPairIndex(exec, ++index, '(', ')')) > 0) {
                defaultParam = exec.substring(index, index2);
            }
            if (acceptUserParams && userLocalParamsLabels != null) {
                String[] cmdUserParams = (String[])cmd.getProperty("userParams");
                if (cmdUserParams == null) {
                    cmdUserParams = new String[userLocalParamsLabels.length];
                }
                cmd.setProperty("userParams", cmdUserParams);
                if (num >= userLocalParamsLabels.length) {
                    num = userLocalParamsLabels.length - 1;
                }
                if (cmdUserParams[num] != null) {
                    defaultParam = cmdUserParams[num];
                }
                results.put(userLocalParamsLabels[num], defaultParam);
                varNames.put(varName, userLocalParamsLabels[num]);
                userParamsIndexes.put(varName, new Integer(-num - 1));
            } else {
                vars.put(varName, defaultParam);
            }
            pos = varEnd;
        }
        return results;
    }

    private static boolean needPromptForPR(String name, String exec, Hashtable vars) {
        boolean result = false;
        String oldPassword = (String)vars.get("PASSWORD");
        vars.put("PASSWORD", "");
        String oldReason = (String)vars.get("REASON");
        vars.put("REASON", "");
        String test = "variable_must_be_prompt_for";
        vars.put(name, test);
        String s = Variables.expand(vars, exec, false);
        boolean bl = result = s.indexOf(test) >= 0;
        if (oldPassword != null) {
            vars.put("PASSWORD", oldPassword);
        } else {
            vars.remove("PASSWORD");
        }
        if (oldReason != null) {
            vars.put("REASON", oldReason);
        } else {
            vars.remove("REASON");
        }
        return result;
    }

    private static void addComponentsWithPrecommands(VariableInputComponent component, ArrayList componentsWithPrecommands) {
        VariableInputComponent[] components;
        if (component.needsPreCommandPerform()) {
            componentsWithPrecommands.add(component);
        }
        if ((components = component.subComponents()) != null) {
            int i = 0;
            while (i < components.length) {
                CommandExecutorSupport.addComponentsWithPrecommands(components[i], componentsWithPrecommands);
                ++i;
            }
        }
    }

    private static void processPrecommands(VcsFileSystem fileSystem, Hashtable vars, VariableInputDescriptor inputDescriptor) throws UserCancelException {
        VariableInputComponent[] components = inputDescriptor.components();
        ArrayList componentsWithPrecommands = new ArrayList();
        int i = 0;
        while (i < components.length) {
            CommandExecutorSupport.addComponentsWithPrecommands(components[i], componentsWithPrecommands);
            ++i;
        }
        if (componentsWithPrecommands.size() > 0) {
            String[] defVals = new String[componentsWithPrecommands.size()];
            int i2 = 0;
            while (i2 < defVals.length) {
                defVals[i2] = ((VariableInputComponent)componentsWithPrecommands.get(i2)).getDefaultValue();
                ++i2;
            }
            PreCommandPerformer cmdPerf = new PreCommandPerformer(fileSystem, vars);
            String[] values = cmdPerf.process(defVals);
            int i3 = 0;
            while (i3 < values.length) {
                ((VariableInputComponent)componentsWithPrecommands.get(i3)).setValue(values[i3]);
                ++i3;
            }
        }
    }

    private static boolean showInputDescriptor(VariableInputDescriptor inputDescriptor, boolean isExpertMode, Map vars) {
        VariableInputComponent[] inputComponents = inputDescriptor.components();
        if (inputComponents.length == 0) {
            return false;
        }
        int i = 0;
        while (i < inputComponents.length) {
            if (VariableInputComponent.isVarConditionMatch(inputComponents[i].getVarConditions(), vars) && (inputComponents[i].isExpert() && isExpertMode || !inputComponents[i].isExpert() && inputComponents[i].getComponent() != 8)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String g(String s) {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$commands$CommandExecutorSupport == null ? (class$org$netbeans$modules$vcscore$commands$CommandExecutorSupport = CommandExecutorSupport.class$("org.netbeans.modules.vcscore.commands.CommandExecutorSupport")) : class$org$netbeans$modules$vcscore$commands$CommandExecutorSupport)).getString(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

