/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.commands;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import org.netbeans.api.vcs.commands.Command;
import org.netbeans.api.vcs.commands.CommandTask;
import org.netbeans.modules.vcscore.commands.CommandProcessListener;
import org.netbeans.modules.vcscore.commands.CommandProcessor;
import org.netbeans.modules.vcscore.commands.CommandTaskInfo;
import org.netbeans.modules.vcscore.commands.RegexOutputListener;
import org.netbeans.modules.vcscore.commands.TextOutputListener;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.commands.VcsDescribedTask;
import org.netbeans.spi.vcs.VcsCommandsProvider;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class CommandOutputCollector
implements CommandProcessListener {
    private static final int DEFAULT_NUM_OF_LINES_OF_OUTPUT_TO_COLLECT = 5000;
    private int numOfLinesOfOutputToCollect = 5000;
    private CommandProcessor commandProcessor;
    private VcsCommandExecutor vce;
    private long cmdId;
    private VcsCommandsProvider provider;
    private static final int NUM_OUTPUTS = 4;
    private static final String[] OUTPUT_FILE_ID = new String[]{"so", "eo", "sd", "ed"};
    private static final String RUNNING_FOLDER_PATH = "system/vcs/running/";
    private static final String FILE_PREFIX = "cmd";
    private static final String FILE_MIDFIX = "_";
    private static final String FILE_POSTFIX = ".txt";
    private static File runningFolder = null;
    private static ArrayList outputCollectorsToFree = new ArrayList();
    private static RequestProcessor.Task collectorsFreeTask = null;
    private ArrayList[] cmdOutput;
    private ArrayList[] cmdOutputListeners;
    private File[] outputFiles;
    private boolean finalized = false;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$commands$CommandOutputCollector;

    public CommandOutputCollector(CommandTask task, VcsCommandsProvider provider) {
        if (task instanceof VcsDescribedTask) {
            this.vce = ((VcsDescribedTask)((Object)task)).getExecutor();
        }
        this.provider = provider;
        this.commandProcessor = CommandProcessor.getInstance();
        this.cmdId = this.commandProcessor.getTaskID(task);
        this.outputFiles = new File[4];
        if (runningFolder == null) {
            CommandOutputCollector.initRunningFolder();
        }
        this.createOutputListeners();
        this.commandProcessor.addCommandProcessListener(this);
    }

    private static synchronized void initRunningFolder() {
        String userHome;
        if (runningFolder == null && !(runningFolder = new File(userHome = System.getProperty("netbeans.user"), RUNNING_FOLDER_PATH)).exists() && !runningFolder.mkdirs()) {
            runningFolder = new File(userHome);
        }
    }

    private void createOutputListeners() {
        this.cmdOutput = new ArrayList[4];
        this.cmdOutputListeners = new ArrayList[4];
        int i = 0;
        while (i < 4) {
            this.cmdOutput[i] = new ArrayList();
            this.cmdOutputListeners[i] = new ArrayList();
            ++i;
        }
        if (this.vce != null) {
            this.vce.addTextOutputListener(new CollectingOutputListener(0));
            this.vce.addTextErrorListener(new CollectingOutputListener(1));
            this.vce.addRegexOutputListener(new CollectingOutputListener(0));
            this.vce.addRegexErrorListener(new CollectingOutputListener(1));
        }
    }

    private void addOutput(int outputId, Object output) {
        ArrayList arrayList = this.cmdOutput[outputId];
        synchronized (arrayList) {
            this.cmdOutput[outputId].add(output);
            if (this.cmdOutput[outputId].size() > this.numOfLinesOfOutputToCollect) {
                this.flushOutput(outputId);
                this.cmdOutput[outputId].clear();
            }
            if (output instanceof String) {
                String line = (String)output;
                Iterator it = ((AbstractList)this.cmdOutputListeners[outputId]).iterator();
                while (it.hasNext()) {
                    ((TextOutputListener)it.next()).outputLine(line);
                }
            } else if (output instanceof String[]) {
                String[] elements = (String[])output;
                Iterator it = ((AbstractList)this.cmdOutputListeners[outputId]).iterator();
                while (it.hasNext()) {
                    ((RegexOutputListener)it.next()).outputMatchedGroups(elements);
                }
            }
        }
    }

    public VcsCommandsProvider getProvider() {
        return this.provider;
    }

    public void commandPreprocessed(Command cmd, boolean status) {
    }

    public void commandPreprocessing(Command cmd) {
    }

    public void commandStarting(CommandTaskInfo info) {
        VcsCommandExecutor vce = null;
        CommandTask task = info.getTask();
        if (task instanceof VcsDescribedTask) {
            vce = ((VcsDescribedTask)((Object)info.getTask())).getExecutor();
        }
        if (vce == null || !vce.equals(this.vce)) {
            return;
        }
        this.cmdId = this.commandProcessor.getTaskID(task);
    }

    public void commandDone(CommandTaskInfo info) {
        VcsCommandExecutor vce = null;
        if (info.getTask() instanceof VcsDescribedTask) {
            vce = ((VcsDescribedTask)((Object)info.getTask())).getExecutor();
        }
        if (vce == null || !vce.equals(this.vce)) {
            return;
        }
        Class clazz = class$org$netbeans$modules$vcscore$commands$CommandOutputCollector == null ? (class$org$netbeans$modules$vcscore$commands$CommandOutputCollector = CommandOutputCollector.class$("org.netbeans.modules.vcscore.commands.CommandOutputCollector")) : class$org$netbeans$modules$vcscore$commands$CommandOutputCollector;
        synchronized (clazz) {
            if (collectorsFreeTask == null) {
                collectorsFreeTask = new RequestProcessor().create(new Runnable(){
                    static /* synthetic */ Class class$org$netbeans$modules$vcscore$commands$CommandOutputCollector;

                    public void run() {
                        Class clazz = class$org$netbeans$modules$vcscore$commands$CommandOutputCollector == null ? (class$org$netbeans$modules$vcscore$commands$CommandOutputCollector = 1.class$("org.netbeans.modules.vcscore.commands.CommandOutputCollector")) : class$org$netbeans$modules$vcscore$commands$CommandOutputCollector;
                        synchronized (clazz) {
                            Iterator it = ((AbstractList)outputCollectorsToFree).iterator();
                            while (it.hasNext()) {
                                ((CommandOutputCollector)it.next()).freeCommandOutput();
                            }
                            outputCollectorsToFree.clear();
                        }
                    }

                    static /* synthetic */ Class class$(String x0) {
                        try {
                            return Class.forName(x0);
                        }
                        catch (ClassNotFoundException x1) {
                            throw new NoClassDefFoundError(x1.getMessage());
                        }
                    }
                });
                collectorsFreeTask.setPriority(1);
            }
            if (!this.finalized) {
                outputCollectorsToFree.add(this);
            }
        }
        collectorsFreeTask.schedule(5000);
        this.commandProcessor.removeCommandProcessListener(this);
    }

    private void freeCommandOutput() {
        if (this.cmdOutput == null) {
            return;
        }
        int i = 0;
        while (i < 4) {
            ArrayList arrayList = this.cmdOutput[i];
            synchronized (arrayList) {
                this.cmdOutputListeners[i] = null;
                this.flushOutput(i);
                this.cmdOutput[i] = null;
            }
            ++i;
        }
        this.cmdOutput = null;
    }

    private void addOutputListener(int outputId, Object listener) {
        this.sendCommandOutputFromFile(outputId, listener);
        if (this.cmdOutput != null && this.cmdOutput[outputId] != null) {
            ArrayList arrayList = this.cmdOutput[outputId];
            synchronized (arrayList) {
                Iterator it;
                EventListener l;
                if (this.cmdOutput == null || this.cmdOutput[outputId] == null) {
                    return;
                }
                if (listener instanceof TextOutputListener) {
                    l = (TextOutputListener)listener;
                    it = ((AbstractList)this.cmdOutput[outputId]).iterator();
                    while (it.hasNext()) {
                        l.outputLine((String)it.next());
                    }
                }
                if (listener instanceof RegexOutputListener) {
                    l = (RegexOutputListener)listener;
                    it = ((AbstractList)this.cmdOutput[outputId]).iterator();
                    while (it.hasNext()) {
                        l.outputMatchedGroups((String[])it.next());
                    }
                }
                if (this.cmdOutputListeners[outputId] != null) {
                    this.cmdOutputListeners[outputId].add(listener);
                }
            }
        }
    }

    private void addOutputListenerLazily(final int outputId, final Object listener) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                CommandOutputCollector.this.addOutputListener(outputId, listener);
            }
        });
    }

    public void addTextOutputListener(TextOutputListener l) {
        this.addOutputListenerLazily(0, l);
    }

    public void addTextErrorListener(TextOutputListener l) {
        this.addOutputListenerLazily(1, l);
    }

    public void addRegexOutputListener(RegexOutputListener l) {
        this.addOutputListenerLazily(2, l);
    }

    public synchronized void addRegexErrorListener(RegexOutputListener l) {
        this.addOutputListenerLazily(3, l);
    }

    private File createOutputFile(int outputId) {
        if (this.outputFiles[outputId] == null) {
            String file = FILE_PREFIX + this.cmdId + FILE_MIDFIX + OUTPUT_FILE_ID[outputId] + FILE_POSTFIX;
            this.outputFiles[outputId] = new File(runningFolder, file);
            try {
                this.outputFiles[outputId].delete();
                this.outputFiles[outputId].createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.outputFiles[outputId].deleteOnExit();
        }
        return this.outputFiles[outputId];
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void flushOutput(int outputId) {
        File outputFile = this.createOutputFile(outputId);
        BufferedWriter w = null;
        w = new BufferedWriter(new FileWriter(outputFile.getAbsolutePath(), true));
        Iterator it = ((AbstractList)this.cmdOutput[outputId]).iterator();
        while (it.hasNext()) {
            String line;
            Object output = it.next();
            if (output instanceof String) {
                line = (String)output;
            } else if (output instanceof String[]) {
                String[] elements = (String[])output;
                line = this.encodeElements(elements);
            } else {
                line = "";
            }
            w.write(line + "\n");
        }
        Object var9_9 = null;
        if (w == null) return;
        try {
            w.close();
            return;
        }
        catch (IOException exc2) {}
        return;
        {
            catch (IOException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
                Object var9_10 = null;
                if (w == null) return;
                try {
                    w.close();
                    return;
                }
                catch (IOException exc2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (w == null) throw throwable;
            try {
                w.close();
                throw throwable;
            }
            catch (IOException exc2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendCommandOutputFromFile(int outputId, Object listener) {
        String line;
        if (this.outputFiles[outputId] == null) {
            return;
        }
        BufferedReader r = null;
        r = new BufferedReader(new FileReader(this.outputFiles[outputId]));
        while ((line = r.readLine()) != null) {
            void var4_4;
            EventListener l;
            if (listener instanceof TextOutputListener) {
                l = (TextOutputListener)listener;
                l.outputLine((String)var4_4);
            }
            if (!(listener instanceof RegexOutputListener)) continue;
            l = (RegexOutputListener)listener;
            l.outputMatchedGroups(this.decodeElements((String)var4_4));
        }
        Object var7_7 = null;
        if (r == null) return;
        try {
            r.close();
            return;
        }
        catch (IOException exc2) {}
        return;
        {
            catch (IOException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
                Object var7_8 = null;
                if (r == null) return;
                try {
                    r.close();
                    return;
                }
                catch (IOException exc2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (r == null) throw throwable;
            try {
                r.close();
                throw throwable;
            }
            catch (IOException exc2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private String encodeElements(String[] elements) {
        String line = "";
        int i = 0;
        while (i < elements.length) {
            line = elements[i] != null ? line + Utilities.replaceString((String)elements[i], (String)"/", (String)" // ") + " / " : line + " /null/ ";
            ++i;
        }
        return line;
    }

    private String[] decodeElements(String line) {
        ArrayList<String> elements = new ArrayList<String>();
        int index = 0;
        int lastIndex = 0;
        while (true) {
            int sepLength;
            int index1 = line.indexOf(" / ", lastIndex);
            int index2 = line.indexOf(" /null/ ", lastIndex);
            if (index1 < 0 && index2 < 0) break;
            index = index1 >= 0 ? index1 : index2;
            if (index2 >= 0 && index2 < index) {
                index = index2;
                sepLength = " /null/ ".length();
            } else {
                sepLength = " / ".length();
            }
            String element = line.substring(lastIndex, index);
            elements.add(Utilities.replaceString((String)element, (String)" // ", (String)"/"));
            lastIndex = index + sepLength;
        }
        return elements.toArray(new String[0]);
    }

    protected void finalize() {
        this.finalized = true;
        Class clazz = class$org$netbeans$modules$vcscore$commands$CommandOutputCollector == null ? (class$org$netbeans$modules$vcscore$commands$CommandOutputCollector = CommandOutputCollector.class$("org.netbeans.modules.vcscore.commands.CommandOutputCollector")) : class$org$netbeans$modules$vcscore$commands$CommandOutputCollector;
        synchronized (clazz) {
            ((AbstractCollection)outputCollectorsToFree).remove(this);
        }
        if (this.outputFiles != null) {
            int i = 0;
            while (i < 4) {
                if (this.outputFiles[i] != null) {
                    this.outputFiles[i].delete();
                }
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CollectingOutputListener
    implements TextOutputListener,
    RegexOutputListener {
        private int outIndex;

        public CollectingOutputListener(int outIndex) {
            this.outIndex = outIndex;
        }

        public void outputLine(String line) {
            CommandOutputCollector.this.addOutput(0 + this.outIndex, line);
        }

        public void outputMatchedGroups(String[] elements) {
            CommandOutputCollector.this.addOutput(2 + this.outIndex, elements);
        }
    }
}

