/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.commands;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ObjectStreamException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.netbeans.api.vcs.commands.CommandTask;
import org.netbeans.modules.vcscore.commands.CommandOutputPanel;
import org.netbeans.modules.vcscore.commands.CommandProcessor;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.commands.VcsCommandVisualizer;
import org.netbeans.modules.vcscore.commands.VcsDescribedTask;
import org.netbeans.modules.vcscore.util.TopComponentCloseListener;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class CommandOutputVisualizer
extends VcsCommandVisualizer {
    public static final String MODE_NAME = "Default VCS Command Output";
    private static final int MAX_BUFFER_SIZE = 240000;
    private static final int FAST_APPEND_SIZE = 8000;
    private static final int MAX_AREA_SIZE = 232000;
    private static RequestProcessor outputDisplayRequestProcessor;
    private static Hashtable outputDisplayStuff;
    private CommandOutputPanel outputPanel;
    private ArrayList closeListeners = new ArrayList();
    private CommandTask task;
    private VcsCommandExecutor vce;
    private ActionListener killListener = null;
    private static final long serialVersionUID = -8901790341334731237L;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer;

    protected CommandOutputVisualizer() {
        this.outputPanel = new CommandOutputPanel();
        this.setIcon(Utilities.loadImage((String)"org/netbeans/modules/vcscore/commands/commandOutputWindow.gif"));
        ((JComponent)((Object)this)).putClientProperty("PersistenceType", "Never");
        ((JComponent)((Object)this)).putClientProperty("TabPolicy", "HideWhenAlone");
        this.initComponents();
        Class clazz = class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer == null ? (class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer = CommandOutputVisualizer.class$("org.netbeans.modules.vcscore.commands.CommandOutputVisualizer")) : class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer;
        synchronized (clazz) {
            if (outputDisplayRequestProcessor == null) {
                outputDisplayRequestProcessor = new RequestProcessor("Output Display Request Processor");
                outputDisplayRequestProcessor.post((Runnable)new OutputDisplayer());
            }
        }
    }

    public CommandOutputVisualizer(VcsDescribedTask task) {
        this();
        this.vce = task.getExecutor();
        this.task = (CommandTask)((Object)task);
        this.killListener = new CommandKillListener();
        this.outputPanel.addKillActionListener(this.killListener);
        this.outputPanel.setExec(this.vce.getExec());
        String name = this.vce.getCommand().getDisplayName();
        if (name == null || name.length() == 0) {
            name = this.vce.getCommand().getName();
        }
        this.setName(MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer == null ? (class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer = CommandOutputVisualizer.class$("org.netbeans.modules.vcscore.commands.CommandOutputVisualizer")) : class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer)).getString("CommandOutputVisualizer.name"), name));
    }

    public CommandOutputVisualizer(ActionListener killListener, String execString, String name) {
        this();
        this.killListener = killListener;
        this.outputPanel.addKillActionListener(this.killListener);
        this.outputPanel.setExec(execString);
        this.setName(MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer == null ? (class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer = CommandOutputVisualizer.class$("org.netbeans.modules.vcscore.commands.CommandOutputVisualizer")) : class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer)).getString("CommandOutputVisualizer.name"), name));
    }

    private void initComponents() {
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        ((Container)((Object)this)).add(this.outputPanel, gridBagConstraints);
        this.outputPanel.setStatus(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer == null ? (class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer = CommandOutputVisualizer.class$("org.netbeans.modules.vcscore.commands.CommandOutputVisualizer")) : class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer)).getString("CommandExitStatus.running"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer == null ? (class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer = CommandOutputVisualizer.class$("org.netbeans.modules.vcscore.commands.CommandOutputVisualizer")) : class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer), (String)"ACSN_CommandOutputVisualizer"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer == null ? (class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer = CommandOutputVisualizer.class$("org.netbeans.modules.vcscore.commands.CommandOutputVisualizer")) : class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer), (String)"ACSD_CommandOutputVisualizer"));
    }

    public boolean openAfterCommandFinish() {
        return false;
    }

    public void open(Workspace workspace) {
        Mode myMode;
        if (workspace == null) {
            workspace = WindowManager.getDefault().getCurrentWorkspace();
        }
        if ((myMode = workspace.findMode((TopComponent)this)) == null) {
            String modeName = NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer == null ? (class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer = CommandOutputVisualizer.class$("org.netbeans.modules.vcscore.commands.CommandOutputVisualizer")) : class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer)).getString("CommandOutputVisualizer.modeName");
            myMode = workspace.createMode(MODE_NAME, modeName, null);
            myMode.dockInto((TopComponent)this);
        }
        super.open(workspace);
        this.requestFocus();
    }

    protected void componentActivated() {
        super.componentActivated();
        this.outputPanel.componentActivated();
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        this.outputPanel.componentDeactivated();
    }

    protected Object writeReplace() throws ObjectStreamException {
        this.close();
        return null;
    }

    private void appendLineToArea(JTextArea area, String line) {
        Hashtable hashtable = outputDisplayStuff;
        synchronized (hashtable) {
            StringBuffer buffer = (StringBuffer)outputDisplayStuff.get(area);
            if (buffer == null) {
                buffer = new StringBuffer(line + "\n");
                Hashtable hashtable2 = outputDisplayStuff;
                synchronized (hashtable2) {
                    outputDisplayStuff.put(area, buffer);
                    if (outputDisplayStuff.size() == 1) {
                        outputDisplayStuff.notify();
                    }
                }
            } else {
                buffer.append(line + "\n");
                if (buffer.length() > 240000) {
                    buffer.delete(0, buffer.length() - 232000 - 1);
                }
            }
        }
    }

    public void stdOutputLine(String line) {
        this.appendLineToArea(this.outputPanel.getStdOutputArea(), line);
    }

    public void errOutputLine(String line) {
        this.appendLineToArea(this.outputPanel.getErrOutputArea(), line);
    }

    public void stdOutputData(String[] data) {
        this.appendLineToArea(this.outputPanel.getStdDataOutputArea(), VcsUtilities.arrayToString(data));
    }

    public void errOutputData(String[] data) {
        this.appendLineToArea(this.outputPanel.getErrDataOutputArea(), VcsUtilities.arrayToString(data));
    }

    public void setExitStatus(int exit) {
        this.outputPanel.setStatus(CommandProcessor.getExitStatusString(exit));
        this.outputPanel.commandFinished(true);
    }

    public void addCloseListener(TopComponentCloseListener l) {
        ArrayList arrayList = this.closeListeners;
        synchronized (arrayList) {
            this.closeListeners.add(l);
        }
    }

    public boolean canClose(Workspace workspace, boolean last) {
        boolean can = super.canClose(workspace, last);
        if (last && can) {
            this.closing();
        }
        return can;
    }

    private void closing() {
        this.outputPanel.removeKillActionListener(this.killListener);
        ArrayList arrayList = this.closeListeners;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this.closeListeners).iterator();
            while (it.hasNext()) {
                TopComponentCloseListener l = (TopComponentCloseListener)it.next();
                l.closing();
            }
            this.closeListeners.clear();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class OutputDisplayer
    implements Runnable {
        private Random random;

        public OutputDisplayer() {
            outputDisplayStuff = new Hashtable();
            this.random = new Random();
        }

        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                int start;
                String replace;
                String append;
                JTextArea area;
                int index = this.random.nextInt(outputDisplayStuff.size());
                Enumeration keysEnum = outputDisplayStuff.keys();
                do {
                    area = (JTextArea)keysEnum.nextElement();
                } while (--index >= 0);
                int end = area.getDocument().getLength();
                Hashtable hashtable = outputDisplayStuff;
                synchronized (hashtable) {
                    StringBuffer buffer = (StringBuffer)outputDisplayStuff.get(area);
                    if (buffer.length() >= 232000) {
                        append = null;
                        replace = buffer.substring(buffer.length() - 8000, buffer.length()).toString();
                        buffer.delete(0, replace.length());
                        start = end - replace.length();
                        if (start < 0) {
                            start = 0;
                        }
                    } else {
                        buffer = (StringBuffer)outputDisplayStuff.remove(area);
                        append = buffer.toString();
                        start = 0;
                        end = (end += append.length()) < 232000 ? 0 : end - 232000 + 8000;
                        replace = null;
                    }
                }
                if (append != null) {
                    area.append(append);
                }
                if (end > 0) {
                    area.replaceRange(replace, start, end);
                }
            } else {
                block12: while (true) {
                    Hashtable hashtable = outputDisplayStuff;
                    synchronized (hashtable) {
                        if (outputDisplayStuff.size() == 0) {
                            try {
                                outputDisplayStuff.wait();
                            }
                            catch (InterruptedException iexc) {
                                break;
                            }
                        }
                    }
                    do {
                        try {
                            SwingUtilities.invokeAndWait(this);
                            Thread.currentThread();
                            Thread.yield();
                            Thread.currentThread();
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException iexc) {
                            continue block12;
                        }
                        catch (InvocationTargetException itexc) {
                            ErrorManager.getDefault().notify((Throwable)itexc);
                            continue block12;
                        }
                    } while (outputDisplayStuff.size() > 0);
                }
            }
        }
    }

    class CommandKillListener
    implements ActionListener {
        static /* synthetic */ Class class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer;

        CommandKillListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            String name = CommandOutputVisualizer.this.vce.getCommand().getDisplayName();
            if (name == null || name.length() == 0) {
                name = CommandOutputVisualizer.this.vce.getCommand().getName();
            }
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer == null ? (class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer = CommandKillListener.class$("org.netbeans.modules.vcscore.commands.CommandOutputVisualizer")) : class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer)).getString("CommandOutputVisualizer.killCommand"), name), 2);
            if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
                CommandOutputVisualizer.this.task.stop();
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

