/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.commands;

import java.util.ArrayList;
import java.util.Hashtable;
import org.netbeans.api.vcs.VcsManager;
import org.netbeans.api.vcs.commands.CommandTask;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cmdline.ExecuteCommand;
import org.netbeans.modules.vcscore.commands.CommandProcessor;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.commands.VcsDescribedCommand;
import org.openide.util.WeakSet;

public class CommandsPool {
    public static final int PREPROCESS_CANCELLED = 0;
    public static final int PREPROCESS_NEXT_FILE = 1;
    public static final int PREPROCESS_DONE = 2;
    private static final int MAX_NUM_RUNNING_COMMANDS = 10;
    private static final int MAX_NUM_RUNNING_LISTS = 7;
    private static long lastCommandID = 0L;
    private static CommandsPool instance = null;
    private Hashtable commandsWrappers;
    private ArrayList commandsToRun;
    private ArrayList commandsWaitQueue;
    private ArrayList commandsRunning;
    private ArrayList commandsExceptionallyRunning;
    private WeakSet cancelledCommandExecutors;
    private Hashtable outputContainers;
    private Hashtable outputVisualizers;
    private ArrayList commandsFinished;
    private ArrayList fsWithCmdsRemovedOnRequest;
    private int numRunningListCommands = 0;
    private CommandProcessor processor;
    private boolean collectOutput = true;
    private boolean collectErrOutput = true;
    private ArrayList commandListeners = new ArrayList();
    private boolean execStarterLoopStarted = false;
    private boolean execStarterLoopRunning = true;

    private CommandsPool() {
        this.commandsToRun = new ArrayList();
        this.commandsRunning = new ArrayList();
        this.commandsExceptionallyRunning = new ArrayList();
        this.commandsFinished = new ArrayList();
        this.commandsWaitQueue = new ArrayList();
        this.commandsWrappers = new Hashtable();
        this.cancelledCommandExecutors = new WeakSet();
        this.outputContainers = new Hashtable();
        this.outputVisualizers = new Hashtable();
        this.fsWithCmdsRemovedOnRequest = new ArrayList();
        this.processor = CommandProcessor.getInstance();
    }

    public static synchronized CommandsPool getInstance() {
        if (instance == null) {
            instance = new CommandsPool();
        }
        return instance;
    }

    protected void finalize() {
        this.cleanup();
    }

    public void cleanup() {
    }

    public int preprocessCommand(VcsCommandExecutor vce, Hashtable vars, VcsFileSystem fileSystem) {
        if (vce instanceof ExecuteCommand) {
            VcsDescribedCommand cmd = ((ExecuteCommand)vce).getDescribedCommand();
            return VcsManager.getDefault().showCustomizer(cmd) ? 2 : 0;
        }
        return 2;
    }

    public void startExecutor(VcsCommandExecutor vce) {
        this.startExecutor(vce, null);
    }

    public void startExecutor(VcsCommandExecutor vce, VcsFileSystem fileSystem) {
        if (this.cancelledCommandExecutors.contains((Object)vce)) {
            return;
        }
        if (!(vce instanceof ExecuteCommand)) {
            return;
        }
        VcsDescribedCommand cmd = ((ExecuteCommand)vce).getDescribedCommand();
        cmd.execute();
    }

    public boolean isWaiting(VcsCommandExecutor vce) {
        if (!(vce instanceof ExecuteCommand)) {
            return false;
        }
        CommandTask task = ((ExecuteCommand)vce).getTask();
        return !task.isFinished() && !task.isRunning();
    }

    public boolean isRunning(VcsCommandExecutor vce) {
        if (!(vce instanceof ExecuteCommand)) {
            return false;
        }
        CommandTask task = ((ExecuteCommand)vce).getTask();
        return !task.isFinished();
    }

    public void waitToFinish(VcsCommandExecutor vce) throws InterruptedException {
        if (!(vce instanceof ExecuteCommand)) {
            return;
        }
        CommandTask task = ((ExecuteCommand)vce).getTask();
        task.waitFinished(0);
    }

    public void kill(VcsCommandExecutor vce) {
        if (!(vce instanceof ExecuteCommand)) {
            return;
        }
        CommandTask task = ((ExecuteCommand)vce).getTask();
        task.stop();
    }
}

