/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.commands;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import org.netbeans.api.vcs.VcsManager;
import org.netbeans.api.vcs.commands.CommandTask;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.commands.RegexErrorListener;
import org.netbeans.modules.vcscore.commands.RegexOutputListener;
import org.netbeans.modules.vcscore.commands.VcsDescribedCommand;
import org.netbeans.modules.vcscore.util.Debug;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.openide.ErrorManager;
import org.openide.util.UserCancelException;

public class PreCommandPerformer {
    private Debug E;
    private Debug D;
    public static final String INSERT_OUTPUT = "{INSERT_OUTPUT_OF_";
    public static final String INSERT_ERROR = "{INSERT_ERROR_OF_";
    public static final String FILE_OUTPUT = "{FILE_OUTPUT_OF_";
    private static final String TEMP_FILE_PREFIX = "tempVcsCmd";
    private static final String TEMP_FILE_SUFFIX = "output";
    private VcsFileSystem fileSystem;
    private Hashtable vars;
    private volatile Vector[] preCommandOutput;
    private volatile Vector[] preCommandError;
    private static final String NL_TRUE = "true";
    private static final String NL_FALSE = "false";

    public PreCommandPerformer(VcsFileSystem fileSystem, Hashtable vars) {
        this.D = this.E = new Debug("PreCommandPerformer", true);
        this.fileSystem = fileSystem;
        this.vars = vars;
    }

    public String process(String exec) throws UserCancelException {
        return this.process(exec, null);
    }

    public String process(String exec, Collection cmdExitStates) throws UserCancelException {
        if (exec == null) {
            return null;
        }
        ArrayList commands = this.findPreCommands(exec);
        String[] commandNames = new TreeSet(commands).toArray(new String[0]);
        Collection exiStates = this.processPreCommands(commandNames);
        if (cmdExitStates != null) {
            cmdExitStates.clear();
            cmdExitStates.addAll(exiStates);
        }
        exec = this.insertPreCommandsOutput(exec, commandNames);
        return exec;
    }

    public String[] process(String[] execs) throws UserCancelException {
        if (execs == null) {
            return null;
        }
        String[] processed = new String[execs.length];
        String concatenation = VcsUtilities.array2string(execs);
        ArrayList commands = this.findPreCommands(concatenation);
        String[] commandNames = new TreeSet(commands).toArray(new String[0]);
        this.processPreCommands(commandNames);
        int i = 0;
        while (i < execs.length) {
            processed[i] = this.insertPreCommandsOutput(execs[i], commandNames);
            ++i;
        }
        return processed;
    }

    private ArrayList findPreCommands(String exec) {
        ArrayList<String> commands = new ArrayList<String>();
        String[] outputs = new String[]{INSERT_OUTPUT, INSERT_ERROR, FILE_OUTPUT};
        int out = 0;
        while (out < outputs.length) {
            int i;
            int index = 0;
            do {
                int end;
                if ((i = exec.indexOf(outputs[out], index)) < 0 || (end = exec.indexOf(40, i += outputs[out].length())) <= 0) continue;
                String name = exec.substring(i, end);
                commands.add(name);
            } while ((index = i) >= 0);
            ++out;
        }
        return commands;
    }

    /*
     * Unable to fully structure code
     */
    private Collection processPreCommands(String[] preCommands) throws UserCancelException {
        this.preCommandOutput = new Vector[preCommands.length];
        this.preCommandError = new Vector[preCommands.length];
        runningExecutors = new ArrayList<CommandTask>();
        i = 0;
        while (i < preCommands.length) {
            cmdName = preCommands[i];
            cmdSupport = this.fileSystem.getCommandSupport(cmdName);
            if (cmdSupport != null) {
                cmd = cmdSupport.createCommand();
                this.preCommandOutput[i] = new Vector<E>();
                this.preCommandError[i] = new Vector<E>();
                if (cmd instanceof VcsDescribedCommand) {
                    ((VcsDescribedCommand)cmd).setAdditionalVariables(this.vars);
                    ((VcsDescribedCommand)cmd).addRegexOutputListener(new DataOutputContainer(i));
                    ((VcsDescribedCommand)cmd).addRegexErrorListener(new DataErrorOutputContainer(i));
                }
                if (!VcsManager.getDefault().showCustomizer(cmd)) {
                    throw new UserCancelException();
                }
                task = cmd.execute();
                runningExecutors.add(task);
            }
            ++i;
        }
        exitStates = new ArrayList<Boolean>();
        while (runningExecutors.size() > 0) {
            block11: {
                task = (CommandTask)runningExecutors.get(0);
                try {
                    task.waitFinished(0);
                    break block11;
                }
                catch (InterruptedException iexc) {
                    r = 0;
                    ** while (r < runningExecutors.size())
                }
lbl-1000:
                // 1 sources

                {
                    rtask = (CommandTask)runningExecutors.get(r);
                    if (!task.isFinished()) {
                        task.stop();
                        exitStates.add(Boolean.FALSE);
                    } else {
                        exitStates.add(rtask.getExitStatus() == 0 ? Boolean.TRUE : Boolean.FALSE);
                    }
                    ++r;
                    continue;
                }
lbl42:
                // 1 sources

                runningExecutors.clear();
                break;
            }
            runningExecutors.remove(0);
            if (task.getExitStatus() == 0) {
                exitStates.add(Boolean.TRUE);
                continue;
            }
            exitStates.add(Boolean.FALSE);
        }
        return exitStates;
    }

    private String insertPreCommandsOutput(String exec, String[] commands) {
        int endOfInsert;
        int where;
        String name;
        int end;
        int begin;
        int i;
        int index = 0;
        do {
            if ((i = exec.indexOf(INSERT_OUTPUT, index)) < 0) continue;
            begin = i;
            end = exec.indexOf(40, i += INSERT_OUTPUT.length());
            if (end <= 0) continue;
            name = exec.substring(i, end);
            where = Arrays.binarySearch(commands, name);
            endOfInsert = exec.indexOf(")}", end);
            if (endOfInsert <= 0) continue;
            exec = this.insertOutput(exec, begin, endOfInsert + ")}".length(), exec.substring(end + 1, endOfInsert), where, this.preCommandOutput);
        } while ((index = i) >= 0);
        index = 0;
        do {
            if ((i = exec.indexOf(INSERT_ERROR, index)) < 0) continue;
            begin = i;
            end = exec.indexOf(40, i += INSERT_ERROR.length());
            if (end <= 0) continue;
            name = exec.substring(i, end);
            where = Arrays.binarySearch(commands, name);
            endOfInsert = exec.indexOf(")}", end);
            if (endOfInsert <= 0) continue;
            exec = this.insertOutput(exec, begin, endOfInsert + ")}".length(), exec.substring(end + 1, endOfInsert), where, this.preCommandError);
        } while ((index = i) >= 0);
        index = 0;
        do {
            if ((i = exec.indexOf(FILE_OUTPUT, index)) < 0) continue;
            begin = i;
            end = exec.indexOf(40, i += FILE_OUTPUT.length());
            if (end <= 0) continue;
            name = exec.substring(i, end);
            where = Arrays.binarySearch(commands, name);
            endOfInsert = exec.indexOf(")}", end);
            if (endOfInsert <= 0) continue;
            exec = this.fileOutput(exec, begin, endOfInsert + ")}".length(), exec.substring(end + 1, endOfInsert), where, name);
        } while ((index = i) >= 0);
        return exec;
    }

    private String insertOutput(String exec, int begin, int end, String whichElement, int whichOutput, Vector[] preCommandOutput) {
        StringBuffer insertion = new StringBuffer(exec.substring(0, begin));
        boolean insertNewLine = false;
        int maxFirstLines = -1;
        int maxLastLines = -1;
        int tindex = whichElement.indexOf(NL_TRUE);
        if (tindex > 0) {
            insertNewLine = true;
        } else {
            tindex = whichElement.indexOf(NL_FALSE);
            if (tindex > 0) {
                insertNewLine = false;
            }
        }
        if (tindex > 0) {
            int tend = tindex + NL_TRUE.length();
            while (tend < whichElement.length() && whichElement.charAt(tend) != ',') {
                ++end;
            }
            whichElement = whichElement.substring(0, tindex) + (++tend < whichElement.length() ? whichElement.substring(tend) : "");
        }
        String nl = insertNewLine ? "\n" : "".intern();
        int commaIndex = whichElement.indexOf(44);
        if (commaIndex > 0) {
            try {
                int commaIndex2 = whichElement.indexOf(44, commaIndex + 1);
                if (commaIndex2 < 0) {
                    commaIndex2 = whichElement.length();
                }
                maxFirstLines = Integer.parseInt(whichElement.substring(commaIndex + 1, commaIndex2).trim());
                if (commaIndex2 < whichElement.length()) {
                    maxLastLines = Integer.parseInt(whichElement.substring(commaIndex2 + 1).trim());
                }
                whichElement = whichElement.substring(0, commaIndex).trim();
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
        }
        try {
            int index = Integer.parseInt(whichElement);
            int line = 0;
            ArrayList<String> lastLines = null;
            if (maxLastLines > 0) {
                lastLines = new ArrayList<String>();
            }
            boolean linesCut = false;
            Enumeration enumeration = preCommandOutput[whichOutput].elements();
            while (enumeration.hasMoreElements()) {
                String[] elements = (String[])enumeration.nextElement();
                if (elements.length > index && elements[index] != null) {
                    if (maxFirstLines > 0) {
                        if (line < maxFirstLines) {
                            insertion.append(elements[index] + nl);
                        } else {
                            linesCut = true;
                            if (maxLastLines > 0) {
                                lastLines.add(elements[index]);
                                if (lastLines.size() > maxLastLines) {
                                    lastLines.remove(0);
                                }
                            }
                        }
                    } else {
                        insertion.append(elements[index] + nl);
                    }
                }
                ++line;
            }
            if (linesCut) {
                insertion.append("..." + nl);
                if (lastLines != null) {
                    int i = 0;
                    while (i < lastLines.size()) {
                        insertion.append(lastLines.get(i) + nl);
                        ++i;
                    }
                }
            }
        }
        catch (NumberFormatException exc) {
            // empty catch block
        }
        insertion.append(exec.substring(end, exec.length()));
        return insertion.toString();
    }

    private String fileOutput(String exec, int begin, int end, String whichElement, int whichOutput, String cmdName) {
        int index;
        BufferedWriter writer;
        File outputFile;
        try {
            outputFile = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
            outputFile.deleteOnExit();
            writer = new BufferedWriter(new FileWriter(outputFile));
        }
        catch (IOException ioexc) {
            ErrorManager.getDefault().notify((Throwable)ioexc);
            return exec;
        }
        try {
            index = Integer.parseInt(whichElement);
        }
        catch (NumberFormatException exc) {
            ErrorManager.getDefault().notify((Throwable)exc);
            return exec;
        }
        try {
            Enumeration enumeration = this.preCommandOutput[whichOutput].elements();
            while (enumeration.hasMoreElements()) {
                String[] elements = (String[])enumeration.nextElement();
                if (elements.length <= index) continue;
                writer.write((elements[index] != null ? elements[index] : "") + "\n");
            }
            ((Writer)writer).close();
        }
        catch (IOException ioexc) {
            ErrorManager.getDefault().notify((Throwable)ioexc);
            return exec;
        }
        if (this.preCommandOutput[whichOutput].size() == 0) {
            this.vars.put("FILE_EMPTY_OUTPUT_OF_" + cmdName + whichElement, NL_TRUE);
        }
        return exec.substring(0, begin) + outputFile.getAbsolutePath() + exec.substring(end, exec.length());
    }

    private final class DataErrorOutputContainer
    implements RegexErrorListener {
        private int index;

        public DataErrorOutputContainer(int index) {
            this.index = index;
        }

        public void outputMatchedGroups(String[] elements) {
            PreCommandPerformer.this.preCommandError[this.index].add(elements);
        }
    }

    private final class DataOutputContainer
    implements RegexOutputListener {
        private int index;

        public DataOutputContainer(int index) {
            this.index = index;
        }

        public void outputMatchedGroups(String[] elements) {
            PreCommandPerformer.this.preCommandOutput[this.index].add(elements);
        }
    }
}

