/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.grouping;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import org.netbeans.modules.vcscore.grouping.VcsGroupNode;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;

public class MainVcsGroupChildren
extends Children.Keys {
    private VcsGroupFileChangeList fsListener = new VcsGroupFileChangeList();
    private FileChangeListener wfsListener = WeakListener.fileChange((FileChangeListener)this.fsListener, null);
    private FileObject rootFo;
    private static final String DEFAULT_FOLDER_NAME = "default";
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$grouping$MainVcsGroupChildren;

    public MainVcsGroupChildren() {
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        this.rootFo = fs.findResource("vcs/Groups");
        if (this.rootFo != null) {
            this.rootFo.addFileChangeListener((FileChangeListener)this.fsListener);
        }
    }

    public static DataFolder getMainVcsGroupFolder() {
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject rootFo = fs.findResource("vcs/Groups");
        DataFolder fold = null;
        try {
            fold = (DataFolder)DataObject.find((FileObject)rootFo);
        }
        catch (DataObjectNotFoundException exc) {
            return null;
        }
        return fold;
    }

    VcsGroupNode getDefaultGroupNode() {
        Node[] nodes = this.getNodes();
        int i = 0;
        while (i < nodes.length) {
            FileObject fo;
            DataObject dob = (DataObject)nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? MainVcsGroupChildren.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (dob != null && (fo = dob.getPrimaryFile()).getName().equalsIgnoreCase(DEFAULT_FOLDER_NAME)) {
                return (VcsGroupNode)nodes[i];
            }
            ++i;
        }
        try {
            FileObject props = this.rootFo.getFileObject(DEFAULT_FOLDER_NAME, "properties");
            if (props == null) {
                props = this.rootFo.createData(DEFAULT_FOLDER_NAME, "properties");
            }
            PrintWriter writer = new PrintWriter(props.getOutputStream(props.lock()));
            writer.println("name=" + NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$grouping$MainVcsGroupChildren == null ? (class$org$netbeans$modules$vcscore$grouping$MainVcsGroupChildren = MainVcsGroupChildren.class$("org.netbeans.modules.vcscore.grouping.MainVcsGroupChildren")) : class$org$netbeans$modules$vcscore$grouping$MainVcsGroupChildren)).getString("LBL_DefaultGroupName"));
            writer.close();
            FileObject group = this.rootFo.getFileObject(DEFAULT_FOLDER_NAME);
            if (group == null) {
                this.rootFo.createFolder(DEFAULT_FOLDER_NAME);
            }
        }
        catch (IOException exc) {
            ErrorManager manager = ErrorManager.getDefault();
            manager.notify(16, (Throwable)exc);
            return null;
        }
        this.refreshAll();
        return this.getDefaultGroupNode();
    }

    private Node createVcsGroupNode(FileObject fo) {
        DataFolder fold = null;
        try {
            fold = (DataFolder)DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException exc) {
            return null;
        }
        VcsGroupNode node = new VcsGroupNode(fold);
        return node;
    }

    protected void addNotify() {
        this.setKeys(this.getGroups());
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
    }

    private void refreshAll() {
        this.setKeys(this.getGroups());
    }

    private Collection getGroups() {
        Enumeration enumeration;
        LinkedList<FileObject> grList = new LinkedList<FileObject>();
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        this.rootFo = fs.findResource("vcs/Groups");
        if (this.rootFo != null && (enumeration = this.rootFo.getChildren(false)) != null) {
            while (enumeration.hasMoreElements()) {
                FileObject fo = (FileObject)enumeration.nextElement();
                if (!fo.isFolder()) continue;
                grList.add(fo);
            }
        }
        return grList;
    }

    protected Node[] createNodes(Object key) {
        DataFolder df = DataFolder.findFolder((FileObject)((FileObject)key));
        if (df != null) {
            return new Node[]{new VcsGroupNode(df)};
        }
        return new Node[0];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class VcsGroupFileChangeList
    extends FileChangeAdapter {
        private VcsGroupFileChangeList() {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            if (fileRenameEvent.getFile().isFolder()) {
                MainVcsGroupChildren.this.refreshAll();
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            if (fileEvent.getFile().isFolder()) {
                MainVcsGroupChildren.this.refreshAll();
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            if (fileEvent.getFile().isFolder()) {
                MainVcsGroupChildren.this.refreshAll();
            }
        }

        public void fileChanged(FileEvent fileEvent) {
        }
    }
}

