/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.grouping;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import org.netbeans.modules.vcscore.grouping.VcsGroupFileNode;
import org.netbeans.modules.vcscore.grouping.VcsGroupSettings;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakListener;

public class VcsGroupChildren
extends Children.Keys
implements PropertyChangeListener {
    private GroupFileChange fsListener = new GroupFileChange();
    private FileChangeListener wfsListener = WeakListener.fileChange((FileChangeListener)this.fsListener, null);
    private PropertyChangeListener wpropertyListener = WeakListener.propertyChange((PropertyChangeListener)this, null);
    private DataFolder folder;
    private ShadowPropertyChangeListener shPropChange = new ShadowPropertyChangeListener();
    private DOPropertyChangeListener doPropChange = new DOPropertyChangeListener();
    private RefreshAllTask refreshRunnable;
    private RequestProcessor.Task refreshTask;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$grouping$VcsGroupSettings;

    public VcsGroupChildren(DataFolder dobj) {
        this.folder = dobj;
        this.refreshRunnable = new RefreshAllTask();
        this.refreshTask = null;
    }

    protected void addNotify() {
        this.setKeys(this.getFilesInGroup());
        this.folder.getPrimaryFile().addFileChangeListener(this.wfsListener);
        VcsGroupSettings settings = (VcsGroupSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$vcscore$grouping$VcsGroupSettings == null ? (class$org$netbeans$modules$vcscore$grouping$VcsGroupSettings = VcsGroupChildren.class$("org.netbeans.modules.vcscore.grouping.VcsGroupSettings")) : class$org$netbeans$modules$vcscore$grouping$VcsGroupSettings), (boolean)true);
        settings.addPropertyChangeListener(this);
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        this.folder.getPrimaryFile().removeFileChangeListener(this.wfsListener);
        VcsGroupSettings settings = (VcsGroupSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$vcscore$grouping$VcsGroupSettings == null ? (class$org$netbeans$modules$vcscore$grouping$VcsGroupSettings = VcsGroupChildren.class$("org.netbeans.modules.vcscore.grouping.VcsGroupSettings")) : class$org$netbeans$modules$vcscore$grouping$VcsGroupSettings), (boolean)true);
        settings.removePropertyChangeListener(this);
    }

    private synchronized void refreshAll() {
        if (this.refreshTask != null) {
            if (this.refreshTask.getDelay() > 500) {
                return;
            }
            if (this.refreshTask.getDelay() > 0 && this.refreshTask.getDelay() < 500) {
                this.refreshTask.schedule(1000);
                return;
            }
        }
        this.refreshTask = RequestProcessor.postRequest((Runnable)this.refreshRunnable, (int)1000);
    }

    private Collection getFilesInGroup() {
        LinkedList<DataObject> list = new LinkedList<DataObject>();
        Enumeration childs = this.folder.children(false);
        HashSet actions = new HashSet();
        while (childs.hasMoreElements()) {
            DataObject dos = (DataObject)childs.nextElement();
            if (dos instanceof DataShadow) {
                DataShadow shadow = (DataShadow)dos;
                shadow.getOriginal().removePropertyChangeListener((PropertyChangeListener)this.doPropChange);
                shadow.getOriginal().addPropertyChangeListener((PropertyChangeListener)this.doPropChange);
                shadow.removePropertyChangeListener((PropertyChangeListener)this.shPropChange);
                shadow.addPropertyChangeListener((PropertyChangeListener)this.shPropChange);
                list.add(shadow.getOriginal());
            }
            if (!dos.getClass().getName().equals("org.openide.loaders.BrokenDataShadow")) continue;
            list.add(dos);
        }
        return list;
    }

    private DataObject findShadowForDO(DataObject orig) {
        Enumeration childs = this.folder.children(false);
        while (childs.hasMoreElements()) {
            DataShadow shadow;
            DataObject dos = (DataObject)childs.nextElement();
            if (!(dos instanceof DataShadow) || !orig.equals((shadow = (DataShadow)dos).getOriginal())) continue;
            return shadow;
        }
        return null;
    }

    protected Node[] createNodes(Object key) {
        DataObject dobj = (DataObject)key;
        if (!dobj.isValid()) {
            return new Node[0];
        }
        if (key.getClass().getName().equals("org.openide.loaders.BrokenDataShadow")) {
            DataObject obj = (DataObject)key;
            if (!obj.isValid()) {
                return new Node[0];
            }
            obj.addPropertyChangeListener((PropertyChangeListener)this.shPropChange);
            return new Node[]{obj.getNodeDelegate().cloneNode()};
        }
        DataObject obj = (DataObject)key;
        DataShadow shad = (DataShadow)this.findShadowForDO(obj);
        if (!obj.isValid()) {
            if (shad != null) {
                shad.getOriginal().removePropertyChangeListener((PropertyChangeListener)this.doPropChange);
                shad.removePropertyChangeListener((PropertyChangeListener)this.shPropChange);
            }
            return new Node[0];
        }
        if (shad == null) {
            return new Node[0];
        }
        return new Node[]{new VcsGroupFileNode(shad, obj.getNodeDelegate().cloneNode())};
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent != null && "showLinks".equals(propertyChangeEvent.getPropertyName())) {
            Node[] nods = this.getNodes();
            int i = 0;
            while (i < nods.length) {
                if (nods[i] instanceof VcsGroupFileNode) {
                    ((VcsGroupFileNode)nods[i]).checkShowLinks();
                }
                ++i;
            }
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class RefreshAllTask
    implements Runnable {
        public void run() {
            VcsGroupChildren.super.setKeys(VcsGroupChildren.this.getFilesInGroup());
        }
    }

    private class DOPropertyChangeListener
    implements PropertyChangeListener {
        private DOPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Boolean bool;
            if (propertyChangeEvent.getPropertyName().equals("valid") && propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue() instanceof Boolean && !(bool = (Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                VcsGroupChildren.this.refreshAll();
            }
        }
    }

    private class ShadowPropertyChangeListener
    implements PropertyChangeListener {
        private ShadowPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Boolean bool;
            if (propertyChangeEvent.getPropertyName().equals("valid") && propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue() instanceof Boolean && !(bool = (Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                DataObject obj = (DataObject)propertyChangeEvent.getSource();
                obj.removePropertyChangeListener((PropertyChangeListener)VcsGroupChildren.this.shPropChange);
                VcsGroupChildren.this.refreshAll();
            }
        }
    }

    private class GroupFileChange
    extends FileChangeAdapter {
        private GroupFileChange() {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            VcsGroupChildren.this.refreshAll();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            VcsGroupChildren.this.refreshAll();
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileDeleted(FileEvent fileEvent) {
            VcsGroupChildren.this.refreshAll();
        }

        public void fileChanged(FileEvent fileEvent) {
            VcsGroupChildren.this.refreshAll();
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }
    }
}

