/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.grouping;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ResourceBundle;
import org.netbeans.modules.vcscore.grouping.GroupCookie;
import org.netbeans.modules.vcscore.grouping.VcsGroupChildren;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class VcsGroupNode
extends AbstractNode {
    public static final String PROPFILE_EXT = "properties";
    private DataFolder groupDO;
    private String groupName;
    private String groupDescription = "";
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$actions$AddToGroupAction;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$grouping$VerifyGroupAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$RenameAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$grouping$VcsGroupNode;
    static /* synthetic */ Class class$java$lang$String;

    public VcsGroupNode(DataFolder dobj) {
        super((Children)new VcsGroupChildren(dobj));
        this.groupDO = dobj;
        this.setIconBase("org/netbeans/modules/vcscore/grouping/VcsGroupNodeIcon");
        this.groupName = this.groupDO.getName();
        FileObject propsFo = dobj.getPrimaryFile().getParent().getFileObject(dobj.getPrimaryFile().getName(), PROPFILE_EXT);
        if (propsFo != null) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(propsFo.getInputStream()));
                this.groupName = this.getBundleValue(reader.readLine());
                this.groupDescription = this.getBundleValue(reader.readLine());
                this.groupDescription = Utilities.replaceString((String)this.groupDescription, (String)"\\n", (String)"\n");
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify(16, (Throwable)exc);
            }
        }
        this.getCookieSet().add((Node.Cookie)new GroupCookieImpl());
    }

    private String getBundleValue(String keyValue) {
        int index;
        if (keyValue != null && (index = keyValue.indexOf(61)) > 0 && keyValue.length() > index) {
            return keyValue.substring(index + 1);
        }
        return "";
    }

    public SystemAction[] getActions() {
        Node[] childs = this.getChildren().getNodes();
        HashSet<SystemAction> actions = new HashSet<SystemAction>();
        HashMap<SystemAction, LinkedList<Node>> map = new HashMap<SystemAction, LinkedList<Node>>();
        LinkedList<SystemAction> actionsList = new LinkedList<SystemAction>();
        if (childs != null) {
            int i = 0;
            while (i < childs.length) {
                try {
                    DataObject dob = (DataObject)childs[i].getCookie(class$org$openide$loaders$DataObject == null ? VcsGroupNode.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                    if (dob != null) {
                        FileObject fo = dob.getPrimaryFile();
                        SystemAction[] acts = fo.getFileSystem().getActions();
                        int m = 0;
                        while (m < acts.length) {
                            if (acts[m].isEnabled() && !acts[m].getClass().equals(class$org$netbeans$modules$vcscore$actions$AddToGroupAction == null ? VcsGroupNode.class$("org.netbeans.modules.vcscore.actions.AddToGroupAction") : class$org$netbeans$modules$vcscore$actions$AddToGroupAction)) {
                                actions.add(acts[m]);
                                actionsList.add(acts[m]);
                                LinkedList<Node> lst = (LinkedList<Node>)map.get(acts[m]);
                                if (lst == null) {
                                    lst = new LinkedList<Node>();
                                    map.put(acts[m], lst);
                                }
                                lst.add(childs[i]);
                            }
                            ++m;
                        }
                    }
                }
                catch (FileStateInvalidException exc) {
                    // empty catch block
                }
                ++i;
            }
        }
        Iterator actIt = map.keySet().iterator();
        while (actIt.hasNext()) {
            Object act = actIt.next();
            LinkedList list = (LinkedList)map.get(act);
            if (list != null) {
                if (list.size() == childs.length) continue;
                actions.remove(act);
                continue;
            }
            actions.remove(act);
        }
        SystemAction[] toReturn = new SystemAction[actions.size() + 7];
        Iterator it = actionsList.iterator();
        int index = 0;
        while (it.hasNext()) {
            SystemAction act = (SystemAction)it.next();
            if (actions.contains(act)) {
                toReturn[index] = act;
                ++index;
                actions.remove(act);
            }
            if (actions.size() == 0) break;
        }
        toReturn[toReturn.length - 6] = (SystemAction)SharedClassObject.findObject((Class)(class$org$netbeans$modules$vcscore$grouping$VerifyGroupAction == null ? (class$org$netbeans$modules$vcscore$grouping$VerifyGroupAction = VcsGroupNode.class$("org.netbeans.modules.vcscore.grouping.VerifyGroupAction")) : class$org$netbeans$modules$vcscore$grouping$VerifyGroupAction), (boolean)true);
        toReturn[toReturn.length - 5] = null;
        toReturn[toReturn.length - 4] = SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = VcsGroupNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction));
        toReturn[toReturn.length - 3] = SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = VcsGroupNode.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction));
        toReturn[toReturn.length - 2] = null;
        toReturn[toReturn.length - 1] = SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = VcsGroupNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction));
        return toReturn;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    public Node cloneNode() {
        return new VcsGroupNode(this.groupDO);
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set props = Sheet.createPropertiesSet();
        sheet.put(props);
        props.setValue("helpID", (class$org$netbeans$modules$vcscore$grouping$VcsGroupNode == null ? (class$org$netbeans$modules$vcscore$grouping$VcsGroupNode = VcsGroupNode.class$("org.netbeans.modules.vcscore.grouping.VcsGroupNode")) : class$org$netbeans$modules$vcscore$grouping$VcsGroupNode).getName() + "_properties");
        this.createProperties(props);
        return sheet;
    }

    private void createProperties(Sheet.Set set) {
        ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$grouping$VcsGroupNode == null ? (class$org$netbeans$modules$vcscore$grouping$VcsGroupNode = VcsGroupNode.class$("org.netbeans.modules.vcscore.grouping.VcsGroupNode")) : class$org$netbeans$modules$vcscore$grouping$VcsGroupNode));
        set.put((Node.Property)new PropertySupport.ReadWrite("shortDescription", class$java$lang$String == null ? (class$java$lang$String = VcsGroupNode.class$("java.lang.String")) : class$java$lang$String, bundle.getString("LBL_Description"), bundle.getString("DESC_Description")){

            public void setValue(Object value) {
                VcsGroupNode.this.setShortDescription(value.toString());
            }

            public Object getValue() {
                return VcsGroupNode.this.groupDescription;
            }
        });
        set.put((Node.Property)new PropertySupport.ReadWrite("name", class$java$lang$String == null ? (class$java$lang$String = VcsGroupNode.class$("java.lang.String")) : class$java$lang$String, bundle.getString("LBL_GroupName"), bundle.getString("DESC_GroupName")){

            public void setValue(Object value) {
                VcsGroupNode.this.setName(value.toString());
            }

            public Object getValue() {
                return VcsGroupNode.this.getName();
            }
        });
    }

    public boolean canRename() {
        return true;
    }

    public void setName(String name) {
        String oldName = this.groupName;
        this.groupName = name;
        super.setName(name);
        this.saveProperties();
        this.firePropertyChange("name", oldName, name);
    }

    public String getName() {
        return this.groupName;
    }

    public String getDisplayName() {
        return this.groupName;
    }

    public String getShortDescription() {
        if (this.groupDescription.length() == 0) {
            return null;
        }
        return this.groupDescription;
    }

    public void setShortDescription(String desc) {
        String oldDesc = this.groupDescription;
        this.groupDescription = desc;
        super.setShortDescription(desc);
        this.saveProperties();
        this.firePropertyChange("shortDescription", oldDesc, desc);
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        super.destroy();
        FileObject parent = this.groupDO.getPrimaryFile().getParent();
        String name = this.groupDO.getPrimaryFile().getName();
        if (this.groupDO.isValid()) {
            try {
                this.groupDO.delete();
            }
            catch (IOException exc) {
                ErrorManager.getDefault().annotate((Throwable)exc, NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$grouping$VcsGroupNode == null ? (class$org$netbeans$modules$vcscore$grouping$VcsGroupNode = VcsGroupNode.class$("org.netbeans.modules.vcscore.grouping.VcsGroupNode")) : class$org$netbeans$modules$vcscore$grouping$VcsGroupNode)).getString("VcsGroupNode.cannotDestroyGroup"));
                return;
            }
        }
        FileObject props = parent.getFileObject(name, PROPFILE_EXT);
        try {
            if (props != null) {
                props.delete(props.lock());
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().annotate((Throwable)ex, NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$grouping$VcsGroupNode == null ? (class$org$netbeans$modules$vcscore$grouping$VcsGroupNode = VcsGroupNode.class$("org.netbeans.modules.vcscore.grouping.VcsGroupNode")) : class$org$netbeans$modules$vcscore$grouping$VcsGroupNode)).getString("VcsGroupNode.cannotDestroyGroupProps"));
        }
    }

    private void saveProperties() {
        block3: {
            FileObject fo = this.groupDO.getPrimaryFile();
            PrintWriter writer = null;
            try {
                FileObject props = fo.getParent().getFileObject(fo.getName(), PROPFILE_EXT);
                if (props == null) {
                    props = fo.getParent().createData(fo.getName(), PROPFILE_EXT);
                }
                writer = new PrintWriter(props.getOutputStream(props.lock()));
                writer.println("name=" + this.getDisplayName());
                String oneLineDescription = Utilities.replaceString((String)this.groupDescription, (String)"\n", (String)"\\n");
                writer.println("shortDescription=" + oneLineDescription);
                writer.close();
            }
            catch (IOException exc) {
                if (writer == null) break block3;
                writer.close();
            }
        }
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz.equals(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = VcsGroupNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject)) {
            return this.groupDO;
        }
        Node.Cookie retValue = super.getCookie(clazz);
        return retValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ShadowOnlyDataFilter
    implements DataFilter {
        private static final long serialVersionUID = 6549358585875198736L;

        private ShadowOnlyDataFilter() {
        }

        public boolean acceptDataObject(DataObject dataObject) {
            return dataObject instanceof DataShadow;
        }
    }

    private class GroupCookieImpl
    implements GroupCookie {
        private GroupCookieImpl() {
        }

        public String getDisplayName() {
            return VcsGroupNode.this.getDisplayName();
        }

        public String getDescription() {
            return VcsGroupNode.this.getShortDescription();
        }
    }
}

