/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.objectintegrity;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.vcscore.objectintegrity.VcsOISActivator;
import org.netbeans.modules.vcscore.objectintegrity.VcsObjectIntegritySupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;

public final class IntegritySupportMaintainer
implements PropertyChangeListener,
VetoableChangeListener,
Runnable {
    public static final String DB_FILE_NAME = ".nbintdb";
    private static Map VOISMap = new WeakHashMap();
    private static final int SAVER_SCHEDULE_TIME = 500;
    private FileSystem fileSystem;
    private VcsOISActivator objectIntegrityActivator;
    private VcsObjectIntegritySupport objectIntegritySupport;
    private PropertyChangeListener vOISChangeListener;
    private RequestProcessor.Task saverTask;
    private Map voisToSave;
    private int saverScheduleTime = 500;

    public IntegritySupportMaintainer(FileSystem fileSystem, VcsOISActivator objectIntegrityActivator) {
        this.fileSystem = fileSystem;
        this.objectIntegrityActivator = objectIntegrityActivator;
        this.saverTask = RequestProcessor.createRequest((Runnable)this);
        this.saverTask.setPriority(1);
        this.voisToSave = new HashMap();
        this.initVOIS();
        fileSystem.addVetoableChangeListener(WeakListener.vetoableChange((VetoableChangeListener)this, (Object)fileSystem));
        fileSystem.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this, (Object)fileSystem));
    }

    private synchronized void initVOIS() {
        this.objectIntegritySupport = new VcsObjectIntegritySupport(new VOISInitializer(this.fileSystem.getRoot()));
        this.vOISChangeListener = WeakListener.propertyChange((PropertyChangeListener)this, (Object)this.objectIntegritySupport);
        this.objectIntegrityActivator.activate(this.objectIntegritySupport);
        this.objectIntegritySupport.addPropertyChangeListener(this.vOISChangeListener);
        Map map = VOISMap;
        synchronized (map) {
            VOISMap.put(this.fileSystem, this.objectIntegritySupport);
        }
    }

    public static VcsObjectIntegritySupport findObjectIntegritySupport(FileSystem fileSystem) {
        Map map = VOISMap;
        synchronized (map) {
            VcsObjectIntegritySupport vcsObjectIntegritySupport = (VcsObjectIntegritySupport)VOISMap.get(fileSystem);
            return vcsObjectIntegritySupport;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("root".equals(propertyName)) {
            this.initVOIS();
        } else if ("filesChanged".equals(propertyName)) {
            Map map = this.voisToSave;
            synchronized (map) {
                this.voisToSave.put(this.fileSystem.getRoot(), evt.getSource());
                this.saverTask.schedule(this.saverScheduleTime);
            }
        }
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("root".equals(evt.getPropertyName())) {
            IntegritySupportMaintainer integritySupportMaintainer = this;
            synchronized (integritySupportMaintainer) {
                if (this.objectIntegritySupport == null) {
                    return;
                }
                Map map = VOISMap;
                synchronized (map) {
                    VOISMap.remove(this.fileSystem);
                }
                this.objectIntegritySupport.removePropertyChangeListener(this.vOISChangeListener);
                this.objectIntegritySupport.deactivate();
                this.vOISChangeListener = null;
                this.objectIntegritySupport = null;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        toSave = new HashMap<K, V>();
        var2_2 = this.voisToSave;
        synchronized (var2_2) {
            toSave.putAll(this.voisToSave);
            this.voisToSave.clear();
        }
        start = System.currentTimeMillis();
        it = toSave.keySet().iterator();
        while (it.hasNext()) {
            block15: {
                fo = (FileObject)it.next();
                vois = (VcsObjectIntegritySupport)toSave.get(fo);
                folder = FileUtil.toFile((FileObject)fo);
                if (folder == null) continue;
                dbFile = new File(folder, ".nbintdb");
                dbSaveFile = new File(folder, ".nbintdb~");
                oout = null;
                ok = false;
                try {
                    oout = new ObjectOutputStream(new FileOutputStream(dbSaveFile));
                    oout.writeObject(vois);
                    var15_15 = null;
                    ** if (oout == null) goto lbl-1000
                }
                catch (Throwable var14_17) {
                    var15_15 = null;
                    if (oout != null) {
                        try {
                            oout.close();
                            ok = true;
                        }
                        catch (IOException ioex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ioex);
                        }
                    }
                    throw var14_17;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        oout.close();
                        ok = true;
                    }
                    catch (IOException ioex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ioex);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block15;
                    catch (IOException ioex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ioex);
                        var15_15 = null;
                        if (oout != null) {
                            try {
                                oout.close();
                                ok = true;
                            }
                            catch (IOException ioex) {
                                ErrorManager.getDefault().notify(1, (Throwable)ioex);
                            }
                        }
                    }
                }
            }
            if (!ok) continue;
            dbFile.delete();
            dbSaveFile.renameTo(dbFile);
        }
        end = System.currentTimeMillis();
        this.saverScheduleTime = Math.max(500, (int)(end - start));
    }

    private static final class VOISInitializer
    implements PrivilegedAction {
        private FileObject rootFO;

        public VOISInitializer(FileObject rootFO) {
            this.rootFO = rootFO;
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object run() {
            File folder = FileUtil.toFile((FileObject)this.rootFO);
            if (folder == null) return null;
            File dbFile = new File(folder, IntegritySupportMaintainer.DB_FILE_NAME);
            if (!dbFile.exists()) {
                dbFile = new File(folder, ".nbintdb~");
            }
            if (!dbFile.exists() || !dbFile.canRead()) return null;
            ObjectInputStream oin = null;
            Object vois = null;
            oin = new ObjectInputStream(new FileInputStream(dbFile));
            vois = oin.readObject();
            Object var8_5 = null;
            if (oin == null) return vois;
            try {
                oin.close();
                return vois;
            }
            catch (IOException ioex2) {}
            return vois;
            {
                catch (IOException ioex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ioex);
                    Object var8_6 = null;
                    if (oin == null) return vois;
                    try {
                        oin.close();
                        return vois;
                    }
                    catch (IOException ioex2) {}
                    return vois;
                }
                catch (ClassNotFoundException cnfex) {
                    ErrorManager.getDefault().notify(1, (Throwable)cnfex);
                    Object var8_7 = null;
                    if (oin == null) return vois;
                    try {
                        oin.close();
                        return vois;
                    }
                    catch (IOException ioex2) {}
                    return vois;
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (oin == null) throw throwable;
                try {
                    oin.close();
                    throw throwable;
                }
                catch (IOException ioex2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

