/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.objectintegrity;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.vcs.VcsManager;
import org.netbeans.api.vcs.commands.AddCommand;
import org.netbeans.api.vcs.commands.CommandTask;
import org.netbeans.modules.vcscore.objectintegrity.ObjectIntegrityCommand;
import org.netbeans.modules.vcscore.objectintegrity.ObjectIntegrityPanel;
import org.netbeans.modules.vcscore.objectintegrity.VcsObjectIntegritySupport;
import org.netbeans.spi.vcs.commands.CommandSupport;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ObjectIntegrityCommandSupport
extends CommandSupport
implements PrivilegedAction {
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$objectintegrity$ObjectIntegrityCommand;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$objectintegrity$ObjectIntegrityCommandSupport;

    public ObjectIntegrityCommandSupport() {
        super(class$org$netbeans$modules$vcscore$objectintegrity$ObjectIntegrityCommand == null ? (class$org$netbeans$modules$vcscore$objectintegrity$ObjectIntegrityCommand = ObjectIntegrityCommandSupport.class$("org.netbeans.modules.vcscore.objectintegrity.ObjectIntegrityCommand")) : class$org$netbeans$modules$vcscore$objectintegrity$ObjectIntegrityCommand);
    }

    protected int execute(CommandTask task) {
        ObjectIntegrityCommand cmd = (ObjectIntegrityCommand)this.getCommand(task);
        AddCommand addCmd = cmd.getAddCommand();
        addCmd.setExpertMode(cmd.isExpertMode());
        addCmd.setGUIMode(cmd.isGUIMode());
        FileObject[] filesToAdd = cmd.getFilesToAdd();
        if (filesToAdd == null) {
            return 0;
        }
        addCmd.setFiles(filesToAdd);
        boolean customized = VcsManager.getDefault().showCustomizer(addCmd);
        if (customized) {
            CommandTask cmdTask = addCmd.execute();
            try {
                cmdTask.waitFinished(0);
                return cmdTask.getExitStatus();
            }
            catch (InterruptedException iex) {
                return 2;
            }
        }
        return 2;
    }

    public FileObject[] getApplicableFiles(FileObject[] files) {
        ObjectIntegrityCommand cmd = (ObjectIntegrityCommand)this.getCommand();
        VcsObjectIntegritySupport integritySupport = cmd.getObjectIntegritySupport();
        if (integritySupport != null && (files = ObjectIntegrityCommandSupport.findFilesToAdd(integritySupport, files)).length == 0) {
            files = null;
        }
        return files;
    }

    public String getDisplayName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$objectintegrity$ObjectIntegrityCommandSupport == null ? (class$org$netbeans$modules$vcscore$objectintegrity$ObjectIntegrityCommandSupport = ObjectIntegrityCommandSupport.class$("org.netbeans.modules.vcscore.objectintegrity.ObjectIntegrityCommandSupport")) : class$org$netbeans$modules$vcscore$objectintegrity$ObjectIntegrityCommandSupport), (String)"ObjectIntegrityCommand.name");
    }

    public String getName() {
        return "Object Integrity Helper";
    }

    public boolean hasExpertMode() {
        return false;
    }

    protected Object clone() throws CloneNotSupportedException {
        return new ObjectIntegrityCommandSupport();
    }

    public Object run() {
        ObjectIntegrityCommand cmd = (ObjectIntegrityCommand)this.getCommand();
        ObjectIntegrityPanel integrityPanel = new ObjectIntegrityPanel();
        FileObject[] files = cmd.getFiles();
        if (files == null) {
            return null;
        }
        String[] filePaths = new String[files.length];
        int i = 0;
        while (i < files.length) {
            filePaths[i] = files[i].getPath();
            ++i;
        }
        integrityPanel.setFilePaths(filePaths);
        Object[] options = new Object[]{NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$objectintegrity$ObjectIntegrityCommandSupport == null ? (class$org$netbeans$modules$vcscore$objectintegrity$ObjectIntegrityCommandSupport = ObjectIntegrityCommandSupport.class$("org.netbeans.modules.vcscore.objectintegrity.ObjectIntegrityCommandSupport")) : class$org$netbeans$modules$vcscore$objectintegrity$ObjectIntegrityCommandSupport), (String)"ObjectIntegrityCommand.btn.add"), NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$objectintegrity$ObjectIntegrityCommandSupport == null ? (class$org$netbeans$modules$vcscore$objectintegrity$ObjectIntegrityCommandSupport = ObjectIntegrityCommandSupport.class$("org.netbeans.modules.vcscore.objectintegrity.ObjectIntegrityCommandSupport")) : class$org$netbeans$modules$vcscore$objectintegrity$ObjectIntegrityCommandSupport), (String)"ObjectIntegrityCommand.btn.skip"), NotifyDescriptor.CANCEL_OPTION};
        DialogDescriptor dlgDescriptor = new DialogDescriptor((Object)integrityPanel, NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$objectintegrity$ObjectIntegrityCommandSupport == null ? (class$org$netbeans$modules$vcscore$objectintegrity$ObjectIntegrityCommandSupport = ObjectIntegrityCommandSupport.class$("org.netbeans.modules.vcscore.objectintegrity.ObjectIntegrityCommandSupport")) : class$org$netbeans$modules$vcscore$objectintegrity$ObjectIntegrityCommandSupport), (String)"ObjectIntegrityCommand.dlg.title"), true, options, options[0], 0, new HelpCtx(class$org$netbeans$modules$vcscore$objectintegrity$ObjectIntegrityCommandSupport == null ? (class$org$netbeans$modules$vcscore$objectintegrity$ObjectIntegrityCommandSupport = ObjectIntegrityCommandSupport.class$("org.netbeans.modules.vcscore.objectintegrity.ObjectIntegrityCommandSupport")) : class$org$netbeans$modules$vcscore$objectintegrity$ObjectIntegrityCommandSupport), (ActionListener)new DialogActionListener(cmd, integrityPanel, options));
        dlgDescriptor.setClosingOptions(options);
        return dlgDescriptor;
    }

    private static FileObject[] findFilesToAdd(VcsObjectIntegritySupport objectIntegritySupport, FileObject[] files) {
        ArrayList<FileObject> localFiles = new ArrayList<FileObject>();
        Map secondariesByPrimary = objectIntegritySupport.getObjectsWithLocalFiles();
        int i = 0;
        while (i < files.length) {
            FileObject fo = files[i];
            if (fo.isFolder()) {
                ObjectIntegrityCommandSupport.addLocalsUnder(fo, secondariesByPrimary, objectIntegritySupport, localFiles);
            } else {
                String path = fo.getPath();
                Set locals = (Set)secondariesByPrimary.get(path);
                if (locals != null) {
                    Iterator it = locals.iterator();
                    while (it.hasNext()) {
                        String localFile = (String)it.next();
                        FileObject local = objectIntegritySupport.findFileObject(localFile);
                        if (local == null) continue;
                        localFiles.add(local);
                    }
                }
            }
            ++i;
        }
        return localFiles.toArray(new FileObject[localFiles.size()]);
    }

    private static void addLocalsUnder(FileObject folder, Map secondariesByPrimary, VcsObjectIntegritySupport objectIntegritySupport, List localFiles) {
        String folderPath = folder.getPath();
        int length = folderPath.length();
        Iterator it = secondariesByPrimary.keySet().iterator();
        while (it.hasNext()) {
            Set locals;
            String primaryPath = (String)it.next();
            if (!primaryPath.startsWith(folderPath) || primaryPath.length() <= length || primaryPath.charAt(length) != '/' || (locals = (Set)secondariesByPrimary.get(primaryPath)) == null) continue;
            Iterator lockIt = locals.iterator();
            while (lockIt.hasNext()) {
                String localFile = (String)lockIt.next();
                FileObject local = objectIntegritySupport.findFileObject(localFile);
                if (local == null) continue;
                localFiles.add(local);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class DialogActionListener
    implements ActionListener {
        private ObjectIntegrityCommand cmd;
        private ObjectIntegrityPanel integrityPanel;
        private Object[] options;

        public DialogActionListener(ObjectIntegrityCommand cmd, ObjectIntegrityPanel integrityPanel, Object[] options) {
            this.cmd = cmd;
            this.integrityPanel = integrityPanel;
            this.options = options;
        }

        public void actionPerformed(ActionEvent e) {
            VcsObjectIntegritySupport vcsOIS;
            String command = e.getActionCommand();
            if (this.options[0].equals(command)) {
                String[] filePaths = this.integrityPanel.getSelectedFilePaths();
                if (filePaths.length == 0) {
                    this.cmd.setFilesToAdd(null);
                } else {
                    vcsOIS = this.cmd.getObjectIntegritySupport();
                    FileObject[] files = new FileObject[filePaths.length];
                    int i = 0;
                    while (i < filePaths.length) {
                        files[i] = vcsOIS.findFileObject(filePaths[i]);
                        ++i;
                    }
                    this.cmd.setFilesToAdd(files);
                }
            } else if (this.options[1].equals(command)) {
                this.cmd.setFilesToAdd(null);
            }
            String[] ignoredFiles = this.integrityPanel.getIgnoredFilePaths();
            if (ignoredFiles.length > 0) {
                vcsOIS = this.cmd.getObjectIntegritySupport();
                vcsOIS.addIgnoredFiles(ignoredFiles);
            }
        }
    }
}

