/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.objectintegrity;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.vcs.VcsManager;
import org.netbeans.api.vcs.commands.AddCommand;
import org.netbeans.api.vcs.commands.Command;
import org.netbeans.api.vcs.commands.CommandTask;
import org.netbeans.modules.vcscore.FileObjectImportantness;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandlerEvent;
import org.netbeans.modules.vcscore.cache.CacheHandlerListener;
import org.netbeans.modules.vcscore.cache.FileSystemCache;
import org.netbeans.modules.vcscore.objectintegrity.IntegritySupportMaintainer;
import org.netbeans.modules.vcscore.objectintegrity.ObjectIntegrityCommand;
import org.netbeans.modules.vcscore.objectintegrity.ObjectIntegrityCommandSupport;
import org.netbeans.spi.vcs.VcsCommandsProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.OperationAdapter;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.OperationListener;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;

public class VcsObjectIntegritySupport
extends OperationAdapter
implements Runnable,
CacheHandlerListener,
Serializable {
    public static final String ATTRIBUTE_NAME = (class$org$netbeans$modules$vcscore$objectintegrity$VcsObjectIntegritySupport == null ? (class$org$netbeans$modules$vcscore$objectintegrity$VcsObjectIntegritySupport = VcsObjectIntegritySupport.class$("org.netbeans.modules.vcscore.objectintegrity.VcsObjectIntegritySupport")) : class$org$netbeans$modules$vcscore$objectintegrity$VcsObjectIntegritySupport).getName();
    public static final String PROPERTY_FILES_CHANGED = "filesChanged";
    private static final int ANALYZER_SCHEDULE_TIME = 200;
    private static final RequestProcessor analyzerRequestProcessor = new RequestProcessor("VCS Object Integrity Analyzer", 1);
    private transient FileSystem fileSystem;
    private transient FileSystemCache cache;
    private transient String fsRootPath;
    private transient FileObjectImportantness foImportantness;
    private transient Set objectsToAnalyze;
    private transient RequestProcessor.Task analyzerTask;
    private transient boolean activated = false;
    private transient PrivilegedAction initializer;
    private transient Object initializeLock = new Object();
    private transient OperationListener operationListener;
    private transient CacheHandlerListener cacheHandlerListaner;
    private transient PropertyChangeSupport propertyChangeSupport;
    private transient PropertyChangeListener doFileChangeListener;
    private Map objectsWithLocalFiles = new HashMap();
    private Map filesMap = new HashMap();
    private Set primaryLocalFiles = new HashSet();
    private Set ignoredSecondaryLocalFiles = Collections.synchronizedSet(new HashSet());
    private static final long serialVersionUID = 7128452018671390570L;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$objectintegrity$VcsObjectIntegritySupport;
    static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool;
    static /* synthetic */ Class class$org$openide$loaders$OperationListener;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$cache$CacheHandlerListener;
    static /* synthetic */ Class class$org$netbeans$api$vcs$commands$AddCommand;

    public VcsObjectIntegritySupport() {
    }

    public VcsObjectIntegritySupport(PrivilegedAction initializer) {
        this.initializer = initializer;
    }

    private void initialize() {
        Object object = this.initializeLock;
        synchronized (object) {
            if (this.initializer != null) {
                VcsObjectIntegritySupport newVOIS = (VcsObjectIntegritySupport)this.initializer.run();
                if (newVOIS != null) {
                    this.copyDataFrom(newVOIS);
                }
                this.initializer = null;
            }
        }
    }

    private void copyDataFrom(VcsObjectIntegritySupport vois) {
        Map map = this.objectsWithLocalFiles;
        synchronized (map) {
            this.objectsWithLocalFiles.putAll(vois.objectsWithLocalFiles);
            this.filesMap.putAll(vois.filesMap);
        }
        Set set = this.primaryLocalFiles;
        synchronized (set) {
            this.primaryLocalFiles.addAll(vois.primaryLocalFiles);
        }
        this.ignoredSecondaryLocalFiles.addAll(vois.ignoredSecondaryLocalFiles);
    }

    public synchronized boolean isActivated() {
        return this.activated;
    }

    public synchronized void activate(FileSystem fileSystem, FileSystemCache cache, String fsRootPath, FileObjectImportantness foImportantness) {
        this.fileSystem = fileSystem;
        this.cache = cache;
        this.fsRootPath = fsRootPath;
        this.foImportantness = foImportantness;
        this.objectsToAnalyze = new HashSet();
        this.analyzerTask = analyzerRequestProcessor.post((Runnable)this, 200, 1);
        DataLoaderPool pool = (DataLoaderPool)Lookup.getDefault().lookup(class$org$openide$loaders$DataLoaderPool == null ? (class$org$openide$loaders$DataLoaderPool = VcsObjectIntegritySupport.class$("org.openide.loaders.DataLoaderPool")) : class$org$openide$loaders$DataLoaderPool);
        this.operationListener = (OperationListener)WeakListener.create((Class)(class$org$openide$loaders$OperationListener == null ? (class$org$openide$loaders$OperationListener = VcsObjectIntegritySupport.class$("org.openide.loaders.OperationListener")) : class$org$openide$loaders$OperationListener), (EventListener)this, (Object)pool);
        pool.addOperationListener(this.operationListener);
        this.cacheHandlerListaner = (CacheHandlerListener)WeakListener.create((Class)(class$org$netbeans$modules$vcscore$cache$CacheHandlerListener == null ? (class$org$netbeans$modules$vcscore$cache$CacheHandlerListener = VcsObjectIntegritySupport.class$("org.netbeans.modules.vcscore.cache.CacheHandlerListener")) : class$org$netbeans$modules$vcscore$cache$CacheHandlerListener), (EventListener)this, (Object)cache);
        cache.addCacheHandlerListener(this.cacheHandlerListaner);
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.doFileChangeListener = new DOFileChangeListener();
        this.activated = true;
    }

    public void deactivate() {
        VcsObjectIntegritySupport vcsObjectIntegritySupport = this;
        synchronized (vcsObjectIntegritySupport) {
            if (this.operationListener != null) {
                DataLoaderPool pool = (DataLoaderPool)Lookup.getDefault().lookup(class$org$openide$loaders$DataLoaderPool == null ? (class$org$openide$loaders$DataLoaderPool = VcsObjectIntegritySupport.class$("org.openide.loaders.DataLoaderPool")) : class$org$openide$loaders$DataLoaderPool);
                pool.removeOperationListener(this.operationListener);
            }
            if (this.cacheHandlerListaner != null) {
                this.cache.removeCacheHandlerListener(this.cacheHandlerListaner);
            }
        }
        this.analyzerTask.waitFinished();
        VcsObjectIntegritySupport vcsObjectIntegritySupport2 = this;
        synchronized (vcsObjectIntegritySupport2) {
            this.propertyChangeSupport = null;
            this.activated = false;
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.addPropertyChangeListener(l);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(l);
        }
    }

    private void firePropertyChange() {
        PropertyChangeSupport propertyChangeSupport;
        VcsObjectIntegritySupport vcsObjectIntegritySupport = this;
        synchronized (vcsObjectIntegritySupport) {
            propertyChangeSupport = this.propertyChangeSupport;
        }
        if (propertyChangeSupport != null) {
            propertyChangeSupport.firePropertyChange(PROPERTY_FILES_CHANGED, null, null);
        }
    }

    public void operationPostCreate(OperationEvent operationEvent) {
        DataObject dobj = operationEvent.getObject();
        Set set = this.objectsToAnalyze;
        synchronized (set) {
            this.objectsToAnalyze.add(dobj);
        }
        this.analyzerTask.schedule(200);
    }

    public void run() {
        Set objects;
        boolean changed = false;
        Set set = this.objectsToAnalyze;
        synchronized (set) {
            objects = this.objectsToAnalyze;
            this.objectsToAnalyze = new HashSet();
        }
        boolean initialized = false;
        Iterator objIt = objects.iterator();
        while (objIt.hasNext()) {
            Set set2;
            File primaryFile;
            CacheFile pcFile;
            DataObject dobj = (DataObject)objIt.next();
            FileObject primary = dobj.getPrimaryFile();
            FileSystem fs = (FileSystem)primary.getAttribute("VcsFileSystemAttributeIdentifier");
            if (primary.isFolder() || !this.fileSystem.equals(fs)) continue;
            if (!initialized) {
                this.initialize();
                initialized = true;
            }
            if ((pcFile = this.cache.getCacheFile(primaryFile = FileUtil.toFile((FileObject)primary), 3, null)) == null || pcFile.isLocal()) {
                set2 = this.primaryLocalFiles;
                synchronized (set2) {
                    this.primaryLocalFiles.add(primary.getPath());
                }
                changed = true;
                continue;
            }
            set2 = this.primaryLocalFiles;
            synchronized (set2) {
                if (this.primaryLocalFiles.remove(primary.getPath())) {
                    changed = true;
                }
            }
            String primaryFilePath = primary.getPath();
            dobj.addPropertyChangeListener(this.doFileChangeListener);
            HashSet<String> filesToAdd = new HashSet<String>();
            HashSet<String> filesToRemove = new HashSet<String>();
            Set fileSet = dobj.files();
            fileSet.remove(primary);
            Iterator fileIt = fileSet.iterator();
            while (fileIt.hasNext()) {
                FileObject fo = (FileObject)fileIt.next();
                String filePath = fo.getPath();
                fs = (FileSystem)fo.getAttribute("VcsFileSystemAttributeIdentifier");
                if (fo.isFolder() || !this.fileSystem.equals(fs) || !this.foImportantness.isImportant(filePath) || this.ignoredSecondaryLocalFiles.contains(filePath)) {
                    filesToRemove.add(filePath);
                    continue;
                }
                File file = FileUtil.toFile((FileObject)fo);
                CacheFile cFile = this.cache.getCacheFile(file, 3, null);
                if (cFile == null || cFile.isLocal()) {
                    filesToAdd.add(filePath);
                    continue;
                }
                filesToRemove.add(filePath);
            }
            Map map = this.objectsWithLocalFiles;
            synchronized (map) {
                HashSet localSec = (HashSet)this.objectsWithLocalFiles.get(primaryFilePath);
                if (localSec == null) {
                    localSec = new HashSet();
                }
                localSec.addAll(filesToAdd);
                Iterator fileIt2 = filesToAdd.iterator();
                while (fileIt2.hasNext()) {
                    String secFile = (String)fileIt2.next();
                    this.filesMap.put(secFile, primaryFilePath);
                }
                localSec.removeAll(filesToRemove);
                this.filesMap.keySet().removeAll(filesToRemove);
                if (localSec.size() > 0) {
                    this.objectsWithLocalFiles.put(primaryFilePath, localSec);
                    changed = true;
                } else {
                    Object removedObj = this.objectsWithLocalFiles.remove(primaryFilePath);
                    if (removedObj != null) {
                        changed = true;
                    }
                }
            }
        }
        if (changed) {
            this.firePropertyChange();
        }
    }

    public Map getObjectsWithLocalFiles() {
        this.initialize();
        Map map = this.objectsWithLocalFiles;
        synchronized (map) {
            Map map2 = Collections.unmodifiableMap(new HashMap(this.objectsWithLocalFiles));
            return map2;
        }
    }

    public void addIgnoredFiles(String[] ignoredFilePaths) {
        this.initialize();
        this.ignoredSecondaryLocalFiles.addAll(Arrays.asList(ignoredFilePaths));
        boolean changed = false;
        Map map = this.objectsWithLocalFiles;
        synchronized (map) {
            int i = 0;
            while (i < ignoredFilePaths.length) {
                Set localSec;
                String primary = (String)this.filesMap.remove(ignoredFilePaths[i]);
                if (primary != null && (localSec = (Set)this.objectsWithLocalFiles.get(primary)) != null) {
                    localSec.remove(ignoredFilePaths[i]);
                    if (localSec.size() == 0) {
                        this.objectsWithLocalFiles.remove(primary);
                    }
                    changed = true;
                }
                ++i;
            }
        }
        if (changed) {
            this.firePropertyChange();
        }
    }

    public FileObject findFileObject(String name) {
        return this.fileSystem.findResource(name);
    }

    private static final String getFilePath(CacheFile cFile, String fsRootPath) {
        String absPath = cFile.getAbsolutePath();
        String path = null;
        if (absPath.startsWith(fsRootPath)) {
            path = fsRootPath.length() == absPath.length() ? "" : absPath.substring(fsRootPath.length() + 1, absPath.length());
            path = path.replace(File.separatorChar, '/');
        }
        return path;
    }

    public void cacheAdded(CacheHandlerEvent event) {
        CacheFile cFile = event.getCacheFile();
        if (cFile instanceof CacheDir || cFile.isLocal()) {
            return;
        }
        String path = VcsObjectIntegritySupport.getFilePath(cFile, this.fsRootPath);
        if (path != null) {
            boolean wasLocal;
            this.initialize();
            Set set = this.primaryLocalFiles;
            synchronized (set) {
                wasLocal = this.primaryLocalFiles.remove(path);
            }
            if (wasLocal) {
                FileObject fo = this.fileSystem.findResource(path);
                if (fo != null) {
                    try {
                        DataObject dobj = DataObject.find((FileObject)fo);
                        Set set2 = this.objectsToAnalyze;
                        synchronized (set2) {
                            this.objectsToAnalyze.add(dobj);
                        }
                        this.analyzerTask.schedule(200);
                    }
                    catch (DataObjectNotFoundException donfex) {
                        // empty catch block
                    }
                }
                return;
            }
            boolean changed = false;
            Map map = this.objectsWithLocalFiles;
            synchronized (map) {
                Set localSec;
                String primary = (String)this.filesMap.remove(path);
                if (primary != null && (localSec = (Set)this.objectsWithLocalFiles.get(primary)) != null) {
                    localSec.remove(path);
                    if (localSec.size() == 0) {
                        this.objectsWithLocalFiles.remove(primary);
                    }
                    changed = true;
                }
            }
            if (changed) {
                this.firePropertyChange();
            }
        }
    }

    public void cacheRemoved(CacheHandlerEvent event) {
        CacheFile cFile = event.getCacheFile();
        if (cFile instanceof CacheDir || cFile.isLocal()) {
            return;
        }
        String path = VcsObjectIntegritySupport.getFilePath(cFile, this.fsRootPath);
        if (path != null) {
            this.initialize();
            boolean changed = false;
            Map map = this.objectsWithLocalFiles;
            synchronized (map) {
                Set localSet = (Set)this.objectsWithLocalFiles.remove(path);
                if (localSet != null) {
                    Iterator it = localSet.iterator();
                    while (it.hasNext()) {
                        String secondary = (String)it.next();
                        this.filesMap.remove(secondary);
                    }
                    changed = true;
                }
            }
            if (changed) {
                this.firePropertyChange();
            }
        }
    }

    public void statusChanged(CacheHandlerEvent event) {
        CacheFile cFile = event.getCacheFile();
        if (cFile instanceof CacheDir) {
            return;
        }
        String path = VcsObjectIntegritySupport.getFilePath(cFile, this.fsRootPath);
        if (path != null) {
            this.initialize();
            boolean changed = false;
            if (cFile.isLocal()) {
                Map map = this.objectsWithLocalFiles;
                synchronized (map) {
                    Set localSet = (Set)this.objectsWithLocalFiles.remove(path);
                    if (localSet != null) {
                        Object secondary;
                        Iterator it = localSet.iterator();
                        while (it.hasNext()) {
                            secondary = (String)it.next();
                            this.filesMap.remove(secondary);
                        }
                        secondary = this.primaryLocalFiles;
                        synchronized (secondary) {
                            this.primaryLocalFiles.add(path);
                        }
                        changed = true;
                    }
                }
            }
            Map map = this.objectsWithLocalFiles;
            synchronized (map) {
                String primary = (String)this.filesMap.remove(path);
                if (primary != null) {
                    Set localSet = (Set)this.objectsWithLocalFiles.get(primary);
                    if (localSet != null) {
                        localSet.remove(path);
                    }
                    changed = true;
                }
            }
            Set set = this.primaryLocalFiles;
            synchronized (set) {
                FileObject fo;
                if (this.primaryLocalFiles.remove(path) && (fo = this.fileSystem.findResource(path)) != null) {
                    try {
                        DataObject dobj = DataObject.find((FileObject)fo);
                        Set set2 = this.objectsToAnalyze;
                        synchronized (set2) {
                            this.objectsToAnalyze.add(dobj);
                        }
                        this.analyzerTask.schedule(200);
                    }
                    catch (DataObjectNotFoundException donfex) {
                        // empty catch block
                    }
                }
            }
            if (changed) {
                this.firePropertyChange();
            }
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        if (this.ignoredSecondaryLocalFiles == null) {
            this.ignoredSecondaryLocalFiles = Collections.synchronizedSet(new HashSet());
        }
        this.initializeLock = new Object();
    }

    private static Map findCommandProvidersForFiles(FileObject[] files) {
        List<FileObject> fileList;
        VcsCommandsProvider provider;
        HashMap<VcsCommandsProvider, Object> providers = new HashMap<VcsCommandsProvider, Object>();
        int i = 0;
        while (i < files.length) {
            FileObject fo = files[i];
            provider = VcsCommandsProvider.findProvider(fo);
            if (provider != null) {
                if (providers.containsKey(provider)) {
                    fileList = (List)providers.get(provider);
                    fileList.add(fo);
                } else {
                    fileList = new ArrayList();
                    fileList.add(fo);
                    providers.put(provider, fileList);
                }
            }
            ++i;
        }
        Iterator it = providers.keySet().iterator();
        while (it.hasNext()) {
            provider = (VcsCommandsProvider)it.next();
            fileList = (ArrayList)providers.get(provider);
            FileObject[] fileArray = fileList.toArray(new FileObject[fileList.size()]);
            providers.put(provider, fileArray);
        }
        return providers;
    }

    public static boolean runIntegrityKeeper(FileObject[] files, Command origCommand) {
        Map providersForFiles = VcsObjectIntegritySupport.findCommandProvidersForFiles(files);
        boolean customized = true;
        Iterator it = providersForFiles.keySet().iterator();
        while (it.hasNext()) {
            VcsCommandsProvider provider = (VcsCommandsProvider)it.next();
            AddCommand addCmd = (AddCommand)provider.createCommand(class$org$netbeans$api$vcs$commands$AddCommand == null ? VcsObjectIntegritySupport.class$("org.netbeans.api.vcs.commands.AddCommand") : class$org$netbeans$api$vcs$commands$AddCommand);
            if (addCmd == null) continue;
            FileObject[] cmdFiles = (FileObject[])providersForFiles.get(provider);
            VcsObjectIntegritySupport objectIntegritySupport = null;
            FileSystem fs = (FileSystem)cmdFiles[0].getAttribute("VcsFileSystemAttributeIdentifier");
            if (fs != null) {
                objectIntegritySupport = IntegritySupportMaintainer.findObjectIntegritySupport(fs);
            }
            if (objectIntegritySupport == null) continue;
            ObjectIntegrityCommandSupport integrityCmdSupport = new ObjectIntegrityCommandSupport();
            ObjectIntegrityCommand integrityCmd = (ObjectIntegrityCommand)integrityCmdSupport.createCommand();
            integrityCmd.setAddCommand(addCmd);
            integrityCmd.setObjectIntegritySupport(objectIntegritySupport);
            integrityCmd.setFiles(cmdFiles);
            integrityCmd.setExpertMode(origCommand.isExpertMode());
            integrityCmd.setGUIMode(origCommand.isGUIMode());
            customized = VcsManager.getDefault().showCustomizer(integrityCmd);
            if (!customized) continue;
            CommandTask task = integrityCmd.execute();
            try {
                task.waitFinished(0);
            }
            catch (InterruptedException iex) {
                // empty catch block
            }
        }
        return customized;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DOFileChangeListener
    implements PropertyChangeListener {
        private DOFileChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if ("files".equals(name)) {
                DataObject dobj = (DataObject)evt.getSource();
                Set set = VcsObjectIntegritySupport.this.objectsToAnalyze;
                synchronized (set) {
                    VcsObjectIntegritySupport.this.objectsToAnalyze.add(dobj);
                }
                VcsObjectIntegritySupport.this.analyzerTask.schedule(200);
            }
        }
    }
}

