/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.registry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.vcscore.registry.FSInfo;
import org.netbeans.modules.vcscore.registry.FSRegistryEvent;
import org.netbeans.modules.vcscore.registry.FSRegistryListener;

public class FSRegistry {
    private static FSRegistry registry;
    private List registryListeners = new LinkedList();
    private List fsInfos = new LinkedList();

    private FSRegistry() {
    }

    public static synchronized FSRegistry getDefault() {
        if (registry == null) {
            registry = new FSRegistry();
        }
        return registry;
    }

    public void register(FSInfo fsInfo) {
        List list = this.fsInfos;
        synchronized (list) {
            this.fsInfos.add(fsInfo);
        }
        this.fireFSInfoChanged(fsInfo, true);
    }

    public void unregister(FSInfo fsInfo) {
        List list = this.fsInfos;
        synchronized (list) {
            this.fsInfos.remove(fsInfo);
        }
        this.fireFSInfoChanged(fsInfo, false);
    }

    public FSInfo[] getRegistered() {
        List list = this.fsInfos;
        synchronized (list) {
            FSInfo[] fSInfoArray = this.fsInfos.toArray(new FSInfo[this.fsInfos.size()]);
            return fSInfoArray;
        }
    }

    public void addFSRegistryListener(FSRegistryListener fsrl) {
        List list = this.registryListeners;
        synchronized (list) {
            this.registryListeners.add(fsrl);
        }
    }

    public void removeFSRegistryListener(FSRegistryListener fsrl) {
        List list = this.registryListeners;
        synchronized (list) {
            this.registryListeners.remove(fsrl);
        }
    }

    protected void fireFSInfoChanged(FSInfo fsInfo, boolean added) {
        ArrayList listeners;
        FSRegistryEvent evt = new FSRegistryEvent(this, fsInfo, added);
        List list = this.registryListeners;
        synchronized (list) {
            listeners = new ArrayList(this.registryListeners);
        }
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            FSRegistryListener l = (FSRegistryListener)it.next();
            if (added) {
                l.fsAdded(evt);
                continue;
            }
            l.fsRemoved(evt);
        }
    }
}

