/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.runtime;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import org.netbeans.modules.vcscore.runtime.RuntimeCommandsProvider;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryAdapter;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.WeakListener;

public class RuntimeMainChildren
extends Children.Keys {
    private static final String NUM_OF_FINISHED_CMDS_TO_COLLECT_CHANGED_METHOD = "numOfFinishedCmdsToCollectChanged";
    private LinkedList providerList;
    private RuntimeRepositoryListener rrl = new RuntimeRepositoryListener();

    public RuntimeMainChildren() {
        this.providerList = new LinkedList();
        Repository repos = Repository.getDefault();
        Enumeration enumeration = repos.getFileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fs = (FileSystem)enumeration.nextElement();
            RuntimeCommandsProvider provider = RuntimeCommandsProvider.findProvider(fs);
            if (provider == null || this.providerList.contains(provider)) continue;
            this.providerList.add(provider);
        }
        repos.addRepositoryListener(WeakListener.repository((RepositoryListener)this.rrl, (Object)repos));
        RuntimeCommandsProvider[] providers = RuntimeCommandsProvider.getRegistered();
        RuntimeCommandsProvider.addRegisteredListenerWeakly(this.rrl);
        if (providers != null) {
            this.providerList.addAll(Arrays.asList(providers));
        }
    }

    protected void addNotify() {
        this.setKeys(this.getProviders());
    }

    private Collection getProviders() {
        return this.providerList;
    }

    protected Node[] createNodes(Object key) {
        Node fsRuntime;
        RuntimeCommandsProvider provider = (RuntimeCommandsProvider)key;
        if (this.providerList.contains(provider) && (fsRuntime = provider.getNodeDelegate()) != null) {
            return new Node[]{fsRuntime};
        }
        return null;
    }

    public class RuntimeRepositoryListener
    extends RepositoryAdapter
    implements PropertyChangeListener {
        public void fileSystemAdded(RepositoryEvent ev) {
            FileSystem fs = ev.getFileSystem();
            RuntimeCommandsProvider provider = RuntimeCommandsProvider.findProvider(fs);
            if (provider != null && !RuntimeMainChildren.this.providerList.contains(provider)) {
                RuntimeMainChildren.this.providerList.add(provider);
                provider.notifyAdded();
                RuntimeMainChildren.super.setKeys(RuntimeMainChildren.this.providerList);
            }
        }

        public void fileSystemPoolReordered(RepositoryReorderedEvent ev) {
            super.fileSystemPoolReordered(ev);
        }

        public void fileSystemRemoved(RepositoryEvent ev) {
            FileSystem fs = ev.getFileSystem();
            RuntimeCommandsProvider provider = RuntimeCommandsProvider.findProvider(fs);
            if (provider != null && !this.containsProvider(ev.getRepository(), provider) && RuntimeMainChildren.this.providerList.remove(provider)) {
                provider.notifyRemoved();
                RuntimeMainChildren.super.setKeys(RuntimeMainChildren.this.providerList);
            }
        }

        private boolean containsProvider(Repository repository, RuntimeCommandsProvider provider) {
            Enumeration enumeration = repository.fileSystems();
            while (enumeration.hasMoreElements()) {
                FileSystem fs = (FileSystem)enumeration.nextElement();
                if (!provider.equals(RuntimeCommandsProvider.findProvider(fs))) continue;
                return true;
            }
            return false;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            RuntimeCommandsProvider oldProvider = (RuntimeCommandsProvider)propertyChangeEvent.getOldValue();
            RuntimeCommandsProvider newProvider = (RuntimeCommandsProvider)propertyChangeEvent.getNewValue();
            if (oldProvider != null) {
                RuntimeMainChildren.this.providerList.remove(oldProvider);
            }
            if (newProvider != null) {
                RuntimeMainChildren.this.providerList.add(newProvider);
                newProvider.notifyRemoved();
            }
            RuntimeMainChildren.super.setKeys(RuntimeMainChildren.this.providerList);
        }
    }
}

