/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.runtime;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.vcs.commands.Command;
import org.netbeans.api.vcs.commands.CommandTask;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.commands.CommandProcessListener;
import org.netbeans.modules.vcscore.commands.CommandProcessor;
import org.netbeans.modules.vcscore.commands.CommandTaskInfo;
import org.netbeans.modules.vcscore.runtime.RuntimeCommand;
import org.netbeans.modules.vcscore.runtime.RuntimeCommandTask;
import org.netbeans.modules.vcscore.runtime.RuntimeCommandsProvider;
import org.netbeans.modules.vcscore.runtime.RuntimeFolderNode;
import org.netbeans.spi.vcs.VcsCommandsProvider;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;

public class VcsRuntimeCommandsProvider
extends RuntimeCommandsProvider {
    private VcsFileSystem fs;
    private RuntimeCommandsListener rcl;
    private int numOfCommandsToKeep = 20;
    private List finishedCommands = new ArrayList();
    private List commands = new ArrayList();
    private Map runtimeCommandsForExecutors = new HashMap();
    private Map finishedExecutorsForCommands = new HashMap();
    private CommandProcessor processor = CommandProcessor.getInstance();

    public VcsRuntimeCommandsProvider(VcsFileSystem fs) {
        this.fs = fs;
        this.rcl = new RuntimeCommandsListener();
        this.processor.addCommandProcessListener(this.rcl);
        fs.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.rcl, (Object)fs));
        this.numOfCommandsToKeep = fs.getNumberOfFinishedCmdsToCollect();
    }

    protected Node createNodeDelegate() {
        String str;
        RuntimeFolderNode fsRuntime = new RuntimeFolderNode((Children)new RuntimeCommandsProvider.RuntimeFolderChildren(this));
        fsRuntime.setName(this.fs.getSystemName());
        fsRuntime.setDisplayName(this.fs.getDisplayName());
        fsRuntime.setNumOfFinishedCmdsToCollect(this.numOfCommandsToKeep);
        BeanDescriptor bd = VcsRuntimeCommandsProvider.getFsBeanDescriptor(this.fs);
        if (bd != null && (str = (String)bd.getValue("VCS Icon Base")) != null) {
            fsRuntime.setIconBase(str);
        }
        fsRuntime.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.rcl, (Object)((Object)fsRuntime)));
        return fsRuntime;
    }

    private static BeanDescriptor getFsBeanDescriptor(VcsFileSystem fs) {
        BeanInfo info;
        try {
            info = Utilities.getBeanInfo(fs.getClass());
        }
        catch (IntrospectionException intrExc) {
            return null;
        }
        if (info != null) {
            return info.getBeanDescriptor();
        }
        return null;
    }

    public RuntimeCommand[] children() {
        return this.commands.toArray(new RuntimeCommand[this.commands.size()]);
    }

    public boolean cutCommandsToMaxToKeep() {
        boolean cutted = false;
        VcsRuntimeCommandsProvider vcsRuntimeCommandsProvider = this;
        synchronized (vcsRuntimeCommandsProvider) {
            int current = this.commands.size();
            while (current > this.numOfCommandsToKeep && this.finishedCommands.size() > 0) {
                RuntimeCommand cmd = (RuntimeCommand)this.finishedCommands.remove(0);
                this.commands.remove(cmd);
                CommandTaskInfo vce = (CommandTaskInfo)this.finishedExecutorsForCommands.remove(cmd);
                --current;
                cutted = true;
            }
        }
        return cutted;
    }

    protected void notifyAdded() {
        this.processor.addCommandProcessListener(this.rcl);
    }

    protected void notifyRemoved() {
        this.processor.removeCommandProcessListener(this.rcl);
    }

    private class RuntimeCommandsListener
    implements CommandProcessListener,
    PropertyChangeListener {
        private VcsCommandsProvider provider;

        private RuntimeCommandsListener() {
            this.provider = VcsRuntimeCommandsProvider.this.fs.getCommandsProvider();
        }

        public VcsCommandsProvider getProvider() {
            return this.provider;
        }

        public void commandPreprocessing(Command command) {
        }

        public void commandPreprocessed(Command command, boolean status) {
        }

        public void commandStarting(CommandTaskInfo info) {
            RuntimeCommand cmd = (RuntimeCommand)VcsRuntimeCommandsProvider.this.runtimeCommandsForExecutors.get(info);
            if (cmd == null) {
                CommandTask task = info.getTask();
                if (!(task instanceof RuntimeCommandTask)) {
                    return;
                }
                cmd = ((RuntimeCommandTask)((Object)task)).getRuntimeCommand(info);
                if (cmd == null) {
                    return;
                }
                VcsRuntimeCommandsProvider vcsRuntimeCommandsProvider = VcsRuntimeCommandsProvider.this;
                synchronized (vcsRuntimeCommandsProvider) {
                    VcsRuntimeCommandsProvider.this.commands.add(cmd);
                    VcsRuntimeCommandsProvider.this.runtimeCommandsForExecutors.put(info, cmd);
                    VcsRuntimeCommandsProvider.this.cutCommandsToMaxToKeep();
                }
                VcsRuntimeCommandsProvider.this.firePropertyChange("children", null, null);
            }
            cmd.setState(11);
        }

        public void commandDone(CommandTaskInfo info) {
            RuntimeCommand cmd = (RuntimeCommand)VcsRuntimeCommandsProvider.this.runtimeCommandsForExecutors.get(info);
            if (cmd != null) {
                VcsRuntimeCommandsProvider vcsRuntimeCommandsProvider = VcsRuntimeCommandsProvider.this;
                synchronized (vcsRuntimeCommandsProvider) {
                    VcsRuntimeCommandsProvider.this.runtimeCommandsForExecutors.remove(info);
                    VcsRuntimeCommandsProvider.this.finishedExecutorsForCommands.put(cmd, info);
                    VcsRuntimeCommandsProvider.this.finishedCommands.add(cmd);
                    VcsRuntimeCommandsProvider.this.cutCommandsToMaxToKeep();
                }
                cmd.setState(12);
                VcsRuntimeCommandsProvider.this.firePropertyChange("children", null, null);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object source = propertyChangeEvent.getSource();
            String propertyName = propertyChangeEvent.getPropertyName();
            if (source == VcsRuntimeCommandsProvider.this.fs) {
                RuntimeFolderNode node;
                if ("numberOfFinishedCmdsToCollect".equals(propertyName)) {
                    int newNumOfCommandsToKeep = VcsRuntimeCommandsProvider.this.fs.getNumberOfFinishedCmdsToCollect();
                    if (VcsRuntimeCommandsProvider.this.numOfCommandsToKeep == newNumOfCommandsToKeep) {
                        return;
                    }
                    VcsRuntimeCommandsProvider.this.numOfCommandsToKeep = newNumOfCommandsToKeep;
                    RuntimeFolderNode node2 = (RuntimeFolderNode)VcsRuntimeCommandsProvider.this.getExistingNodeDelegate();
                    if (node2 != null) {
                        node2.setNumOfFinishedCmdsToCollect(VcsRuntimeCommandsProvider.this.numOfCommandsToKeep);
                    }
                    if (VcsRuntimeCommandsProvider.this.cutCommandsToMaxToKeep()) {
                        VcsRuntimeCommandsProvider.this.firePropertyChange("children", null, null);
                    }
                } else if ("displayName".equals(propertyName) && (node = (RuntimeFolderNode)VcsRuntimeCommandsProvider.this.getExistingNodeDelegate()) != null) {
                    node.setDisplayName(VcsRuntimeCommandsProvider.this.fs.getDisplayName());
                }
            } else if (source instanceof RuntimeFolderNode) {
                RuntimeFolderNode node = (RuntimeFolderNode)((Object)source);
                if ("numberOfFinishedCmdsToCollect".equals(propertyName)) {
                    int newNumOfCommandsToKeep = node.getNumOfFinishedCmdsToCollect();
                    if (VcsRuntimeCommandsProvider.this.numOfCommandsToKeep == newNumOfCommandsToKeep) {
                        return;
                    }
                    VcsRuntimeCommandsProvider.this.numOfCommandsToKeep = newNumOfCommandsToKeep;
                    VcsRuntimeCommandsProvider.this.fs.setNumberOfFinishedCmdsToCollect(VcsRuntimeCommandsProvider.this.numOfCommandsToKeep);
                    if (VcsRuntimeCommandsProvider.this.cutCommandsToMaxToKeep()) {
                        VcsRuntimeCommandsProvider.this.firePropertyChange("children", null, null);
                    }
                }
            }
        }
    }
}

