/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.settings;

import java.io.File;
import java.util.LinkedList;
import org.openide.options.SystemOption;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class GeneralVcsSettings
extends SystemOption {
    public static final String PROP_USE_GLOBAL = "useGlobal";
    public static final String PROP_OFFLINE = "offLine";
    public static final String PROP_AUTO_REFRESH = "autoRefresh";
    public static final String PROP_HOME = "home";
    public static final String PROP_HIDE_SHADOW_FILES = "hideShadowFiles";
    public static final String PROP_LAST_DIRECTORIES = "wizardDirectoryCache";
    public static final String PROP_CVS_COMMAND_PATH = "wizardCvsCommandPath";
    public static final String PROP_SH_COMMAND_PATH = "wizardShellCommandPath";
    public static final String PROP_SSH_WARNINGS_DONE = "wizardSshWarningsDone";
    public static final String PROP_AUTO_DETECT = "autoDetect";
    public static final int AUTO_REFRESH_NO_REFRESH = 0;
    public static final int AUTO_REFRESH_ON_DIR_OPEN = 1;
    public static final int AUTO_REFRESH_ON_MOUNT = 2;
    public static final int AUTO_REFRESH_ON_RESTART = 3;
    public static final int AUTO_REFRESH_ON_MOUNT_AND_RESTART = 4;
    private static final String DEFAULT_CVS_EXEC = "cvs";
    private static final String DEFAULT_SHELL_EXEC = "sh";
    private static String wizardCvsCommandPath;
    private static String wizardShellCommandPath;
    static final long serialVersionUID = -3279219340064367270L;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$settings$VcsSettings;

    protected void initialize() {
        super.initialize();
        this.setAutoDetect(true);
        this.setAutoRefresh(1);
        this.setHideShadowFiles(false);
        this.setOffLine(false);
        this.setUseGlobal(true);
        this.setWizardSshWarningsDone(false);
    }

    public String displayName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$settings$VcsSettings == null ? (class$org$netbeans$modules$vcscore$settings$VcsSettings = GeneralVcsSettings.class$("org.netbeans.modules.vcscore.settings.VcsSettings")) : class$org$netbeans$modules$vcscore$settings$VcsSettings)).getString("CTL_VcsSettings");
    }

    public boolean isUseGlobal() {
        return (Boolean)this.getProperty(PROP_USE_GLOBAL);
    }

    public void setUseGlobal(boolean global) {
        this.putProperty(PROP_USE_GLOBAL, global ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public boolean isOffLine() {
        return (Boolean)this.getProperty(PROP_OFFLINE);
    }

    public void setOffLine(boolean newOffLine) {
        this.putProperty(PROP_OFFLINE, newOffLine ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public int getAutoRefresh() {
        return (Integer)this.getProperty(PROP_AUTO_REFRESH);
    }

    public void setAutoRefresh(int newAutoRefresh) {
        this.putProperty(PROP_AUTO_REFRESH, new Integer(newAutoRefresh), true);
    }

    public boolean isAutoDetect() {
        return (Boolean)this.getProperty(PROP_AUTO_DETECT);
    }

    public void setAutoDetect(boolean newAutoDetect) {
        this.putProperty(PROP_AUTO_DETECT, newAutoDetect ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public File getHome() {
        String home = System.getProperty("Env-HOME");
        if (home == null && Utilities.isWindows()) {
            String homeDrive = System.getProperty("Env-HOMEDRIVE");
            String homeDir = System.getProperty("Env-HOMEPATH");
            if (homeDrive != null && homeDir != null) {
                home = homeDrive + homeDir;
            }
        }
        if (home == null) {
            home = System.getProperty("user.home");
            File fhome = new File(home);
            this.setHome(fhome);
            return fhome;
        }
        return new File(home);
    }

    public void setHome(File home) {
        int index;
        if (home == null) {
            return;
        }
        String homepath = home.getAbsolutePath();
        System.setProperty("Env-HOME", homepath);
        System.setProperty("env-home", homepath.toLowerCase());
        if (Utilities.isWindows() && (index = homepath.indexOf(58)) > 0) {
            String homeDrive = homepath.substring(0, index + 1);
            String homeDir = index + 1 < homepath.length() ? homepath.substring(index + 1) : "\\";
            System.setProperty("Env-HOMEDRIVE", homeDrive);
            System.setProperty("env-homedrive", homeDrive.toLowerCase());
            System.setProperty("Env-HOMEPATH", homeDir);
            System.setProperty("env-homepath", homeDir.toLowerCase());
        }
        this.firePropertyChange(PROP_HOME, null, home);
    }

    public void setHideShadowFiles(boolean hide) {
        this.putProperty(PROP_HIDE_SHADOW_FILES, hide ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public boolean isHideShadowFiles() {
        return (Boolean)this.getProperty(PROP_HIDE_SHADOW_FILES);
    }

    public LinkedList getWizardDirectoryCache() {
        Object[] arr = (Object[])this.getProperty(PROP_LAST_DIRECTORIES);
        LinkedList<Object> toReturn = new LinkedList<Object>();
        if (arr != null) {
            int i = 0;
            while (i < arr.length) {
                toReturn.add(arr[i]);
                ++i;
            }
        }
        return toReturn;
    }

    public void setWizardDirectoryCache(LinkedList cache) {
        if (cache == null) {
            cache = new LinkedList();
        }
        this.putProperty(PROP_LAST_DIRECTORIES, cache.toArray());
        this.firePropertyChange(PROP_LAST_DIRECTORIES, null, cache.toArray());
    }

    public String getWizardCvsCommandPath() {
        if (wizardCvsCommandPath == null || wizardCvsCommandPath.length() == 0) {
            return DEFAULT_CVS_EXEC;
        }
        return wizardCvsCommandPath;
    }

    public void setWizardCvsCommandPath(String cvsCommandPath) {
        wizardCvsCommandPath = cvsCommandPath;
    }

    public String getWizardShellCommandPath() {
        if (wizardShellCommandPath == null || wizardShellCommandPath.length() == 0) {
            return DEFAULT_SHELL_EXEC;
        }
        return wizardShellCommandPath;
    }

    public void setWizardShellCommandPath(String shellCommandPath) {
        wizardShellCommandPath = shellCommandPath;
    }

    public void setWizardSshWarningsDone(boolean done) {
        this.putProperty(PROP_SSH_WARNINGS_DONE, done ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isWizardSshWarningsDone() {
        return (Boolean)this.getProperty(PROP_SSH_WARNINGS_DONE);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

