/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.settings;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.LinkedList;
import org.netbeans.modules.vcscore.settings.GeneralVcsSettings;
import org.openide.options.SystemOption;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;

public class VcsSettings
extends SystemOption {
    private static final int AUTO_REFRESH_NO_REFRESH = 0;
    private static final int AUTO_REFRESH_ON_DIR_OPEN = 1;
    private static final int AUTO_REFRESH_ON_MOUNT = 2;
    private static final int AUTO_REFRESH_ON_RESTART = 3;
    private static final int AUTO_REFRESH_ON_MOUNT_AND_RESTART = 4;
    private static final String DEFAULT_CVS_EXEC = "cvs";
    private static final String DEFAULT_SHELL_EXEC = "sh";
    private static boolean useGlobal = true;
    private static boolean offLine = false;
    private static int autoRefresh = 1;
    private static boolean hideShadowFiles = false;
    private static String wizardCvsCommandPath;
    private static String wizardShellCommandPath;
    private static LinkedList wizardDirectoryCache;
    static final long serialVersionUID = 2366734217889995634L;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$settings$VcsSettings;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings;

    public String displayName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$settings$VcsSettings == null ? (class$org$netbeans$modules$vcscore$settings$VcsSettings = VcsSettings.class$("org.netbeans.modules.vcscore.settings.VcsSettings")) : class$org$netbeans$modules$vcscore$settings$VcsSettings)).getString("CTL_VcsSettings");
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        GeneralVcsSettings settings = (GeneralVcsSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings == null ? (class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings = VcsSettings.class$("org.netbeans.modules.vcscore.settings.GeneralVcsSettings")) : class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings), (boolean)true);
        settings.setUseGlobal(useGlobal);
        settings.setOffLine(offLine);
        settings.setHome(new File(this.getHome()));
        settings.setHideShadowFiles(hideShadowFiles);
        settings.setAutoRefresh(autoRefresh);
        settings.setWizardCvsCommandPath(wizardCvsCommandPath);
        settings.setWizardDirectoryCache(wizardDirectoryCache);
        settings.setWizardShellCommandPath(wizardShellCommandPath);
    }

    public boolean isUseGlobal() {
        return useGlobal;
    }

    public void setUseGlobal(boolean global) {
        useGlobal = global;
    }

    public boolean isOffLine() {
        return offLine;
    }

    public void setOffLine(boolean newOffLine) {
        offLine = newOffLine;
    }

    public int getAutoRefresh() {
        return autoRefresh;
    }

    public void setAutoRefresh(int newAutoRefresh) {
        autoRefresh = newAutoRefresh;
    }

    public String getHome() {
        String home = System.getProperty("Env-HOME");
        if (home == null && Utilities.isWindows()) {
            String homeDrive = System.getProperty("Env-HOMEDRIVE");
            String homeDir = System.getProperty("Env-HOMEPATH");
            if (homeDrive != null && homeDir != null) {
                home = homeDrive + homeDir;
            }
        }
        return home;
    }

    public void setHome(String home) {
        int index;
        if (home == null) {
            return;
        }
        System.setProperty("Env-HOME", home);
        System.setProperty("env-home", home.toLowerCase());
        if (Utilities.isWindows() && (index = home.indexOf(58)) > 0) {
            String homeDrive = home.substring(0, index + 1);
            String homeDir = index + 1 < home.length() ? home.substring(index + 1) : "\\";
            System.setProperty("Env-HOMEDRIVE", homeDrive);
            System.setProperty("env-homedrive", homeDrive.toLowerCase());
            System.setProperty("Env-HOMEPATH", homeDir);
            System.setProperty("env-homepath", homeDir.toLowerCase());
        }
    }

    public void setHideShadowFiles(boolean hide) {
        hideShadowFiles = hide;
    }

    public boolean isHideShadowFiles() {
        return hideShadowFiles;
    }

    public LinkedList getWizardDirectoryCache() {
        if (wizardDirectoryCache == null) {
            wizardDirectoryCache = new LinkedList();
        }
        return wizardDirectoryCache;
    }

    public void setWizardDirectoryCache(LinkedList cache) {
        wizardDirectoryCache = cache;
    }

    public String getWizardCvsCommandPath() {
        if (wizardCvsCommandPath == null || wizardCvsCommandPath.length() == 0) {
            return DEFAULT_CVS_EXEC;
        }
        return wizardCvsCommandPath;
    }

    public void setWizardCvsCommandPath(String cvsCommandPath) {
        wizardCvsCommandPath = cvsCommandPath;
    }

    public String getWizardShellCommandPath() {
        if (wizardShellCommandPath == null || wizardShellCommandPath.length() == 0) {
            return DEFAULT_SHELL_EXEC;
        }
        return wizardShellCommandPath;
    }

    public void setWizardShellCommandPath(String shellCommandPath) {
        wizardShellCommandPath = shellCommandPath;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

