/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.ui.views;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.vcscore.ui.views.ChildrenInfoFilter;
import org.netbeans.modules.vcscore.ui.views.FileVcsInfoChildren;
import org.netbeans.modules.vcscore.ui.views.FileVcsInfoFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

public class FileVcsInfo
implements Node.Cookie {
    public static final String BLANK = "BLANK";
    public static final String PROPERTY_NODE_PATH = "NODE_PATH";
    public static final String PROPERTY_FILTER = "FILTER_UPDATED";
    private static final String PROPERTY_CHILDREN = "Children.Keys Instance";
    private File file;
    private transient WeakReference fileObject = null;
    private transient WeakReference versFileObject = null;
    private transient FileVcsInfoFactory.GeneralTypeInfo info;
    private String type;
    private Map attrMap;
    private boolean dumped;
    private File dumpFile;
    private transient PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public FileVcsInfo() {
        this(new File(""), BLANK, (Children)new FileVcsInfoChildren());
    }

    private FileVcsInfo(File file, Children children) {
        this.file = file;
        this.attrMap = new HashMap(6, 0.9f);
        this.setAttribute(PROPERTY_CHILDREN, children);
        this.dumped = false;
    }

    public FileVcsInfo(File file, String type, Children children) {
        this(file, children);
        this.type = type;
    }

    public File getFile() {
        return this.file;
    }

    public Children getChildren() {
        return (Children)this.getAttribute(PROPERTY_CHILDREN);
    }

    protected void reviveDumpedIfNeccesary(String attrName) {
        if (!this.dumped || this.info.isDumpAbleAttribute(attrName)) {
            // empty if block
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dumpAttributesToDisk() {
        if (this.dumped) {
            return;
        }
        String[] attrs = this.info.getAttributesAllowedToDump();
        if (attrs == null) return;
        ObjectOutputStream stream = null;
        this.dumpFile = File.createTempFile(this.getType(), "dmp");
        this.dumpFile.deleteOnExit();
        stream = new ObjectOutputStream(new FileOutputStream(this.dumpFile));
        int i = 0;
        while (i < attrs.length) {
            Object value = this.getAttribute(attrs[i]);
            if (value instanceof Composite) {
                Composite comp = (Composite)value;
                comp.dumpAllRows(this, stream);
            } else {
                stream.writeUTF(attrs[i]);
                stream.writeObject(value);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < attrs.length) {
            this.attrMap.remove(attrs[i2]);
            ++i2;
        }
        this.dumped = true;
        Object var7_8 = null;
        if (stream == null) return;
        try {
            stream.close();
            return;
        }
        catch (IOException exc2) {
            this.dumped = false;
        }
        return;
        {
            catch (IOException exc) {
                this.dumped = false;
                Object var7_9 = null;
                if (stream == null) return;
                try {
                    stream.close();
                    return;
                }
                catch (IOException exc2) {
                    this.dumped = false;
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (stream == null) throw throwable;
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException exc2) {
                this.dumped = false;
            }
            throw throwable;
        }
    }

    public void setChildrenFilter(ChildrenInfoFilter filter) {
        this.setChildrenFilter(filter, true);
    }

    private void setChildrenFilter(ChildrenInfoFilter filter, boolean recursive) {
        Children childs = this.getChildren();
        if (childs instanceof FileVcsInfoChildren) {
            FileVcsInfoChildren myChilds = (FileVcsInfoChildren)childs;
            Iterator it = myChilds.getAllKeys();
            while (it.hasNext()) {
                FileVcsInfo info = (FileVcsInfo)it.next();
                info.setChildrenFilter(filter);
            }
            myChilds.setChildrenNodesFilter(filter);
            this.firePropertyChange(PROPERTY_FILTER, null, filter);
        }
    }

    void replaceChildrenWithClone() {
        if (this.getChildren() instanceof FileVcsInfoChildren) {
            Children newChildren = (Children)((FileVcsInfoChildren)this.getChildren()).clone();
            this.setAttribute(PROPERTY_CHILDREN, newChildren);
        }
    }

    void setGeneralTypeInfo(FileVcsInfoFactory.GeneralTypeInfo info) {
        this.info = info;
    }

    void overwriteAttributesFrom(FileVcsInfo source) {
        Children childs = this.getChildren();
        this.attrMap.clear();
        this.attrMap = source.getMap();
    }

    Map getMap() {
        return this.attrMap;
    }

    public SystemAction[] getAdditionalActions() {
        if (this.info != null) {
            return this.info.getAdditionalActions();
        }
        return null;
    }

    public void setAttribute(String attrName, Object value) {
        this.reviveDumpedIfNeccesary(attrName);
        this.attrMap.put(attrName, value);
        this.firePropertyChange(attrName, null, value);
    }

    public Object getAttribute(String attributeName) {
        this.reviveDumpedIfNeccesary(attributeName);
        return this.attrMap.get(attributeName);
    }

    public String getAttributeNonNull(String attributeName) {
        this.reviveDumpedIfNeccesary(attributeName);
        Object obj = this.attrMap.get(attributeName);
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    public String getType() {
        return this.type;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    private void firePropertyChange(String propname, Object old, Object neu) {
        this.changeSupport.firePropertyChange(propname, old, neu);
    }

    public static class CompositeItem
    implements Serializable {
        static final long serialVersionUID = 0L;
        private Map attrMap = new HashMap(5, 0.9f);

        public void setAttribute(String attrName, Object value) {
            this.attrMap.put(attrName, value);
        }

        public Object getAttribute(String attributeName) {
            return this.attrMap.get(attributeName);
        }

        public String getAttributeNonNull(String attributeName) {
            Object obj = this.attrMap.get(attributeName);
            if (obj == null) {
                return "";
            }
            return obj.toString();
        }
    }

    public static class Composite {
        public static final String PROPERTY_SELECTED_ITEMS = "SelectedItems";
        public static final String PROPERTY_ADDED_ITEM = "AddedItem";
        static final String COMPOSITE_BLOCK_START = "COMPOSITE_DUMP_BLOCK_START";
        static final String COMPOSITE_BLOCK_END = "COMPOSITE_DUMP_BLOCK_END";
        private String type;
        private List list;
        private FileVcsInfo info;
        private CompositeItem[] selectedItems;
        private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

        public Composite(String type) {
            this.list = new ArrayList();
            this.type = type;
            this.info = null;
        }

        public Composite(List list, String type) {
            this.type = type;
            this.list = new ArrayList(list);
        }

        void dumpAllRows(FileVcsInfo info, ObjectOutputStream stream) throws IOException {
            this.info = info;
            Iterator it = this.list.iterator();
            stream.writeUTF(this.getType());
            stream.writeObject(COMPOSITE_BLOCK_START);
            while (it.hasNext()) {
                stream.writeObject(it.next());
                it.remove();
            }
            stream.writeObject(COMPOSITE_BLOCK_END);
        }

        void reviveDumpedRows(ObjectOutputStream stream) throws IOException {
        }

        protected void reviveDumpedIfNeccesary() {
            if (this.info != null) {
                this.info.reviveDumpedIfNeccesary(this.getType());
            }
        }

        public void appendRow(CompositeItem item) {
            this.reviveDumpedIfNeccesary();
            this.list.add(item);
            this.firePropertyChange(PROPERTY_ADDED_ITEM, null, item);
        }

        public String getType() {
            return this.type;
        }

        public CompositeItem getRow(int row) {
            this.reviveDumpedIfNeccesary();
            if (row >= 0 && row < this.list.size()) {
                return (CompositeItem)this.list.get(row);
            }
            return null;
        }

        public Object getItem(int row, String attributeName) {
            this.reviveDumpedIfNeccesary();
            if (row >= 0 && row < this.list.size()) {
                CompositeItem item = (CompositeItem)this.list.get(row);
                return item.getAttribute(attributeName);
            }
            return null;
        }

        public int getCount() {
            this.reviveDumpedIfNeccesary();
            return this.list.size();
        }

        public void setSelectedItems(CompositeItem[] items) {
            CompositeItem[] oldItems = this.selectedItems;
            this.selectedItems = items;
            this.firePropertyChange(PROPERTY_SELECTED_ITEMS, oldItems, this.selectedItems);
        }

        public CompositeItem[] getSelectedItems() {
            return this.selectedItems;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.removePropertyChangeListener(listener);
        }

        private void firePropertyChange(String propname, Object old, Object neu) {
            this.changeSupport.firePropertyChange(propname, old, neu);
        }
    }
}

