/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.ui.views;

import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.vcscore.ui.views.ChildrenInfoFilter;
import org.netbeans.modules.vcscore.ui.views.FileInfoNode;
import org.netbeans.modules.vcscore.ui.views.FileVcsInfo;
import org.netbeans.modules.vcscore.versioning.VersioningRepository;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.WeakSet;

public class FileVcsInfoChildren
extends Children.Keys {
    private boolean filteredListCreated = false;
    private boolean addNotifyCalled = false;
    private List keyList = Collections.synchronizedList(new ArrayList());
    private ChildrenInfoFilter filter;
    private List filteredList = new ArrayList();
    private WeakSet weakNodesSet = new WeakSet();

    protected void addNotify() {
        if (!this.filteredListCreated) {
            Collections.sort(this.keyList, new FileVcsInfoComparator());
            this.createFilteredList();
        }
        this.setFilteredKeys();
        this.addNotifyCalled = true;
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        this.addNotifyCalled = false;
        this.filteredListCreated = false;
        this.filteredList.clear();
    }

    public void updateFilter() {
        if (this.filteredListCreated) {
            Collections.sort(this.keyList, new FileVcsInfoComparator());
            this.createFilteredList();
            if (this.addNotifyCalled) {
                this.setFilteredKeys();
            }
        }
    }

    private List createFilteredList() {
        List toReturn = this.filteredList;
        toReturn.clear();
        Iterator it = this.keyList.iterator();
        while (it.hasNext()) {
            FileVcsInfo info = (FileVcsInfo)it.next();
            if (this.filter != null) {
                if (!this.filter.checkFileInfo(info)) continue;
                toReturn.add(info);
                continue;
            }
            toReturn.add(info);
        }
        this.filteredListCreated = true;
        return toReturn;
    }

    private void setFilteredKeys() {
        this.setKeys(this.filteredList);
    }

    public void addKey(FileVcsInfo info) {
        this.keyList.add(info);
        this.updateFilter();
    }

    public void removeKey(FileVcsInfo info) {
        this.keyList.remove(info);
        this.filteredList.remove(info);
        this.updateFilter();
    }

    public FileVcsInfo findKeyByFileName(String name) {
        ArrayList newList = new ArrayList(this.keyList);
        Iterator it = newList.iterator();
        while (it.hasNext()) {
            FileVcsInfo info = (FileVcsInfo)it.next();
            if (!name.equals(info.getFile().getName())) continue;
            return info;
        }
        return null;
    }

    public Iterator getAllKeys() {
        ArrayList newList = new ArrayList(this.keyList);
        return newList.iterator();
    }

    public Iterator getFilteredKeys() {
        if (!this.filteredListCreated) {
            Collections.sort(this.keyList, new FileVcsInfoComparator());
            this.createFilteredList();
        }
        return ((AbstractList)new ArrayList(this.filteredList)).iterator();
    }

    public int getTotalKeyCount() {
        return this.keyList.size();
    }

    public int getFilteredKeyCount() {
        return this.filteredList.size();
    }

    void setChildrenNodesFilter(ChildrenInfoFilter filter) {
        this.filter = filter;
        if (this.filteredListCreated) {
            this.updateFilter();
        }
    }

    public void refreshThisKey(Object key) {
        super.refreshKey(key);
    }

    protected Node[] createNodes(Object key) {
        if (!(key instanceof FileVcsInfo)) {
            return new Node[0];
        }
        FileVcsInfo info = (FileVcsInfo)key;
        DataObject dobj = FileVcsInfoChildren.findVersioningDO(info);
        if (dobj != null) {
            FileInfoNode newNode = null;
            if (!info.getChildren().equals(Children.LEAF)) {
                info.replaceChildrenWithClone();
                newNode = new FileInfoNode(dobj, info);
            } else {
                newNode = new FileInfoNode(dobj, info);
            }
            return new Node[]{newNode};
        }
        if (!info.getChildren().equals(Children.LEAF)) {
            info.replaceChildrenWithClone();
        }
        FileInfoNode nd = new FileInfoNode((Node)new DummyNode(info), info);
        return new Node[]{nd};
    }

    static DataObject findVersioningDO(FileVcsInfo info) {
        VersioningRepository rep = VersioningRepository.getRepository();
        File fl = info.getFile();
        if (fl != null) {
            try {
                String fileName = fl.getCanonicalPath();
                File file = fl.getCanonicalFile();
                List fsList = rep.getVersioningFileSystems();
                FileSystem fs = null;
                Iterator it = fsList.iterator();
                while (it.hasNext()) {
                    File file2Fo;
                    String rootName;
                    File root;
                    fs = (FileSystem)it.next();
                    if (fs == null || (root = FileUtil.toFile((FileObject)fs.getRoot())) == null || fileName.indexOf(rootName = root.getCanonicalPath()) != 0) continue;
                    String res = fileName.substring(rootName.length()).replace(File.separatorChar, '/');
                    FileObject fo = fs.findResource(res);
                    File file2 = file2Fo = fo != null ? FileUtil.toFile((FileObject)fo) : null;
                    if (fo == null || file2Fo == null || !file.equals(file2Fo.getCanonicalFile())) continue;
                    try {
                        DataObject dobj = DataObject.find((FileObject)fo);
                        return dobj;
                    }
                    catch (DataObjectNotFoundException exc) {
                        exc.printStackTrace();
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public Object clone() {
        FileVcsInfoChildren childs = new FileVcsInfoChildren();
        childs.initialize(this.keyList, this.filter, this.filteredList, this.filteredListCreated);
        return childs;
    }

    void initialize(List keyList, ChildrenInfoFilter filter, List filterList, boolean filterListCreated) {
        this.keyList = keyList;
        this.filter = filter;
        this.filteredListCreated = this.filteredListCreated;
        this.filteredList = filterList;
    }

    private static class DummyNode
    extends AbstractNode {
        private FileVcsInfo info;
        static /* synthetic */ Class class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo;

        public DummyNode(FileVcsInfo info) {
            super(info.getChildren());
            this.info = info;
            this.setName(info.getFile().getName());
        }

        public Node.Cookie getCookie(Class clazz) {
            if (clazz.equals(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? (class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo = DummyNode.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo")) : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo)) {
                return this.info;
            }
            return super.getCookie(clazz);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class FileVcsInfoComparator
    implements Comparator {
        private FileVcsInfoComparator() {
        }

        public int compare(Object o1, Object o2) {
            FileVcsInfo info1 = (FileVcsInfo)o1;
            FileVcsInfo info2 = (FileVcsInfo)o2;
            if (info1.getFile().isDirectory() && !info2.getFile().isDirectory()) {
                return -1;
            }
            if (!info1.getFile().isDirectory() && info2.getFile().isDirectory()) {
                return 1;
            }
            return info1.getFile().compareTo(info2.getFile());
        }
    }
}

