/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.ui.views;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import org.netbeans.modules.vcscore.ui.views.FileVcsInfo;
import org.netbeans.modules.vcscore.ui.views.FileVcsInfoChildren;
import org.netbeans.modules.vcscore.util.table.ColumnSortListener;
import org.netbeans.modules.vcscore.util.table.TableInfoModel;
import org.openide.ErrorManager;
import org.openide.awt.MouseUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Lookup;
import org.openide.util.WeakListener;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;

public class NodesTableView
extends JScrollPane
implements Externalizable {
    static final long serialVersionUID = 0L;
    private transient ExplorerManager manager;
    protected transient JTable table;
    protected transient TableInfoModel model;
    transient Listener managerListener;
    transient PropertyChangeListener wlpc;
    transient VetoableChangeListener wlvc;
    transient PopupAdapter popupListener;
    transient TableNodeListener nodeListener;
    private boolean popupAllowed = true;
    private boolean traversalAllowed = true;
    private ActionListener defaultProcessor;
    transient boolean listenerActive;
    private String compositeAttributeName;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo;

    public NodesTableView(TableInfoModel model) {
        this.model = model;
        this.initializeTable();
    }

    private void initializeTable() {
        this.table = this.createTable();
        this.table.setModel(this.model);
        JTableHeader head = this.table.getTableHeader();
        head.setUpdateTableInRealTime(true);
        ColumnSortListener listen = new ColumnSortListener(this.table);
        head.addMouseListener(listen);
        this.setViewportView(this.table);
        this.managerListener = new Listener();
        this.popupListener = new PopupAdapter();
        this.nodeListener = new TableNodeListener();
        this.model.addTableModelListener(this.managerListener);
        this.table.addMouseListener(this.managerListener);
        this.table.addMouseListener((MouseListener)((Object)this.popupListener));
        this.table.getSelectionModel().setSelectionMode(2);
        ToolTipManager.sharedInstance().registerComponent(this.table);
        this.table.addFocusListener(new FocusAdapter());
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.popupAllowed ? Boolean.TRUE : Boolean.FALSE);
        out.writeObject(this.traversalAllowed ? Boolean.TRUE : Boolean.FALSE);
        out.writeObject(this.compositeAttributeName);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.popupAllowed = (Boolean)in.readObject();
        this.traversalAllowed = (Boolean)in.readObject();
        this.compositeAttributeName = in.readUTF();
    }

    public boolean isPopupAllowed() {
        return this.popupAllowed;
    }

    public void setPopupAllowed(boolean value) {
        this.popupAllowed = value;
    }

    public boolean isTraversalAllowed() {
        return false;
    }

    public void setTraversalAllowed(boolean value) {
        this.traversalAllowed = value;
    }

    public ActionListener getDefaultProcessor() {
        return this.defaultProcessor;
    }

    public void setDefaultProcessor(ActionListener value) {
        this.defaultProcessor = value;
    }

    public int getSelectionMode() {
        return this.table.getSelectionModel().getSelectionMode();
    }

    public boolean isDragSource() {
        return false;
    }

    public void setDragSource(boolean state) {
    }

    public boolean isDropTarget() {
        return false;
    }

    public void setDropTarget(boolean state) {
    }

    protected JTable createTable() {
        NbTable table = new NbTable();
        return table;
    }

    public TableInfoModel getTableModel() {
        return this.model;
    }

    protected void selectionChanged(Node[] nodes, ExplorerManager em) throws PropertyVetoException {
        em.setSelectedNodes(nodes);
    }

    protected boolean selectionAccept(Node[] nodes) {
        return true;
    }

    private void fillModelWithData(FileVcsInfo parentInfo) {
        Children childs = parentInfo.getChildren();
        if (!childs.equals(Children.LEAF)) {
            Iterator en = ((FileVcsInfoChildren)childs).getFilteredKeys();
            while (en.hasNext()) {
                FileVcsInfo info = (FileVcsInfo)en.next();
                if (info != null && !info.getType().startsWith("BLANK")) {
                    this.model.addElement(info);
                }
                if (Children.LEAF.equals(info.getChildren())) continue;
                this.fillModelWithData(info);
            }
        }
    }

    private void clearModel() {
        this.model.clear();
    }

    public void addNotify() {
        FileVcsInfo info;
        super.addNotify();
        ExplorerManager em = ExplorerManager.find((Component)this);
        if (em != this.manager) {
            if (this.manager != null) {
                this.manager.removeVetoableChangeListener(this.wlvc);
                this.manager.removePropertyChangeListener(this.wlpc);
            }
            this.manager = em;
            this.wlvc = WeakListener.vetoableChange((VetoableChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addVetoableChangeListener(this.wlvc);
            this.wlpc = WeakListener.propertyChange((PropertyChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addPropertyChangeListener(this.wlpc);
            this.clearModel();
            info = (FileVcsInfo)this.manager.getRootContext().getCookie(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? (class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo = NodesTableView.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo")) : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo);
            if (info != null) {
                this.fillModelWithData(info);
            }
        }
        if (!this.listenerActive) {
            this.listenerActive = true;
            this.table.getSelectionModel().addListSelectionListener(this.managerListener);
            if (this.manager != null && (info = (FileVcsInfo)this.manager.getRootContext().getCookie(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? (class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo = NodesTableView.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo")) : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo)) != null) {
                info.addPropertyChangeListener(this.managerListener);
            }
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.listenerActive = false;
        this.table.getSelectionModel().removeListSelectionListener(this.managerListener);
        FileVcsInfo info = (FileVcsInfo)this.manager.getRootContext().getCookie(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? (class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo = NodesTableView.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo")) : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo);
        if (info != null) {
            info.removePropertyChangeListener(this.managerListener);
        }
    }

    public void requestFocus() {
        this.table.requestFocus();
    }

    final void performObjectAt(int index, int modifiers) {
        if (index < 0 || index >= this.model.getRowCount()) {
            return;
        }
    }

    void createPopup(int xpos, int ypos) {
        if (this.manager == null) {
            return;
        }
        if (!this.popupAllowed) {
            return;
        }
        JPopupMenu popup = NodeOp.findContextMenu((Node[])this.manager.getSelectedNodes());
        if (popup != null && popup.getSubElements().length > 0) {
            Point p = this.getViewport().getViewPosition();
            p.x = xpos - p.x;
            p.y = ypos - p.y;
            SwingUtilities.convertPointToScreen(p, this);
            Dimension popupSize = popup.getPreferredSize();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            if (p.x + popupSize.width > screenSize.width) {
                p.x = screenSize.width - popupSize.width;
            }
            if (p.y + popupSize.height > screenSize.height) {
                p.y = screenSize.height - popupSize.height;
            }
            SwingUtilities.convertPointFromScreen(p, this);
            popup.show(this, p.x, p.y);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class Listener
    extends MouseAdapter
    implements TableModelListener,
    ListSelectionListener,
    PropertyChangeListener,
    VetoableChangeListener {
        static /* synthetic */ Class class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo;

        private Listener() {
        }

        public void tableChanged(TableModelEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            if (MouseUtils.isDoubleClick((MouseEvent)e)) {
                // empty if block
            }
        }

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            Node[] newNodes;
            NodesTableView.this.manager;
            if ("selectedNodes".equals(evt.getPropertyName()) && !NodesTableView.this.selectionAccept(newNodes = (Node[])evt.getNewValue())) {
                throw new PropertyVetoException("", evt);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            FileVcsInfo info;
            NodesTableView.this.manager;
            if ("selectedNodes".equals(evt.getPropertyName()) && evt.getNewValue() != null) {
                Node[] nodes = (Node[])evt.getNewValue();
                List list = NodesTableView.this.model.getList();
                NodesTableView.this.table.getSelectionModel().clearSelection();
                NodesTableView.this.table.getSelectionModel().setSelectionMode(2);
                NodesTableView.this.table.getSelectionModel().setValueIsAdjusting(true);
                int i = 0;
                while (i < nodes.length) {
                    FileVcsInfo info2 = (FileVcsInfo)nodes[i].getCookie(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? Listener.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo") : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo);
                    int index = list.indexOf(info2);
                    if (index >= 0 && !NodesTableView.this.table.getSelectionModel().isSelectedIndex(index)) {
                        NodesTableView.this.table.getSelectionModel().addSelectionInterval(index, index);
                    }
                    ++i;
                }
                NodesTableView.this.table.getSelectionModel().setValueIsAdjusting(false);
                return;
            }
            if ("exploredContext".equals(evt.getPropertyName())) {
                return;
            }
            if ("FILTER_UPDATED".equals(evt.getPropertyName()) && (info = (FileVcsInfo)NodesTableView.this.manager.getRootContext().getCookie(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? (class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo = Listener.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo")) : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo)) != null) {
                NodesTableView.this.clearModel();
                NodesTableView.this.fillModelWithData(info);
                NodesTableView.this.model.fireTableDataChanged();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void valueChanged(ListSelectionEvent e) {
            int[] rows = NodesTableView.this.table.getSelectedRows();
            Node[] nodes = new Node[rows.length];
            int i = 0;
            while (i < nodes.length) {
                FileVcsInfo info = (FileVcsInfo)NodesTableView.this.model.getElementAt(rows[i]);
                String path = (String)info.getAttribute("NODE_PATH");
                path = path == null || path.length() == 0 ? info.getFile().getName() : path + "/" + info.getFile().getName();
                try {
                    Node selNode;
                    nodes[i] = selNode = NodeOp.findPath((Node)NodesTableView.this.manager.getRootContext(), (Enumeration)new StringTokenizer(path, "/"));
                }
                catch (NodeNotFoundException exc) {
                    ErrorManager.getDefault().notify((Throwable)exc);
                }
                ++i;
            }
            NodesTableView.this.manager.removePropertyChangeListener(NodesTableView.this.wlpc);
            NodesTableView.this.manager.removeVetoableChangeListener(NodesTableView.this.wlvc);
            try {
                try {
                    NodesTableView.this.selectionChanged(nodes, NodesTableView.this.manager);
                }
                catch (PropertyVetoException ex) {
                    Object var9_11 = null;
                    NodesTableView.this.manager.addPropertyChangeListener(NodesTableView.this.wlpc);
                    NodesTableView.this.manager.addVetoableChangeListener(NodesTableView.this.wlvc);
                    return;
                }
                Object var9_10 = null;
                NodesTableView.this.manager.addPropertyChangeListener(NodesTableView.this.wlpc);
                NodesTableView.this.manager.addVetoableChangeListener(NodesTableView.this.wlvc);
                return;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                NodesTableView.this.manager.addPropertyChangeListener(NodesTableView.this.wlpc);
                NodesTableView.this.manager.addVetoableChangeListener(NodesTableView.this.wlvc);
                throw throwable;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    final class FocusAdapter
    implements FocusListener {
        CallbackSystemAction csa;
        PopupPerformer performer;
        static /* synthetic */ Class class$org$openide$ErrorManager;

        FocusAdapter() {
        }

        public void focusGained(FocusEvent ev) {
            if (this.csa == null) {
                try {
                    Class<?> popup = Class.forName("org.openide.actions.PopupAction");
                    this.csa = (CallbackSystemAction)SystemAction.get(popup);
                    this.performer = new PopupPerformer();
                }
                catch (ClassNotFoundException e) {
                    NoClassDefFoundError err = new NoClassDefFoundError();
                    ErrorManager em = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = FocusAdapter.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
                    if (em != null) {
                        em.annotate((Throwable)err, (Throwable)e);
                    }
                    throw err;
                }
            }
            this.csa.setActionPerformer((ActionPerformer)this.performer);
        }

        public void focusLost(FocusEvent ev) {
            if (this.csa != null && this.csa.getActionPerformer() instanceof PopupPerformer) {
                this.csa.setActionPerformer(null);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    final class PopupPerformer
    implements ActionPerformer {
        PopupPerformer() {
        }

        public void performAction(SystemAction act) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int i;
                    ListSelectionModel mod = ((PopupPerformer)this).NodesTableView.this.table.getSelectionModel();
                    boolean multisel = mod.getSelectionMode() != 0;
                    int n = i = multisel ? mod.getLeadSelectionIndex() : mod.getLeadSelectionIndex();
                    if (i < 0) {
                        return;
                    }
                    Rectangle rect = ((PopupPerformer)this).NodesTableView.this.table.getCellRect(((PopupPerformer)this).NodesTableView.this.table.getSelectedRow(), ((PopupPerformer)this).NodesTableView.this.table.getSelectedColumn(), false);
                    Point p = rect.getLocation();
                    if (p == null) {
                        return;
                    }
                    NodesTableView.this.createPopup(p.x, p.y);
                }
            });
        }
    }

    private final class PopupAdapter
    extends MouseUtils.PopupMouseAdapter {
        private PopupAdapter() {
        }

        protected void showPopup(MouseEvent e) {
            int i = NodesTableView.this.table.rowAtPoint(new Point(e.getX(), e.getY()));
            NodesTableView.this.createPopup(e.getX(), e.getY());
        }
    }

    final class NbTable
    extends JTable {
        static final long serialVersionUID = 0L;

        NbTable() {
        }

        public String getToolTipText(MouseEvent event) {
            if (event != null) {
                Object obj;
                Point p = event.getPoint();
                int row = this.rowAtPoint(p);
                int column = this.columnAtPoint(p);
                if (row >= 0 && column >= 0 && (obj = NodesTableView.this.model.getValueAt(row, column)) != null) {
                    return obj.toString();
                }
            }
            return null;
        }
    }

    private class TableNodeListener
    extends NodeAdapter {
        static /* synthetic */ Class class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo;

        private TableNodeListener() {
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
            super.nodeDestroyed(nodeEvent);
            FileVcsInfo info = (FileVcsInfo)nodeEvent.getNode().getCookie(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? (class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo = TableNodeListener.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo")) : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo);
            NodesTableView.this.model.removeElement(info);
        }

        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
            super.childrenRemoved(nodeMemberEvent);
            Node[] nodes = nodeMemberEvent.getDelta();
            int i = 0;
            while (i < nodes.length) {
                FileVcsInfo info = (FileVcsInfo)nodes[i].getCookie(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? TableNodeListener.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo") : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo);
                NodesTableView.this.model.removeElement(info);
                ++i;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

