/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.ui.views;

import java.awt.Container;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.modules.vcscore.ui.views.FileInfoNode;
import org.netbeans.modules.vcscore.ui.views.FileVcsInfo;
import org.netbeans.modules.vcscore.ui.views.FileVcsInfoChildren;
import org.netbeans.modules.vcscore.ui.views.FileVcsInfoFactory;
import org.netbeans.modules.vcscore.ui.views.VcsExplorerPanel;
import org.netbeans.modules.vcscore.ui.views.VcsViewCreator;
import org.openide.explorer.ExplorerPanel;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class OutputDisplayFactory {
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo;

    public static void addCollectedFileInfos(FileVcsInfo root, List results) {
        Iterator it = results.iterator();
        FileVcsInfo parent = root;
        File rootFile = parent.getFile();
        String path = "";
        while (it.hasNext()) {
            FileVcsInfo info = (FileVcsInfo)it.next();
            File parentFile = info.getFile().getParentFile();
            if (!parentFile.getAbsolutePath().equals(parent.getFile().getAbsolutePath())) {
                if (parentFile.getPath().length() == rootFile.getPath().length()) {
                    path = "";
                    parent = root;
                } else {
                    path = parentFile.getAbsolutePath().substring(rootFile.getAbsolutePath().length() + 1);
                    path = path.replace('\\', '/');
                    parent = OutputDisplayFactory.createDirPath(root, path);
                }
            }
            info.setAttribute("NODE_PATH", path);
            if (parent.getChildren().equals(Children.LEAF)) continue;
            FileVcsInfoChildren children = (FileVcsInfoChildren)parent.getChildren();
            FileVcsInfo found = children.findKeyByFileName(info.getFile().getName());
            if (found == null) {
                children.addKey(info);
                continue;
            }
            found.overwriteAttributesFrom(info);
            children.refreshThisKey(found);
        }
    }

    public static FileInfoNode createRootNode(FileVcsInfo root, boolean createDirStructure) {
        DataObject dobj = FileVcsInfoChildren.findVersioningDO(root);
        if (dobj != null) {
            if (dobj instanceof DataFolder) {
                DataFolder folder = (DataFolder)dobj;
                FileInfoNode node = new FileInfoNode((DataObject)folder, root);
                if (createDirStructure) {
                    OutputDisplayFactory.createSubDirStructure(folder, root);
                }
                return node;
            }
            FileInfoNode node = new FileInfoNode(dobj, root);
            return node;
        }
        AbstractNode nd = new AbstractNode(root.getChildren());
        nd.setName(root.getFile().getName());
        FileInfoNode node = new FileInfoNode((Node)nd, root);
        return node;
    }

    private static void createSubDirStructure(DataFolder folder, FileVcsInfo info) {
        File rootFile = info.getFile();
        DataObject[] objs = folder.getChildren();
        if (objs != null && objs.length > 0) {
            int i = 0;
            while (i < objs.length) {
                if (objs[i] instanceof DataFolder) {
                    DataFolder subfolder = (DataFolder)objs[i];
                    File newFile = new File(rootFile, subfolder.getName());
                    FileVcsInfo dirInfo = FileVcsInfoFactory.createBlankFileVcsInfo(info.getType(), newFile);
                    FileVcsInfoChildren childs = (FileVcsInfoChildren)info.getChildren();
                    childs.addKey(dirInfo);
                    OutputDisplayFactory.createSubDirStructure(subfolder, dirInfo);
                }
                ++i;
            }
        }
    }

    static FileVcsInfo createDirPath(FileVcsInfo rootNode, String path) {
        FileVcsInfo currentParent = rootNode;
        StringTokenizer tokenizer = new StringTokenizer(path, "/", false);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            FileVcsInfoChildren childs = (FileVcsInfoChildren)currentParent.getChildren();
            FileVcsInfo info = childs.findKeyByFileName(token);
            if (info != null) {
                currentParent = info;
                continue;
            }
            File newFile = new File(currentParent.getFile(), token);
            FileVcsInfo itemInfo = FileVcsInfoFactory.createFileVcsInfo(currentParent.getType(), newFile, false);
            childs.addKey(itemInfo);
            currentParent = itemInfo;
        }
        return currentParent;
    }

    static ExplorerPanel findExistingRootContextPanel(FileVcsInfo info) {
        Set components = TopComponent.getRegistry().getOpened();
        if (components == null || components.size() == 0) {
            return null;
        }
        Iterator it = components.iterator();
        while (it.hasNext()) {
            ExplorerPanel panel;
            Node rootContext;
            FileVcsInfo infoCookie;
            Object next = it.next();
            if (!(next instanceof ExplorerPanel) || (infoCookie = (FileVcsInfo)(rootContext = (panel = (ExplorerPanel)next).getExplorerManager().getRootContext()).getCookie(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? OutputDisplayFactory.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo") : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo)) == null || !infoCookie.getType().equals(info.getType()) || !infoCookie.getFile().equals(info.getFile())) continue;
            return panel;
        }
        return null;
    }

    public static void displayExplorer(FileVcsInfo rootInfo, List resultsList, VcsViewCreator viewCreator, Mode modeToDockTo) {
        VcsExplorerPanel expanel = (VcsExplorerPanel)OutputDisplayFactory.findExistingRootContextPanel(rootInfo);
        FileInfoNode rootNode = null;
        if (expanel == null) {
            expanel = new VcsExplorerPanel();
            expanel.setName(viewCreator.getTitle());
            expanel.setIcon(viewCreator.getImage());
            Workspace workspace = WindowManager.getDefault().getCurrentWorkspace();
            Mode javaMode = modeToDockTo;
            javaMode.dockInto((TopComponent)expanel);
            rootNode = OutputDisplayFactory.createRootNode(rootInfo, false);
            ((Container)((Object)expanel)).add(viewCreator.createView());
        } else {
            rootNode = (FileInfoNode)expanel.getExplorerManager().getRootContext();
            FileVcsInfo oldRootInfo = (FileVcsInfo)rootNode.getCookie(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? (class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo = OutputDisplayFactory.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo")) : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo);
            oldRootInfo.overwriteAttributesFrom(rootInfo);
        }
        OutputDisplayFactory.addCollectedFileInfos(rootInfo, resultsList);
        expanel.getExplorerManager().setRootContext((Node)rootNode);
        try {
            expanel.getExplorerManager().setSelectedNodes(new Node[]{rootNode});
        }
        catch (PropertyVetoException exc) {
            exc.printStackTrace();
        }
        if (expanel.isOpened()) {
            expanel.requestFocus();
        } else {
            expanel.open();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

