/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.ui.views;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.netbeans.modules.vcscore.ui.views.FileInfoNode;
import org.netbeans.modules.vcscore.ui.views.FileVcsInfo;
import org.openide.ErrorManager;
import org.openide.awt.MouseUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.Lookup;
import org.openide.util.WeakListener;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;

public class SingleNodeView
extends JPanel
implements Externalizable {
    static final long serialVersionUID = 0L;
    private transient ExplorerManager manager;
    transient Listener managerListener;
    transient PropertyChangeListener wlpc;
    transient VetoableChangeListener wlvc;
    transient PopupAdapter popupListener;
    private boolean popupAllowed = true;
    private boolean traversalAllowed = false;
    private ActionListener defaultProcessor;
    private transient Node filterNode;
    transient boolean dragActive = false;
    transient boolean dropActive = false;
    transient boolean listenerActive;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo;
    static /* synthetic */ Class class$javax$swing$Action;
    static /* synthetic */ Class class$java$awt$event$ActionEvent;
    static /* synthetic */ Class class$org$openide$ErrorManager;

    public SingleNodeView() {
        this.initialize();
    }

    private void initialize() {
        this.managerListener = new Listener();
        this.popupListener = new PopupAdapter();
        this.addMouseListener(this.managerListener);
        this.addMouseListener((MouseListener)((Object)this.popupListener));
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addFocusListener(new FocusAdapter());
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.popupAllowed ? Boolean.TRUE : Boolean.FALSE);
        out.writeObject(this.traversalAllowed ? Boolean.TRUE : Boolean.FALSE);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.popupAllowed = (Boolean)in.readObject();
        this.traversalAllowed = (Boolean)in.readObject();
    }

    public boolean isPopupAllowed() {
        return this.popupAllowed;
    }

    public void setPopupAllowed(boolean value) {
        this.popupAllowed = value;
    }

    public boolean isTraversalAllowed() {
        return this.traversalAllowed;
    }

    public void setTraversalAllowed(boolean value) {
        this.traversalAllowed = value;
    }

    public ActionListener getDefaultProcessor() {
        return this.defaultProcessor;
    }

    public void setDefaultProcessor(ActionListener value) {
        this.defaultProcessor = value;
    }

    public boolean isDragSource() {
        return false;
    }

    public boolean isDropTarget() {
        return false;
    }

    public int getAllowedDragActions() {
        return 0x40000003;
    }

    public void setAllowedDragActions(int actions) {
    }

    public int getAllowedDropActions() {
        return 0x40000003;
    }

    public void setAllowedDropActions(int actions) {
    }

    protected void selectionChanged(Node[] nodes, ExplorerManager em) throws PropertyVetoException {
        em.setSelectedNodes(nodes);
    }

    protected boolean selectionAccept(Node[] nodes) {
        return true;
    }

    public void setContextNode(Node node) {
        FileVcsInfo info;
        if (this.filterNode != null) {
            info = (FileVcsInfo)this.filterNode.getCookie(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? (class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo = SingleNodeView.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo")) : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo);
            info.removePropertyChangeListener(this.managerListener);
        }
        if (node != null) {
            this.filterNode = (FileInfoNode)node;
            info = (FileVcsInfo)this.filterNode.getCookie(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? (class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo = SingleNodeView.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo")) : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo);
            info.addPropertyChangeListener(this.managerListener);
        } else {
            this.filterNode = null;
        }
    }

    public Node getContextNode() {
        return this.filterNode;
    }

    public void addNotify() {
        super.addNotify();
        ExplorerManager em = ExplorerManager.find((Component)this);
        if (em != this.manager) {
            if (this.manager != null) {
                this.manager.removeVetoableChangeListener(this.wlvc);
                this.manager.removePropertyChangeListener(this.wlpc);
            }
            this.manager = em;
            this.wlvc = WeakListener.vetoableChange((VetoableChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addVetoableChangeListener(this.wlvc);
            this.wlpc = WeakListener.propertyChange((PropertyChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addPropertyChangeListener(this.wlpc);
            Node[] nodes = this.manager.getSelectedNodes();
            if (nodes != null && nodes.length == 1 && nodes[0] instanceof FileInfoNode) {
                this.setContextNode(nodes[0]);
            } else {
                this.setContextNode(null);
            }
        }
        if (!this.listenerActive) {
            this.listenerActive = true;
        }
    }

    public void removeNotify() {
        FileVcsInfo info;
        super.removeNotify();
        this.listenerActive = false;
        if (this.filterNode != null && (info = (FileVcsInfo)this.filterNode.getCookie(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? (class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo = SingleNodeView.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo")) : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo)) != null) {
            info.removePropertyChangeListener(this.managerListener);
        }
    }

    public void requestFocus() {
        this.requestFocus();
    }

    final void performNode(Node node, int modifiers) {
        if (this.defaultProcessor != null) {
            this.defaultProcessor.actionPerformed(new ActionEvent(node, 0, null, modifiers));
            return;
        }
        SystemAction sa = node.getDefaultAction();
        if (sa != null && (modifiers & 2) == 0) {
            SingleNodeView.invokeAction(sa, new ActionEvent(node, 1001, ""));
        } else if (this.traversalAllowed && !node.isLeaf()) {
            this.manager.setExploredContext(node, this.manager.getSelectedNodes());
        }
    }

    static void invokeAction(SystemAction sa, ActionEvent ev) {
        Exception t = null;
        try {
            Class<?> c = Class.forName("org.openide.actions.ActionManager");
            Object o = Lookup.getDefault().lookup(c);
            if (o != null) {
                Method m = c.getMethod("invokeAction", class$javax$swing$Action == null ? (class$javax$swing$Action = SingleNodeView.class$("javax.swing.Action")) : class$javax$swing$Action, class$java$awt$event$ActionEvent == null ? (class$java$awt$event$ActionEvent = SingleNodeView.class$("java.awt.event.ActionEvent")) : class$java$awt$event$ActionEvent);
                m.invoke(o, sa, ev);
                return;
            }
        }
        catch (ClassNotFoundException x) {
        }
        catch (ExceptionInInitializerError x) {
        }
        catch (LinkageError x) {
        }
        catch (SecurityException x) {
            t = x;
        }
        catch (NoSuchMethodException x) {
            t = x;
        }
        catch (IllegalAccessException x) {
            t = x;
        }
        catch (IllegalArgumentException x) {
            t = x;
        }
        catch (InvocationTargetException x) {
            t = x;
        }
        if (t != null) {
            ErrorManager err = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = SingleNodeView.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
            if (err != null) {
                err.notify(1, (Throwable)t);
            } else {
                t.printStackTrace();
            }
        }
        sa.actionPerformed(ev);
    }

    static boolean shouldPopupBeDisplayed(Component comp) {
        try {
            Class<?> c = Class.forName("org.openide.windows.TopComponent$Registry");
            Object registry = Lookup.getDefault().lookup(c);
            if (registry == null) {
                return true;
            }
            Method m = c.getMethod("getActivated", new Class[0]);
            Object activated = m.invoke(registry, new Object[0]);
            boolean fromActivated = SwingUtilities.isDescendingFrom(comp, (Component)activated);
            if (fromActivated) {
                return true;
            }
            Window w = SwingUtilities.getWindowAncestor(comp);
            return w instanceof Dialog;
        }
        catch (Exception x) {
            ErrorManager err = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = SingleNodeView.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
            if (err != null) {
                err.notify(1, (Throwable)x);
            } else {
                x.printStackTrace();
            }
            return true;
        }
    }

    private void updateSelection() {
        Node[] nodes = this.manager.getSelectedNodes();
        if (nodes != null && nodes.length == 1 && nodes[0] instanceof FileInfoNode) {
            this.setContextNode(nodes[0]);
        } else {
            this.setContextNode(null);
        }
    }

    void createPopup(int xpos, int ypos) {
        if (this.manager == null || this.getContextNode() == null) {
            return;
        }
        if (!this.popupAllowed) {
            return;
        }
        JPopupMenu popup = NodeOp.findContextMenu((Node[])new Node[]{this.getContextNode()});
        if (popup != null && popup.getSubElements().length > 0 && SingleNodeView.shouldPopupBeDisplayed(this)) {
            Point p = this.getVisibleRect().getLocation();
            p.x = xpos - p.x;
            p.y = ypos - p.y;
            SwingUtilities.convertPointToScreen(p, this);
            Dimension popupSize = popup.getPreferredSize();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            if (p.x + popupSize.width > screenSize.width) {
                p.x = screenSize.width - popupSize.width;
            }
            if (p.y + popupSize.height > screenSize.height) {
                p.y = screenSize.height - popupSize.height;
            }
            SwingUtilities.convertPointFromScreen(p, this);
            popup.show(this, p.x, p.y);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class EnterAction
    extends AbstractAction {
        static final long serialVersionUID = -239805141416294016L;

        public EnterAction() {
            super("Enter");
        }

        public void actionPerformed(ActionEvent e) {
            Node nd = SingleNodeView.this.getContextNode();
            if (nd != null) {
                SingleNodeView.this.performNode(nd, e.getModifiers());
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private final class Listener
    extends MouseAdapter
    implements PropertyChangeListener,
    VetoableChangeListener {
        private Listener() {
        }

        public void mouseClicked(MouseEvent e) {
            Node nd;
            if (MouseUtils.isDoubleClick((MouseEvent)e) && (nd = SingleNodeView.this.getContextNode()) != null) {
                SingleNodeView.this.performNode(nd, e.getModifiers());
            }
        }

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            Node[] newNodes;
            SingleNodeView.this.manager;
            if ("selectedNodes".equals(evt.getPropertyName()) && !SingleNodeView.this.selectionAccept(newNodes = (Node[])evt.getNewValue())) {
                throw new PropertyVetoException("", evt);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            SingleNodeView.this.manager;
            if ("selectedNodes".equals(evt.getPropertyName())) {
                SingleNodeView.this.updateSelection();
                return;
            }
            if (evt.getSource() != null && evt.getSource() instanceof FileVcsInfo) {
                SingleNodeView.this.setContextNode(SingleNodeView.this.getContextNode());
            }
        }
    }

    final class FocusAdapter
    implements FocusListener {
        CallbackSystemAction csa;
        PopupPerformer performer;
        static /* synthetic */ Class class$org$openide$ErrorManager;

        FocusAdapter() {
        }

        public void focusGained(FocusEvent ev) {
            if (this.csa == null) {
                try {
                    Class<?> popup = Class.forName("org.openide.actions.PopupAction");
                    this.csa = (CallbackSystemAction)SystemAction.get(popup);
                    this.performer = new PopupPerformer();
                }
                catch (ClassNotFoundException e) {
                    NoClassDefFoundError err = new NoClassDefFoundError();
                    ErrorManager em = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = FocusAdapter.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
                    if (em != null) {
                        em.annotate((Throwable)err, (Throwable)e);
                    }
                    throw err;
                }
            }
            this.csa.setActionPerformer((ActionPerformer)this.performer);
        }

        public void focusLost(FocusEvent ev) {
            if (this.csa != null && this.csa.getActionPerformer() instanceof PopupPerformer) {
                this.csa.setActionPerformer(null);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    final class PopupPerformer
    implements ActionPerformer {
        PopupPerformer() {
        }

        public void performAction(SystemAction act) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Point p = SingleNodeView.this.getLocation();
                    if (p == null) {
                        return;
                    }
                    SingleNodeView.this.createPopup(p.x, p.y);
                }
            });
        }
    }

    private final class PopupAdapter
    extends MouseUtils.PopupMouseAdapter {
        private PopupAdapter() {
        }

        protected void showPopup(MouseEvent e) {
            SingleNodeView.this.createPopup(e.getX(), e.getY());
        }
    }
}

