/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.ui.views.types;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.vcscore.ui.views.FileVcsInfo;
import org.netbeans.modules.vcscore.ui.views.FileVcsInfoFactory;
import org.netbeans.modules.vcscore.ui.views.SingleNodeView;
import org.netbeans.modules.vcscore.ui.views.TableView;
import org.netbeans.modules.vcscore.util.table.DateComparator;
import org.netbeans.modules.vcscore.util.table.IntegerComparator;
import org.netbeans.modules.vcscore.util.table.RevisionComparator;
import org.netbeans.modules.vcscore.util.table.TableInfoModel;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class AnnotateInfoPanel
extends SingleNodeView {
    public static final String ANNOTATIONS_LIST = "ANNOTATIONS_LIST";
    public static final String ANNOT_CONTENT = "ANNOT_CONTENT";
    public static final String ANNOT_DATE_STRING = "ANNOT_DATE_STRING";
    public static final String ANNOT_AUTHOR = "ANNOT_AUTHOR";
    public static final String ANNOT_REVISION = "ANNOT_REVISION";
    public static final String ANNOT_LINE_NUMBER = "ANNOT_LINE_NUMBER";
    public static final String TYPE = "ANNOTATE";
    private TableInfoModel modAnnotations = null;
    private static final int REVISION_COLUMN = 1;
    private static final int AUTHOR_COLUMN = 2;
    private static final Color colorBoth = new Color(255, 160, 180);
    private static final Color colorRev = new Color(180, 255, 180);
    private static final Color colorAuth = new Color(160, 200, 255);
    private FileVcsInfo currentInfo;
    private FileVcsInfo clearInfo;
    DefaultComboBoxModel revModel;
    DefaultComboBoxModel authModel;
    String noRevisionSelected;
    String noAuthorSelected;
    List revSet;
    List authSet;
    TableView tblAnnotat;
    private JLabel lblRevision;
    private JPanel pnlHead;
    private JLabel lblAuthor;
    private JComboBox cbRevisionList;
    private JTextField txWorkFile;
    private JComboBox cbAuthorList;
    private JComboBox cbRevisionRange;
    private JLabel lblWorkFile;
    private static final long serialVersionUID = -2618655204542546204L;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo$CompositeItem;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo;

    public AnnotateInfoPanel() {
        this.initComponents();
        this.setPreferredSize(new Dimension(750, 400));
        this.setMinimumSize(new Dimension(750, 400));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 26;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 12, 11, 11);
        this.modAnnotations = this.createModel();
        this.tblAnnotat = new AnnotateTableView(ANNOTATIONS_LIST, this.modAnnotations);
        this.tblAnnotat.setColumnModel(this.createColumnModel());
        this.add((Component)this.tblAnnotat, gridBagConstraints);
        this.revModel = new DefaultComboBoxModel();
        this.authModel = new DefaultComboBoxModel();
        this.noRevisionSelected = NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("AnnotatePanel.noRevisionSelected");
        this.noAuthorSelected = NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("AnnotatePanel.noAuthorSelected");
        this.revSet = new LinkedList();
        this.authModel.addElement(this.noAuthorSelected);
        this.authSet = new LinkedList();
        this.cbRevisionList.setModel(this.revModel);
        this.cbAuthorList.setModel(this.authModel);
        String bigger = NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("AnnotatePanel.biggerThan");
        String smaller = NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("AnnotatePanel.smallerThan");
        String equals = NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("AnnotatePanel.equals");
        this.cbRevisionRange.setModel(new DefaultComboBoxModel<Object>(new Object[]{equals, bigger, smaller}));
        this.lblWorkFile.setDisplayedMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("AnnotateInfoPanel.lblWorkFile.Mnem").charAt(0));
        this.lblRevision.setDisplayedMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("AnnotatePanel.lblRevision.Mnem").charAt(0));
        this.lblAuthor.setDisplayedMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("AnnotatePanel.lblAuthor.Mnem").charAt(0));
        this.txWorkFile.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                AnnotateInfoPanel.this.txWorkFile.selectAll();
            }

            public void focusLost(FocusEvent e) {
                AnnotateInfoPanel.this.txWorkFile.select(1, 1);
            }
        });
        this.txWorkFile.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("ACSD_AnnotatePanel.txWorkFile"));
        this.cbRevisionRange.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("ACSN_AnnotatePanel.cbRevisionRange"));
        this.cbRevisionRange.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("ACSD_AnnotatePanel.cbRevisionRange"));
        this.cbRevisionList.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("ACSN_AnnotatePanel.cbRevisionList"));
        this.cbRevisionList.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("ACSD_AnnotatePanel.cbRevisionList"));
        this.cbAuthorList.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("ACSN_AnnotatePanel.cbAuthorList"));
        this.cbAuthorList.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("ACSD_AnnotatePanel.cbAuthorList"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("ACSD_AnnotatePanel"));
        this.initClearInfo();
    }

    private void initClearInfo() {
        this.clearInfo = FileVcsInfoFactory.createBlankFileVcsInfo(TYPE, new File(""));
    }

    private void initComponents() {
        this.pnlHead = new JPanel();
        this.lblWorkFile = new JLabel();
        this.txWorkFile = new JTextField();
        this.cbRevisionList = new JComboBox();
        this.cbAuthorList = new JComboBox();
        this.lblRevision = new JLabel();
        this.lblAuthor = new JLabel();
        this.cbRevisionRange = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.pnlHead.setLayout(new GridBagLayout());
        this.lblWorkFile.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("AnnotateInfoPanel.lblWorkFile.text"));
        this.lblWorkFile.setLabelFor(this.txWorkFile);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 5, 0);
        this.pnlHead.add((Component)this.lblWorkFile, gridBagConstraints);
        this.txWorkFile.setEditable(false);
        this.txWorkFile.setText("jTextField1");
        this.txWorkFile.setPreferredSize(new Dimension(250, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 5, 11);
        this.pnlHead.add((Component)this.txWorkFile, gridBagConstraints);
        this.cbRevisionList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnnotateInfoPanel.this.cbRevisionListActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 11);
        this.pnlHead.add((Component)this.cbRevisionList, gridBagConstraints);
        this.cbAuthorList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnnotateInfoPanel.this.cbAuthorListActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 12, 11);
        this.pnlHead.add((Component)this.cbAuthorList, gridBagConstraints);
        this.lblRevision.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("AnnotatePanel.lblRevision.text"));
        this.lblRevision.setLabelFor(this.cbRevisionRange);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 2, 0);
        this.pnlHead.add((Component)this.lblRevision, gridBagConstraints);
        this.lblAuthor.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("AnnotatePanel.lblAuthor"));
        this.lblAuthor.setLabelFor(this.cbAuthorList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.pnlHead.add((Component)this.lblAuthor, gridBagConstraints);
        this.cbRevisionRange.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnnotateInfoPanel.this.cbRevisionRangeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.pnlHead.add((Component)this.cbRevisionRange, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.add((Component)this.pnlHead, gridBagConstraints);
    }

    private void cbRevisionRangeActionPerformed(ActionEvent evt) {
        this.tblAnnotat.repaint();
    }

    private void cbRevisionListActionPerformed(ActionEvent evt) {
        this.tblAnnotat.repaint();
    }

    private void cbAuthorListActionPerformed(ActionEvent evt) {
        this.tblAnnotat.repaint();
    }

    private void lstSymNamesValueChanged(ListSelectionEvent evt) {
    }

    private TableColumnModel createColumnModel() {
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        ColoringUpdateRenderer colorRenderer = new ColoringUpdateRenderer();
        TableColumn col = new TableColumn();
        col.setIdentifier("LineNum");
        col.setModelIndex(0);
        col.setHeaderValue(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("AnnotateInfoPanel.LineNumColumn"));
        col.setMaxWidth(100);
        col.setMinWidth(50);
        col.setPreferredWidth(50);
        col.setCellRenderer(colorRenderer);
        model.addColumn(col);
        col = new TableColumn();
        col.setIdentifier("Revision");
        col.setModelIndex(1);
        col.setHeaderValue(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("AnnotateInfoPanel.RevisionColumn"));
        col.setMaxWidth(100);
        col.setMinWidth(50);
        col.setPreferredWidth(50);
        col.setCellRenderer(colorRenderer);
        model.addColumn(col);
        col = new TableColumn();
        col.setIdentifier("Author");
        col.setModelIndex(2);
        col.setHeaderValue(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("AnnotateInfoPanel.AuthorColumn"));
        col.setMaxWidth(150);
        col.setMinWidth(50);
        col.setPreferredWidth(75);
        col.setCellRenderer(colorRenderer);
        model.addColumn(col);
        col = new TableColumn();
        col.setIdentifier("Date");
        col.setModelIndex(3);
        col.setHeaderValue(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("AnnotateInfoPanel.DateColumn"));
        col.setMaxWidth(120);
        col.setMinWidth(10);
        col.setPreferredWidth(80);
        col.setCellRenderer(colorRenderer);
        model.addColumn(col);
        col = new TableColumn();
        col.setIdentifier("Text");
        col.setModelIndex(4);
        col.setHeaderValue(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("AnnotateInfoPanel.TextColumn"));
        col.setMaxWidth(500);
        col.setMinWidth(50);
        col.setPreferredWidth(200);
        col.setCellRenderer(colorRenderer);
        model.addColumn(col);
        return model;
    }

    private TableInfoModel createModel() {
        TableInfoModel modAnnotations = new TableInfoModel();
        Class classa = class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo$CompositeItem == null ? (class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo$CompositeItem = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo$CompositeItem")) : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo$CompositeItem;
        String label0 = NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("AnnotateInfoPanel.LineNumColumn");
        String label1 = NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("AnnotateInfoPanel.AuthorColumn");
        String label2 = NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("AnnotateInfoPanel.RevisionColumn");
        String label3 = NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("AnnotateInfoPanel.DateColumn");
        String label4 = NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel == null ? (class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.types.AnnotateInfoPanel")) : class$org$netbeans$modules$vcscore$ui$views$types$AnnotateInfoPanel)).getString("AnnotateInfoPanel.TextColumn");
        try {
            Method method1 = classa.getMethod("getAttribute", class$java$lang$String == null ? (class$java$lang$String = AnnotateInfoPanel.class$("java.lang.String")) : class$java$lang$String);
            Method method2 = classa.getMethod("getAttributeNonNull", class$java$lang$String == null ? (class$java$lang$String = AnnotateInfoPanel.class$("java.lang.String")) : class$java$lang$String);
            modAnnotations.setColumnDefinition(0, label0, method1, new Object[]{ANNOT_LINE_NUMBER}, true, new IntegerComparator());
            modAnnotations.setColumnDefinition(1, label1, method2, new Object[]{ANNOT_REVISION}, true, new RevisionComparator());
            modAnnotations.setColumnDefinition(2, label2, method2, new Object[]{ANNOT_AUTHOR}, true, null);
            modAnnotations.setColumnDefinition(3, label3, method2, new Object[]{ANNOT_DATE_STRING}, true, new DateComparator());
            modAnnotations.setColumnDefinition(4, label4, method2, new Object[]{ANNOT_CONTENT}, false, null);
        }
        catch (NoSuchMethodException exc) {
            Thread.dumpStack();
        }
        catch (SecurityException exc2) {
            Thread.dumpStack();
        }
        return modAnnotations;
    }

    private void setComboModel(List list, DefaultComboBoxModel model) {
        model.removeAllElements();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            model.addElement(it.next());
        }
    }

    private void setData(FileVcsInfo info) {
        this.currentInfo = info;
        if (info.getFile() != null) {
            this.txWorkFile.setText(info.getFile().getAbsolutePath());
        } else {
            this.txWorkFile.setText("");
        }
        FileVcsInfo.Composite comp = (FileVcsInfo.Composite)info.getAttribute(ANNOTATIONS_LIST);
        this.revSet.clear();
        this.authSet.clear();
        if (comp != null) {
            int i = 0;
            while (i < comp.getCount()) {
                FileVcsInfo.CompositeItem item = comp.getRow(i);
                String rev = (String)item.getAttribute(ANNOT_REVISION);
                String auth = (String)item.getAttribute(ANNOT_AUTHOR);
                if (rev != null && !this.revSet.contains(rev)) {
                    this.revSet.add(rev);
                }
                if (auth != null && !this.authSet.contains(auth)) {
                    this.authSet.add(auth);
                }
                ++i;
            }
            Collections.sort(this.revSet, new RevisionComparator());
            Collections.sort(this.authSet);
            this.revSet.add(0, this.noRevisionSelected);
            this.authSet.add(0, this.noAuthorSelected);
        } else {
            this.revSet.add(this.noRevisionSelected);
            this.authSet.add(this.noAuthorSelected);
        }
        this.setComboModel(this.revSet, this.revModel);
        this.setComboModel(this.authSet, this.authModel);
    }

    public void setContextNode(Node node) {
        super.setContextNode(node);
        Node infoNode = this.getContextNode();
        if (infoNode != null) {
            FileVcsInfo info = (FileVcsInfo)infoNode.getCookie(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? (class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo = AnnotateInfoPanel.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo")) : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo);
            if (info != null && info.getType().equals(TYPE)) {
                this.setData(info);
            } else {
                this.setData(this.clearInfo);
            }
        } else {
            this.setData(this.clearInfo);
        }
    }

    boolean matchesAuthor(String author) {
        return this.cbAuthorList.getSelectedIndex() != 0 && author.equals(this.cbAuthorList.getSelectedItem());
    }

    boolean matchesRevision(String revision) {
        if (this.cbRevisionList.getSelectedIndex() != 0) {
            RevisionComparator comp = new RevisionComparator();
            int result = comp.compare(revision, this.cbRevisionList.getSelectedItem());
            if (result == 0 && this.cbRevisionRange.getSelectedIndex() == 0) {
                return true;
            }
            if (result == 1 && this.cbRevisionRange.getSelectedIndex() == 1) {
                return true;
            }
            if (result == -1 && this.cbRevisionRange.getSelectedIndex() == 2) {
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class AnnotateTableView
    extends TableView {
        public AnnotateTableView(String compositeAttributeName, TableInfoModel model) {
            super(compositeAttributeName, model);
        }

        protected JTable createTable() {
            JTable retValue = super.createTable();
            retValue.setShowGrid(false);
            retValue.setBorder(null);
            retValue.setRowSelectionAllowed(true);
            retValue.setShowHorizontalLines(false);
            retValue.setShowVerticalLines(false);
            retValue.setIntercellSpacing(new Dimension(0, 0));
            return retValue;
        }
    }

    private class ColoringUpdateRenderer
    extends DefaultTableCellRenderer {
        private Color almostWhite = new Color(254, 254, 254);
        private static final long serialVersionUID = -8634243127049172822L;

        public Component getTableCellRendererComponent(JTable jTable, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            Component retValue = super.getTableCellRendererComponent(jTable, obj, isSelected, hasFocus, row, column);
            if (isSelected) {
                return retValue;
            }
            String auth = AnnotateInfoPanel.this.modAnnotations.getValueAt(row, 2).toString();
            String rev = AnnotateInfoPanel.this.modAnnotations.getValueAt(row, 1).toString();
            boolean matchesAuthor = AnnotateInfoPanel.this.matchesAuthor(auth);
            boolean matchesRevision = AnnotateInfoPanel.this.matchesRevision(rev);
            if (matchesAuthor && matchesRevision) {
                retValue.setBackground(colorBoth);
                return retValue;
            }
            if (matchesAuthor) {
                retValue.setBackground(colorAuth);
                return retValue;
            }
            if (matchesRevision) {
                retValue.setBackground(colorRev);
                return retValue;
            }
            retValue.setBackground(this.almostWhite);
            return retValue;
        }
    }
}

