/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.vcscore.util.Debug;
import org.openide.util.NbBundle;

public class ChooseFileDialog
extends JDialog {
    private Debug E;
    private Debug D;
    private JFileChooser chooser;
    private File initialDir;
    private File selectedFile;
    private boolean propFileFilter;
    static final long serialVersionUID = -4725583654994487624L;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$util$ChooseFileDialog;

    public ChooseFileDialog(Frame owner, File initialDir, boolean propFileFilter) {
        super(owner, "", true);
        this.D = this.E = new Debug("ChooseFileDialog", false);
        this.chooser = null;
        this.initialDir = null;
        this.selectedFile = null;
        this.propFileFilter = false;
        this.setTitle(ChooseFileDialog.g("CTL_Select_file"));
        this.initialDir = initialDir;
        this.propFileFilter = propFileFilter;
        this.initComponents();
        this.pack();
    }

    private void initComponents() {
        this.chooser = new JFileChooser();
        this.chooser.setFileSelectionMode(0);
        this.chooser.setFileHidingEnabled(false);
        if (this.propFileFilter) {
            this.chooser.setFileFilter(new PropertiesFileFilter());
        }
        if (this.initialDir != null) {
            this.chooser.setCurrentDirectory(this.initialDir);
        }
        this.chooser.setApproveButtonText(ChooseFileDialog.g("CTL_Select"));
        this.chooser.setApproveButtonToolTipText(ChooseFileDialog.g("CTL_SelectToolTip"));
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChooseFileDialog.this.selectedFile = null;
                ChooseFileDialog.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0, true), 2);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 27) {
                    ChooseFileDialog.this.selectedFile = null;
                    ChooseFileDialog.this.close();
                }
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.chooser, "Center");
        this.chooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if ("ApproveSelection".equals(evt.getActionCommand())) {
                    File f = ChooseFileDialog.this.chooser.getSelectedFile();
                    ChooseFileDialog.this.selectedFile = f;
                    ChooseFileDialog.this.close();
                } else if ("CancelSelection".equals(evt.getActionCommand())) {
                    ChooseFileDialog.this.selectedFile = null;
                    ChooseFileDialog.this.close();
                }
            }
        });
    }

    private void close() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public String getSelectedFile() {
        String path = null;
        if (this.selectedFile == null) {
            return null;
        }
        try {
            path = this.selectedFile.getCanonicalPath();
        }
        catch (IOException e) {
            this.E.err(e, "getSelectedFile()");
            path = null;
        }
        return path;
    }

    private static String g(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$util$ChooseFileDialog == null ? (class$org$netbeans$modules$vcscore$util$ChooseFileDialog = ChooseFileDialog.class$("org.netbeans.modules.vcscore.util.ChooseFileDialog")) : class$org$netbeans$modules$vcscore$util$ChooseFileDialog), (String)s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class PropertiesFileFilter
    extends FileFilter {
        private static final String EXTENSION = "properties";

        PropertiesFileFilter() {
        }

        public boolean accept(File f) {
            int dotIndex = f.getName().indexOf(".");
            String ext = "";
            if (dotIndex > 0) {
                ext = f.getName().substring(dotIndex + 1);
            }
            return ext.equals(EXTENSION);
        }

        public String getDescription() {
            return "Properties files (*.properties)";
        }
    }
}

