/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.util;

import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.netbeans.modules.vcscore.util.TopComponentCloseListener;
import org.openide.text.CloneableEditorSupport;
import org.openide.windows.CloneableOpenSupport;

public class FileEditorSupport
extends CloneableEditorSupport {
    private File file;
    private FileEnvironment env;

    public FileEditorSupport(File file, FileEnvironment env) {
        super((CloneableEditorSupport.Env)env);
        env.setFileEditorSupport(this);
        this.file = file;
        this.env = env;
    }

    public void addCloseListener(TopComponentCloseListener listener) {
        this.env.addCloseListener(listener);
    }

    public String messageName() {
        return this.file.getName();
    }

    public String messageOpened() {
        return null;
    }

    public String messageOpening() {
        return null;
    }

    public String messageSave() {
        return "";
    }

    public String messageToolTip() {
        return "";
    }

    protected boolean canClose() {
        boolean can = super.canClose();
        if (can) {
            Iterator it = ((AbstractList)this.env.getCloseListeners()).iterator();
            while (it.hasNext()) {
                ((TopComponentCloseListener)it.next()).closing();
            }
        }
        return can;
    }

    public static class FileEnvironment
    implements CloneableEditorSupport.Env {
        private File file;
        private String mimeType;
        private ArrayList closeListeners = new ArrayList();
        private transient FileEditorSupport editorSupport = null;
        static final long serialVersionUID = 2366777428924127835L;

        public FileEnvironment(File file, String mimeType) {
            this.file = file;
            this.mimeType = mimeType;
        }

        void addCloseListener(TopComponentCloseListener listener) {
            this.closeListeners.add(listener);
        }

        ArrayList getCloseListeners() {
            return this.closeListeners;
        }

        void setFileEditorSupport(FileEditorSupport editorSupport) {
            this.editorSupport = editorSupport;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public Date getTime() {
            return new Date(this.file.lastModified());
        }

        public InputStream inputStream() throws IOException {
            FileInputStream in = null;
            try {
                in = new FileInputStream(this.file);
            }
            catch (FileNotFoundException exc) {
                throw new IOException(exc.getMessage());
            }
            return in;
        }

        public OutputStream outputStream() throws IOException {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(this.file);
            }
            catch (FileNotFoundException exc) {
                throw new IOException(exc.getMessage());
            }
            return out;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void addVetoableChangeListener(VetoableChangeListener l) {
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            if (this.editorSupport != null) {
                return this.editorSupport;
            }
            if (this.file.exists()) {
                return new FileEditorSupport(this.file, this);
            }
            return null;
        }

        public boolean isModified() {
            return false;
        }

        public boolean isValid() {
            return this.editorSupport != null;
        }

        public void markModified() throws IOException {
            throw new IOException();
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }

        public void removeVetoableChangeListener(VetoableChangeListener l) {
        }

        public void unmarkModified() {
        }
    }
}

