/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.util;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.vcscore.util.VariableInputDescriptor;
import org.netbeans.modules.vcscore.util.VariableInputValidator;

public class VariableInputComponent {
    private int component;
    private boolean expert = false;
    private String variable;
    private String label;
    private Character labelMnemonic;
    private String a11yName = null;
    private String a11yDescription = null;
    private String value = null;
    private String valueSelected = null;
    private String valueUnselected = null;
    private String defaultValue = null;
    private Dimension dimension = null;
    private HashSet enable = null;
    private HashSet disable = null;
    private String selector = null;
    private String validator = null;
    private ArrayList subComponents = null;
    private String[] varConditions = new String[2];
    private String[] selectorVarConditions = new String[2];
    private ArrayList history = new ArrayList();

    public VariableInputComponent(int component, String variable, String label) {
        this(component, variable, label, null);
    }

    public VariableInputComponent(int component, String variable, String label, String labelMnemonic) {
        this.component = component;
        this.variable = variable;
        this.label = label;
        this.labelMnemonic = labelMnemonic != null && labelMnemonic.length() > 0 ? new Character(labelMnemonic.charAt(0)) : null;
    }

    public int getComponent() {
        return this.component;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVarConditions(String[] varConditions) {
        this.varConditions = varConditions;
    }

    public String[] getVarConditions() {
        return this.varConditions;
    }

    public static boolean isVarConditionMatch(String[] varConditions, Map vars) {
        String var;
        boolean is = true;
        if (vars == null) {
            return true;
        }
        if (varConditions[0] != null) {
            var = (String)vars.get(varConditions[0]);
            is &= var == null || var.length() == 0;
        }
        if (varConditions[1] != null) {
            var = (String)vars.get(varConditions[1]);
            is &= var != null && var.length() > 0;
        }
        return is;
    }

    public void setExpert(boolean expert) {
        this.expert = expert;
    }

    public boolean isExpert() {
        return this.expert;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabelMnemonic(String mnemonic) {
        this.labelMnemonic = mnemonic != null && mnemonic.length() > 0 ? new Character(mnemonic.charAt(0)) : null;
    }

    public Character getLabelMnemonic() {
        return this.labelMnemonic;
    }

    public void setA11yName(String name) {
        this.a11yName = name;
    }

    public String getA11yName() {
        return this.a11yName;
    }

    public void setA11yDescription(String description) {
        this.a11yDescription = description;
    }

    public String getA11yDescription() {
        return this.a11yDescription;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValueSelected(String valueSelected) {
        this.valueSelected = valueSelected;
    }

    public String getValueSelected() {
        return this.valueSelected;
    }

    public void setValueUnselected(String valueUnselected) {
        this.valueUnselected = valueUnselected;
    }

    public String getValueUnselected() {
        return this.valueUnselected;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    private boolean canResetDefaultValue() {
        String value = this.getDefaultValue();
        if (value == null) {
            return true;
        }
        int index = value.indexOf("${");
        if (index >= 0 && (index == 0 || value.charAt(index - 1) != '\\')) {
            return false;
        }
        return !this.needsPreCommandPerform();
    }

    public boolean needsPreCommandPerform() {
        String value = this.getDefaultValue();
        return value != null && (value.indexOf("{INSERT_OUTPUT_OF_") >= 0 || value.indexOf("{INSERT_ERROR_OF_") >= 0 || value.indexOf("{FILE_OUTPUT_OF_") >= 0);
    }

    public void setValuesAsDefault() {
        if (this.canResetDefaultValue()) {
            this.setDefaultValue(this.getValue());
        }
        VariableInputComponent[] comps = this.subComponents();
        int i = 0;
        while (i < comps.length) {
            comps[i].setValuesAsDefault();
            ++i;
        }
    }

    public void setDefaultValues() {
        if (this.canResetDefaultValue()) {
            this.setValue(this.getDefaultValue());
        }
        VariableInputComponent[] comps = this.subComponents();
        int i = 0;
        while (i < comps.length) {
            comps[i].setDefaultValues();
            ++i;
        }
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void addEnable(String varName) {
        if (this.enable == null) {
            this.enable = new HashSet();
        }
        this.enable.add(varName);
    }

    public Set getEnable() {
        if (this.enable != null) {
            return Collections.unmodifiableSet(this.enable);
        }
        return Collections.EMPTY_SET;
    }

    public Set getDisable() {
        if (this.disable != null) {
            return Collections.unmodifiableSet(this.disable);
        }
        return Collections.EMPTY_SET;
    }

    public void addDisable(String varName) {
        if (this.disable == null) {
            this.disable = new HashSet();
        }
        this.disable.add(varName);
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelectorVarConditions(String[] varConditions) {
        this.selectorVarConditions = varConditions;
    }

    public String[] getSelectorVarConditions() {
        return this.selectorVarConditions;
    }

    public void setValidator(String validator) {
        this.validator = validator;
    }

    public String getValidator() {
        return this.validator;
    }

    public VariableInputValidator validate() {
        return new VariableInputValidator(this, this.validator);
    }

    void addValuesToHistory() {
        this.history.add(this.value);
        VariableInputComponent[] comps = this.subComponents();
        int i = 0;
        while (i < comps.length) {
            comps[i].addValuesToHistory();
            ++i;
        }
    }

    public int getHistorySize() {
        return this.history.size();
    }

    public String getHistoryValue(int index) {
        if (index < this.history.size()) {
            return (String)this.history.get(index);
        }
        return this.value;
    }

    public void addSubComponent(VariableInputComponent component) {
        if (this.subComponents == null) {
            this.subComponents = new ArrayList();
        }
        this.subComponents.add(component);
    }

    public VariableInputComponent[] subComponents() {
        if (this.subComponents == null) {
            return new VariableInputComponent[0];
        }
        return this.subComponents.toArray(new VariableInputComponent[0]);
    }

    public String toString() {
        return this.toString(false);
    }

    private String toString(boolean cutCompVar) {
        String varName;
        Iterator it;
        StringBuffer items = new StringBuffer();
        if (!cutCompVar) {
            VariableInputComponent.putVarConditionsStr(items, this.varConditions);
            String name = VariableInputDescriptor.getInputIdString(this.component);
            items.append(name);
            if (this.expert) {
                items.append("_EXPERT");
            }
            items.append('(');
            items.append('\"');
            items.append(this.variable);
            items.append("\", ");
        }
        items.append('\"');
        items.append(this.label);
        if (this.value == null) {
            items.append("\", \"\"");
        } else {
            items.append("\", \"");
            if (3 == this.component) {
                if (this.value != null && this.value.equals(this.valueSelected)) {
                    items.append("true");
                } else {
                    items.append("false");
                }
            } else {
                items.append(this.value);
            }
            items.append('\"');
        }
        if (this.a11yName != null || this.a11yDescription != null || this.labelMnemonic != null) {
            VariableInputDescriptor.appendAccessibility(items, this.a11yName, this.a11yDescription, this.labelMnemonic);
        }
        if (this.validator != null) {
            items.append(", \"");
            items.append(this.validator);
            items.append('\"');
        }
        if (this.selector != null) {
            items.append(", \"");
            VariableInputComponent.putVarConditionsStr(items, this.selectorVarConditions);
            items.append(this.selector);
            items.append('\"');
        }
        if (this.dimension != null) {
            items.append(", ");
            items.append(this.dimension.width);
            items.append(", ");
            items.append(this.dimension.height);
        }
        if (this.component == 3 && this.valueSelected != null) {
            items.append(", \"");
            items.append(this.valueSelected);
            items.append('\"');
            if (this.valueUnselected != null) {
                items.append(", \"");
                items.append(this.valueUnselected);
                items.append('\"');
            }
        }
        if (this.enable != null && !this.enable.isEmpty()) {
            items.append(", ");
            items.append("ENABLE(");
            it = this.enable.iterator();
            while (true) {
                varName = (String)it.next();
                items.append(varName);
                if (!it.hasNext()) break;
                items.append(", ");
            }
            items.append(')');
        }
        if (this.disable != null && !this.disable.isEmpty()) {
            items.append(", ");
            items.append("DISABLE(");
            it = this.disable.iterator();
            while (true) {
                varName = (String)it.next();
                items.append(varName);
                if (!it.hasNext()) break;
                items.append(", ");
            }
            items.append(')');
        }
        VariableInputComponent[] subComponents = this.subComponents();
        int i = 0;
        while (i < subComponents.length) {
            items.append(", [");
            items.append(subComponents[i].toString(true));
            items.append(']');
            ++i;
        }
        if (!cutCompVar) {
            items.append(')');
        }
        return items.toString();
    }

    private static void putVarConditionsStr(StringBuffer items, String[] varConditions) {
        if (varConditions[0] != null) {
            items.append("IF_VAR_EMPTY\"");
            items.append(varConditions[0]);
            items.append("\"_");
        }
        if (varConditions[1] != null) {
            items.append("IF_VAR_NON_EMPTY\"");
            items.append(varConditions[1]);
            items.append("\"_");
        }
    }
}

