/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.util;

import java.awt.Dimension;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.netbeans.modules.vcscore.util.VariableInputComponent;
import org.netbeans.modules.vcscore.util.VariableInputFormatException;
import org.netbeans.modules.vcscore.util.VariableInputValidator;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.openide.util.NbBundle;

public class VariableInputDescriptor {
    public static final int INPUT_LABEL = 0;
    public static final int INPUT_ACCESSIBILITY = 10;
    public static final int INPUT_PROMPT_FIELD = 1;
    public static final int INPUT_PROMPT_AREA = 2;
    public static final int INPUT_ASK = 3;
    public static final int INPUT_SELECT_RADIO = 4;
    public static final int INPUT_RADIO_BTN = 5;
    public static final int INPUT_SELECT_COMBO = 6;
    public static final int INPUT_COMBO_ITEM = 7;
    public static final int INPUT_GLOBAL = 8;
    public static final int INPUT_SELECT_COMBO_EDITABLE = 9;
    public static final String INPUT_STR_LABEL = "LABEL";
    public static final String INPUT_STR_PROMPT_FIELD = "PROMPT_FOR";
    public static final String INPUT_STR_PROMPT_AREA = "PROMPT_FOR_FILE";
    public static final String INPUT_STR_ASK = "ASK_FOR";
    public static final String INPUT_STR_SELECT_RADIO = "SELECT_RADIO";
    public static final String INPUT_STR_SELECT_COMBO = "SELECT_COMBO";
    public static final String INPUT_STR_SELECT_COMBO_EDITABLE = "SELECT_COMBO_EDITABLE";
    public static final String INPUT_STR_GLOBAL_PARAMS = "GLOBAL_PARAMS";
    public static final String INPUT_STR_GLOBAL_ALL_VARS = "ALL_VARIABLES";
    public static final String INPUT_IS_EXPERT = "_EXPERT";
    public static final String INPUT_STR_ENABLE = "ENABLE";
    public static final String INPUT_STR_DISABLE = "DISABLE";
    public static final String INPUT_STR_ACCESSIBILITY = "ACCESSIBILITY";
    public static final String INPUT_STR_A11Y_NAME = "NAME_";
    public static final String INPUT_STR_A11Y_DESCRIPTION = "DESCRIPTION_";
    public static final String INPUT_STR_MNEMONIC = "MNEMONIC_";
    public static final String INPUT_STR_A11Y_DELIMETER = ";;";
    public static final String SELECTOR = "SELECTOR_";
    public static final String SELECTOR_FILE = "SELECTOR_FILE";
    public static final String SELECTOR_DIR = "SELECTOR_DIR";
    public static final String SELECTOR_DATE_CVS = "SELECTOR_DATE_CVS";
    public static final String SELECTOR_CMD = "SELECTOR_CMD_";
    public static final String IF_VAR_NON_EMPTY_BEGIN = "IF_VAR_NON_EMPTY\"";
    public static final String IF_VAR_NON_EMPTY_END = "\"_";
    public static final String IF_VAR_EMPTY_BEGIN = "IF_VAR_EMPTY\"";
    public static final String IF_VAR_EMPTY_END = "\"_";
    public static final char INPUT_STR_ARG_OPEN = '(';
    public static final char INPUT_STR_ARG_CLOSE = ')';
    public static final char INPUT_SELECT_STR_ARG_OPEN = '[';
    public static final char INPUT_SELECT_STR_ARG_CLOSE = ']';
    private static HashMap inputMap = null;
    private static final Object inputMapLock = new Object();
    private String label;
    private String a11yName = null;
    private String a11yDescription = null;
    private ArrayList components = new ArrayList();
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$util$VariableInputDescriptor;

    private VariableInputDescriptor() {
        if (inputMap == null) {
            Object object = inputMapLock;
            synchronized (object) {
                if (inputMap == null) {
                    inputMap = new HashMap();
                    inputMap.put(INPUT_STR_LABEL, new Integer(0));
                    inputMap.put(INPUT_STR_ACCESSIBILITY, new Integer(10));
                    inputMap.put(INPUT_STR_PROMPT_FIELD, new Integer(1));
                    inputMap.put(INPUT_STR_PROMPT_AREA, new Integer(2));
                    inputMap.put(INPUT_STR_ASK, new Integer(3));
                    inputMap.put(INPUT_STR_SELECT_RADIO, new Integer(4));
                    inputMap.put(INPUT_STR_SELECT_COMBO, new Integer(6));
                    inputMap.put(INPUT_STR_SELECT_COMBO_EDITABLE, new Integer(9));
                    inputMap.put(INPUT_STR_GLOBAL_PARAMS, new Integer(8));
                }
            }
        }
    }

    public static VariableInputDescriptor create(String label, VariableInputComponent[] components) {
        VariableInputDescriptor descriptor = new VariableInputDescriptor();
        descriptor.label = label;
        descriptor.components.addAll(Arrays.asList(components));
        return descriptor;
    }

    public static VariableInputDescriptor parseItems(String inputItems) throws VariableInputFormatException {
        int begin;
        VariableInputDescriptor descriptor = new VariableInputDescriptor();
        int index = 0;
        int end = 0;
        while ((begin = inputItems.indexOf(40, index)) >= 0 && (end = VcsUtilities.getPairIndex(inputItems, begin + 1, '(', ')')) >= 0) {
            String inputStr = inputItems.substring(index, begin).trim();
            boolean expert = inputStr.endsWith(INPUT_IS_EXPERT);
            if (expert) {
                inputStr = inputStr.substring(0, inputStr.length() - INPUT_IS_EXPERT.length());
            }
            String[] varConditions = new String[2];
            inputStr = VariableInputDescriptor.getVarConditions(inputStr, varConditions);
            int inputId = VariableInputDescriptor.getInputId(inputStr);
            String inputArg = inputItems.substring(begin + 1, end);
            String[] inputArgs = VcsUtilities.getQuotedStrings(inputArg);
            if (inputId == 0 && inputArgs.length > 0) {
                descriptor.label = VcsUtilities.getBundleString(inputArgs[0]);
            } else if (inputId == 10 && inputArgs.length > 0) {
                VariableInputComponent testComponent = new VariableInputComponent(0, "", "");
                VariableInputDescriptor.setA11y(VcsUtilities.getBundleString(inputArg), testComponent);
                descriptor.a11yName = testComponent.getA11yName();
                descriptor.a11yDescription = testComponent.getA11yDescription();
            } else {
                VariableInputComponent component = VariableInputDescriptor.parseComponent(inputId, inputArgs, inputArg);
                component.setExpert(expert);
                component.setVarConditions(varConditions);
                descriptor.components.add(component);
            }
            index = end + 1;
            while (index < inputItems.length() && Character.isWhitespace(inputItems.charAt(index))) {
                ++index;
            }
            if (index < inputItems.length()) continue;
        }
        if (index < inputItems.length()) {
            if (end >= 0) {
                throw new VariableInputFormatException(VariableInputDescriptor.g("EXC_UnrecognizedItem", new Integer(index)));
            }
            throw new VariableInputFormatException(VariableInputDescriptor.g("EXC_MissingClosingPar", new Integer(begin)));
        }
        return descriptor;
    }

    public String getLabel() {
        return this.label;
    }

    public String getA11yName() {
        return this.a11yName;
    }

    public String getA11yDescription() {
        return this.a11yDescription;
    }

    public VariableInputComponent[] components() {
        return this.components.toArray(new VariableInputComponent[0]);
    }

    public VariableInputValidator validate() {
        VariableInputValidator validator = null;
        VariableInputComponent[] components = this.components();
        int i = 0;
        while (i < components.length) {
            validator = components[i].validate();
            if (!validator.isValid()) break;
            ++i;
        }
        if (validator == null) {
            validator = new VariableInputValidator(null, null);
        }
        return validator;
    }

    public void addValuesToHistory() {
        VariableInputComponent[] comps = this.components();
        int i = 0;
        while (i < comps.length) {
            comps[i].addValuesToHistory();
            ++i;
        }
    }

    public void setValuesAsDefault() {
        VariableInputComponent[] comps = this.components();
        int i = 0;
        while (i < comps.length) {
            comps[i].setValuesAsDefault();
            ++i;
        }
    }

    public void setDefaultValues() {
        VariableInputComponent[] comps = this.components();
        int i = 0;
        while (i < comps.length) {
            comps[i].setDefaultValues();
            ++i;
        }
    }

    public String getStringInputItems() {
        StringBuffer items = new StringBuffer();
        if (this.label != null) {
            items.append("LABEL(");
            items.append(this.label);
            if (this.a11yName != null || this.a11yDescription != null) {
                VariableInputDescriptor.appendAccessibility(items, this.a11yName, this.a11yDescription, null);
            }
            items.append(")\n");
        }
        Iterator it = ((AbstractList)this.components).iterator();
        while (it.hasNext()) {
            VariableInputComponent component = (VariableInputComponent)it.next();
            items.append(component.toString());
            items.append('\n');
        }
        return items.toString();
    }

    static void appendAccessibility(StringBuffer items, String a11yName, String a11yDescription, Character mnemonic) {
        items.append(", ACCESSIBILITY(");
        boolean delimeter = false;
        if (a11yName != null) {
            items.append(INPUT_STR_A11Y_NAME);
            items.append(a11yName);
            delimeter = true;
        }
        if (a11yDescription != null) {
            if (delimeter) {
                items.append(INPUT_STR_A11Y_DELIMETER);
            }
            items.append(INPUT_STR_A11Y_DESCRIPTION);
            items.append(a11yDescription);
            delimeter = true;
        }
        if (mnemonic != null) {
            if (delimeter) {
                items.append(INPUT_STR_A11Y_DELIMETER);
            }
            items.append(INPUT_STR_MNEMONIC);
            items.append(mnemonic.charValue());
        }
        items.append(')');
    }

    public String toString() {
        return this.getStringInputItems();
    }

    private static String getVarConditions(String inputStr, String[] varConditions) {
        int i;
        if (inputStr.startsWith(IF_VAR_EMPTY_BEGIN) && (i = inputStr.indexOf("\"_", IF_VAR_EMPTY_BEGIN.length())) > 0) {
            varConditions[0] = inputStr.substring(IF_VAR_EMPTY_BEGIN.length(), i);
            inputStr = inputStr.substring(i + "\"_".length());
        }
        if (inputStr.startsWith(IF_VAR_NON_EMPTY_BEGIN) && (i = inputStr.indexOf("\"_", IF_VAR_NON_EMPTY_BEGIN.length())) > 0) {
            varConditions[1] = inputStr.substring(IF_VAR_NON_EMPTY_BEGIN.length(), i);
            inputStr = inputStr.substring(i + "\"_".length());
        }
        return inputStr;
    }

    private static int getInputId(String inputStr) throws VariableInputFormatException {
        Integer id = (Integer)inputMap.get(inputStr);
        if (id == null) {
            throw new VariableInputFormatException(VariableInputDescriptor.g("EXC_UnrecognizedComponent", inputStr));
        }
        return id;
    }

    static String getInputIdString(int id) {
        Iterator it = inputMap.keySet().iterator();
        while (it.hasNext()) {
            String inputStr = (String)it.next();
            Integer testID = (Integer)inputMap.get(inputStr);
            if (testID != id) continue;
            return inputStr;
        }
        return "Unknown";
    }

    private static VariableInputComponent parseComponent(int id, String[] inputArgs, String inputArg) throws VariableInputFormatException {
        int index;
        int argNum;
        VariableInputComponent component;
        int len = inputArgs.length;
        if (len < 2) {
            throw new VariableInputFormatException(VariableInputDescriptor.g("EXC_InsufficientArgs"));
        }
        if (len > 3 && inputArgs[3].startsWith(INPUT_STR_ACCESSIBILITY)) {
            component = new VariableInputComponent(id, inputArgs[0], VcsUtilities.getBundleString(inputArgs[1]));
            int begin = inputArgs[3].indexOf(40, 0);
            if (begin > 0) {
                int end = inputArgs[3].lastIndexOf(41);
                if (end < 0) {
                    end = inputArgs[3].length();
                }
                VariableInputDescriptor.setA11y(inputArgs[3].substring(begin + 1, end), component);
            }
            argNum = 4;
        } else {
            component = new VariableInputComponent(id, inputArgs[0], VcsUtilities.getBundleString(inputArgs[1]));
            argNum = 3;
        }
        if (len >= 3) {
            component.setValue(VcsUtilities.getBundleString(inputArgs[2]));
        }
        if (len > argNum && inputArgs[argNum].indexOf("VALIDATOR_") == 0) {
            String validator = inputArgs[argNum];
            component.setValidator(validator);
            ++argNum;
        }
        if (len > argNum && inputArgs[argNum].indexOf(SELECTOR) >= 0) {
            String selector = inputArgs[argNum];
            String[] varConditions = new String[2];
            if ((selector = VariableInputDescriptor.getVarConditions(selector, varConditions)).indexOf(SELECTOR) == 0) {
                component.setSelector(selector);
                component.setSelectorVarConditions(varConditions);
                ++argNum;
            }
        }
        if (2 == id && len >= argNum + 2) {
            try {
                int x = Integer.parseInt(inputArgs[argNum]);
                int y = Integer.parseInt(inputArgs[argNum + 1]);
                component.setDimension(new Dimension(x, y));
            }
            catch (NumberFormatException exc) {
                throw new VariableInputFormatException(exc.getMessage());
            }
            argNum += 2;
        }
        if (4 == id || 6 == id || 9 == id) {
            String[] inputSelectArgs = VariableInputDescriptor.getSelectArgs(inputArgs[0], inputArg, inputArgs[0].length() + inputArgs[1].length());
            int subId = 4 == id ? 5 : 7;
            int i = 0;
            while (i < inputSelectArgs.length) {
                VariableInputComponent subComponent = VariableInputDescriptor.parseComponent(subId, VcsUtilities.getQuotedStrings(inputSelectArgs[i]), inputSelectArgs[i]);
                component.addSubComponent(subComponent);
                ++i;
            }
        }
        if (3 == id && len > argNum && inputArgs[argNum].indexOf(INPUT_STR_ENABLE) < 0) {
            component.setValueSelected(inputArgs[argNum]);
            ++argNum;
        }
        if (3 == id && len > argNum && inputArgs[argNum].indexOf(INPUT_STR_ENABLE) < 0) {
            component.setValueUnselected(inputArgs[argNum]);
            ++argNum;
        }
        if (3 == id) {
            String selected = component.getValueSelected();
            if (selected != null) {
                if (Boolean.TRUE.toString().equalsIgnoreCase(component.getValue())) {
                    component.setValue(component.getValueSelected());
                } else {
                    component.setValue(component.getValueUnselected());
                }
            } else if (!Boolean.TRUE.toString().equalsIgnoreCase(component.getValue())) {
                component.setValue("");
            }
        }
        if (len > argNum && inputArgs[argNum].indexOf(INPUT_STR_ENABLE) == 0) {
            argNum = VariableInputDescriptor.addEnable(inputArgs, argNum, component);
        }
        if (len > argNum && inputArgs[argNum].indexOf(INPUT_STR_DISABLE) == 0) {
            argNum = VariableInputDescriptor.addDisable(inputArgs, argNum, component);
        }
        if (5 == id && len > argNum && (index = inputArg.indexOf(inputArgs[argNum])) > 0) {
            String subInputArg = inputArg.substring(index);
            VariableInputDescriptor subDescriptor = VariableInputDescriptor.parseItems(subInputArg);
            VariableInputComponent[] subComponents = subDescriptor.components();
            int i = 0;
            while (i < subComponents.length) {
                component.addSubComponent(subComponents[i]);
                ++i;
            }
        }
        return component;
    }

    private static int addEnable(String[] inputArgs, int enableIndex, VariableInputComponent component) {
        String var = inputArgs[enableIndex].substring(INPUT_STR_ENABLE.length() + 1).trim();
        String endBracket = new Character(')').toString();
        while (true) {
            if (var.endsWith(endBracket)) {
                var = var.substring(0, var.length() - 1);
                component.addEnable(var.trim());
                break;
            }
            component.addEnable(var.trim());
            if (++enableIndex >= inputArgs.length) break;
            var = inputArgs[enableIndex].trim();
        }
        return enableIndex + 1;
    }

    private static int addDisable(String[] inputArgs, int enableIndex, VariableInputComponent component) {
        String var = inputArgs[enableIndex].substring(INPUT_STR_DISABLE.length() + 1).trim();
        String endBracket = new Character(')').toString();
        while (true) {
            if (var.endsWith(endBracket)) {
                var = var.substring(0, var.length() - 1);
                component.addDisable(var.trim());
                break;
            }
            component.addDisable(var.trim());
            if (++enableIndex >= inputArgs.length) break;
            var = inputArgs[enableIndex].trim();
        }
        return enableIndex + 1;
    }

    private static String[] getSelectArgs(String varName, String inputArg, int begin) {
        String input = inputArg;
        int index = 0;
        ArrayList<String> selectArgsList = new ArrayList<String>();
        while (true) {
            int end;
            if (index < input.length() && input.charAt(index) != '[') {
                ++index;
                continue;
            }
            if (index >= input.length() || (end = VcsUtilities.getPairIndex(input, index + 1, '[', ']')) < 0) break;
            String selectArg = input.substring(index + 1, end);
            selectArgsList.add(varName + ", " + selectArg);
            index = end + 1;
            if (index >= input.length()) break;
        }
        return selectArgsList.toArray(new String[0]);
    }

    private static void setA11y(String a11yStr, VariableInputComponent component) {
        StringTokenizer a11yTokens = new StringTokenizer(a11yStr, INPUT_STR_A11Y_DELIMETER);
        while (a11yTokens.hasMoreTokens()) {
            String a11y = a11yTokens.nextToken();
            if (a11y.startsWith(INPUT_STR_A11Y_NAME)) {
                component.setA11yName(a11y.substring(INPUT_STR_A11Y_NAME.length()));
                continue;
            }
            if (a11y.startsWith(INPUT_STR_A11Y_DESCRIPTION)) {
                component.setA11yDescription(a11y.substring(INPUT_STR_A11Y_DESCRIPTION.length()));
                continue;
            }
            if (!a11y.startsWith(INPUT_STR_MNEMONIC)) continue;
            component.setLabelMnemonic(a11y.substring(INPUT_STR_MNEMONIC.length()));
        }
    }

    private static String g(String s) {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDescriptor == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDescriptor = VariableInputDescriptor.class$("org.netbeans.modules.vcscore.util.VariableInputDescriptor")) : class$org$netbeans$modules$vcscore$util$VariableInputDescriptor)).getString(s);
    }

    private static String g(String s, Object obj) {
        return MessageFormat.format(VariableInputDescriptor.g(s), obj);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

