/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.vcs.VcsManager;
import org.netbeans.api.vcs.commands.Command;
import org.netbeans.api.vcs.commands.CommandTask;
import org.netbeans.modules.vcscore.Variables;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.commands.RegexOutputListener;
import org.netbeans.modules.vcscore.commands.VcsDescribedCommand;
import org.netbeans.modules.vcscore.util.ChooseDirDialog;
import org.netbeans.modules.vcscore.util.ChooseFileDialog;
import org.netbeans.modules.vcscore.util.Table;
import org.netbeans.modules.vcscore.util.VariableInputComponent;
import org.netbeans.modules.vcscore.util.VariableInputDescriptor;
import org.netbeans.modules.vcscore.util.VariableInputValidator;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.netbeans.spi.vcs.commands.CommandSupport;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class VariableInputDialog
extends JPanel {
    public static final String PROP_VAR_CHANGED = "varChanged";
    private static final int TEXTFIELD_COLUMNS = 20;
    private static final int TEXTAREA_COLUMNS = 40;
    private static final int TEXTAREA_ROWS = 6;
    private static final int DEFAULT_INDENT = 20;
    private boolean validInput = false;
    private JLabel[] varPromptLabels = new JLabel[0];
    private JLabel[] filePromptLabels = new JLabel[0];
    private JLabel[] userPromptLabels = new JLabel[0];
    private String[] userPromptLabelTexts = null;
    private JTextArea[] filePromptAreas = new JTextArea[0];
    private JTextField[] varPromptFields = new JTextField[0];
    private JTextField[] userPromptFields = new JTextField[0];
    private JCheckBox[] varAskCheckBoxes = new JCheckBox[0];
    private int labelOffset = 0;
    private String[] fileNames = new String[0];
    private FilePromptDocumentListener docListener = null;
    private Object docIdentif = null;
    private VcsFileSystem fileSystem = null;
    private Hashtable vars = null;
    private boolean expert = false;
    private String exec = null;
    private VariableInputDescriptor inputDescriptor;
    private VariableInputDescriptor globalDescriptor = null;
    private ArrayList globalVars = null;
    private String globalLabel = null;
    private ArrayList actionList = new ArrayList();
    private ArrayList closeListeners = new ArrayList();
    private ArrayList historyListeners = new ArrayList();
    private ArrayList focusListenersToCallBeforeValidate = new ArrayList();
    private int historySize = 0;
    private int currentHistory = 0;
    private int promptAreaNum = 0;
    private HashMap awtComponentsByVars = new HashMap();
    private HashMap componentsByVars = new HashMap();
    static final long serialVersionUID = 8363935602008486018L;
    private JPanel navigationPanel;
    private JButton prevButton;
    private JButton nextButton;
    private JButton asDefaultButton;
    private JButton getDefaultButton;
    private JTabbedPane variableTabbedPane;
    private JPanel jPanel1;
    private JPanel variablePanel;
    private JPanel pushPanel1;
    private JPanel jPanel2;
    private JPanel globalInputPanel;
    private JPanel pushPanel2;
    private JSeparator promptEachSeparator;
    private JCheckBox promptEachCheckBox;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$util$VariableInputDialog;

    public VariableInputDialog(String[] files, VariableInputDescriptor inputDescriptor, boolean expert) {
        this(files, inputDescriptor, expert, null);
    }

    public VariableInputDialog(String[] files, VariableInputDescriptor inputDescriptor, boolean expert, Hashtable vars) {
        this.initComponents();
        this.inputDescriptor = inputDescriptor;
        this.expert = expert;
        this.vars = vars;
        this.initComponentsFromDescriptor(inputDescriptor, this.variablePanel);
        this.currentHistory = this.historySize;
        this.prevButton.setEnabled(this.currentHistory > 0);
        this.nextButton.setEnabled(false);
        this.setMnemonics();
        if (inputDescriptor != null) {
            VariableInputDialog.setA11y((JComponent)this, inputDescriptor);
        }
    }

    private void setMnemonics() {
        this.prevButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("VariableInputDialog.prevButton.mnemonic").charAt(0));
        this.prevButton.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("VariableInputDialog.prevButton.a11yName"));
        this.prevButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("VariableInputDialog.prevButton.a11yDescription"));
        this.nextButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("VariableInputDialog.nextButton.mnemonic").charAt(0));
        this.nextButton.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("VariableInputDialog.nextButton.a11yName"));
        this.nextButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("VariableInputDialog.nextButton.a11yDescription"));
        this.asDefaultButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("asDefaultButton.mnemonic").charAt(0));
        this.asDefaultButton.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("asDefaultButton.a11yName"));
        this.asDefaultButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("asDefaultButton.a11yDescription"));
        this.getDefaultButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("getDefaultButton.mnemonic").charAt(0));
        this.getDefaultButton.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("getDefaultButton.a11yName"));
        this.getDefaultButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("getDefaultButton.a11yDescription"));
        this.promptEachCheckBox.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("VariableInputDialog.promptEachCheckBox.mnemonic").charAt(0));
        this.promptEachCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("VariableInputDialog.promptEachCheckBox.a11yName"));
        this.promptEachCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("VariableInputDialog.promptEachCheckBox.a11yDescription"));
        this.variableTabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("VariableInputDialog.variableTabbedPane.a11yName"));
        this.variableTabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("VariableInputDialog.variableTabbedPane.a11yDescription"));
    }

    public void setFilePromptDocumentListener(FilePromptDocumentListener docListener) {
        this.docListener = docListener;
    }

    public void setFilePromptDocumentListener(FilePromptDocumentListener docListener, Object docIdentif) {
        this.docListener = docListener;
        this.docIdentif = docIdentif;
    }

    public void setCmdName(String cmdDisplayName) {
        if (cmdDisplayName != null) {
            this.variableTabbedPane.setTitleAt(0, cmdDisplayName);
            this.jPanel1.getAccessibleContext().setAccessibleName(cmdDisplayName);
            this.jPanel1.getAccessibleContext().setAccessibleDescription(cmdDisplayName);
        }
    }

    public FilePromptDocumentListener getFilePromptDocumentListener() {
        return this.docListener;
    }

    public VariableInputDescriptor getInputDescriptor() {
        return this.inputDescriptor;
    }

    public VariableInputDescriptor getGlobalInputDescriptor() {
        return this.globalDescriptor;
    }

    private void initComponents() {
        this.navigationPanel = new JPanel();
        this.prevButton = new JButton();
        this.nextButton = new JButton();
        this.asDefaultButton = new JButton();
        this.getDefaultButton = new JButton();
        this.variableTabbedPane = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.variablePanel = new JPanel();
        this.pushPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.globalInputPanel = new JPanel();
        this.pushPanel2 = new JPanel();
        this.promptEachSeparator = new JSeparator();
        this.promptEachCheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.navigationPanel.setLayout(new GridBagLayout());
        this.prevButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("VariableInputDialog.prevButton.text"));
        this.prevButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VariableInputDialog.this.prevButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints2.anchor = 17;
        this.navigationPanel.add((Component)this.prevButton, gridBagConstraints2);
        this.nextButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("VariableInputDialog.nextButton.text"));
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VariableInputDialog.this.nextButtonActionPerformed(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints2.anchor = 17;
        this.navigationPanel.add((Component)this.nextButton, gridBagConstraints2);
        this.asDefaultButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("asDefaultButton.text"));
        this.asDefaultButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VariableInputDialog.this.asDefaultButtonActionPerformed(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints2.anchor = 17;
        this.navigationPanel.add((Component)this.asDefaultButton, gridBagConstraints2);
        this.getDefaultButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("getDefaultButton.text"));
        this.getDefaultButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VariableInputDialog.this.getDefaultButtonActionPerformed(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weightx = 1.0;
        this.navigationPanel.add((Component)this.getDefaultButton, gridBagConstraints2);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(12, 12, 0, 12);
        gridBagConstraints1.weightx = 1.0;
        this.add((Component)this.navigationPanel, gridBagConstraints1);
        this.variableTabbedPane.setTabPlacement(3);
        this.jPanel1.setLayout(new GridBagLayout());
        this.variablePanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridy = 100;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.anchor = 15;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 1.0;
        this.variablePanel.add((Component)this.pushPanel1, gridBagConstraints4);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.insets = new Insets(12, 12, 12, 12);
        gridBagConstraints3.anchor = 11;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        this.jPanel1.add((Component)this.variablePanel, gridBagConstraints3);
        this.variableTabbedPane.addTab("jPanel1", this.jPanel1);
        this.jPanel2.setLayout(new GridBagLayout());
        this.globalInputPanel.setLayout(new GridBagLayout());
        this.pushPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridy = 100;
        gridBagConstraints6.fill = 1;
        gridBagConstraints6.anchor = 15;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.weighty = 1.0;
        this.globalInputPanel.add((Component)this.pushPanel2, gridBagConstraints6);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.insets = new Insets(12, 12, 12, 12);
        gridBagConstraints5.anchor = 11;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.weighty = 1.0;
        this.jPanel2.add((Component)this.globalInputPanel, gridBagConstraints5);
        this.variableTabbedPane.addTab("jPanel2", this.jPanel2);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(12, 12, 0, 12);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.variableTabbedPane, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(5, 12, 0, 12);
        this.add((Component)this.promptEachSeparator, gridBagConstraints1);
        this.promptEachCheckBox.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("VariableInputDialog.promptEachCheckBox.text"));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.insets = new Insets(0, 12, 0, 12);
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.promptEachCheckBox, gridBagConstraints1);
    }

    private void getDefaultButtonActionPerformed(ActionEvent evt) {
        this.inputDescriptor.setDefaultValues();
        if (this.globalDescriptor != null) {
            this.globalDescriptor.setDefaultValues();
        }
        int lastHistory = this.currentHistory;
        this.currentHistory = this.historySize;
        this.changeHistory(lastHistory, this.currentHistory);
        this.prevButton.setEnabled(this.currentHistory > 0);
        this.nextButton.setEnabled(this.currentHistory < this.historySize);
    }

    private void asDefaultButtonActionPerformed(ActionEvent evt) {
        this.inputDescriptor.setValuesAsDefault();
        if (this.globalDescriptor != null) {
            this.globalDescriptor.setValuesAsDefault();
        }
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        if (this.currentHistory < this.historySize) {
            this.changeHistory(this.currentHistory, this.currentHistory + 1);
            ++this.currentHistory;
        }
        if (this.currentHistory > 0) {
            this.prevButton.setEnabled(true);
        }
        if (this.currentHistory >= this.historySize) {
            this.nextButton.setEnabled(false);
        }
    }

    private void prevButtonActionPerformed(ActionEvent evt) {
        if (this.currentHistory > 0) {
            this.changeHistory(this.currentHistory, this.currentHistory - 1);
            --this.currentHistory;
        }
        if (this.currentHistory == 0) {
            this.prevButton.setEnabled(false);
        }
        if (this.currentHistory < this.historySize) {
            this.nextButton.setEnabled(true);
        }
    }

    private void initComponentsFromDescriptor(VariableInputDescriptor inputDescriptor, JPanel inputPanel) {
        int gridy = 0;
        if (inputDescriptor != null) {
            VariableInputComponent[] components = inputDescriptor.components();
            if (components.length > 0) {
                this.historySize = Integer.MAX_VALUE;
            }
            HashMap varsToEnableDisable = new HashMap();
            int i = 0;
            while (i < components.length) {
                gridy = this.addComponent(components[i], gridy, inputPanel, 0, varsToEnableDisable);
                this.historySize = Math.min(this.historySize, components[i].getHistorySize());
                ++i;
            }
            Iterator it = varsToEnableDisable.keySet().iterator();
            while (it.hasNext()) {
                String[] variables = (String[])it.next();
                boolean enable = (Boolean)varsToEnableDisable.get(variables);
                this.enableComponents(variables, enable);
            }
        }
        this.labelOffset = gridy;
    }

    private int addComponent(final VariableInputComponent component, int gridy, JPanel inputPanel, int leftInset, HashMap varsToEnableDisable) {
        if (VariableInputComponent.isVarConditionMatch(component.getVarConditions(), this.vars)) {
            if (this.expert || !component.isExpert()) {
                int componentId = component.getComponent();
                switch (componentId) {
                    case 1: {
                        this.addVarPromptField(component, gridy, inputPanel, leftInset);
                        ++gridy;
                        break;
                    }
                    case 2: {
                        this.addVarPromptArea(component, gridy, this.promptAreaNum++, inputPanel, leftInset);
                        gridy += 2;
                        break;
                    }
                    case 3: {
                        this.addAskChBox(component, gridy, inputPanel, leftInset, varsToEnableDisable);
                        ++gridy;
                        break;
                    }
                    case 4: {
                        gridy = this.addSelectRadio(component, gridy, inputPanel, leftInset, varsToEnableDisable);
                        break;
                    }
                    case 6: {
                        this.addSelectCombo(component, gridy, inputPanel, leftInset, false, varsToEnableDisable);
                        ++gridy;
                        break;
                    }
                    case 9: {
                        this.addSelectCombo(component, gridy, inputPanel, leftInset, true, varsToEnableDisable);
                        ++gridy;
                        break;
                    }
                    case 8: {
                        this.setGlobalVars(component);
                    }
                }
            } else {
                this.addActionToProcess(new ActionListener(){

                    public void actionPerformed(ActionEvent ev) {
                        if (VariableInputDialog.this.vars != null) {
                            VariableInputDialog.this.vars.put(component.getVariable(), component.getDefaultValue());
                        }
                    }
                });
            }
        }
        return gridy;
    }

    private boolean testValidInput() {
        if (this.inputDescriptor == null) {
            return true;
        }
        Iterator flIt = ((AbstractList)this.focusListenersToCallBeforeValidate).iterator();
        while (flIt.hasNext()) {
            FocusListener fl = (FocusListener)flIt.next();
            fl.focusLost(null);
        }
        VariableInputValidator validator = this.inputDescriptor.validate();
        boolean valid = validator.isValid();
        if (!valid) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)validator.getMessage(), 2));
        }
        return valid;
    }

    public ActionListener getActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (ev.getID() == 1001) {
                    if (NotifyDescriptor.OK_OPTION.equals(ev.getSource())) {
                        if (VariableInputDialog.this.testValidInput()) {
                            VariableInputDialog.this.validInput = true;
                            Iterator it = ((AbstractList)VariableInputDialog.this.closeListeners).iterator();
                            while (it.hasNext()) {
                                ((ActionListener)it.next()).actionPerformed(ev);
                            }
                            VariableInputDialog.this.closeListeners.clear();
                        }
                    } else {
                        VariableInputDialog.this.validInput = false;
                        VariableInputDialog.this.freeReferences();
                    }
                }
            }
        };
    }

    public void addCloseListener(ActionListener closeListener) {
        this.closeListeners.add(closeListener);
    }

    private void freeReferences() {
        this.fileSystem = null;
        this.docIdentif = null;
        this.docListener = null;
    }

    private void addActionToProcess(ActionListener l) {
        this.actionList.add(l);
    }

    public void processActions() {
        Iterator it = ((AbstractList)this.actionList).iterator();
        while (it.hasNext()) {
            ActionListener listener = (ActionListener)it.next();
            listener.actionPerformed(null);
        }
        this.freeReferences();
    }

    private void addHistoryListener(HistoryListener l) {
        this.historyListeners.add(l);
    }

    private void changeHistory(int index1, int index2) {
        Iterator it = ((AbstractList)this.historyListeners).iterator();
        while (it.hasNext()) {
            HistoryListener historyListener = (HistoryListener)it.next();
            historyListener.changeHistory(index1, index2);
        }
    }

    public boolean isValidInput() {
        return this.validInput;
    }

    public void setVCSFileSystem(VcsFileSystem fileSystem, Hashtable vars) {
        this.fileSystem = fileSystem;
        this.vars = vars;
    }

    public void updateVariableValues(Hashtable vars) {
        Iterator it = vars.keySet().iterator();
        while (it.hasNext()) {
            String varName = (String)it.next();
            String varValue = (String)vars.get(varName);
            VariableInputComponent inComponent = (VariableInputComponent)this.componentsByVars.get(varName);
            if (inComponent == null) continue;
            inComponent.setValue(varValue);
            Component[] components = (Component[])this.awtComponentsByVars.get(varName);
            if (components == null) continue;
            int i = 0;
            while (i < components.length) {
                Component component = components[i];
                if (component instanceof JTextField) {
                    varValue = Variables.expand(vars, varValue, false);
                    inComponent.setValue(varValue);
                    ((JTextField)component).setText(varValue);
                } else if (component instanceof JCheckBox) {
                    JCheckBox chbox = (JCheckBox)component;
                    if (varValue == null) {
                        varValue = inComponent.getDefaultValue();
                    }
                    if (varValue != null) {
                        varValue = Variables.expand(vars, varValue, false);
                        inComponent.setValue(varValue);
                        String valueSelected = inComponent.getValueSelected();
                        if (valueSelected != null) {
                            chbox.setSelected(varValue.equals(valueSelected));
                        } else {
                            chbox.setSelected(Boolean.TRUE.toString().equalsIgnoreCase(varValue));
                        }
                    }
                } else if (component instanceof JRadioButton) {
                    JRadioButton button = (JRadioButton)component;
                    ButtonModel model = button.getModel();
                    if (model instanceof DefaultButtonModel) {
                        ButtonGroup group = ((DefaultButtonModel)model).getGroup();
                        VariableInputDialog.selectButton(varValue, inComponent.subComponents(), group);
                    }
                } else if (component instanceof JComboBox) {
                    JComboBox comboBox = (JComboBox)component;
                    if (comboBox.isEditable()) {
                        comboBox.setSelectedItem(varValue);
                    } else {
                        int j;
                        VariableInputComponent[] subComponents = inComponent.subComponents();
                        int items = subComponents.length;
                        String[] values = new String[items];
                        int j2 = 0;
                        while (j2 < items) {
                            values[j2] = subComponents[j2].getDefaultValue();
                            ++j2;
                        }
                        if (varValue != null) {
                            j = 0;
                            while (j < items) {
                                if (varValue.equals(values[j])) break;
                                ++j;
                            }
                            if (j >= items) {
                                j = 0;
                            }
                        } else {
                            j = 0;
                        }
                        comboBox.setSelectedIndex(j);
                    }
                }
                ++i;
            }
        }
    }

    public void setExec(String exec) {
        this.exec = exec;
    }

    private void removeGlobalInputTab() {
        this.remove(this.variableTabbedPane);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.add(this.jPanel1, gridBagConstraints1, 1);
    }

    public void setGlobalInput(VariableInputDescriptor inputDescriptor) {
        if (inputDescriptor == null) {
            this.removeGlobalInputTab();
            return;
        }
        ArrayList<VariableInputComponent> globalComponents = new ArrayList<VariableInputComponent>();
        VariableInputComponent[] components = inputDescriptor.components();
        int i = 0;
        while (i < components.length) {
            String var = components[i].getVariable();
            if (this.globalVars == null || this.globalVars.contains(var)) {
                globalComponents.add(components[i]);
            }
            ++i;
        }
        if (this.globalLabel == null) {
            this.globalLabel = inputDescriptor.getLabel();
        }
        this.globalDescriptor = inputDescriptor;
        if (this.globalLabel != null) {
            if (this.expert) {
                this.variableTabbedPane.setTitleAt(1, this.globalLabel);
                this.jPanel2.getAccessibleContext().setAccessibleName(this.globalLabel);
                this.jPanel2.getAccessibleContext().setAccessibleDescription(this.globalLabel);
            } else {
                this.removeGlobalInputTab();
            }
        }
        int historySizeOrig = this.historySize;
        int labelOffsetOrig = this.labelOffset;
        this.initComponentsFromDescriptor(this.globalDescriptor, this.globalInputPanel);
        this.historySize = historySizeOrig;
        this.labelOffset = labelOffsetOrig;
        if (this.expert) {
            this.globalInputPanel.setVisible(true);
        }
    }

    private void enableComponents(String[] vars, boolean enable) {
        int i = 0;
        while (i < vars.length) {
            Component[] components = (Component[])this.awtComponentsByVars.get(vars[i]);
            if (components != null) {
                int j = 0;
                while (j < components.length) {
                    components[j].setEnabled(enable);
                    ++j;
                }
            }
            ++i;
        }
    }

    private static void setA11y(JComponent jComponent, VariableInputDescriptor descriptor) {
        VariableInputDialog.setA11y(jComponent, descriptor.getA11yName(), descriptor.getA11yDescription());
    }

    private static void setA11y(JComponent jComponent, VariableInputComponent component) {
        VariableInputDialog.setA11y(jComponent, component.getA11yName(), component.getA11yDescription());
    }

    private static void setA11y(JComponent jComponent, String a11yName, String a11yDescription) {
        if (a11yName == null) {
            a11yName = NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("VariableInputDialog.noA11Y.a11yName");
        }
        jComponent.getAccessibleContext().setAccessibleName(a11yName);
        if (a11yDescription == null) {
            a11yDescription = NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("VariableInputDialog.noA11Y.a11yDescription");
        }
        jComponent.getAccessibleContext().setAccessibleDescription(a11yDescription);
    }

    private void addVarPromptField(final VariableInputComponent component, int gridy, JPanel variablePanel, int leftInset) {
        String varLabel = component.getLabel();
        ArrayList<Component> componentList = new ArrayList<Component>();
        final JTextField field = new JTextField(20);
        if (varLabel != null && varLabel.length() > 0) {
            JLabel label = new JLabel(varLabel);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = gridy;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.insets = new Insets(0, leftInset, 8, 8);
            variablePanel.add((Component)label, gridBagConstraints1);
            componentList.add(label);
            label.setLabelFor(field);
            if (component.getLabelMnemonic() != null) {
                label.setDisplayedMnemonic(component.getLabelMnemonic().charValue());
            }
        }
        VariableInputDialog.setA11y((JComponent)field, component);
        String value = component.needsPreCommandPerform() ? component.getValue() : component.getDefaultValue();
        if (value != null) {
            value = Variables.expand(this.vars, value, false);
            field.setText(value);
        }
        component.setValue(value);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = gridy;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets = new Insets(0, 0, 8, 0);
        variablePanel.add((Component)field, gridBagConstraints2);
        componentList.add(field);
        VcsUtilities.removeEnterFromKeymap(field);
        String selector = component.getSelector();
        if (selector != null && !VariableInputComponent.isVarConditionMatch(component.getSelectorVarConditions(), this.vars)) {
            selector = null;
        }
        FocusListener l = new FocusListener(){

            public void focusGained(FocusEvent fevt) {
            }

            public void focusLost(FocusEvent fevt) {
                String oldValue = component.getValue();
                component.setValue(field.getText());
                VariableInputDialog.super.firePropertyChange(VariableInputDialog.PROP_VAR_CHANGED + component.getVariable(), oldValue, component.getValue());
            }
        };
        field.addFocusListener(l);
        this.focusListenersToCallBeforeValidate.add(l);
        if (selector != null) {
            Component awtComponent = null;
            if ("SELECTOR_DIR".equals(selector)) {
                awtComponent = this.addBrowseDir(variablePanel, field, gridy, l);
            } else if ("SELECTOR_FILE".equals(selector)) {
                awtComponent = this.addBrowseFile(variablePanel, field, gridy, l);
            } else if ("SELECTOR_DATE_CVS".equals(selector)) {
                awtComponent = this.addDateCVS(variablePanel, field, gridy, l);
            } else if (selector.indexOf("SELECTOR_CMD_") == 0) {
                awtComponent = this.addSelector(variablePanel, field, gridy, selector.substring("SELECTOR_CMD_".length()), l);
            }
            if (awtComponent != null) {
                componentList.add(awtComponent);
            }
        }
        this.awtComponentsByVars.put(component.getVariable(), componentList.toArray(new Component[0]));
        this.componentsByVars.put(component.getVariable(), component);
        field.addInputMethodListener(new InputMethodListener(){

            public void caretPositionChanged(InputMethodEvent event) {
            }

            public void inputMethodTextChanged(InputMethodEvent event) {
                String oldValue = component.getValue();
                component.setValue(field.getText());
                VariableInputDialog.super.firePropertyChange(VariableInputDialog.PROP_VAR_CHANGED + component.getVariable(), oldValue, component.getValue());
            }
        });
        this.addActionToProcess(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                component.setValue(field.getText());
                if (VariableInputDialog.this.vars != null) {
                    if (field.isEnabled()) {
                        VariableInputDialog.this.vars.put(component.getVariable(), component.getValue());
                    } else {
                        VariableInputDialog.this.vars.remove(component.getVariable());
                    }
                }
            }
        });
        this.addHistoryListener(new HistoryListener(){

            public void changeHistory(int index1, int index) {
                String oldValue = component.getValue();
                field.setText(component.getHistoryValue(index));
                component.setValue(field.getText());
                VariableInputDialog.super.firePropertyChange(VariableInputDialog.PROP_VAR_CHANGED + component.getVariable(), oldValue, component.getValue());
            }
        });
    }

    private Component addBrowseDir(JPanel panel, final JTextField field, int y, final FocusListener l) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = y;
        gridBagConstraints.insets = new Insets(0, 8, 8, 0);
        gridBagConstraints.fill = 2;
        JButton button = new JButton(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("VariableInputDialog.Browse"));
        button.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("VariableInputDialog.BrowseDir.a11yDesc"));
        panel.add((Component)button, gridBagConstraints);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChooseDirDialog chooseDir = new ChooseDirDialog((Frame)new JFrame(), new File(field.getText()));
                VcsUtilities.centerWindow(chooseDir);
                chooseDir.show();
                String selected = chooseDir.getSelectedDir();
                if (selected == null) {
                    return;
                }
                field.setText(selected);
                l.focusLost(null);
            }
        });
        return button;
    }

    private Component addBrowseFile(JPanel panel, final JTextField field, int y, final FocusListener l) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = y;
        gridBagConstraints.insets = new Insets(0, 8, 8, 0);
        gridBagConstraints.fill = 2;
        JButton button = new JButton(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("VariableInputDialog.Browse"));
        button.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("VariableInputDialog.BrowseFile.a11yDesc"));
        panel.add((Component)button, gridBagConstraints);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChooseFileDialog chooseFile = new ChooseFileDialog((Frame)new JFrame(), new File(field.getText()), false);
                VcsUtilities.centerWindow(chooseFile);
                chooseFile.show();
                String selected = chooseFile.getSelectedFile();
                if (selected == null) {
                    return;
                }
                field.setText(selected);
                l.focusLost(null);
            }
        });
        return button;
    }

    private Component addDateCVS(JPanel panel, JTextField field, int y, FocusListener l) {
        field.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("VariableInputDialog.DateCVS"));
        return null;
    }

    private Component addSelector(JPanel panel, final JTextField field, int y, final String commandName, final FocusListener l) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = y;
        gridBagConstraints.insets = new Insets(0, 8, 8, 0);
        gridBagConstraints.fill = 2;
        JButton button = new JButton(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("VariableInputDialog.Select"));
        button.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("VariableInputDialog.Select.a11yDesc"));
        panel.add((Component)button, gridBagConstraints);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                new RequestProcessor("Selector Request Processor").post(new Runnable(this){
                    private final /* synthetic */ 13 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        String selected = VariableInputDialog.access$1500(13.access$1400(this.this$1), 13.access$1200(this.this$1), 13.access$1300(this.this$1).getText());
                        if (selected != null) {
                            13.access$1300(this.this$1).setText(selected);
                            13.access$1600(this.this$1).focusLost(null);
                        }
                    }
                });
            }

            static /* synthetic */ String access$1200(13 x0) {
                return x0.commandName;
            }

            static /* synthetic */ JTextField access$1300(13 x0) {
                return x0.field;
            }

            static /* synthetic */ VariableInputDialog access$1400(13 x0) {
                return x0.VariableInputDialog.this;
            }

            static /* synthetic */ FocusListener access$1600(13 x0) {
                return x0.l;
            }
        });
        return button;
    }

    private String getSelectorText(String commandName, String oldText) {
        CommandSupport cmdSupp = this.fileSystem.getCommandSupport(commandName);
        Command command = cmdSupp.createCommand();
        if (!(command instanceof VcsDescribedCommand)) {
            return null;
        }
        VcsDescribedCommand cmd = (VcsDescribedCommand)command;
        Hashtable varsCopy = new Hashtable(this.vars);
        cmd.setAdditionalVariables(varsCopy);
        if (!VcsManager.getDefault().showCustomizer(cmd)) {
            return null;
        }
        final StringBuffer selectorOutput = new StringBuffer();
        final boolean[] selectorMatched = new boolean[]{false};
        cmd.addRegexOutputListener(new RegexOutputListener(){

            public void outputMatchedGroups(String[] elements) {
                if (elements != null) {
                    selectorMatched[0] = true;
                    selectorOutput.append(VcsUtilities.array2string(elements).trim());
                }
            }
        });
        CommandTask task = cmd.execute();
        try {
            task.waitFinished(0);
        }
        catch (InterruptedException iexc) {
            return null;
        }
        if (task.getExitStatus() == 0 && selectorMatched[0]) {
            return selectorOutput.toString();
        }
        return null;
    }

    private void addAskChBox(final VariableInputComponent component, int gridy, JPanel variablePanel, int leftInset, HashMap varsToEnableDisable) {
        String askDefault;
        String label = component.getLabel();
        final JCheckBox chbox = new JCheckBox(" " + label);
        if (component.needsPreCommandPerform()) {
            askDefault = component.getValue();
        } else {
            askDefault = component.getDefaultValue();
            component.setValue(askDefault);
        }
        if (askDefault != null) {
            askDefault = Variables.expand(this.vars, askDefault, false);
            component.setValue(askDefault);
            String valueSelected = component.getValueSelected();
            if (valueSelected != null) {
                chbox.setSelected(askDefault.equals(valueSelected));
            } else {
                chbox.setSelected(Boolean.TRUE.toString().equalsIgnoreCase(askDefault));
            }
        }
        if (component.getLabelMnemonic() != null) {
            chbox.setMnemonic(component.getLabelMnemonic().charValue());
        }
        VariableInputDialog.setA11y((JComponent)chbox, component);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = gridy;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(0, leftInset, 8, 0);
        gridBagConstraints1.gridwidth = 2;
        variablePanel.add((Component)chbox, gridBagConstraints1);
        chbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                boolean selected = chbox.isSelected();
                String valueSelected = component.getValueSelected();
                String valueUnselected = component.getValueUnselected();
                String oldValue = component.getValue();
                if (selected && valueSelected != null) {
                    component.setValue(valueSelected);
                } else if (!selected && valueUnselected != null) {
                    component.setValue(valueUnselected);
                } else {
                    component.setValue(selected ? Boolean.TRUE.toString() : "");
                }
                VariableInputDialog.super.firePropertyChange(VariableInputDialog.PROP_VAR_CHANGED + component.getVariable(), oldValue, component.getValue());
            }
        });
        this.awtComponentsByVars.put(component.getVariable(), new Component[]{chbox});
        this.componentsByVars.put(component.getVariable(), component);
        final String[] varsEnabled = component.getEnable().toArray(new String[0]);
        final String[] varsDisabled = component.getDisable().toArray(new String[0]);
        if (varsEnabled.length > 0) {
            varsToEnableDisable.put(varsEnabled, chbox.isSelected() ? Boolean.TRUE : Boolean.FALSE);
        }
        if (varsDisabled.length > 0) {
            varsToEnableDisable.put(varsDisabled, !chbox.isSelected() ? Boolean.TRUE : Boolean.FALSE);
        }
        chbox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                VariableInputDialog.this.enableComponents(varsEnabled, chbox.isSelected());
                VariableInputDialog.this.enableComponents(varsDisabled, !chbox.isSelected());
            }
        });
        this.addActionToProcess(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                boolean selected = chbox.isSelected();
                String valueSelected = component.getValueSelected();
                String valueUnselected = component.getValueUnselected();
                if (selected && valueSelected != null) {
                    component.setValue(valueSelected);
                } else if (!selected && valueUnselected != null) {
                    component.setValue(valueUnselected);
                } else {
                    component.setValue(selected ? Boolean.TRUE.toString() : "");
                }
                if (VariableInputDialog.this.vars != null) {
                    if (chbox.isEnabled()) {
                        VariableInputDialog.this.vars.put(component.getVariable(), component.getValue());
                    } else {
                        VariableInputDialog.this.vars.remove(component.getVariable());
                    }
                }
            }
        });
        this.addHistoryListener(new HistoryListener(){

            public void changeHistory(int index1, int index) {
                String valueSelected = component.getValueSelected();
                String valueUnselected = component.getValueUnselected();
                String value = component.getHistoryValue(index);
                if (valueSelected != null && valueSelected.equals(value)) {
                    chbox.setSelected(true);
                } else if (valueUnselected != null && valueUnselected.equals(value)) {
                    chbox.setSelected(false);
                } else {
                    chbox.setSelected(Boolean.TRUE.toString().equals(value));
                }
            }
        });
    }

    private void addVarPromptArea(final VariableInputComponent component, int gridy, final int promptAreaNum, JPanel variablePanel, int leftInset) {
        String message = component.getLabel();
        JLabel label = new JLabel(message);
        Dimension dimension = component.getDimension();
        if (dimension == null) {
            dimension = new Dimension(6, 40);
        }
        final JTextArea area = new JTextArea(dimension.width, dimension.height);
        label.setLabelFor(area);
        if (component.getLabelMnemonic() != null) {
            label.setDisplayedMnemonic(component.getLabelMnemonic().charValue());
        }
        VariableInputDialog.setA11y((JComponent)area, component);
        JScrollPane scrollArea = new JScrollPane(area);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = gridy;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(0, leftInset, 8, 0);
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = gridy + 1;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = new Insets(0, leftInset, 8, 0);
        gridBagConstraints2.gridwidth = 3;
        area.setBorder(new BevelBorder(1));
        variablePanel.add((Component)label, gridBagConstraints1);
        variablePanel.add((Component)scrollArea, gridBagConstraints2);
        if (variablePanel.isAncestorOf(this.pushPanel1)) {
            variablePanel.remove(this.pushPanel1);
        } else if (variablePanel.isAncestorOf(this.pushPanel2)) {
            variablePanel.remove(this.pushPanel2);
        }
        String fileName = component.needsPreCommandPerform() ? component.getValue() : component.getDefaultValue();
        if (fileName == null || fileName.length() == 0) {
            try {
                fileName = File.createTempFile("tempVcsCmd", "input").getAbsolutePath();
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
        } else {
            fileName = Variables.expand(this.vars, fileName, false);
        }
        component.setValue(fileName);
        this.initArea(area, fileName);
        this.awtComponentsByVars.put(component.getVariable(), new Component[]{label, area});
        this.addActionToProcess(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                VariableInputDialog.this.writeFileContents(area, component.getValue(), promptAreaNum);
                if (VariableInputDialog.this.vars != null) {
                    if (area.isEnabled()) {
                        String value = component.getValue();
                        if (value != null) {
                            VariableInputDialog.this.vars.put(component.getVariable(), value);
                        } else {
                            VariableInputDialog.this.vars.remove(component.getVariable());
                        }
                    } else {
                        VariableInputDialog.this.vars.remove(component.getVariable());
                    }
                }
            }
        });
        this.addHistoryListener(new HistoryListener(){

            public void changeHistory(int index1, int index2) {
                if (index1 == VariableInputDialog.this.historySize && index2 < index1) {
                    VariableInputDialog.this.writeFileContents(area, component.getValue(), promptAreaNum);
                }
                VariableInputDialog.this.initArea(area, component.getHistoryValue(index2));
            }
        });
    }

    private int addSelectRadio(final VariableInputComponent component, int gridy, JPanel variablePanel, int leftInset, HashMap varsToEnableDisable) {
        String defValue;
        ArrayList<JComponent> componentList = new ArrayList<JComponent>();
        String message = component.getLabel();
        if (message != null && message.length() > 0) {
            JLabel label = new JLabel(message);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = gridy++;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.insets = new Insets(0, leftInset, 4, 0);
            gridBagConstraints1.gridwidth = 2;
            variablePanel.add((Component)label, gridBagConstraints1);
            componentList.add(label);
        }
        final VariableInputComponent[] subComponents = component.subComponents();
        final ButtonGroup group = new ButtonGroup();
        if (component.needsPreCommandPerform()) {
            defValue = component.getValue();
        } else {
            defValue = component.getDefaultValue();
            component.setValue(defValue);
        }
        int i = 0;
        while (i < subComponents.length) {
            gridy = this.addRadioButton(component, subComponents[i], gridy, group, variablePanel, leftInset, defValue, varsToEnableDisable);
            ++i;
        }
        Enumeration<AbstractButton> enumeration = group.getElements();
        while (enumeration.hasMoreElements()) {
            componentList.add(enumeration.nextElement());
        }
        this.awtComponentsByVars.put(component.getVariable(), componentList.toArray(new Component[0]));
        this.componentsByVars.put(component.getVariable(), component);
        VariableInputDialog.selectButton(defValue, subComponents, group);
        this.addActionToProcess(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (VariableInputDialog.this.vars != null) {
                    String value = component.getValue();
                    if (value != null) {
                        VariableInputDialog.this.vars.put(component.getVariable(), value);
                    } else {
                        VariableInputDialog.this.vars.remove(component.getVariable());
                    }
                }
            }
        });
        this.addHistoryListener(new HistoryListener(){

            public void changeHistory(int index1, int index) {
                VariableInputDialog.selectButton(component.getHistoryValue(index), subComponents, group);
            }
        });
        return gridy;
    }

    private int addRadioButton(final VariableInputComponent superComponent, final VariableInputComponent component, int gridy, ButtonGroup group, JPanel variablePanel, int leftInset, String defValue, HashMap varsToEnableDisable) {
        String label = component.getLabel();
        boolean firstSubLabelEmpty = false;
        VariableInputComponent[] subComponents = component.subComponents();
        if (subComponents.length > 0) {
            String subLabel = subComponents[0].getLabel();
            firstSubLabelEmpty = subLabel == null || subLabel.length() == 0;
        }
        final JRadioButton button = new JRadioButton(label);
        if (component.getLabelMnemonic() != null) {
            button.setMnemonic(component.getLabelMnemonic().charValue());
        }
        VariableInputDialog.setA11y((JComponent)button, component);
        group.add(button);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = gridy;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(0, leftInset, 4, 0);
        gridBagConstraints1.gridwidth = firstSubLabelEmpty ? 1 : 2;
        variablePanel.add((Component)button, gridBagConstraints1);
        ++gridy;
        ArrayList<String> componentVarsList = new ArrayList<String>();
        int i = 0;
        while (i < subComponents.length) {
            int inset;
            if (i == 0 && firstSubLabelEmpty) {
                --gridy;
                inset = 8;
            } else {
                inset = leftInset + 20;
            }
            gridy = this.addComponent(subComponents[i], gridy, variablePanel, inset, varsToEnableDisable);
            componentVarsList.add(subComponents[i].getVariable());
            ++i;
        }
        final String[] componentVars = componentVarsList.toArray(new String[0]);
        this.enableComponents(componentVars, false);
        final String[] varsEnabled = component.getEnable().toArray(new String[0]);
        final String[] varsDisabled = component.getDisable().toArray(new String[0]);
        boolean enabled = defValue.equals(component.getValue());
        if (componentVars.length > 0) {
            varsToEnableDisable.put(componentVars, enabled ? Boolean.TRUE : Boolean.FALSE);
        }
        if (varsEnabled.length > 0) {
            varsToEnableDisable.put(varsEnabled, enabled ? Boolean.TRUE : Boolean.FALSE);
        }
        if (varsDisabled.length > 0) {
            varsToEnableDisable.put(varsDisabled, !enabled ? Boolean.TRUE : Boolean.FALSE);
        }
        button.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                VariableInputDialog.this.enableComponents(componentVars, button.isSelected());
                VariableInputDialog.this.enableComponents(varsEnabled, button.isSelected());
                VariableInputDialog.this.enableComponents(varsDisabled, !button.isSelected());
            }
        });
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (button.isSelected()) {
                    String oldValue = superComponent.getValue();
                    superComponent.setValue(component.getValue());
                    VariableInputDialog.super.firePropertyChange(VariableInputDialog.PROP_VAR_CHANGED + superComponent.getVariable(), oldValue, superComponent.getValue());
                }
            }
        });
        return gridy;
    }

    private static void selectButton(String value, VariableInputComponent[] subComponents, ButtonGroup group) {
        if (value == null && subComponents.length > 0) {
            value = subComponents[0].getValue();
        }
        Enumeration<AbstractButton> enumeration = group.getElements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            JRadioButton radio = (JRadioButton)enumeration.nextElement();
            if (value.equals(subComponents[i].getValue())) {
                radio.doClick();
            }
            ++i;
        }
    }

    private void addSelectCombo(final VariableInputComponent component, int gridy, JPanel variablePanel, int leftInset, final boolean editable, HashMap varsToEnableDisable) {
        int i;
        String selected;
        ArrayList<JComponent> componentList = new ArrayList<JComponent>();
        String message = component.getLabel();
        final VariableInputComponent[] subComponents = component.subComponents();
        final int items = subComponents.length;
        String[] labels = new String[items];
        final String[] values = new String[items];
        final String[][] varsEnabled = new String[items][0];
        final String[][] varsDisabled = new String[items][0];
        int i2 = 0;
        while (i2 < items) {
            labels[i2] = subComponents[i2].getLabel();
            values[i2] = subComponents[i2].getDefaultValue();
            subComponents[i2].setValue(subComponents[i2].getDefaultValue());
            varsEnabled[i2] = subComponents[i2].getEnable().toArray(new String[0]);
            varsDisabled[i2] = subComponents[i2].getDisable().toArray(new String[0]);
            ++i2;
        }
        final JComboBox<String> comboBox = new JComboBox<String>(labels);
        comboBox.setEditable(editable);
        if (editable) {
            comboBox.setPreferredSize(new JTextField().getPreferredSize());
        }
        if (message != null && message.length() > 0) {
            JLabel label = new JLabel(message);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = gridy;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.insets = new Insets(0, leftInset, 8, 8);
            gridBagConstraints1.gridwidth = 1;
            variablePanel.add((Component)label, gridBagConstraints1);
            componentList.add(label);
            label.setLabelFor(comboBox);
            if (component.getLabelMnemonic() != null) {
                label.setDisplayedMnemonic(component.getLabelMnemonic().charValue());
            }
        }
        VariableInputDialog.setA11y(comboBox, component);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = gridy;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets = new Insets(0, 0, 8, 0);
        gridBagConstraints2.gridwidth = 1;
        variablePanel.add(comboBox, gridBagConstraints2);
        componentList.add(comboBox);
        this.awtComponentsByVars.put(component.getVariable(), componentList.toArray(new Component[0]));
        this.componentsByVars.put(component.getVariable(), component);
        if (component.needsPreCommandPerform()) {
            selected = component.getValue();
        } else {
            selected = component.getDefaultValue();
            component.setValue(selected);
        }
        if (selected != null) {
            i = 0;
            while (i < items) {
                if (selected.equals(values[i])) break;
                ++i;
            }
            if (i >= items) {
                i = -1;
            }
        } else {
            i = 0;
        }
        if (i >= 0) {
            comboBox.setSelectedIndex(i);
        } else {
            comboBox.setSelectedItem(selected);
        }
        if (i >= 0) {
            if (varsEnabled[i].length > 0) {
                varsToEnableDisable.put(varsEnabled[i], Boolean.TRUE);
            }
            if (varsDisabled[i].length > 0) {
                varsToEnableDisable.put(varsDisabled[i], Boolean.FALSE);
            }
        }
        comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String currentValue;
                if (editable) {
                    currentValue = (String)comboBox.getSelectedItem();
                } else {
                    int selected2 = comboBox.getSelectedIndex();
                    currentValue = subComponents[selected2].getValue();
                }
                if (currentValue != null) {
                    component.setValue(currentValue);
                    VariableInputDialog.super.firePropertyChange(VariableInputDialog.PROP_VAR_CHANGED + component.getVariable(), null, currentValue);
                }
            }
        });
        comboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                boolean selected2 = 1 == ev.getStateChange();
                Object item = ev.getItem();
                int index = 0;
                while (index < items) {
                    if (item.equals(comboBox.getItemAt(index))) break;
                    ++index;
                }
                if (index < items) {
                    VariableInputDialog.this.enableComponents(varsEnabled[index], selected2);
                    VariableInputDialog.this.enableComponents(varsDisabled[index], !selected2);
                }
            }
        });
        this.addActionToProcess(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                int selected2 = comboBox.getSelectedIndex();
                component.setValue(subComponents[selected2].getValue());
                if (VariableInputDialog.this.vars != null) {
                    if (comboBox.isEnabled()) {
                        String value = component.getValue();
                        if (value != null) {
                            VariableInputDialog.this.vars.put(component.getVariable(), value);
                        } else {
                            VariableInputDialog.this.vars.remove(component.getVariable());
                        }
                    } else {
                        VariableInputDialog.this.vars.remove(component.getVariable());
                    }
                }
            }
        });
        this.addHistoryListener(new HistoryListener(){

            public void changeHistory(int index1, int index) {
                String value = component.getValue();
                String selected2 = component.getHistoryValue(index);
                if (selected2 != null) {
                    int i2 = 0;
                    while (i2 < items) {
                        if (selected2.equals(values[i2])) break;
                        ++i2;
                    }
                    if (i2 < items) {
                        comboBox.setSelectedIndex(i2);
                    }
                } else {
                    comboBox.setSelectedIndex(0);
                }
                component.setValue(value);
            }
        });
    }

    private void setGlobalVars(VariableInputComponent component) {
        String varsStr = component.getVariable();
        String[] vars = VcsUtilities.getQuotedStrings(varsStr);
        if (vars.length != 1 || !"ALL_VARIABLES".equals(vars[0])) {
            this.globalVars = new ArrayList();
            this.globalVars.addAll(Arrays.asList(vars));
        }
        this.globalLabel = component.getLabel();
    }

    public void setUserParamsPromptLabels(Table varLabels, String advancedName) {
        Vector<JLabel> labels = new Vector<JLabel>();
        Vector<JTextField> fields = new Vector<JTextField>();
        int i = 0;
        this.userPromptLabelTexts = new String[varLabels.size()];
        if (advancedName != null && varLabels.size() > 0) {
            JSeparator sep = new JSeparator();
            JLabel label = new JLabel(MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputDialog == null ? (class$org$netbeans$modules$vcscore$util$VariableInputDialog = VariableInputDialog.class$("org.netbeans.modules.vcscore.util.VariableInputDialog")) : class$org$netbeans$modules$vcscore$util$VariableInputDialog)).getString("VariableInputDialog.advancedNameLabel"), advancedName));
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints1.gridwidth = 2;
            gridBagConstraints1.gridy = i + this.labelOffset;
            gridBagConstraints1.insets = new Insets(0, 0, 8, 0);
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints2.gridwidth = 2;
            gridBagConstraints2.gridy = i + this.labelOffset + 1;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(0, 0, 8, 0);
            if (this.labelOffset > 0) {
                this.variablePanel.add((Component)sep, gridBagConstraints1);
            }
            this.variablePanel.add((Component)label, gridBagConstraints2);
            this.labelOffset += 2;
        }
        Enumeration enumeration = varLabels.keys();
        while (enumeration.hasMoreElements()) {
            String labelStr;
            this.userPromptLabelTexts[i] = labelStr = (String)enumeration.nextElement();
            JLabel label = new JLabel(labelStr + ":");
            JTextField field = new JTextField(20);
            field.setText((String)varLabels.get(labelStr));
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = i + this.labelOffset;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.insets = new Insets(0, 0, 8, 8);
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = i + this.labelOffset;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(0, 0, 8, 0);
            this.variablePanel.add((Component)label, gridBagConstraints1);
            this.variablePanel.add((Component)field, gridBagConstraints2);
            labels.addElement(label);
            fields.addElement(field);
            VcsUtilities.removeEnterFromKeymap(field);
            ++i;
        }
        this.labelOffset += varLabels.size();
        this.userPromptLabels = labels.toArray(new JLabel[0]);
        this.userPromptFields = fields.toArray(new JTextField[0]);
    }

    public void showPromptEach(boolean show) {
        this.promptEachCheckBox.setVisible(show);
        this.promptEachSeparator.setVisible(show);
    }

    public void setPromptEach(boolean prompt) {
        this.promptEachCheckBox.setSelected(prompt);
    }

    public String[] getVarPromptValues() {
        String[] varValues = new String[this.varPromptFields.length];
        int i = 0;
        while (i < this.varPromptFields.length) {
            varValues[i] = this.varPromptFields[i].getText();
            ++i;
        }
        return varValues;
    }

    public String[] getVarAskValues() {
        String[] varValues = new String[this.varAskCheckBoxes.length];
        int i = 0;
        while (i < this.varAskCheckBoxes.length) {
            varValues[i] = this.varAskCheckBoxes[i].isSelected() ? "true" : "";
            ++i;
        }
        return varValues;
    }

    public JPanel getVariableInputPanel() {
        return this.variablePanel;
    }

    public Hashtable getUserParamsValuesTable() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        int i = 0;
        while (i < this.userPromptLabels.length) {
            result.put(this.userPromptLabelTexts[i], this.userPromptFields[i].getText());
            ++i;
        }
        return result;
    }

    public boolean getPromptForEachFile() {
        return this.promptEachCheckBox.isSelected();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initArea(JTextArea filePromptArea, String fileName) {
        if (fileName.length() == 0) {
            return;
        }
        File file = new File(fileName);
        if (!file.exists() || !file.canRead()) return;
        FileReader reader = null;
        reader = new FileReader(file);
        filePromptArea.read(reader, null);
        Object var8_5 = null;
        if (reader == null) return;
        try {
            reader.close();
            return;
        }
        catch (IOException ioexc) {}
        return;
        {
            catch (FileNotFoundException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
                Object var8_6 = null;
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException ioexc) {}
                return;
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
                Object var8_7 = null;
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException ioexc) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException ioexc) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeFileContents(JTextArea filePromptArea, String fileName, int promptAreaNum) {
        if (this.docListener != null) {
            this.docListener.filePromptDocumentCleanup(filePromptArea, promptAreaNum, this.docIdentif);
        }
        if (fileName == null || fileName.length() == 0) {
            return;
        }
        File file = new File(fileName);
        FileWriter writer = null;
        writer = new FileWriter(file);
        filePromptArea.write(writer);
        Object var8_6 = null;
        if (writer == null) return;
        try {
            writer.close();
            return;
        }
        catch (IOException ioexc) {}
        return;
        {
            catch (IOException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
                Object var8_7 = null;
                if (writer == null) return;
                try {
                    writer.close();
                    return;
                }
                catch (IOException ioexc) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException ioexc) {
                // empty catch block
            }
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ String access$1500(VariableInputDialog x0, String x1, String x2) {
        return x0.getSelectorText(x1, x2);
    }

    private static interface HistoryListener {
        public void changeHistory(int var1, int var2);
    }

    public static interface FilePromptDocumentListener {
        public void filePromptDocumentCleanup(JTextArea var1, int var2, Object var3);
    }
}

