/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.util;

import java.text.MessageFormat;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.netbeans.modules.vcscore.util.VariableInputComponent;
import org.openide.util.NbBundle;

public class VariableInputValidator {
    public static final String VALIDATOR = "VALIDATOR_";
    public static final String VALIDATOR_NON_EMPTY = "VALIDATOR_NON_EMPTY";
    public static final String VALIDATOR_REGEXP_MATCH = "VALIDATOR_REGEXP_MATCH(";
    public static final String VALIDATOR_REGEXP_UNMATCH = "VALIDATOR_REGEXP_UNMATCH(";
    private boolean valid;
    private String message = null;
    private String variable = null;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$util$VariableInputValidator;

    public VariableInputValidator(VariableInputComponent component, String validator) {
        if (validator == null) {
            this.valid = true;
        } else if (VALIDATOR_NON_EMPTY.equals(validator)) {
            this.validateNonEmpty(component);
        } else if (validator.startsWith(VALIDATOR_REGEXP_MATCH)) {
            this.validateRegExpMatch(component, validator, true);
        } else if (validator.startsWith(VALIDATOR_REGEXP_UNMATCH)) {
            this.validateRegExpMatch(component, validator, false);
        } else {
            this.valid = false;
            this.message = VariableInputValidator.g("VariableInputValidator.BadValidator", validator);
        }
    }

    private void validateNonEmpty(VariableInputComponent component) {
        String value = component.getValue();
        if (value == null || value.length() == 0) {
            this.valid = false;
            this.message = VariableInputValidator.g("VariableInputValidator.NotEmpty", component.getLabel());
            this.variable = component.getVariable();
        } else {
            this.valid = true;
        }
    }

    private void validateRegExpMatch(VariableInputComponent component, String validator, boolean match) {
        int index = validator.lastIndexOf(41);
        if (index < 0) {
            index = validator.length();
        }
        String regExp = match ? validator.substring(VALIDATOR_REGEXP_MATCH.length(), index) : validator.substring(VALIDATOR_REGEXP_UNMATCH.length(), index);
        this.valid = this.validateRegExpMatch(component, regExp);
        if (this.message != null) {
            this.valid = false;
        } else if (this.valid != match) {
            this.message = match ? VariableInputValidator.g("VariableInputValidator.RegExpNotMatched", regExp, component.getLabel()) : VariableInputValidator.g("VariableInputValidator.RegExpNotUnmatched", regExp, component.getLabel());
            this.variable = component.getVariable();
            this.valid = false;
        } else {
            this.valid = true;
        }
    }

    private boolean validateRegExpMatch(VariableInputComponent component, String regExpStr) {
        RE regExp;
        try {
            regExp = new RE(regExpStr);
        }
        catch (RESyntaxException exc) {
            this.message = VariableInputValidator.g("VariableInputValidator.BadRegExp", regExpStr, component.getLabel(), exc.getLocalizedMessage());
            this.variable = component.getVariable();
            return false;
        }
        String value = component.getValue();
        if (value == null) {
            value = "";
        }
        return regExp.match(value);
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getMessage() {
        return this.message;
    }

    public String getVariable() {
        return this.variable;
    }

    private static String g(String pattern, Object obj) {
        return MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputValidator == null ? (class$org$netbeans$modules$vcscore$util$VariableInputValidator = VariableInputValidator.class$("org.netbeans.modules.vcscore.util.VariableInputValidator")) : class$org$netbeans$modules$vcscore$util$VariableInputValidator)).getString(pattern), obj);
    }

    private static String g(String pattern, Object obj, Object obj2) {
        return MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputValidator == null ? (class$org$netbeans$modules$vcscore$util$VariableInputValidator = VariableInputValidator.class$("org.netbeans.modules.vcscore.util.VariableInputValidator")) : class$org$netbeans$modules$vcscore$util$VariableInputValidator)).getString(pattern), obj, obj2);
    }

    private static String g(String pattern, Object obj, Object obj2, Object obj3) {
        return MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$VariableInputValidator == null ? (class$org$netbeans$modules$vcscore$util$VariableInputValidator = VariableInputValidator.class$("org.netbeans.modules.vcscore.util.VariableInputValidator")) : class$org$netbeans$modules$vcscore$util$VariableInputValidator)).getString(pattern), obj, obj2, obj3);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

