/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.netbeans.modules.vcscore.util.VcsUtilities;

public class VariableValueAdjustment
implements Serializable {
    private static final String VAR_ADJUST_CHARS = "ADJUST_CHARS";
    private static final String VAR_ADJUST_VARS = "ADJUST_VARS";
    private char adjustingChar;
    private HashSet adjustedChars = null;
    private HashSet adjustedVars = null;
    private String quoting = null;
    static final long serialVersionUID = 2773459026157834845L;

    public synchronized void setAdjust(Hashtable vars) {
        String adjustCharsStr = (String)vars.get(VAR_ADJUST_CHARS);
        if (adjustCharsStr == null) {
            return;
        }
        this.adjustingChar = adjustCharsStr.charAt(0);
        this.adjustedChars = new HashSet();
        int i = 1;
        while (i < adjustCharsStr.length()) {
            this.adjustedChars.add(new Character(adjustCharsStr.charAt(i)));
            ++i;
        }
        String adjustVarsStr = (String)vars.get(VAR_ADJUST_VARS);
        if (adjustVarsStr == null) {
            return;
        }
        String[] adjustVars = VcsUtilities.getQuotedStrings(adjustVarsStr);
        this.adjustedVars = new HashSet<String>(Arrays.asList(adjustVars));
        this.quoting = (String)vars.get("QUOTE");
    }

    public void adjustVarValues(Hashtable vars) {
        if (this.adjustedVars == null) {
            return;
        }
        Iterator it = this.adjustedVars.iterator();
        while (it.hasNext()) {
            String var = (String)it.next();
            String value = (String)vars.get(var);
            if (value == null) continue;
            vars.put(var, this.adjustVarValue(value));
        }
    }

    public String adjustVarValue(String value) {
        value = this.adjustCharsInValue(value);
        if (this.quoting != null && value != null) {
            int index = 0;
            String adjustedQuoting = null;
            while ((index = value.indexOf(this.quoting, index)) >= 0) {
                if (adjustedQuoting == null) {
                    adjustedQuoting = this.adjustCharsInValue(this.quoting);
                }
                value = value.substring(0, index) + adjustedQuoting + value.substring(index + this.quoting.length());
                index += adjustedQuoting.length();
            }
        }
        return value;
    }

    private String adjustCharsInValue(String value) {
        if (this.adjustedChars == null) {
            return value;
        }
        if (value == null) {
            return value;
        }
        int i = 0;
        while (i < value.length()) {
            Character c = new Character(value.charAt(i));
            if (this.adjustedChars.contains(c)) {
                value = value.substring(0, i) + this.adjustingChar + value.substring(i);
                ++i;
            }
            ++i;
        }
        return value;
    }

    public String revertAdjustedVarValue(String value) {
        value = this.revertAdjustedCharsInValue(value);
        if (this.quoting != null && value != null) {
            int index = 0;
            String revertedQuoting = null;
            while ((index = value.indexOf(this.quoting, index)) >= 0) {
                if (revertedQuoting == null) {
                    revertedQuoting = this.revertAdjustedCharsInValue(this.quoting);
                }
                value = value.substring(0, index) + revertedQuoting + value.substring(index + this.quoting.length());
                index += revertedQuoting.length();
            }
        }
        return value;
    }

    private String revertAdjustedCharsInValue(String value) {
        if (this.adjustedChars == null) {
            return value;
        }
        if (value == null) {
            return value;
        }
        int index = value.indexOf(this.adjustingChar);
        while (index >= 0 && index < value.length() - 1) {
            if (this.adjustedChars.contains(new Character(value.charAt(index + 1)))) {
                value = value.substring(0, index) + value.substring(index + 1);
            }
            index = value.indexOf(this.adjustingChar, index + 1);
        }
        return value;
    }
}

