/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.util.Debug;
import org.openide.ErrorManager;
import org.openide.execution.NbClassLoader;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.NbObjectOutputStream;

public class VcsUtilities {
    private Debug E;
    private Debug D;
    private static final String GET_BUNDLE = "getBundle(";
    private static final String SYSTEM_ENV_PREFIX = "Env-";
    private static HashMap systemEnvVariables = null;
    private static final Object systemEnvVariablesLock = new Object();
    private static ClassLoader sfsClassLoader = null;
    private static boolean sfsCLReset = false;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public VcsUtilities() {
        this.D = this.E = new Debug("VcsUtilities", false);
    }

    public static int max3(int v1, int v2, int v3) {
        return Math.max(Math.max(v1, v2), v3);
    }

    public static int max7(int v1, int v2, int v3, int v4, int v5, int v6, int v7) {
        return VcsUtilities.max3(VcsUtilities.max3(v1, v2, v3), VcsUtilities.max3(v4, v5, v6), v7);
    }

    public static boolean withinRange(int min, int val, int max) {
        return min <= val && val <= max;
    }

    public static int getPairIndex(String str, int from, char p1, char p2) {
        int len = str.length();
        int cp = 1;
        int i = from;
        while (i < len) {
            if (str.charAt(i) == p1) {
                ++cp;
            }
            if (str.charAt(i) == p2) {
                --cp;
            }
            if (cp == 0) break;
            ++i;
        }
        if (i < len) {
            return i;
        }
        return -1;
    }

    public static int charCount(String str, char c) {
        int len = str.length();
        int count = 0;
        int i = 0;
        while (i < len) {
            if (str.charAt(i) == c) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static String arrayToString(String[] sa) {
        if (sa == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        int i = 0;
        while (i < sa.length) {
            if (sa[i] != null) {
                sb.append(sa[i]);
            }
            if (i < sa.length - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public static String array2string(String[] sa) {
        StringBuffer sb = new StringBuffer(255);
        if (sa != null) {
            int i = 0;
            while (i < sa.length) {
                sb.append(sa[i] + " ");
                ++i;
            }
        }
        return sb.toString();
    }

    public static String array2stringNl(String[] sa) {
        StringBuffer sb = new StringBuffer();
        if (sa != null) {
            int i = 0;
            while (i < sa.length) {
                sb.append(sa[i] + "\n");
                ++i;
            }
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String arrayToSpaceSeparatedString(String[] sa) {
        if (sa == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < sa.length) {
            if (sa[i] != null) {
                sb.append(sa[i]);
            }
            if (i < sa.length - 1) {
                sb.append(" ");
            }
            ++i;
        }
        return new String(sb);
    }

    public static String arrayToQuotedString(String[] sa, boolean unixShell) {
        if (sa == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < sa.length) {
            if (sa[i] == null) {
                sb.append("");
            } else {
                sb.append(VcsUtilities.msg2CmdlineStr(sa[i], unixShell));
            }
            if (i < sa.length - 1) {
                sb.append(" ");
            }
            ++i;
        }
        return new String(sb);
    }

    public static String arrayToQuotedStrings(String[] sa) {
        if (sa == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < sa.length) {
            if (sa[i] == null) {
                sb.append("");
            } else {
                sb.append("\"" + sa[i] + "\"");
            }
            if (i < sa.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }

    public static String replaceBackslashDollars(String s) {
        int len = s.length();
        StringBuffer sb = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c != '\\' || i >= len - 1 || '$' != s.charAt(i + 1)) {
                sb.append(c);
            }
            ++i;
        }
        return new String(sb);
    }

    public static String[] mergeArrays(String[] sa1, String[] sa2) {
        if (sa1 == null) {
            sa1 = new String[]{};
        }
        if (sa2 == null) {
            sa2 = new String[]{};
        }
        int sa1Len = sa1.length;
        int sa2Len = sa2.length;
        Hashtable<String, String> tab = new Hashtable<String, String>(sa1Len + sa2Len);
        int i = 0;
        while (i < sa1Len) {
            tab.put(sa1[i], sa1[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < sa2Len) {
            tab.put(sa2[i2], sa2[i2]);
            ++i2;
        }
        int len = tab.size();
        String[] res = new String[len];
        int i3 = 0;
        Enumeration e = tab.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            res[i3++] = s;
        }
        return res;
    }

    public static String toSpaceSeparatedString(Vector v) {
        StringBuffer sb = new StringBuffer(30);
        int i = 0;
        while (i < v.size()) {
            Object o = v.elementAt(i);
            sb.append(" " + o);
            ++i;
        }
        return new String(sb);
    }

    /*
     * Unable to fully structure code
     */
    private static String getQuotedString(String str, int[] pos) {
        block7: {
            while (pos[0] < str.length() && Character.isWhitespace(str.charAt(pos[0]))) {
                pos[0] = pos[0] + 1;
            }
            if (pos[0] >= str.length()) {
                return null;
            }
            result = new StringBuffer();
            if (str.charAt(pos[0]) != '\"') ** GOTO lbl22
            pos[0] = pos[0] + 1;
            while (pos[0] < str.length()) {
                if (str.charAt(pos[0]) != '\"') {
                    result.append(str.charAt(pos[0]));
                } else {
                    if (str.charAt(pos[0] - 1) != '\\') break block7;
                    result.setCharAt(result.length() - 1, '\"');
                }
                pos[0] = pos[0] + 1;
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                result.append(str.charAt(pos[0]));
                pos[0] = pos[0] + 1;
lbl22:
                // 2 sources

                ** while (pos[0] < str.length() && str.charAt((int)pos[0]) != ',')
            }
        }
        return result.toString();
    }

    public static String[] getQuotedStrings(String str) {
        LinkedList<String> list = new LinkedList<String>();
        int[] index = new int[]{0};
        String element = VcsUtilities.getQuotedString(str, index);
        while (element != null) {
            list.add(element);
            while (index[0] < str.length() && str.charAt(index[0]) != ',') {
                index[0] = index[0] + 1;
            }
            index[0] = index[0] + 1;
            element = VcsUtilities.getQuotedString(str, index);
        }
        return list.toArray(new String[0]);
    }

    /*
     * Unable to fully structure code
     */
    private static String getQuotedArgument(String str, int[] pos) {
        block7: {
            while (pos[0] < str.length() && Character.isWhitespace(str.charAt(pos[0]))) {
                pos[0] = pos[0] + 1;
            }
            if (pos[0] >= str.length()) {
                return null;
            }
            result = new StringBuffer();
            if (str.charAt(pos[0]) != '\"') ** GOTO lbl22
            pos[0] = pos[0] + 1;
            while (pos[0] < str.length()) {
                if (str.charAt(pos[0]) != '\"') {
                    result.append(str.charAt(pos[0]));
                } else {
                    if (str.charAt(pos[0] - 1) != '\\') break block7;
                    result.setCharAt(result.length() - 1, '\"');
                }
                pos[0] = pos[0] + 1;
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                result.append(str.charAt(pos[0]));
                pos[0] = pos[0] + 1;
lbl22:
                // 2 sources

                ** while (pos[0] < str.length() && !Character.isWhitespace((char)str.charAt((int)pos[0])))
            }
        }
        return result.toString();
    }

    public static String[] getQuotedArguments(String str) {
        LinkedList<String> list = new LinkedList<String>();
        int[] index = new int[]{0};
        String element = VcsUtilities.getQuotedArgument(str, index);
        while (element != null) {
            list.add(element);
            index[0] = index[0] + 1;
            element = VcsUtilities.getQuotedArgument(str, index);
        }
        return list.toArray(new String[0]);
    }

    public static boolean matchQuotedStringToSet(String quotedStr, Set set) {
        if (quotedStr != null && set != null) {
            String[] strs = VcsUtilities.getQuotedStrings(quotedStr);
            int i = 0;
            while (i < strs.length) {
                if (set.contains(strs[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean areQuotedStringsContainedInSet(String quotedStr, Set set) {
        if (quotedStr != null && set != null) {
            String[] strs = VcsUtilities.getQuotedStrings(quotedStr);
            int i = 0;
            while (i < strs.length) {
                if (!set.contains(strs[i])) {
                    return false;
                }
                ++i;
            }
        } else {
            if (quotedStr != null) {
                return false;
            }
            if (set != null) {
                return true;
            }
        }
        return true;
    }

    public static boolean isSetContainedInQuotedStrings(String quotedStr, Set set) {
        if (quotedStr != null && set != null) {
            HashSet<String> qsSet = new HashSet<String>(Arrays.asList(VcsUtilities.getQuotedStrings(quotedStr)));
            Iterator it = set.iterator();
            while (it.hasNext()) {
                if (qsSet.contains(it.next())) continue;
                return false;
            }
        } else {
            if (quotedStr != null) {
                return true;
            }
            if (set != null) {
                return false;
            }
        }
        return true;
    }

    public static synchronized ClassLoader getSFSClassLoader() {
        if (sfsClassLoader == null) {
            sfsCLReset = false;
            FileSystem sfs = Repository.getDefault().getDefaultFileSystem();
            sfsClassLoader = new NbClassLoader(new FileSystem[]{sfs});
            sfs.addFileChangeListener(new FileChangeListener(){

                public void fileFolderCreated(FileEvent fev) {
                }

                public void fileDataCreated(FileEvent fev) {
                    sfsCLReset = true;
                }

                public void fileChanged(FileEvent fev) {
                    sfsCLReset = true;
                }

                public void fileDeleted(FileEvent fev) {
                    sfsCLReset = true;
                }

                public void fileRenamed(FileRenameEvent frev) {
                    sfsCLReset = true;
                }

                public void fileAttributeChanged(FileAttributeEvent faev) {
                }
            });
        }
        if (sfsCLReset) {
            sfsClassLoader = new NbClassLoader(new FileSystem[]{Repository.getDefault().getDefaultFileSystem()});
            sfsCLReset = false;
        }
        return sfsClassLoader;
    }

    public static String getBundleString(String str) {
        int index = str.indexOf(GET_BUNDLE);
        while (index >= 0) {
            int end = VcsUtilities.getPairIndex(str, index += GET_BUNDLE.length(), '(', ')');
            if (end >= 0) {
                int endArg;
                String bundle = str.substring(index, end);
                int startArg = str.indexOf(40, end);
                if (startArg >= 0 && (endArg = VcsUtilities.getPairIndex(str, ++startArg, '(', ')')) >= 0) {
                    String key = str.substring(startArg, endArg);
                    String replaced = VcsUtilities.getBundleString(bundle, key);
                    str = str.substring(0, index - GET_BUNDLE.length()) + replaced + str.substring(endArg + 1);
                    index = index - GET_BUNDLE.length() + replaced.length();
                }
            }
            index = str.indexOf(GET_BUNDLE, index);
        }
        return str;
    }

    private static String getBundleString(String bundle, String key) {
        Class<?> clazz = null;
        if (bundle.endsWith(".class")) {
            try {
                String className = bundle.substring(0, bundle.length() - ".class".length());
                clazz = Class.forName(className, false, (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = VcsUtilities.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader));
            }
            catch (ClassNotFoundException exc) {
                clazz = null;
            }
        }
        String[] keyWithArgs = VcsUtilities.getQuotedStrings(key);
        Object[] args = null;
        if (keyWithArgs.length > 0) {
            key = keyWithArgs[0];
            args = new String[keyWithArgs.length - 1];
            System.arraycopy(keyWithArgs, 1, args, 0, keyWithArgs.length - 1);
        }
        String bundleStr = key;
        try {
            bundleStr = clazz != null ? NbBundle.getBundle(clazz).getString(key) : NbBundle.getBundle((String)bundle, (Locale)Locale.getDefault(), (ClassLoader)VcsUtilities.getSFSClassLoader()).getString(key);
            if (args != null) {
                bundleStr = MessageFormat.format(bundleStr, args);
            }
        }
        catch (MissingResourceException missExc) {
            ErrorManager.getDefault().notify((Throwable)new Exception(){

                public String getLocalizedMessage() {
                    return "MissingResourceException:" + missExc.getMessage();
                }
            });
        }
        return bundleStr;
    }

    public static String getDirNamePart(String path) {
        String dirName = "";
        int sep = path.lastIndexOf(47);
        dirName = sep < 0 ? "" : path.substring(0, sep);
        return dirName;
    }

    public static String getFileNamePart(String path) {
        String fileName = "";
        int sep = path.lastIndexOf(47);
        fileName = sep < 0 ? path : path.substring(sep + 1);
        return fileName;
    }

    public static void centerWindow(Window w) {
        ((Component)w).setBounds(Utilities.findCenterBounds((Dimension)w.getSize()));
    }

    public static boolean deleteRecursive(File dir) {
        boolean result = true;
        File[] files = dir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                result = files[i].isDirectory() ? result && VcsUtilities.deleteRecursive(files[i]) : result && files[i].delete();
                ++i;
            }
        }
        result = result && dir.delete();
        return result;
    }

    public static void removeEnterFromKeymap(JTextField field) {
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        Keymap map = field.getKeymap();
        map.removeKeyStrokeBinding(enter);
    }

    public static int numChars(String str, char c) {
        int n = 0;
        int index = 0;
        while (index < str.length()) {
            if ((index = str.indexOf(c, index + 1)) < 0) break;
            ++n;
        }
        return n;
    }

    public static String msg2CmdlineStr(String msg, boolean unixShell) {
        if (msg == null) {
            return "";
        }
        String cmd = Utilities.replaceString((String)msg, (String)"\\", (String)"\\\\");
        cmd = unixShell ? Utilities.replaceString((String)cmd, (String)"\"", (String)"\\\\\\\"\\\\\\\"") : Utilities.replaceString((String)cmd, (String)"\"", (String)"\\\\\\\"");
        if (Utilities.isUnix() || unixShell) {
            cmd = Utilities.replaceString((String)cmd, (String)"$", (String)"\\$");
            cmd = Utilities.replaceString((String)cmd, (String)"`", (String)"\\`");
        }
        return cmd;
    }

    public static void removeKeys(HashMap table, HashMap toRemove) {
        Iterator keysIter = toRemove.keySet().iterator();
        while (keysIter.hasNext()) {
            table.remove(keysIter.next());
        }
    }

    public static Map getSystemEnvVars() {
        systemEnvVariables = new HashMap();
        Enumeration<?> enumeration = System.getProperties().propertyNames();
        while (enumeration.hasMoreElements()) {
            String value;
            String key = (String)enumeration.nextElement();
            if (!key.startsWith(SYSTEM_ENV_PREFIX) || (value = System.getProperty(key)) == null) continue;
            systemEnvVariables.put(key.substring(SYSTEM_ENV_PREFIX.length()), value);
        }
        return systemEnvVariables;
    }

    public static Map addEnvVars(Map envVars, Hashtable vars, String varEnvPrefix) {
        Enumeration enumeration = vars.keys();
        while (enumeration.hasMoreElements()) {
            String value;
            String key = (String)enumeration.nextElement();
            if (!key.startsWith(varEnvPrefix) || (value = (String)vars.get(key)) == null) continue;
            envVars.put(key.substring(varEnvPrefix.length()), value);
        }
        return envVars;
    }

    public static Map addEnvVars(Map envVars, Hashtable vars, String varEnvPrefix, String varEnvRemovePrefix) {
        Enumeration enumeration = vars.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.startsWith(varEnvRemovePrefix)) continue;
            envVars.remove(key.substring(varEnvRemovePrefix.length()));
        }
        enum = vars.keys();
        while (enum.hasMoreElements()) {
            String value;
            String key = (String)enum.nextElement();
            if (!key.startsWith(varEnvPrefix) || (value = (String)vars.get(key)) == null) continue;
            envVars.put(key.substring(varEnvPrefix.length()), value);
        }
        return envVars;
    }

    public static String[] getEnvString(Map envVars) {
        String[] vars = new String[envVars.size()];
        int i = 0;
        Iterator it = envVars.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            vars[i] = entry.getKey() + "=" + entry.getValue();
            ++i;
        }
        return vars;
    }

    public static File createTMP() {
        long tmpId;
        String TMP_ROOT = System.getProperty("netbeans.user") + File.separator + "system" + File.separator + "vcs" + File.separator + "tmp";
        File tmpDir = new File(TMP_ROOT);
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        do {
            tmpId = 10000L * (1L + Math.round(Math.random() * 8.0)) + Math.round(Math.random() * 1000.0);
        } while (new File(TMP_ROOT + File.separator + "tmp" + tmpId).exists());
        tmpDir = new File(TMP_ROOT = TMP_ROOT + File.separator + "tmp" + tmpId);
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        return tmpDir;
    }

    public static String createUniqueName(String name, Collection names) {
        String unique = name;
        boolean isUnique = false;
        int i = 1;
        while (!isUnique) {
            if (!names.contains(unique)) break;
            unique = name + "_" + i;
            ++i;
        }
        return unique;
    }

    public static ArrayList createIgnoreList(CacheDir dir, String path, VcsFileSystem.IgnoreListSupport ignSupport) {
        CacheDir parent = dir.getParent();
        ArrayList ignoreList = null;
        if (parent == null) {
            ignoreList = ignSupport.createIgnoreList(path, ignSupport.createInitialIgnoreList());
        } else {
            ArrayList parentIgnoreList = !parent.isIgnoreListSet() ? VcsUtilities.createIgnoreList(parent, VcsUtilities.getDirNamePart(path), ignSupport) : parent.getIgnoreList();
            ignoreList = ignSupport.createIgnoreList(path, parentIgnoreList);
        }
        dir.setIgnoreList(ignoreList);
        return ignoreList;
    }

    public static FileObject[] convertFileObjects(FileObject[] originals) {
        if (originals == null || originals.length == 0) {
            return originals;
        }
        int i = 0;
        while (i < originals.length) {
            FileObject fo = originals[i];
            FileSystem fs = (FileSystem)fo.getAttribute("VcsFileSystemAttributeIdentifier");
            if (fs != null) {
                try {
                    String nativePath;
                    FileSystem fileSys = fo.getFileSystem();
                    if (!fileSys.equals(fs) && (fo = fs.findResource(nativePath = (String)fo.getAttribute("VcsFileSystemNativeFOPath"))) != null) {
                        originals[i] = fo;
                    }
                }
                catch (FileStateInvalidException exc) {
                    // empty catch block
                }
            }
            ++i;
        }
        return originals;
    }

    public static String encodeValue(Object value) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            NbObjectOutputStream oos = new NbObjectOutputStream((OutputStream)bos);
            oos.writeObject(value);
            oos.close();
        }
        catch (SecurityException se) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(), (Throwable)se);
        }
        byte[] bArray = bos.toByteArray();
        StringBuffer strBuff = new StringBuffer(bArray.length * 2);
        int i = 0;
        while (i < bArray.length) {
            if (bArray[i] < 16 && bArray[i] >= 0) {
                strBuff.append("0");
            }
            strBuff.append(Integer.toHexString(bArray[i] < 0 ? bArray[i] + 256 : bArray[i]));
            ++i;
        }
        return strBuff.toString();
    }

    public static Object decodeValue(String value) throws IOException {
        if (value == null || value.length() == 0) {
            return null;
        }
        byte[] bytes = new byte[value.length() / 2];
        int count = 0;
        int i = 0;
        while (i < value.length()) {
            try {
                int tempI = Integer.parseInt(value.substring(i, i + 2), 16);
                if (tempI > 127) {
                    tempI -= 256;
                }
                bytes[count++] = (byte)tempI;
            }
            catch (NumberFormatException ne) {
                throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(), (Throwable)ne);
            }
            i += 2;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes, 0, count);
        try {
            NbObjectInputStream ois = new NbObjectInputStream((InputStream)bis);
            Object ret = ois.readObject();
            return ret;
        }
        catch (OptionalDataException ode) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(), (Throwable)ode);
        }
        catch (ClassNotFoundException cnfe) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(), (Throwable)cnfe);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

