/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.util;

import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class WeakList
extends AbstractList {
    private ArrayList items = new ArrayList();

    public WeakList() {
    }

    public WeakList(Collection c) {
        this.addAll(0, c);
    }

    public void add(int index, Object element) {
        this.items.add(index, new WeakReference<Object>(element));
    }

    public Iterator iterator() {
        return new WeakListIterator();
    }

    public int size() {
        this.removeReleased();
        return this.items.size();
    }

    public Object get(int index) {
        return ((WeakReference)this.items.get(index)).get();
    }

    private void removeReleased() {
        Iterator it = ((AbstractList)this.items).iterator();
        while (it.hasNext()) {
            WeakReference ref = (WeakReference)it.next();
            if (ref.get() != null) continue;
            ((AbstractCollection)this.items).remove(ref);
        }
    }

    private class WeakListIterator
    implements Iterator {
        private int n;
        private int i;

        public WeakListIterator() {
            this.n = WeakList.this.size();
            this.i = 0;
        }

        public boolean hasNext() {
            return this.i < this.n;
        }

        public Object next() {
            return WeakList.this.get(this.i++);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

