/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.util.table;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.vcscore.util.table.TableInfoModel;

public class ColumnSortListener
extends MouseAdapter {
    protected JTable table;

    public ColumnSortListener(JTable usedTable) {
        this.table = usedTable;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        TableColumnModel colTab = this.table.getColumnModel();
        TableInfoModel model = (TableInfoModel)this.table.getModel();
        Object oldSelection = model.getElementAt(this.table.getSelectedRow());
        int index = colTab.getColumnIndexAtX(mouseEvent.getX());
        if (!model.isColumnSortable(index)) {
            return;
        }
        int modIndex = colTab.getColumn(index).getModelIndex();
        if (modIndex < 0) {
            return;
        }
        int ind = 0;
        while (ind < model.getColumnCount()) {
            TableColumn col = colTab.getColumn(ind);
            String title = model.getColumnName(col.getModelIndex());
            if (col.getModelIndex() == modIndex) {
                if (model.getActiveColumn() == modIndex) {
                    model.setDirection(model.getDirection() == -1);
                } else {
                    model.setDirection(true);
                }
                title = model.getDirection() == 1 ? title + " (+)" : title + " (-)";
            }
            col.setHeaderValue(title);
            ++ind;
        }
        this.table.getTableHeader().repaint();
        model.setActiveColumn(modIndex);
        Collections.sort(model.getList(), model);
        this.table.tableChanged(new TableModelEvent(model));
        this.table.repaint();
        int rowIndex = 0;
        while (rowIndex < model.getRowCount()) {
            Object newObj = model.getElementAt(rowIndex);
            if (newObj == oldSelection) {
                this.table.changeSelection(rowIndex, 0, false, false);
                break;
            }
            ++rowIndex;
        }
    }
}

