/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.util.table;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.vcscore.util.table.TableInfoComparator;
import org.openide.util.NbBundle;

public class TableInfoModel
extends AbstractTableModel
implements Comparator {
    private int currentColumn;
    private int direction;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = -1;
    protected HashMap columnLabels;
    protected HashMap columnValueSetters;
    protected HashMap columnValueParams;
    protected HashMap columnSorted;
    protected HashMap columnComparators;
    protected LinkedList list = new LinkedList();
    private static final long serialVersionUID = -794293494044050639L;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$util$table$TableInfoModel;

    public TableInfoModel() {
        this.columnLabels = new HashMap();
        this.columnSorted = new HashMap();
        this.columnValueSetters = new HashMap();
        this.columnValueParams = new HashMap();
        this.columnComparators = new HashMap();
        this.setDirection(true);
        this.setActiveColumn(0);
    }

    public int getRowCount() {
        return this.list.size();
    }

    public int getColumnCount() {
        return this.columnValueSetters.size();
    }

    public Object getValueAt(int row, int column) {
        if (row < 0 || row >= this.getRowCount()) {
            return "";
        }
        Integer columnInt = new Integer(column);
        Object info = this.list.get(row);
        Method getter = (Method)this.columnValueSetters.get(columnInt);
        Object[] params = (Object[])this.columnValueParams.get(columnInt);
        TableInfoComparator comparator = (TableInfoComparator)this.columnComparators.get(columnInt);
        if (getter == null) {
            return "";
        }
        try {
            Object value = getter.invoke(info, params);
            if (comparator != null) {
                return comparator.getDisplayValue(value, info);
            }
            return value;
        }
        catch (IllegalAccessException exc) {
            return "";
        }
        catch (IllegalArgumentException exc2) {
            return "";
        }
        catch (InvocationTargetException exc3) {
            return "";
        }
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public String getColumnName(int param) {
        Integer columnIndex = new Integer(param);
        Object label = this.columnLabels.get(columnIndex);
        if (label != null) {
            return label.toString();
        }
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$util$table$TableInfoModel == null ? (class$org$netbeans$modules$vcscore$util$table$TableInfoModel = TableInfoModel.class$("org.netbeans.modules.vcscore.util.table.TableInfoModel")) : class$org$netbeans$modules$vcscore$util$table$TableInfoModel)).getString("TableInfoModel.noColumnLabel");
    }

    public boolean isColumnSortable(int column) {
        Integer integ = new Integer(column);
        Boolean bvalue = (Boolean)this.columnSorted.get(integ);
        if (bvalue != null) {
            return bvalue;
        }
        return false;
    }

    public Object getElementAt(int row) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        return this.list.get(row);
    }

    public int getElementRow(Object element) {
        return this.list.indexOf(element);
    }

    public void setColumnDefinition(int columnNumber, String label, Method reflectionGetter, boolean sorted, TableInfoComparator comp) {
        Integer integ = new Integer(columnNumber);
        this.columnLabels.put(integ, label);
        this.columnSorted.put(integ, sorted ? Boolean.TRUE : Boolean.FALSE);
        this.columnValueSetters.put(integ, reflectionGetter);
        this.columnValueParams.put(integ, null);
        this.columnComparators.put(integ, comp);
    }

    public void setColumnDefinition(int columnNumber, String label, Method reflectionGetter, Object[] params, boolean sorted, TableInfoComparator comp) {
        Integer integ = new Integer(columnNumber);
        this.columnLabels.put(integ, label);
        this.columnSorted.put(integ, sorted ? Boolean.TRUE : Boolean.FALSE);
        this.columnValueSetters.put(integ, reflectionGetter);
        this.columnValueParams.put(integ, params);
        this.columnComparators.put(integ, comp);
    }

    public void addElement(Object object) {
        this.list.add(object);
    }

    public void fireTableDataChanged() {
        super.fireTableDataChanged();
    }

    public boolean removeElement(Object object) {
        int row = this.list.indexOf(object);
        boolean toReturn = false;
        if (row >= 0) {
            toReturn = this.list.remove(object);
            this.fireTableRowsDeleted(row, row);
        }
        return toReturn;
    }

    public void clear() {
        this.list.clear();
    }

    public void prependElement(Object object) {
        this.list.addFirst(object);
    }

    public void setActiveColumn(int index) {
        this.currentColumn = index;
    }

    public int getActiveColumn() {
        return this.currentColumn;
    }

    public void setDirection(boolean ascending) {
        this.direction = ascending ? 1 : -1;
    }

    public int getDirection() {
        return this.direction;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TableInfoModel) {
            TableInfoModel obj2 = (TableInfoModel)obj;
            return obj2.getActiveColumn() == this.getActiveColumn();
        }
        return false;
    }

    public int compare(Object obj1, Object obj2) {
        Integer columnInt = new Integer(this.getActiveColumn());
        Method getter = (Method)this.columnValueSetters.get(columnInt);
        Object[] params = (Object[])this.columnValueParams.get(columnInt);
        TableInfoComparator comparator = (TableInfoComparator)this.columnComparators.get(columnInt);
        if (getter == null) {
            return 0;
        }
        Object value1 = null;
        Object value2 = null;
        try {
            value1 = getter.invoke(obj1, params);
            value2 = getter.invoke(obj2, params);
        }
        catch (IllegalAccessException exc) {
            return 0;
        }
        catch (IllegalArgumentException exc2) {
            return 0;
        }
        catch (InvocationTargetException exc3) {
            return 0;
        }
        if (comparator == null) {
            comparator = new StringComparator();
        }
        return this.getDirection() * comparator.compare(value1, value2);
    }

    public List getList() {
        return this.list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class StringComparator
    implements TableInfoComparator {
        private StringComparator() {
        }

        public int compare(Object obj, Object obj1) {
            if (obj == null) {
                return -1;
            }
            if (obj1 == null) {
                return 1;
            }
            String str1 = obj.toString();
            String str2 = obj1.toString();
            return str1.compareTo(str2);
        }

        public String getDisplayValue(Object obj, Object rowObject) {
            return obj.toString();
        }
    }
}

