/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.util.virtuals;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.HashSet;
import org.netbeans.modules.vcscore.util.virtuals.VirtualsRefreshing;
import org.openide.ErrorManager;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public final class VcsRefreshRequest
implements Runnable {
    private static final int REFRESH_COUNT = 30;
    private static final int PREFERRED_REFRESH_DELAY = 800;
    private Reference system;
    private Reference refresher;
    private Enumeration en;
    private int refreshTime;
    private RequestProcessor.Task task;
    private HashSet preffered;
    private boolean interrupt;

    public VcsRefreshRequest(AbstractFileSystem fs, int ms, VirtualsRefreshing refresher) {
        int randSeed;
        this.system = new WeakReference<AbstractFileSystem>(fs);
        this.refresher = new WeakReference<VirtualsRefreshing>(refresher);
        if (ms == 0) {
            this.refreshTime = Integer.MAX_VALUE;
            randSeed = Integer.MAX_VALUE;
        } else {
            this.refreshTime = ms;
            randSeed = (int)Math.round(Math.random() * (double)ms) + 1000;
        }
        this.task = RequestProcessor.postRequest((Runnable)this, (int)randSeed, (int)1);
    }

    public int getRefreshTime() {
        if (this.refreshTime == Integer.MAX_VALUE) {
            return 0;
        }
        return this.refreshTime;
    }

    public void setRefreshTime(int ms) {
        if (ms == this.refreshTime) {
            return;
        }
        this.refreshTime = ms == 0 ? Integer.MAX_VALUE : ms;
        VcsRefreshRequest vcsRefreshRequest = this;
        synchronized (vcsRefreshRequest) {
            if (this.task != null) {
                this.task.schedule(ms);
            } else if (ms == 0) {
                this.interrupt = true;
            }
        }
    }

    public synchronized void stop() {
        this.refreshTime = 0;
        if (this.task == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void addPrefferedFolder(String folderPath) {
        VcsRefreshRequest vcsRefreshRequest = this;
        synchronized (vcsRefreshRequest) {
            if (this.preffered == null) {
                this.preffered = new HashSet();
            }
            this.preffered.add(folderPath);
            if (this.task != null) {
                this.task.schedule(800);
            } else {
                this.interrupt = true;
            }
        }
    }

    synchronized boolean hasPrefferedFolder() {
        return this.preffered != null && this.preffered.size() != 0;
    }

    private boolean shouldBeInterrupted() {
        return this.interrupt;
    }

    FileObject getPrefferedFolder() {
        boolean repeat = false;
        FileObject fo = null;
        while (!repeat) {
            String toReturn;
            repeat = true;
            VcsRefreshRequest vcsRefreshRequest = this;
            synchronized (vcsRefreshRequest) {
                if (this.preffered == null || this.preffered.size() == 0) {
                    FileObject fileObject = null;
                    return fileObject;
                }
                toReturn = (String)this.preffered.iterator().next();
                this.preffered.remove(toReturn);
            }
            if (toReturn == null) {
                return null;
            }
            AbstractFileSystem fs = (AbstractFileSystem)this.system.get();
            if (fs == null) {
                return null;
            }
            fo = fs.findResource(toReturn);
            if (fo != null) continue;
            repeat = false;
        }
        return fo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        VcsRefreshRequest vcsRefreshRequest2;
        RequestProcessor.Task t;
        int ms;
        VcsRefreshRequest vcsRefreshRequest = this;
        synchronized (vcsRefreshRequest) {
            ms = this.refreshTime;
            if (ms <= 0) {
                return;
            }
            t = this.task;
            this.interrupt = false;
        }
        try {
            this.task = null;
            this.doLoop();
            Object var6_5 = null;
            vcsRefreshRequest2 = this;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            VcsRefreshRequest vcsRefreshRequest3 = this;
            synchronized (vcsRefreshRequest3) {
                this.task = t;
                this.interrupt = false;
                this.notifyAll();
            }
            if (this.hasPrefferedFolder()) {
                t.schedule(800);
                throw throwable;
            } else {
                t.schedule(ms);
            }
            throw throwable;
        }
        synchronized (vcsRefreshRequest2) {
            this.task = t;
            this.interrupt = false;
            this.notifyAll();
        }
        if (this.hasPrefferedFolder()) {
            t.schedule(800);
            return;
        }
        t.schedule(ms);
    }

    private void doLoop() {
        AbstractFileSystem system = (AbstractFileSystem)this.system.get();
        if (system == null) {
            this.refreshTime = 0;
            return;
        }
        VirtualsRefreshing refreshing = (VirtualsRefreshing)this.refresher.get();
        if (refreshing == null) {
            ErrorManager.getDefault().log(16, "VcsRefreshRequest: Missing refresher. Please file a bug against vcscore module");
            return;
        }
        if (this.en == null || !this.en.hasMoreElements()) {
            this.en = VcsRefreshRequest.existingFolders(refreshing);
        }
        FileObject prefFo = this.getPrefferedFolder();
        while (prefFo != null) {
            refreshing.doVirtualsRefresh(prefFo);
            prefFo = this.getPrefferedFolder();
        }
        if (this.refreshTime == Integer.MAX_VALUE) {
            return;
        }
        int i = 0;
        while (i < 30 && this.en.hasMoreElements()) {
            FileObject fo = (FileObject)this.en.nextElement();
            if (fo != null) {
                refreshing.doVirtualsRefresh(fo);
            }
            if (this.refreshTime <= 0 || this.shouldBeInterrupted()) {
                return;
            }
            ++i;
        }
        if (!this.en.hasMoreElements()) {
            this.en = null;
        }
    }

    private static Enumeration existingFolders(VirtualsRefreshing fs) {
        return fs.getExistingFolders();
    }
}

