/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.versioning;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.vcscore.versioning.RevisionItem;
import org.netbeans.modules.vcscore.versioning.RevisionList;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;

public abstract class RevisionChildren
extends Children.Keys
implements ChangeListener,
Serializable {
    protected static final Object WAIT_KEY = new Object();
    private String acceptField = "";
    private int numAcceptDots = 1;
    private RevisionList list = null;
    private ChangeListener changeListenerToList;
    private ArrayList notificationListeners = new ArrayList(2);
    private Runnable initProcess = null;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$versioning$RevisionChildren;

    public RevisionChildren(RevisionList list) {
        this.changeListenerToList = WeakListener.change((ChangeListener)this, (Object)this);
        if (list != null) {
            list.addChangeListener(this.changeListenerToList);
        }
        this.list = list;
        this.stateChanged(null);
    }

    public RevisionList getList() {
        return this.list;
    }

    public void setList(RevisionList newList) {
        if (this.list != null) {
            this.list.removeChangeListener(this.changeListenerToList);
        }
        this.changeListenerToList = WeakListener.change((ChangeListener)this, (Object)this);
        newList.addChangeListener(this.changeListenerToList);
        this.list = newList;
        this.stateChanged(null);
    }

    public void addNotificationListener(NotificationListener l) {
        ArrayList arrayList = this.notificationListeners;
        synchronized (arrayList) {
            this.notificationListeners.add(l);
        }
    }

    public void removeNotificationListener(NotificationListener l) {
        ArrayList arrayList = this.notificationListeners;
        synchronized (arrayList) {
            ((AbstractCollection)this.notificationListeners).remove(l);
        }
    }

    public void setInitProcess(Runnable initProcess) {
        this.initProcess = initProcess;
    }

    protected void addNotify() {
        if (this.list == null && this.initProcess != null) {
            RequestProcessor.postRequest((Runnable)this.initProcess);
            this.initProcess = null;
        }
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                ArrayList notifList;
                ArrayList arrayList = RevisionChildren.this.notificationListeners;
                synchronized (arrayList) {
                    notifList = new ArrayList(RevisionChildren.this.notificationListeners);
                }
                int i = notifList.size() - 1;
                while (i >= 0) {
                    NotificationListener l = (NotificationListener)notifList.get(i);
                    l.notifyAdded();
                    --i;
                }
            }
        });
        super.addNotify();
    }

    protected void removeNotify() {
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                ArrayList notifList;
                ArrayList arrayList = RevisionChildren.this.notificationListeners;
                synchronized (arrayList) {
                    notifList = new ArrayList(RevisionChildren.this.notificationListeners);
                }
                int i = notifList.size() - 1;
                while (i >= 0) {
                    NotificationListener l = (NotificationListener)notifList.get(i);
                    l.notifyRemoved();
                    --i;
                }
            }
        });
        super.removeNotify();
    }

    private void setAcceptField(String acceptField) {
        this.acceptField = acceptField;
    }

    private void setNumAcceptDots(int dots) {
        this.numAcceptDots = dots;
    }

    protected abstract boolean accept(RevisionItem var1);

    protected abstract RevisionChildren getChildrenFor(RevisionItem var1);

    protected Node createWaitingNode() {
        AbstractNode n = new AbstractNode(Children.LEAF);
        n.setName(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$versioning$RevisionChildren == null ? (class$org$netbeans$modules$vcscore$versioning$RevisionChildren = RevisionChildren.class$("org.netbeans.modules.vcscore.versioning.RevisionChildren")) : class$org$netbeans$modules$vcscore$versioning$RevisionChildren), (String)"WaitNodeTooltip"));
        n.setIconBase("org/netbeans/modules/vcscore/versioning/wait");
        return n;
    }

    protected Node[] createNodes(Object key) {
        Node[] nodes;
        if (WAIT_KEY.equals(key)) {
            return new Node[]{this.createWaitingNode()};
        }
        RevisionItem item = (RevisionItem)key;
        if (this.accept(item)) {
            Node newNode;
            if (!this.list.containsSubRevisions(item.getRevision()) && !item.isBranch()) {
                newNode = this.list.getNodeDelegate(item, null);
            } else {
                RevisionChildren children = this.getChildrenFor(item);
                newNode = this.list.getNodeDelegate(item, children);
            }
            nodes = new Node[]{newNode};
        } else {
            nodes = new Node[]{};
        }
        return nodes;
    }

    public synchronized void stateChanged(ChangeEvent evt) {
        if (this.list == null) {
            this.setKeys(Collections.singleton(WAIT_KEY));
        } else {
            this.setKeys(this.list);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface NotificationListener {
        public void notifyAdded();

        public void notifyRemoved();
    }
}

