/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.versioning;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.openide.nodes.Node;

public abstract class RevisionItem
implements Node.Cookie,
Comparable,
Serializable {
    public static final String PROP_REVISION = "revision";
    public static final String PROP_CURRENT_REVISION = "currentRevision";
    public static final String PROP_DISPLAY_NAME = "displayName";
    public static final String PROP_MESSAGE = "message";
    public static final String PROP_DATE = "date";
    public static final String PROP_AUTHOR = "author";
    public static final String PROP_LOCKER = "locker";
    public static final String PROP_TAGS = "tags";
    public static final String PROP_ADDITIONAL_PROPERTIES = "additionalProperties";
    private String revision;
    private String revisionVCS;
    protected Vector branches;
    private String displayName;
    private String message;
    private String date;
    private String author;
    private String locker;
    private Vector tagNames;
    private boolean current;
    private Hashtable additionalProperties;
    private ArrayList additionalPropertiesSets;
    private transient PropertyChangeSupport changeSupport;

    public RevisionItem(String revision) {
        this.revision = revision;
        this.revisionVCS = revision;
        this.branches = null;
        this.message = null;
        this.date = null;
        this.author = null;
        this.locker = null;
        this.tagNames = new Vector();
        this.current = false;
        this.additionalProperties = new Hashtable();
        this.additionalPropertiesSets = new ArrayList();
        this.displayName = revision;
        this.changeSupport = new PropertyChangeSupport(this);
    }

    public String getRevision() {
        return this.revision;
    }

    public String getRevisionVCS() {
        return this.revisionVCS;
    }

    public void setRevisionVCS(String revisionVCS) {
        this.revisionVCS = revisionVCS;
    }

    public boolean isRevision() {
        return this.branches == null;
    }

    public abstract boolean isBranch();

    public void setDisplayName(String displayName) {
        if (!displayName.equals(this.displayName)) {
            String oldDisplayName = this.displayName;
            this.displayName = displayName;
            this.firePropertyChange(PROP_DISPLAY_NAME, oldDisplayName, displayName);
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setMessage(String message) {
        if (!message.equals(this.message)) {
            String oldMessage = this.message;
            this.message = message;
            this.firePropertyChange(PROP_MESSAGE, oldMessage, message);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setDate(String date) {
        if (!date.equals(this.date)) {
            String oldDate = this.date;
            this.date = date;
            this.firePropertyChange(PROP_DATE, oldDate, date);
        }
    }

    public String getDate() {
        return this.date;
    }

    public void setAuthor(String author) {
        if (!author.equals(this.author)) {
            String oldAuthor = this.author;
            this.author = author;
            this.firePropertyChange(PROP_AUTHOR, oldAuthor, author);
        }
    }

    public String getAuthor() {
        return this.author;
    }

    public void setLocker(String locker) {
        if (!locker.equals(this.locker)) {
            String oldLocker = this.locker;
            this.locker = locker;
            this.firePropertyChange(PROP_LOCKER, oldLocker, locker);
        }
    }

    public String getLocker() {
        return this.locker;
    }

    public void addTagName(String tagName) {
        this.tagNames.add(tagName);
        if (this.isBranch()) {
            this.setDisplayName(this.revision + " (" + tagName + ")");
        }
        this.firePropertyChange(PROP_TAGS, null, null);
    }

    public boolean removeTagName(String tagName) {
        boolean removed = this.tagNames.remove(tagName);
        if (removed) {
            this.firePropertyChange(PROP_TAGS, null, null);
        }
        return removed;
    }

    public void setTagNames(String[] tagNames) {
        this.tagNames = new Vector<String>(Arrays.asList(tagNames));
        this.firePropertyChange(PROP_TAGS, null, null);
    }

    public String[] getTagNames() {
        return this.tagNames.toArray(new String[0]);
    }

    public void setCurrent(boolean current) {
        if (current != this.current) {
            this.current = current;
            this.firePropertyChange(PROP_CURRENT_REVISION, !current ? Boolean.TRUE : Boolean.FALSE, current ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void addProperty(String name, String value) {
        this.additionalProperties.put(name, value);
        this.firePropertyChange(PROP_ADDITIONAL_PROPERTIES, null, null);
    }

    public Hashtable getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void addAdditionalPropertiesSet(String name, Map properties) {
        this.additionalPropertiesSets.add(name);
        this.additionalPropertiesSets.add(properties);
    }

    public String[] getAdditionalPropertiesSetNames() {
        ArrayList names = new ArrayList();
        int i = 0;
        while (i < this.additionalPropertiesSets.size()) {
            names.add(this.additionalPropertiesSets.get(i));
            i += 2;
        }
        return names.toArray(new String[0]);
    }

    public Map[] getAdditionalPropertiesSets() {
        ArrayList sets = new ArrayList();
        int i = 1;
        while (i < this.additionalPropertiesSets.size()) {
            sets.add(this.additionalPropertiesSets.get(i));
            i += 2;
        }
        return sets.toArray(new Map[0]);
    }

    protected abstract RevisionItem getNextItem();

    protected abstract int cmpRev(String var1);

    public abstract RevisionItem addRevision(String var1);

    public abstract RevisionItem addBranch(String var1);

    public void putToList(Collection list) {
        RevisionItem next;
        if (!list.contains(this)) {
            list.add(this);
        }
        if ((next = this.getNextItem()) != null) {
            next.putToList(list);
        }
        if (this.branches != null) {
            Enumeration enumeration = this.branches.elements();
            while (enumeration.hasMoreElements()) {
                ((RevisionItem)enumeration.nextElement()).putToList(list);
            }
        }
    }

    public int hashCode() {
        return this.revision.hashCode();
    }

    public int compareTo(Object p1) {
        return -this.cmpRev(((RevisionItem)p1).getRevision());
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    protected final void firePropertyChange(String property, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(property, oldValue, newValue);
    }

    public String toString() {
        return "[" + this.revision + ", branches = " + (this.branches == null ? null : new ArrayList(this.branches)) + ", tags = " + this.getTagNames() + "]";
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException, NotActiveException {
        in.defaultReadObject();
        this.changeSupport = new PropertyChangeSupport(this);
    }
}

