/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.versioning;

import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.vcscore.versioning.RevisionChildren;
import org.netbeans.modules.vcscore.versioning.RevisionItem;
import org.netbeans.modules.vcscore.versioning.RevisionNode;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public abstract class RevisionList
extends TreeSet
implements Node.Cookie {
    private transient FileObject fo = null;
    private transient Vector listeners = new Vector();
    private transient WeakHashMap nodeDelegates = new WeakHashMap();
    static final long serialVersionUID = -8578787400541124223L;

    public void setFileObject(FileObject fo) {
        this.fo = fo;
    }

    public FileObject getFileObject() {
        return this.fo;
    }

    public boolean add(Object obj) {
        boolean status = super.add(obj);
        this.fireChanged();
        return status;
    }

    public boolean addAll(Collection c) {
        boolean status = super.addAll(c);
        this.fireChanged();
        return status;
    }

    public void clear() {
        super.clear();
        this.fireChanged();
    }

    public boolean remove(Object obj) {
        boolean status = super.remove(obj);
        this.nodeDelegates.remove(obj);
        this.fireChanged();
        return status;
    }

    public boolean removeAll(Collection c) {
        boolean status = super.removeAll(c);
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.nodeDelegates.remove(it.next());
        }
        this.fireChanged();
        return status;
    }

    public boolean removeRevision(String revision) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            RevisionItem rev = (RevisionItem)it.next();
            String revision2 = rev.getRevision();
            if (!revision2.equals(revision)) continue;
            this.remove(rev);
            return true;
        }
        return false;
    }

    public void fireChanged() {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ChangeListener listener = (ChangeListener)enumeration.nextElement();
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    public abstract boolean containsSubRevisions(String var1);

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeChangeListener(ChangeListener listener) {
        return this.listeners.remove(listener);
    }

    public Node getNodeDelegate(RevisionItem item, RevisionChildren children) {
        Node node = (Node)this.nodeDelegates.get(item);
        if (node == null) {
            node = this.createNodeDelegate(item, children);
            this.nodeDelegates.put(item, node);
        }
        return node;
    }

    protected Node createNodeDelegate(RevisionItem item, RevisionChildren children) {
        RevisionNode node;
        if (children == null || Children.LEAF.equals(children)) {
            node = new RevisionNode(this, item);
        } else {
            node = new RevisionNode(children);
            node.setItem(item);
        }
        node.setDisplayName(item.getDisplayName());
        return node;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException, NotActiveException {
        in.defaultReadObject();
        this.listeners = new Vector();
        this.nodeDelegates = new WeakHashMap();
    }
}

